/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public class LongArray
extends AArray {
    public LongArray(Object o) throws Throwable {
        super(o);
    }

    public LongArray(Object o, boolean majority) throws Throwable {
        super(o, majority);
    }

    @Override
    public Object array() {
        switch (this.dim) {
            case 1: {
                return (long[])this.o;
            }
            case 2: {
                return (long[][])this.o;
            }
            case 3: {
                return (long[][][])this.o;
            }
            case 4: {
                return (long[][][][])this.o;
            }
        }
        return null;
    }

    @Override
    public ByteBuffer buffer(Class<?> cl, int ignore) throws Throwable {
        if (cl != Long.TYPE && cl != Integer.TYPE) {
            throw new Throwable("Only int and long targets supported");
        }
        if (this.dim > 4) {
            throw new Throwable("Rank > 4 not supported");
        }
        int elementSize = cl == Integer.TYPE ? 4 : 8;
        ByteBuffer buf = this.allocate(elementSize);
        if (cl == Integer.TYPE) {
            return this.doInt(buf);
        }
        return this.doLong(buf);
    }

    ByteBuffer doInt(ByteBuffer buf) {
        int[] _dim = this.aa.getDimensions();
        int[] temp = null;
        IntBuffer _buf = buf.asIntBuffer();
        switch (this.dim) {
            case 1: {
                long[] data = (long[])this.o;
                temp = new int[data.length];
                for (int i = 0; i < data.length; ++i) {
                    temp[i] = (int)data[i];
                }
                _buf.put(temp);
                return buf;
            }
            case 2: {
                long[][] data2 = (long[][])this.o;
                temp = new int[_dim[1]];
                for (int i = 0; i < _dim[0]; ++i) {
                    long[] di = data2[i];
                    for (int j = 0; j < _dim[1]; ++j) {
                        temp[j] = (int)di[j];
                    }
                    _buf.put(temp);
                }
                return buf;
            }
            case 3: {
                long[][][] data3 = (long[][][])this.o;
                if (this.rowMajority) {
                    temp = new int[_dim[2]];
                    for (int i = 0; i < _dim[0]; ++i) {
                        for (int j = 0; j < _dim[1]; ++j) {
                            long[] di = data3[i][j];
                            for (int k = 0; k < _dim[2]; ++k) {
                                temp[k] = (int)di[k];
                            }
                            _buf.put(temp);
                        }
                    }
                } else {
                    for (int i = 0; i < _dim[0]; ++i) {
                        for (int k = 0; k < _dim[2]; ++k) {
                            for (int j = 0; j < _dim[1]; ++j) {
                                _buf.put((int)data3[i][j][k]);
                            }
                        }
                    }
                }
                return buf;
            }
            case 4: {
                long[][][][] data4 = (long[][][][])this.o;
                if (this.rowMajority) {
                    temp = new int[_dim[3]];
                    for (int i = 0; i < _dim[0]; ++i) {
                        for (int j = 0; j < _dim[1]; ++j) {
                            for (int k = 0; k < _dim[2]; ++k) {
                                long[] di = data4[i][j][k];
                                for (int l = 0; l < _dim[3]; ++l) {
                                    temp[l] = (int)di[l];
                                }
                                _buf.put(temp);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < _dim[0]; ++i) {
                        for (int l = 0; l < _dim[3]; ++l) {
                            for (int k = 0; k < _dim[2]; ++k) {
                                for (int j = 0; j < _dim[1]; ++j) {
                                    _buf.put((int)data4[i][j][k][l]);
                                }
                            }
                        }
                    }
                }
                return buf;
            }
        }
        return null;
    }

    ByteBuffer doLong(ByteBuffer buf) {
        int[] _dim = this.aa.getDimensions();
        LongBuffer _buf = buf.asLongBuffer();
        switch (this.dim) {
            case 1: {
                long[] data = (long[])this.o;
                _buf.put(data);
                return buf;
            }
            case 2: {
                long[][] data2 = (long[][])this.o;
                for (int i = 0; i < _dim[0]; ++i) {
                    _buf.put(data2[i]);
                }
                return buf;
            }
            case 3: {
                long[][][] data3 = (long[][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < _dim[0]; ++i) {
                        for (int j = 0; j < _dim[1]; ++j) {
                            _buf.put(data3[i][j]);
                        }
                    }
                } else {
                    for (int i = 0; i < _dim[0]; ++i) {
                        for (int k = 0; k < _dim[2]; ++k) {
                            for (int j = 0; j < _dim[1]; ++j) {
                                _buf.put(data3[i][j][k]);
                            }
                        }
                    }
                }
                return buf;
            }
            case 4: {
                long[][][][] data4 = (long[][][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < _dim[0]; ++i) {
                        for (int j = 0; j < _dim[1]; ++j) {
                            for (int k = 0; k < _dim[2]; ++k) {
                                _buf.put(data4[i][j][k]);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < _dim[0]; ++i) {
                        for (int l = 0; l < _dim[3]; ++l) {
                            for (int k = 0; k < _dim[2]; ++k) {
                                for (int j = 0; j < _dim[1]; ++j) {
                                    _buf.put(data4[i][j][k][l]);
                                }
                            }
                        }
                    }
                }
                return buf;
            }
        }
        return null;
    }
}

