/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDF2Impl;
import gov.nasa.gsfc.spdf.cdfj.CDF3Impl;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFFactory;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.CDFReader;
import gov.nasa.gsfc.spdf.cdfj.CDFUrl;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;

public final class ReaderFactory {
    static int preamble = 3000;

    public static CDFReader getReader(String fname) throws CDFException.ReaderError {
        CDFImpl cdf = null;
        File file = new File(fname);
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            long len = raf.length();
            if (len > (long)preamble) {
                len = preamble;
            }
            byte[] ba = new byte[(int)len];
            raf.readFully(ba);
            ByteBuffer buf = ByteBuffer.wrap(ba);
            cdf = ReaderFactory.getVersion(buf, raf.getChannel());
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError("I/O Error reading " + fname);
        }
        final String _fname = file.getPath();
        cdf.setSource(new CDFFactory.CDFSource(){

            @Override
            public String getName() {
                return _fname;
            }

            @Override
            public boolean isFile() {
                return true;
            }
        });
        CDFReader rdr = new CDFReader();
        rdr.setImpl(cdf);
        return rdr;
    }

    public static CDFReader getReader(URL url) throws CDFException.ReaderError {
        CDFImpl cdf = null;
        try {
            int got;
            int remaining;
            URLConnection con = new CDFUrl(url).openConnection();
            InputStream is = con.getInputStream();
            byte[] ba = new byte[remaining];
            int offset = 0;
            for (remaining = con.getContentLength(); remaining > 0; remaining -= got) {
                got = is.read(ba, offset, remaining);
                offset += got;
            }
            ((HttpURLConnection)con).disconnect();
            ByteBuffer buf = ByteBuffer.wrap(ba);
            cdf = CDFFactory.getVersion(buf);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError("I/O Error reading " + url);
        }
        CDFReader rdr = new CDFReader();
        rdr.setImpl(cdf);
        final String _url = url.toString();
        cdf.setSource(new CDFFactory.CDFSource(){

            @Override
            public String getName() {
                return _url;
            }

            @Override
            public boolean isFile() {
                return false;
            }
        });
        return rdr;
    }

    static CDFImpl getVersion(ByteBuffer buf, FileChannel ch) throws Throwable {
        LongBuffer lbuf = buf.asLongBuffer();
        long magic = lbuf.get();
        if (magic == -3606538872298602497L) {
            return new CDF3Impl(buf, ch);
        }
        if (magic == -3606538868862746623L) {
            ByteBuffer mbuf = CDFFactory.uncompressed(buf, 3);
            return new CDF3Impl(mbuf);
        }
        if (magic == 0xFFFF0000FFFFL) {
            int release = buf.getInt(24);
            return new CDF2Impl(buf, release, ch);
        }
        ShortBuffer sbuf = buf.asShortBuffer();
        if (sbuf.get() == -12814 && sbuf.get() == 24578) {
            short x = sbuf.get();
            if (x == 0) {
                if (sbuf.get() == -1) {
                    return new CDF2Impl(buf, 6, ch);
                }
            } else if (x == -13108 && sbuf.get() == 1) {
                ByteBuffer mbuf = CDFFactory.uncompressed(buf, 2);
                return new CDF2Impl(mbuf, 6, ch);
            }
        }
        return null;
    }

    public static CDFReader getReader(String fname, boolean map) throws CDFException.ReaderError {
        CDFImpl cdf = null;
        File file = new File(fname);
        try {
            int len = (int)file.length();
            byte[] ba = new byte[len];
            try (FileInputStream fis = new FileInputStream(file);){
                int n = 0;
                for (int rem = len; rem > 0; rem -= len) {
                    len = fis.read(ba, n, rem);
                    n += len;
                }
            }
            cdf = CDFFactory.getCDF(ba);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError("I/O Error reading " + fname);
        }
        final String _fname = file.getPath();
        cdf.setSource(new CDFFactory.CDFSource(){

            @Override
            public String getName() {
                return _fname;
            }

            @Override
            public boolean isFile() {
                return true;
            }
        });
        CDFReader rdr = new CDFReader();
        rdr.setImpl(cdf);
        return rdr;
    }
}

