/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFReader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.autoplot.cdf.CdfDataSource;
import org.autoplot.cdf.CdfUtil;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.RecentComboBox;
import org.autoplot.datasource.URISplit;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.util.DasExceptionHandler;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;

public final class CdfJavaDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    public static final String NO_PLOTTABLE_PARAMETERS_MSG = "<html><i>No plottable parameters</i></html>";
    private static final int MAX_SLICE1_OFFER = 32;
    private static final Logger logger = Logger.getLogger("apdss.cdf");
    private boolean isValidCDF = false;
    private boolean listening = true;
    private JCheckBox emptyVariablesCB;
    private RecentComboBox filterComboBox;
    private JLabel interpretMetadataLabel;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JCheckBox noDep;
    private JCheckBox noInterpMeta;
    private JLabel paramInfo;
    private JTree parameterTree;
    private JCheckBox showAllVarTypeCB;
    private JCheckBox sortAlphaCheckBox;
    private JComboBox subsetComboBox;
    private JCheckBox whereCB;
    private JComboBox whereOp;
    private JComboBox whereParamList;
    private JTextField whereTF;
    private JCheckBox xCheckBox;
    private JTree xParameterTree;
    private JCheckBox yCheckBox;
    private JTree yParameterTree;
    private BindingGroup bindingGroup;
    JComponent delegateComponent = null;
    DataSetSelector delegateDataSetSelector = null;
    DataSourceEditorPanel delegateEditorPanel = null;
    Map<String, String> params;
    String vapScheme;
    URI resourceUri;
    Map<String, String> parameterDescriptions;
    Map<String, String> parameterInfo;
    Map<String, String> xparameterInfo;
    Map<String, String> yparameterInfo;
    LinkedHashMap<String, CdfUtil.CdfVariableDescription> cdfParameterInfo;
    String parameter;
    String xparameter;
    String yparameter;
    public static final String X_PARAMETER = "X_PARAMETER";
    public static final String Y_PARAMETER = "Y_PARAMETER";
    boolean showAllInitially = false;
    long subsetMaxRec = -1L;
    File cdfFile;
    CDFReader cdf;
    Throwable cdfException;

    public CdfJavaDataSourceEditorPanel() {
        this.initComponents();
        this.parameterTree.getSelectionModel().setSelectionMode(4);
        this.xParameterTree.getSelectionModel().setSelectionMode(1);
        this.yParameterTree.getSelectionModel().setSelectionMode(1);
        this.jPanel3.setVisible(false);
        if (AutoplotHelpSystem.getHelpSystem() != null) {
            AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this, "cdf_main");
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel1 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.subsetComboBox = new JComboBox();
        this.interpretMetadataLabel = new JLabel();
        this.noInterpMeta = new JCheckBox();
        this.noDep = new JCheckBox();
        this.showAllVarTypeCB = new JCheckBox();
        this.whereCB = new JCheckBox();
        this.whereParamList = new JComboBox();
        this.whereOp = new JComboBox();
        this.whereTF = new JTextField();
        this.filterComboBox = new RecentComboBox();
        this.sortAlphaCheckBox = new JCheckBox();
        this.emptyVariablesCB = new JCheckBox();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane3 = new JScrollPane();
        this.parameterTree = new JTree();
        this.jPanel2 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.xParameterTree = new JTree();
        this.xCheckBox = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.yParameterTree = new JTree();
        this.yCheckBox = new JCheckBox();
        this.jScrollPane2 = new JScrollPane();
        this.paramInfo = new JLabel();
        this.setName("cdfDataSourceEditorPanel");
        this.setPreferredSize(new Dimension(615, 452));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setPreferredSize(new Dimension(615, 452));
        this.jSplitPane2.setDividerLocation(230);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane1.setDividerLocation(320);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Advanced"));
        this.jPanel3.setMaximumSize(new Dimension(285, Short.MAX_VALUE));
        this.jLabel4.setText("Load subset of the data:");
        this.jLabel4.setToolTipText("<html>Load a subset of the data records, for example:<br>[0:100]  first 100 records<br> [-100:] last 100 records<br> [::10] every tenth record<br> </html>");
        this.subsetComboBox.setEditable(true);
        this.subsetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "::10", "0:100", "-100:", "0:10000:5"}));
        this.subsetComboBox.setToolTipText("<html>Load a subset of the data records, for example:<br>[0:100]  first 100 records<br> [-100:] last 100 records<br> [::10] every tenth record<br> </html>");
        this.interpretMetadataLabel.setText("Interpret Metadata:");
        this.noInterpMeta.setText("no ISTP");
        this.noInterpMeta.setToolTipText("Don't interpret metadata to get titles and units.");
        this.noDep.setText("no dependencies");
        this.noDep.setToolTipText("Ignore connections between variables like \"DEPEND_0\"\n");
        this.showAllVarTypeCB.setText("show all");
        this.showAllVarTypeCB.setToolTipText("show all parameters, even if ISTP VAR_TYPE is not \"data\"");
        this.showAllVarTypeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.showAllVarTypeCBActionPerformed(evt);
            }
        });
        this.whereCB.setText("Only load data where:");
        this.whereCB.setToolTipText("return only the records where the condition is true");
        this.whereParamList.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.whereCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.whereParamList, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.whereOp.setModel(new DefaultComboBoxModel<String>(new String[]{".eq", ".gt", ".lt", ".ne", ".within"}));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.whereCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.whereOp, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.whereTF.setText("0");
        this.whereTF.setToolTipText("enter the value, or \"mode\" for the most frequently occuring value.");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.whereCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.whereTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.filterComboBox.setToolTipText("Pattern to match in variables names.  If this is a valid regular expression, it will be used as such, otherwise the variables containing the string are used.");
        this.filterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.filterComboBoxActionPerformed(evt);
            }
        });
        this.sortAlphaCheckBox.setText("sort alpha");
        this.sortAlphaCheckBox.setToolTipText("Sort the names alphabetically.");
        this.sortAlphaCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.sortAlphaCheckBoxActionPerformed(evt);
            }
        });
        this.emptyVariablesCB.setSelected(true);
        this.emptyVariablesCB.setText("empty variables");
        this.emptyVariablesCB.setToolTipText("show variables which have no records");
        this.emptyVariablesCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.emptyVariablesCBActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.whereParamList, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.whereOp, -2, 84, -2).addPreferredGap(0).add((Component)this.whereTF, -2, 53, -2)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabel4).add((Component)this.whereCB).add((Component)this.interpretMetadataLabel).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.noInterpMeta).add((Component)this.showAllVarTypeCB).add((Component)this.sortAlphaCheckBox)).addPreferredGap(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.filterComboBox, -2, -1, -2).add((Component)this.noDep).add((Component)this.emptyVariablesCB))).add((Component)this.subsetComboBox, -2, 160, -2)))).add(0, 0, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.subsetComboBox, -2, -1, -2).addPreferredGap(0).add((Component)this.whereCB).add(8, 8, 8).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.whereParamList, -2, -1, -2).add((Component)this.whereOp, -2, -1, -2).add((Component)this.whereTF, -2, -1, -2)).addPreferredGap(0).add((Component)this.interpretMetadataLabel).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.noInterpMeta).add((Component)this.noDep)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.showAllVarTypeCB).add((Component)this.filterComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.sortAlphaCheckBox).add((Component)this.emptyVariablesCB))));
        this.jSplitPane1.setRightComponent(this.jPanel3);
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CdfJavaDataSourceEditorPanel.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.parameterTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.parameterTreeValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.parameterTree);
        this.jTabbedPane1.addTab("Data", this.jScrollPane3);
        this.xParameterTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.xParameterTreeValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.xParameterTree);
        this.xCheckBox.setText("Set Variable for X");
        this.xCheckBox.setToolTipText("Specify the parameter to use for the X tags, overriding any settings found in the file.");
        this.xCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.xCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.xCheckBox, -1, 401, Short.MAX_VALUE).add((Component)this.jScrollPane4));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.xCheckBox).addPreferredGap(0).add((Component)this.jScrollPane4, -1, 169, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("X", this.jPanel2);
        this.yParameterTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.yParameterTreeValueChanged(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.yParameterTree);
        this.yCheckBox.setText("Set Variable for Y");
        this.yCheckBox.setToolTipText("Specify the parameter to use for the Y tags, overriding any settings found in the file.");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.yCheckBox, -1, 401, Short.MAX_VALUE).add((Component)this.jScrollPane5));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.yCheckBox).addPreferredGap(0).add((Component)this.jScrollPane5, -1, 169, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Y", this.jPanel4);
        this.jSplitPane1.setLeftComponent(this.jTabbedPane1);
        this.jSplitPane2.setTopComponent(this.jSplitPane1);
        this.jScrollPane2.setMaximumSize(new Dimension(1000, 600));
        this.paramInfo.setText("Variable");
        this.paramInfo.setVerticalAlignment(1);
        this.paramInfo.setMaximumSize(new Dimension(1000, 4000));
        this.paramInfo.setPreferredSize(new Dimension(600, 100));
        this.paramInfo.setVerticalTextPosition(1);
        this.jScrollPane2.setViewportView(this.paramInfo);
        this.jSplitPane2.setRightComponent(this.jScrollPane2);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jSplitPane2, -1, 675, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jSplitPane2, -1, 425, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.bindingGroup.bind();
    }

    private void showAllVarTypeCBActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.setURI(this.getURI());
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        int tab = this.jTabbedPane1.getSelectedIndex();
        this.updateMetadata(tab);
    }

    private void yParameterTreeValueChanged(TreeSelectionEvent evt) {
        this.yCheckBox.setSelected(true);
        TreePath tp = evt.getPath();
        if (this.isValidCDF) {
            this.yparameter = String.valueOf(tp.getPathComponent(1));
            String longName = this.yparameterInfo.get(this.yparameter);
            this.paramInfo.setText(longName);
        }
    }

    private void xCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void xParameterTreeValueChanged(TreeSelectionEvent evt) {
        this.xCheckBox.setSelected(true);
        TreePath tp = evt.getPath();
        if (this.isValidCDF) {
            this.xparameter = String.valueOf(tp.getPathComponent(1));
            String longName = this.xparameterInfo.get(this.xparameter);
            this.paramInfo.setText(longName);
        }
    }

    private void parameterTreeValueChanged(TreeSelectionEvent evt) {
        TreePath tp = evt.getPath();
        if (this.isValidCDF && this.listening) {
            this.parameter = String.valueOf(tp.getPathComponent(1));
            String slice1 = "";
            String s = this.getParamAndSubset(this.xParameterTree, "");
            if (this.xparameter != null && this.xparameter.length() <= s.length()) {
                slice1 = s.substring(this.xparameter.length());
            }
            LinkedHashMap<String, CdfUtil.CdfVariableDescription> xx = CdfJavaDataSourceEditorPanel.getCompatible(this.cdfParameterInfo, this.parameter, X_PARAMETER);
            this.fillTree(this.xParameterTree, this.toDescriptions(xx), this.cdf, this.xparameter, slice1);
            s = this.getParamAndSubset(this.yParameterTree, "");
            slice1 = "";
            if (this.yparameter != null && this.yparameter.length() <= s.length()) {
                slice1 = s.substring(this.yparameter.length());
            }
            LinkedHashMap<String, CdfUtil.CdfVariableDescription> yy = CdfJavaDataSourceEditorPanel.getCompatible(this.cdfParameterInfo, this.parameter, Y_PARAMETER);
            this.fillTree(this.yParameterTree, this.toDescriptions(yy), this.cdf, this.yparameter, slice1);
            this.updateMetadata();
        }
    }

    private Map<String, String> toDescriptions(LinkedHashMap<String, CdfUtil.CdfVariableDescription> xx) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, CdfUtil.CdfVariableDescription> e : xx.entrySet()) {
            CdfUtil.CdfVariableDescription desc = e.getValue();
            result.put(e.getKey(), desc.htmlDescription);
        }
        return result;
    }

    public static LinkedHashMap<String, CdfUtil.CdfVariableDescription> getCompatible(LinkedHashMap<String, CdfUtil.CdfVariableDescription> cdfParameterInfo, String parameter, Object whichIndependentParameter) {
        CdfUtil.CdfVariableDescription dependent = cdfParameterInfo.get(parameter);
        LinkedHashMap<String, CdfUtil.CdfVariableDescription> result = new LinkedHashMap<String, CdfUtil.CdfVariableDescription>();
        for (Map.Entry<String, CdfUtil.CdfVariableDescription> cvds : cdfParameterInfo.entrySet()) {
            CdfUtil.CdfVariableDescription cvd = cvds.getValue();
            if (dependent != null && whichIndependentParameter == X_PARAMETER) {
                if (cvd.numberOfRecords != dependent.numberOfRecords || cvd.dimensions.length != 0 && (cvd.dimensions.length != 1 || cvd.dimensions[0] != 2)) continue;
                result.put(cvd.name, cvd);
                continue;
            }
            if (dependent != null && whichIndependentParameter == Y_PARAMETER) {
                if (cvd.dimensions.length == 1 && dependent.dimensions.length == 1 && cvd.dimensions[0] == dependent.dimensions[0]) {
                    if (cvd.numberOfRecords == 1L) {
                        result.put(cvd.name, cvd);
                        continue;
                    }
                    if (cvd.numberOfRecords != dependent.numberOfRecords) continue;
                    result.put(cvd.name, cvd);
                    continue;
                }
                if (cvd.dimensions.length != 0 || dependent.dimensions.length != 0 || cvd.numberOfRecords != dependent.numberOfRecords) continue;
                result.put(cvd.name, cvd);
                continue;
            }
            result.put(cvd.name, cvd);
        }
        return result;
    }

    private void filterComboBoxActionPerformed(ActionEvent evt) {
        this.updateTree();
    }

    private void sortAlphaCheckBoxActionPerformed(ActionEvent evt) {
        this.updateTree();
    }

    private void emptyVariablesCBActionPerformed(ActionEvent evt) {
        this.setURI(this.getURI());
    }

    private void updateTree() {
        String param = this.getParam();
        this.fillTree(this.parameterTree, this.parameterInfo, this.cdf, param, "");
    }

    private void updateMetadata() {
        this.updateMetadata(0);
    }

    private void updateMetadata(int tab) {
        switch (tab) {
            case 0: {
                if (this.parameter != null) {
                    String longName = this.parameterInfo.get(this.parameter);
                    this.paramInfo.setText(longName);
                    break;
                }
            }
            case 1: {
                if (this.xparameter != null) {
                    String longName = this.xparameterInfo.get(this.xparameter);
                    this.paramInfo.setText(longName);
                    break;
                }
            }
            case 2: {
                if (this.yparameter == null) break;
                String longName = this.yparameterInfo.get(this.yparameter);
                this.paramInfo.setText(longName);
                break;
            }
        }
    }

    public JPanel getPanel() {
        if (this.showAllInitially) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CdfJavaDataSourceEditorPanel.this.showAllVarTypeCB.setSelected(true);
                    CdfJavaDataSourceEditorPanel.this.setURI(CdfJavaDataSourceEditorPanel.this.getURI());
                }
            });
        }
        return this;
    }

    public void setShowAdvancedSubpanel(boolean v) {
        this.noDep.setVisible(v);
        this.noInterpMeta.setVisible(v);
    }

    public boolean reject(String url) throws IOException, URISyntaxException {
        URISplit split = URISplit.parse((String)url);
        if (split.resourceUri == null) {
            return true;
        }
        FileSystem fs = FileSystem.create((URI)DataSetURI.getWebURL((URI)DataSetURI.toUri((String)split.path)).toURI());
        return fs.isDirectory(split.file.substring(split.path.length()));
    }

    public boolean prepare(String url, Window parent, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse((String)url);
        this.cdfFile = DataSetURI.getFile((URI)split.resourceUri, (ProgressMonitor)mon);
        DataSetURI.checkLength((File)this.cdfFile);
        logger.log(Level.FINE, "opening cdf file {0}", this.cdfFile.toString());
        try {
            CdfDataSource.checkCdf(this.cdfFile);
            this.cdf = CdfDataSource.getCdfFile(this.cdfFile.toString());
            if (this.cdf == null) {
                throw new IllegalArgumentException("file is not a CDF file");
            }
            this.cdfException = null;
        }
        catch (IOException | IllegalArgumentException ex) {
            this.cdfException = ex;
        }
        return true;
    }

    public static String getKeyForFile(String filename) {
        int j = filename.indexOf("19");
        if (j == -1) {
            j = filename.indexOf("20");
        }
        if (j == -1) {
            j = filename.length();
        }
        while (j > 0 && filename.charAt(j - 1) == '_') {
            --j;
        }
        String key = filename.substring(0, j);
        return key;
    }

    public void setURI(String url) {
        URISplit split = URISplit.parse((String)url);
        this.vapScheme = split.vapScheme;
        LinkedHashMap lparams = URISplit.parseParams((String)split.params);
        try {
            int i;
            int i2;
            int i3;
            String label;
            this.resourceUri = split.resourceUri;
            this.cdfFile = DataSetURI.getFile((URI)split.resourceUri, (ProgressMonitor)new NullProgressMonitor());
            DataSetURI.checkLength((File)this.cdfFile);
            String fileName = this.cdfFile.toString();
            String key = CdfJavaDataSourceEditorPanel.getKeyForFile(split.file.substring(split.path.length()));
            this.filterComboBox.setPreferenceNode("cdf_" + key);
            this.filterComboBox.setToolTipText("Filter parameters");
            logger.log(Level.FINE, "opening cdf file {0}", fileName);
            if (this.cdf == null && this.cdfException == null) {
                try {
                    this.cdf = CdfDataSource.getCdfFile(fileName);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (this.cdfException != null) {
                this.parameterTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("")));
                this.paramInfo.setText("<html>Unable to read CDF file:<br>" + this.cdfException.getMessage());
                return;
            }
            logger.finest("inspect cdf for plottable parameters");
            boolean isMaster = fileName.contains("MASTERS");
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("includeEmptyRecords", String.valueOf(this.emptyVariablesCB.isSelected()));
            options.put("isMaster", String.valueOf(isMaster));
            options.put("deep", String.valueOf(true));
            try {
                this.parameterDescriptions = CdfUtil.getPlottable(this.cdf, !this.showAllVarTypeCB.isSelected(), 4);
            }
            catch (Exception ex) {
                this.parameterTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("")));
                this.paramInfo.setText("<html>Unable to work with metadata in CDF file:<br>" + ex);
                throw ex;
            }
            Map<String, String> allParameterInfo = CdfUtil.getPlottable(this.cdf, false, 4, options);
            Map<String, String> dataParameterInfo = CdfUtil.getPlottable(this.cdf, true, 4, options);
            options.put("deep", String.valueOf(false));
            Map<String, String> whereParameterInfo = CdfUtil.getPlottable(this.cdf, false, 2, options);
            this.cdfParameterInfo = CdfUtil.getPlottable(this.cdf, options);
            String param = (String)lparams.remove("arg_0");
            String[] params = null;
            if (param != null) {
                for (String p : params = param.split(";", -2)) {
                    if (dataParameterInfo.containsKey(p)) continue;
                    this.showAllVarTypeCB.setSelected(true);
                    this.parameterDescriptions = CdfUtil.getPlottable(this.cdf, !this.showAllVarTypeCB.isSelected(), 4, new HashMap<String, String>());
                    this.showAllVarTypeCB.setEnabled(false);
                }
            }
            if (dataParameterInfo.isEmpty() && !this.cdfParameterInfo.isEmpty()) {
                this.showAllVarTypeCB.setSelected(true);
            }
            if (this.showAllVarTypeCB.isSelected()) {
                this.parameterInfo = allParameterInfo;
                label = "Select CDF Variable (%d data, %d support):";
            } else {
                this.parameterInfo = dataParameterInfo;
                label = "Select CDF Variable (%d data, %d support not shown):";
            }
            this.xparameterInfo = allParameterInfo;
            this.yparameterInfo = allParameterInfo;
            this.isValidCDF = true;
            this.jPanel3.setVisible(true);
            int numData = dataParameterInfo.size();
            int numSupport = allParameterInfo.size() - numData;
            if (this.showAllVarTypeCB.isSelected()) {
                this.jTabbedPane1.setTitleAt(0, String.format("Select CDF Variable (of %d)", numData + numSupport));
            } else {
                this.jTabbedPane1.setTitleAt(0, String.format("Select CDF Variable (of %d)", numData));
            }
            this.jTabbedPane1.setToolTipText(String.format(label, numData, numSupport));
            if (this.showAllVarTypeCB.isSelected()) {
                this.showAllVarTypeCB.setText("show all (" + numSupport + " support shown)");
            } else {
                this.showAllVarTypeCB.setText("show all (" + numSupport + " support not shown)");
            }
            Pattern slice1pattern = Pattern.compile("\\[\\:\\,(\\d+)\\]");
            String slice = (String)lparams.remove("slice1");
            Pattern slice2pattern = Pattern.compile("\\[\\:\\,\\:\\,(\\d+)\\]");
            Pattern slice3pattern = Pattern.compile("\\[\\:\\,\\:\\,\\:\\,(\\d+)\\]");
            String subset = null;
            if (param != null && (i3 = param.indexOf("[")) != -1) {
                subset = param.substring(i3);
                param = param.substring(0, i3);
                Matcher m = slice1pattern.matcher(subset);
                if (m.matches()) {
                    slice = m.group(1);
                    subset = null;
                }
                if (subset != null) {
                    m = slice2pattern.matcher(subset);
                    if (m.matches()) {
                        slice = m.group(1);
                        subset = null;
                    } else {
                        m = slice3pattern.matcher(subset);
                        if (m.matches()) {
                            slice = m.group(1);
                            subset = null;
                        }
                    }
                }
            }
            if (allParameterInfo.containsKey(param) && !dataParameterInfo.containsKey(param)) {
                this.showAllInitially = true;
            }
            this.listening = false;
            if (params != null && params.length > 1) {
                this.fillTree(this.parameterTree, this.parameterInfo, this.cdf, param, slice);
            } else {
                this.fillTree(this.parameterTree, this.parameterInfo, this.cdf, param, slice);
            }
            this.listening = true;
            Map<String, String> parameterDescriptions2 = CdfUtil.getPlottable(this.cdf, false, 2);
            String xparam = (String)lparams.remove("depend0");
            String xslice1 = null;
            if (xparam == null) {
                xparam = (String)lparams.remove("X");
            }
            if (xparam == null) {
                xparam = (String)lparams.remove("x");
            }
            if (xparam != null && (i2 = xparam.indexOf("[")) != -1) {
                String xsubset = xparam.substring(i2);
                xparam = xparam.substring(0, i2);
                Matcher m = slice1pattern.matcher(xsubset);
                if (m.matches()) {
                    xslice1 = m.group(1);
                }
            }
            this.fillTree(this.xParameterTree, parameterDescriptions2, this.cdf, xparam, xslice1);
            String yslice1 = null;
            String yparam = (String)lparams.remove("Y");
            if (yparam == null) {
                yparam = (String)lparams.remove("y");
            }
            if (yparam != null && (i = yparam.indexOf("[")) != -1) {
                String ysubset = yparam.substring(i);
                yparam = yparam.substring(0, i);
                Matcher m = slice1pattern.matcher(ysubset);
                if (m.matches()) {
                    yslice1 = m.group(1);
                }
            }
            this.fillTree(this.yParameterTree, parameterDescriptions2, this.cdf, yparam, yslice1);
            logger.finest("close cdf");
            DefaultComboBoxModel<String> cbmodel = new DefaultComboBoxModel<String>();
            for (String p : this.parameterDescriptions.keySet()) {
                cbmodel.addElement(p);
            }
            if (param != null) {
                if (subset != null) {
                    if (subset.startsWith("[")) {
                        subset = subset.substring(1);
                    }
                    if (subset.endsWith("]")) {
                        subset = subset.substring(0, subset.length() - 1);
                    }
                    this.subsetComboBox.setSelectedItem(subset);
                } else {
                    this.subsetComboBox.setSelectedItem("");
                }
            } else if (!this.parameterDescriptions.isEmpty()) {
                this.parameter = this.parameterDescriptions.entrySet().iterator().next().getKey();
                this.subsetComboBox.setSelectedItem("");
                param = this.parameter;
                this.paramInfo.setText("");
            } else {
                param = "";
                if (this.parameterTree.getRowCount() == 0 && numSupport > 0 && numData == 0 && !this.showAllVarTypeCB.isSelected()) {
                    this.paramInfo.setText("(all parameters are marked as support data, select \"show all\" above)");
                } else {
                    this.paramInfo.setText("(no plottable parameters)");
                }
            }
            this.parameter = param.replaceAll("%3D", "=");
            if ("no".equals(lparams.remove("interpMeta"))) {
                this.noInterpMeta.setSelected(true);
            }
            if ("no".equals(lparams.remove("doDep"))) {
                this.noDep.setSelected(true);
            }
            this.whereParamList.setModel(new DefaultComboBoxModel<Object>(whereParameterInfo.keySet().toArray()));
            String where = (String)lparams.remove("where");
            if (where != null && where.length() > 0) {
                this.whereCB.setSelected(true);
                int i4 = where.indexOf(".");
                if (i4 > -1) {
                    this.whereParamList.setSelectedItem(where.substring(0, i4));
                    int i0 = where.indexOf("(");
                    int i1 = where.indexOf(")", i0);
                    this.whereOp.setSelectedItem(where.substring(i4, i0));
                    this.whereTF.setText(where.substring(i0 + 1, i1).replaceAll("\\+", " "));
                }
            } else {
                this.whereCB.setSelected(false);
            }
            this.updateMetadata();
        }
        catch (IOException ex) {
            DasExceptionHandler.handle((Throwable)ex);
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IllegalArgumentException ex) {
            DasExceptionHandler.handle((Throwable)ex);
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (Exception ex) {
            DasExceptionHandler.handle((Throwable)ex);
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.params = lparams;
    }

    private String getParam() {
        TreePath treePath = this.parameterTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        String p = String.valueOf(treePath.getPathComponent(1));
        p = p.replaceAll("=", "%3D");
        return p;
    }

    private String getParamAndSubset(JTree jtree, String subset) {
        StringBuilder ps = new StringBuilder();
        TreePath[] tps = jtree.getSelectionPaths();
        if (tps == null) {
            tps = new TreePath[]{jtree.getSelectionPath()};
        }
        for (TreePath treePath : tps) {
            String p;
            if (ps.length() > 0) {
                ps.append(";");
            }
            if (treePath == null) {
                logger.fine("param was null");
                continue;
            }
            if (treePath.getPathCount() == 3) {
                int idx;
                p = String.valueOf(treePath.getPathComponent(1));
                p = p.replaceAll("=", "%3D");
                String val = String.valueOf(treePath.getPathComponent(2));
                int dims = 1;
                try {
                    dims = this.cdf.getDimensions(p).length;
                }
                catch (CDFException.ReaderError e) {
                    e.printStackTrace();
                }
                if (dims == 3) {
                    idx = val.indexOf(":");
                    ps.append(p).append("[:,:,:,").append(val.substring(0, idx).trim()).append("]");
                    continue;
                }
                if (dims == 2) {
                    idx = val.indexOf(":");
                    ps.append(p).append("[:,:,").append(val.substring(0, idx).trim()).append("]");
                    continue;
                }
                idx = val.indexOf(":");
                ps.append(p).append("[:,").append(val.substring(0, idx).trim()).append("]");
                continue;
            }
            p = String.valueOf(treePath.getPathComponent(1));
            p = p.replaceAll("=", "%3D");
            ps.append(p).append(subset);
        }
        return ps.toString();
    }

    public String getURI() {
        Map<String, String> lparams;
        URISplit split = URISplit.parse((URI)this.resourceUri);
        split.vapScheme = this.vapScheme;
        String subset = this.subsetComboBox.getSelectedItem().toString().trim();
        if (subset.length() > 0 && subset.charAt(0) != '[') {
            subset = "[" + subset + "]";
        }
        lparams = (lparams = this.params) != null ? new HashMap<String, String>(lparams) : new HashMap<String, String>();
        if (this.isValidCDF) {
            String p;
            TreePath[] tps = this.parameterTree.getSelectionPaths();
            if (tps != null && (p = this.getParamAndSubset(this.parameterTree, subset)).length() > 0) {
                lparams.put("arg_0", p);
            }
            if (this.xCheckBox.isSelected() && (p = this.getParamAndSubset(this.xParameterTree, "")).length() > 0) {
                lparams.put("X", p);
            }
            if (this.yCheckBox.isSelected() && (p = this.getParamAndSubset(this.yParameterTree, "")).length() > 0) {
                lparams.put("Y", p);
            }
            if (this.noDep.isSelected()) {
                lparams.put("doDep", "no");
            }
            if (this.noInterpMeta.isSelected()) {
                lparams.put("interpMeta", "no");
            }
            if (this.whereCB.isSelected()) {
                if (this.whereParamList.getSelectedItem() != null) {
                    lparams.put("where", String.format("%s%s(%s)", this.whereParamList.getSelectedItem(), this.whereOp.getSelectedItem(), this.whereTF.getText().replaceAll(" ", "+")));
                } else {
                    lparams.remove("where");
                }
            } else {
                lparams.remove("where");
            }
        }
        split.params = URISplit.formatParams(lparams);
        if (split.params != null && split.params.length() == 0) {
            split.params = null;
        }
        return URISplit.format((URISplit)split);
    }

    public void markProblems(List<String> problems) {
    }

    private void fillTree(JTree parameterTree, Map<String, String> mm, CDFReader cdf, String param, String slice1) {
        boolean sortAlpha;
        logger.entering("CdfJavaDataSourceEditorPanel", "fillTree");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        ArrayList<TreePath> expand = new ArrayList<TreePath>(mm.size());
        String filter = this.filterComboBox.getText().trim();
        Pattern filterPattern = null;
        if (filter.length() > 0) {
            try {
                filterPattern = Pattern.compile(filter, 2);
            }
            catch (PatternSyntaxException ex) {
                filterPattern = Pattern.compile(Pattern.quote(filter), 2);
            }
        }
        if (sortAlpha = this.sortAlphaCheckBox.isSelected()) {
            TreeMap<String, String> sortedMM = new TreeMap<String, String>();
            sortedMM.putAll(mm);
            mm = sortedMM;
        }
        ArrayList<TreePath> selections = new ArrayList<TreePath>();
        List<Object> params = param != null ? Arrays.asList(param.split(";")) : new ArrayList();
        TreePath selection = null;
        for (Map.Entry<String, String> e : mm.entrySet()) {
            String varname = e.getKey();
            if (filterPattern != null) {
                if (!filterPattern.matcher(varname).find() && !filterPattern.matcher(e.getValue()).find()) continue;
                logger.log(Level.FINER, "found pattern for {0}", varname);
            }
            try {
                boolean doComponents;
                int[] dimensions;
                boolean sureIsVector;
                List voattr;
                List oattr = cdf.getAttribute(varname, "LABL_PTR_2");
                String lablPtr = null;
                if (oattr != null && oattr instanceof List) {
                    voattr = oattr;
                    if (voattr.size() > 0) {
                        lablPtr = (String)((List)oattr).get(0);
                    } else {
                        oattr = Collections.emptyList();
                    }
                }
                if (oattr != null && oattr instanceof List && ((List)oattr).size() == 0 && (oattr = cdf.getAttribute(varname, "LABL_PTR_1")) != null && oattr instanceof List) {
                    voattr = oattr;
                    if (voattr.size() > 0) {
                        lablPtr = (String)((List)oattr).get(0);
                    } else {
                        oattr = null;
                    }
                }
                boolean bl = sureIsVector = (dimensions = cdf.getDimensions(varname)).length > 0 && dimensions[dimensions.length - 1] < 5;
                if (dimensions.length == 3 && oattr == null && sureIsVector) {
                    oattr = cdf.getAttribute(varname, "LABL_PTR_3");
                    lablPtr = null;
                    if (oattr != null && oattr instanceof List) {
                        List voattr2 = oattr;
                        if (voattr2.size() > 0) {
                            lablPtr = (String)((List)oattr).get(0);
                        } else {
                            oattr = Collections.emptyList();
                        }
                    }
                }
                boolean bl2 = doComponents = oattr != null && (dimensions.length == 1 || dimensions.length == 2 || sureIsVector) && dimensions[dimensions.length - 1] <= 32;
                if (doComponents) {
                    String s = lablPtr;
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(varname);
                    try {
                        String[] rec;
                        Object o = cdf.get(s);
                        if (o.getClass().isArray() && String.class.isAssignableFrom(o.getClass().getComponentType())) {
                            rec = (String[])o;
                        } else {
                            Object oo = Array.get(o, 0);
                            if (!oo.getClass().isArray() || !String.class.isAssignableFrom(oo.getClass().getComponentType())) {
                                logger.log(Level.FINE, "Expected string array in element: {0}", s);
                                continue;
                            }
                            rec = (String[])Array.get(o, 0);
                        }
                        for (int i = 0; i < rec.length; ++i) {
                            String snode = String.format("%d: %s", i, rec[i]);
                            DefaultMutableTreeNode child = new DefaultMutableTreeNode(snode);
                            node.add(child);
                            if (!varname.equals(param)) continue;
                            if (slice1 != null) {
                                if (!String.valueOf(i).equals(slice1)) continue;
                                selection = new TreePath(new Object[]{root, node, child});
                                continue;
                            }
                            selection = new TreePath(new Object[]{root, node});
                        }
                        root.add(node);
                        if (rec.length >= 4) continue;
                        expand.add(new TreePath(new Object[]{root, node}));
                    }
                    catch (CDFException.ReaderError | ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException ex) {
                        logger.log(Level.WARNING, "parameter name found: " + s + " referred to by " + varname, ex);
                        root.add(node);
                    }
                    continue;
                }
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(varname);
                root.add(node);
                if (params.contains(varname)) {
                    selections.add(new TreePath(new Object[]{root, node}));
                }
                if (!varname.equals(param)) continue;
                selection = new TreePath(new Object[]{root, node});
            }
            catch (CDFException.ReaderError t) {
                logger.log(Level.WARNING, t.getMessage(), t);
            }
        }
        DefaultTreeModel tm = new DefaultTreeModel(root);
        parameterTree.setRootVisible(false);
        parameterTree.setModel(tm);
        if (selection != null) {
            parameterTree.setSelectionPath(selection);
            parameterTree.scrollPathToVisible(selection);
        }
        if (selections.size() > 0) {
            parameterTree.setSelectionPaths(selections.toArray(new TreePath[selections.size()]));
        }
        for (TreePath tp : expand) {
            parameterTree.expandPath(tp);
        }
        logger.exiting("CdfJavaDataSourceEditorPanel", "fillTree");
    }

    private static boolean isSupportParameter(Map<String, CdfUtil.CdfVariableDescription> dataParameterInfo, String param) {
        if (param == null || param.trim().length() == 0) {
            return false;
        }
        String[] params = param.contains(";") ? param.split(";") : new String[]{param};
        for (String p : params) {
            CdfUtil.CdfVariableDescription cdfvd = dataParameterInfo.get(p);
            if (cdfvd == null || !cdfvd.isSupport) continue;
            return true;
        }
        return false;
    }
}

