/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class CdfVirtualVars {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.cdf");

    public static QDataSet execute(Map<String, Object> metadata, String function, List<QDataSet> args, ProgressMonitor mon) throws IllegalArgumentException {
        logger.log(Level.FINE, "implement virtual variable \"{0}\"", function);
        if (function.equalsIgnoreCase("sum_values")) {
            if (args.size() < 1) {
                throw new IllegalArgumentException("virtual variable function sum_values expects at least one argument");
            }
            QDataSet sum = args.get(0);
            for (int i = 1; i < args.size(); ++i) {
                sum = Ops.add((QDataSet)sum, (QDataSet)args.get(i));
            }
            return sum;
        }
        if (function.equalsIgnoreCase("compute_magnitude")) {
            return CdfVirtualVars.computeMagnitude(args.get(0));
        }
        if (function.equalsIgnoreCase("convert_log10")) {
            return CdfVirtualVars.convertLog10(args.get(0));
        }
        if (function.equalsIgnoreCase("fftPower512")) {
            return Ops.fftPower((QDataSet)args.get(0), (int)512, (ProgressMonitor)mon);
        }
        if (function.equalsIgnoreCase("fftPower1024")) {
            return Ops.fftPower((QDataSet)args.get(0), (int)1024, (ProgressMonitor)mon);
        }
        if (function.equalsIgnoreCase("fftPower")) {
            if (args.size() != 2) {
                throw new IllegalArgumentException("virtual variable function fftPower expects two arguments");
            }
            QDataSet size = args.get(1);
            while (size.rank() > 0) {
                size = size.slice(0);
            }
            mon.setProgressMessage("apply FFT power");
            return Ops.fftPower((QDataSet)args.get(0), (QDataSet)Ops.windowFunction((Ops.FFTFilterType)Ops.FFTFilterType.Hann, (int)((int)size.value())), (ProgressMonitor)mon);
        }
        if (function.equalsIgnoreCase("fftPowerDelta512")) {
            QDataSet deltaT = args.get(1);
            MutablePropertyDataSet waves = DataSetOps.makePropertiesMutable((QDataSet)args.get(0));
            while (deltaT.rank() > 0) {
                deltaT = deltaT.slice(0);
            }
            waves.putProperty("DEPEND_1", (Object)Ops.multiply((QDataSet)deltaT, (QDataSet)Ops.findgen((int)waves.length(0))));
            QDataSet pow = Ops.fftPower((QDataSet)waves, (int)512, (ProgressMonitor)mon);
            return pow;
        }
        if (function.equalsIgnoreCase("fftPowerDelta1024")) {
            QDataSet deltaT = args.get(1);
            MutablePropertyDataSet waves = DataSetOps.makePropertiesMutable((QDataSet)args.get(0));
            while (deltaT.rank() > 0) {
                deltaT = deltaT.slice(0);
            }
            waves.putProperty("DEPEND_1", (Object)Ops.multiply((QDataSet)deltaT, (QDataSet)Ops.findgen((int)waves.length(0))));
            QDataSet pow = Ops.fftPower((QDataSet)waves, (int)1024, (ProgressMonitor)mon);
            return pow;
        }
        if (function.equalsIgnoreCase("fftPowerDelta2048")) {
            QDataSet deltaT = args.get(1);
            MutablePropertyDataSet waves = DataSetOps.makePropertiesMutable((QDataSet)args.get(0));
            while (deltaT.rank() > 0) {
                deltaT = deltaT.slice(0);
            }
            waves.putProperty("DEPEND_1", (Object)Ops.multiply((QDataSet)deltaT, (QDataSet)Ops.findgen((int)waves.length(0))));
            QDataSet pow = Ops.fftPower((QDataSet)waves, (int)2048, (ProgressMonitor)mon);
            return pow;
        }
        if (function.equalsIgnoreCase("fftPowerDeltaTranslation512")) {
            QDataSet deltaT = args.get(1);
            QDataSet translation = args.get(2);
            MutablePropertyDataSet waves = DataSetOps.makePropertiesMutable((QDataSet)args.get(0));
            waves.putProperty("DEPEND_1", (Object)Ops.multiply((QDataSet)deltaT.slice(0), (QDataSet)Ops.findgen((int)waves.length(0))));
            QDataSet pow = Ops.fftPower((QDataSet)waves, (int)512, (ProgressMonitor)mon);
            MutablePropertyDataSet poww = DataSetOps.makePropertiesMutable((QDataSet)pow);
            QDataSet trs1 = Ops.add((QDataSet)((QDataSet)pow.property("DEPEND_1")), (QDataSet)translation.slice(0));
            poww.putProperty("DEPEND_1", (Object)trs1);
            throw new IllegalArgumentException("fftPowerDeltaTranslation512 is untested");
        }
        if (function.equalsIgnoreCase("calc_p")) {
            return CdfVirtualVars.calcP(args);
        }
        if (function.equalsIgnoreCase("conv_pos1")) {
            return CdfVirtualVars.convPos(args, "ANG-GSE");
        }
        if (function.equalsIgnoreCase("alternate_view")) {
            return args.get(0);
        }
        if (function.equalsIgnoreCase("region_filt")) {
            ArrayDataSet real_data = ArrayDataSet.copy((QDataSet)args.get(0));
            QDataSet region_data = args.get(1);
            Number fill = (Number)metadata.get("FILLVAL");
            if (fill == null) {
                fill = Double.NaN;
            }
            for (int i = 0; i < real_data.length(); ++i) {
                if (region_data.value(i) == 1.0) continue;
                real_data.putValue(i, fill.doubleValue());
            }
            return real_data;
        }
        if (function.equalsIgnoreCase("apply_qflag")) {
            QDataSet quality_data = args.get(1);
            QDataSet data = args.get(0);
            String n = ((String)data.property("NAME")).toLowerCase();
            int channel = 0;
            switch (n) {
                case "flux_h": 
                case "sigma_h": {
                    channel = 0;
                    break;
                }
                case "flux_o": 
                case "sigma_o": {
                    channel = 1;
                    break;
                }
                case "flux_he_1": 
                case "sigma_he_1": {
                    channel = 2;
                    break;
                }
                case "flux_he_2": 
                case "sigma_he_2": {
                    channel = 3;
                    break;
                }
            }
            quality_data = Ops.slice1((QDataSet)quality_data, (int)channel);
            QDataSet rBad = Ops.where((QDataSet)Ops.ge((Object)quality_data, (Object)4));
            double fill = (Double)data.property("FILL_VALUE");
            WritableDataSet wdata = Ops.copy((QDataSet)data);
            for (int i = 0; i < rBad.length(); ++i) {
                for (int j = 0; j < data.length(i); ++j) {
                    for (int k = 0; k < data.length(i, j); ++k) {
                        wdata.putValue(i, j, k, fill);
                    }
                }
            }
            return wdata;
        }
        if (function.equalsIgnoreCase("apply_esa_qflag")) {
            ArrayDataSet esa_data = ArrayDataSet.copy((QDataSet)args.get(0));
            QDataSet quality_data = args.get(1);
            Number fill = (Number)metadata.get("FILLVAL");
            if (fill == null) {
                fill = Double.NaN;
            }
            double dfill = fill.doubleValue();
            int n = DataSetUtil.product((int[])DataSetUtil.qubeDims((QDataSet)esa_data.slice(0)));
            block58: for (int i = 0; i < quality_data.length(); ++i) {
                if (!(quality_data.value(i) > 0.0)) continue;
                switch (esa_data.rank()) {
                    case 1: {
                        esa_data.putValue(i, dfill);
                        continue block58;
                    }
                    case 2: {
                        int j;
                        int n1 = esa_data.length(0);
                        for (j = 0; j < n1; ++j) {
                            esa_data.putValue(i, j, dfill);
                        }
                        continue block58;
                    }
                    case 3: {
                        int k;
                        int n2;
                        int j;
                        int n1 = esa_data.length(0);
                        for (j = 0; j < n1; ++j) {
                            n2 = esa_data.length(0, 0);
                            for (k = 0; k < n2; ++k) {
                                esa_data.putValue(i, j, k, dfill);
                            }
                        }
                        continue block58;
                    }
                    case 4: {
                        int k;
                        int n2;
                        int j;
                        int n1 = esa_data.length(0);
                        for (j = 0; j < n1; ++j) {
                            n2 = esa_data.length(0, 0);
                            for (k = 0; k < n2; ++k) {
                                int n3 = esa_data.length(0, 0);
                                for (int l = 0; l < n3; ++l) {
                                    esa_data.putValue(i, j, k, 1, dfill);
                                }
                            }
                        }
                        continue block58;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported rank ");
                    }
                }
            }
            return esa_data;
        }
        if (function.equalsIgnoreCase("arr_slice")) {
            QDataSet result;
            QDataSet sliceable = args.get(0);
            Map<String, Object> m = metadata;
            if (m == null) {
                throw new IllegalArgumentException("unable to implement because metadata is needed");
            }
            Object oi = m.get("ARR_INDEX");
            Object od = m.get("ARR_DIM");
            if (od instanceof Number) {
                int i = ((Number)od).intValue();
                switch (i) {
                    case 0: {
                        result = Ops.slice1((QDataSet)sliceable, (int)((Number)oi).intValue());
                        break;
                    }
                    case 1: {
                        result = Ops.slice2((QDataSet)sliceable, (int)((Number)oi).intValue());
                        break;
                    }
                    case 2: {
                        result = Ops.slice3((QDataSet)sliceable, (int)((Number)oi).intValue());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("not supported slice dimension");
                    }
                }
            } else {
                throw new IllegalArgumentException("ARR_DIM property in metadata should be a number");
            }
            return result;
        }
        if (function.equalsIgnoreCase("apply_filter_flag")) {
            QDataSet temp;
            double compareValue;
            WritableDataSet zdata = Ops.maybeCopy((QDataSet)Ops.copy((QDataSet)args.get(0)));
            QDataSet filterData = args.get(1);
            Map<String, Object> m = metadata;
            if (m == null) {
                throw new IllegalArgumentException("unable to implement because metadata is needed");
            }
            Object ocompareOperator = m.get("COMPARE_OPERATOR");
            String compareOperator = ocompareOperator == null ? "eq" : (String)ocompareOperator;
            Object ocompareValue = m.get("COMPARE_VAL");
            Units u = SemanticOps.getUnits((QDataSet)filterData);
            if (UnitsUtil.isNominalMeasurement((Units)u)) {
                compareValue = ((EnumerationUnits)u).createDatum((Object)ocompareValue.toString().trim()).doubleValue(u);
                filterData = Ops.putProperty((QDataSet)filterData, (String)"UNITS", null);
            } else {
                compareValue = ocompareValue == null ? 0.0 : ((Number)ocompareValue).doubleValue();
            }
            switch (compareOperator) {
                case "eq": {
                    temp = Ops.where((QDataSet)Ops.ne((Object)filterData, (Object)compareValue));
                    break;
                }
                case "ne": {
                    temp = Ops.where((QDataSet)Ops.eq((Object)filterData, (Object)compareValue));
                    break;
                }
                case "lt": {
                    temp = Ops.where((QDataSet)Ops.ge((Object)filterData, (Object)compareValue));
                    break;
                }
                case "le": {
                    temp = Ops.where((QDataSet)Ops.gt((Object)filterData, (Object)compareValue));
                    break;
                }
                case "gt": {
                    temp = Ops.where((QDataSet)Ops.le((Object)filterData, (Object)compareValue));
                    break;
                }
                case "ge": {
                    temp = Ops.where((QDataSet)Ops.lt((Object)filterData, (Object)compareValue));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("bad compare operator, must be eq ne lt le gt ge: " + compareOperator);
                }
            }
            double fillValue = (Double)metadata.get("FILLVAL");
            switch (zdata.rank()) {
                case 1: {
                    for (int i = 0; i < temp.length(); ++i) {
                        zdata.putValue((int)temp.value(i), fillValue);
                    }
                    break;
                }
                case 2: {
                    int nj = zdata.length(0);
                    for (int i = 0; i < temp.length(); ++i) {
                        int itt = (int)temp.value(i);
                        for (int j = 0; j < nj; ++j) {
                            zdata.putValue(itt, j, fillValue);
                        }
                    }
                    break;
                }
                case 3: {
                    int nj = zdata.length(0);
                    int nk = zdata.length(0, 0);
                    for (int i = 0; i < temp.length(); ++i) {
                        int itt = (int)temp.value(i);
                        for (int j = 0; j < nj; ++j) {
                            for (int k = 0; k < nk; ++k) {
                                zdata.putValue(itt, j, k, fillValue);
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    int nj = zdata.length(0);
                    int nk = zdata.length(0, 0);
                    int nl = zdata.length(0, 0, 0);
                    for (int i = 0; i < temp.length(); ++i) {
                        int itt = (int)temp.value(i);
                        for (int j = 0; j < nj; ++j) {
                            for (int k = 0; k < nk; ++k) {
                                for (int l = 0; l < nl; ++l) {
                                    zdata.putValue(itt, j, k, l, fillValue);
                                }
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("only rank 1,2,3,4 supported in apply_filter_flag");
                }
            }
            zdata.makeImmutable();
            return zdata;
        }
        throw new IllegalArgumentException("virtual variable function not implemented: " + function);
    }

    protected static QDataSet calcP(List<QDataSet> args) {
        DRank0DataSet coefficient = DataSetUtil.asDataSet((double)1.6726E-6);
        QDataSet V_GSE_p = args.get(0);
        QDataSet np = args.get(1);
        QDataSet pressure = Ops.multiply((QDataSet)Ops.multiply((QDataSet)coefficient, (QDataSet)np), (QDataSet)Ops.pow((Object)DataSetOps.slice1((QDataSet)V_GSE_p, (int)0), (Object)2));
        return pressure;
    }

    public static QDataSet convPos(List<QDataSet> args, String coordSys) {
        throw new IllegalArgumentException("not implemented");
    }

    protected static QDataSet alternateView(QDataSet burley) {
        return burley;
    }

    protected static QDataSet computeMagnitude(QDataSet burley) {
        return Ops.magnitude((QDataSet)burley);
    }

    protected static QDataSet convertLog10(QDataSet burley) {
        return Ops.log10((QDataSet)burley);
    }

    protected static QDataSet addSeconds(QDataSet burley, double seconds) {
        QDataSet dep0 = (QDataSet)burley.property("DEPEND_0");
        if (dep0 == null) {
            throw new IllegalArgumentException("DEPEND_0 not found");
        }
        dep0 = Ops.add((QDataSet)dep0, (QDataSet)DataSetUtil.asDataSet((double)seconds, (Units)Units.seconds));
        ArrayDataSet result = ArrayDataSet.maybeCopy((QDataSet)burley);
        result.putProperty("DEPEND_0", (Object)dep0);
        return result;
    }

    public static boolean isSupported(String function) {
        List<String> functions = Arrays.asList("compute_magnitude", "convert_log10", "fftpowerdelta512", "fftpowerdelta1024", "fftpowerdelta2048", "fftpower", "fftPower512", "fftPower1024", "fftpowerdeltatranslation512", "alternate_view", "calc_p", "region_filt", "apply_esa_qflag", "apply_qflag", "sum_values", "arr_slice", "apply_filter_flag");
        boolean supported = functions.contains(function.toLowerCase());
        logger.log(Level.FINE, "virtual variable function \"{0}\" is supported: {1}", new Object[]{function, supported});
        return supported;
    }
}

