/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    @Override
    public int read() {
        if (this.buffer.hasRemaining()) {
            return 0xFF & this.buffer.get();
        }
        return -1;
    }

    @Override
    public void close() {
    }

    @Override
    public long skip(long n) {
        if (n > (long)this.buffer.remaining()) {
            long skipped = this.buffer.remaining();
            this.buffer.position(this.buffer.limit());
            return skipped;
        }
        this.buffer.position(this.buffer.position() + (int)n);
        return n;
    }

    @Override
    public void reset() throws IOException {
        try {
            this.buffer.reset();
        }
        catch (InvalidMarkException ime) {
            IOException ioe = new IOException(ime.getMessage());
            ioe.initCause(ime);
            throw ioe;
        }
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.buffer.mark();
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.buffer.hasRemaining()) {
            int bytesRead = Math.min(len, this.buffer.remaining());
            this.buffer.get(b, off, bytesRead);
            return bytesRead;
        }
        return -1;
    }
}

