/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.das2.util.DasPNGConstants;

public class DasPNGEncoder
extends DasPNGConstants {
    public void addText(String keyword, String content) {
        ArrayList<String> list = (ArrayList<String>)this.textMap.get(keyword);
        if (list == null) {
            list = new ArrayList<String>();
            this.textMap.put(keyword, list);
        }
        list.add(content);
    }

    public void removeText(String keyword, String content) {
        List list = (List)this.textMap.get(keyword);
        if (list != null) {
            list.remove(content);
        }
    }

    public void removeAllText(String keyword) {
        this.textMap.remove(keyword);
    }

    public void setGamma(int gamma) {
        this.gamma = gamma;
    }

    public void write(BufferedImage image, OutputStream out) throws IOException {
        LinkedList<byte[]> chunkList = new LinkedList<byte[]>();
        int totalSize = 0;
        chunkList.add(this.getHeaderBytes());
        chunkList.add(this.getIHDRBytes(image));
        this.gettEXtBytes(chunkList);
        chunkList.add(this.getgAMABytes());
        chunkList.add(this.getPLTEBytes(image));
        chunkList.add(this.getIDATBytes(image));
        chunkList.add(this.getIENDBytes());
        Iterator iterator = chunkList.iterator();
        while (iterator.hasNext()) {
            totalSize += ((byte[])iterator.next()).length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(totalSize);
        iterator = chunkList.iterator();
        while (iterator.hasNext()) {
            buffer.put((byte[])iterator.next());
        }
        out.write(buffer.array());
    }

    private byte[] getHeaderBytes() {
        return new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    }

    private byte[] getIHDRBytes(BufferedImage image) {
        byte colorType;
        byte bitDepth;
        int imageType = image.getType();
        switch (imageType) {
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                bitDepth = 8;
                colorType = 2;
                break;
            }
            case 2: 
            case 6: {
                bitDepth = 8;
                colorType = 6;
                break;
            }
            case 13: {
                bitDepth = 8;
                colorType = 3;
                break;
            }
            case 10: {
                bitDepth = 8;
                colorType = 0;
                break;
            }
            case 11: {
                bitDepth = 16;
                colorType = 0;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported image type");
            }
        }
        byte compressionMethod = 0;
        byte filterMethod = 0;
        byte interlaceMethod = 0;
        byte[] array = new byte[25];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putInt(13);
        buffer.put(DasPNGEncoder.getISO8859_1Bytes("IHDR"));
        buffer.putInt(image.getWidth());
        buffer.putInt(image.getHeight());
        buffer.put(bitDepth);
        buffer.put(colorType);
        buffer.put(compressionMethod);
        buffer.put(filterMethod);
        buffer.put(interlaceMethod);
        CRC32 crc = new CRC32();
        crc.update(array, 4, 17);
        buffer.putInt((int)crc.getValue());
        return array;
    }

    private byte[] getgAMABytes() {
        byte[] array = new byte[16];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putInt(4);
        buffer.put(DasPNGEncoder.getISO8859_1Bytes("gAMA"));
        buffer.putInt(this.gamma);
        CRC32 crc = new CRC32();
        crc.update(array, 4, 8);
        buffer.putInt((int)crc.getValue());
        return array;
    }

    private byte[] getPLTEBytes(BufferedImage image) {
        if (image.getType() != 13) {
            return new byte[0];
        }
        throw new UnsupportedOperationException();
    }

    private byte[] getIDATBytes(BufferedImage image) {
        byte[] imageData;
        int imageType = image.getType();
        switch (imageType) {
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                imageData = this.getRGBBytes(image);
                break;
            }
            case 6: {
                throw new UnsupportedOperationException("ABGR mode not supported");
            }
            case 2: {
                throw new UnsupportedOperationException("ARGB mode not supported");
            }
            case 10: 
            case 13: {
                throw new UnsupportedOperationException("8 bit mode not supported");
            }
            case 11: {
                throw new UnsupportedOperationException("16bit mode not supported");
            }
            default: {
                throw new RuntimeException("Unsupported image type");
            }
        }
        byte[] compressedImageData = new byte[imageData.length];
        Deflater deflater = new Deflater();
        deflater.setInput(imageData);
        deflater.finish();
        int compressedSize = deflater.deflate(compressedImageData);
        byte[] array = new byte[compressedSize + 12];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putInt(compressedSize);
        buffer.put(DasPNGEncoder.getISO8859_1Bytes("IDAT"));
        buffer.put(compressedImageData, 0, compressedSize);
        CRC32 crc = new CRC32();
        crc.update(array, 4, compressedSize + 4);
        buffer.putInt((int)crc.getValue());
        return array;
    }

    private byte[] getRGBBytes(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] intPixels = new int[width * height];
        image.getRGB(0, 0, width, height, intPixels, 0, width);
        byte[] bytePixels = new byte[intPixels.length * 3 + height];
        for (int line = 0; line < height; ++line) {
            int offset = (width * 3 + 1) * line;
            bytePixels[offset] = 0;
            for (int pixel = 0; pixel < width; ++pixel) {
                int intIndex = line * width + pixel;
                int byteIndex = offset + (pixel * 3 + 1);
                bytePixels[byteIndex] = (byte)((0xFF0000 & intPixels[intIndex]) >> 16);
                bytePixels[byteIndex + 1] = (byte)((0xFF00 & intPixels[intIndex]) >> 8);
                bytePixels[byteIndex + 2] = (byte)(0xFF & intPixels[intIndex]);
            }
        }
        return bytePixels;
    }

    private byte[] getIENDBytes() {
        byte[] array = new byte[12];
        byte[] typeBytes = DasPNGEncoder.getISO8859_1Bytes("IEND");
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putInt(0);
        buffer.put(typeBytes);
        CRC32 crc = new CRC32();
        crc.update(typeBytes);
        buffer.putInt((int)crc.getValue());
        return array;
    }

    private void gettEXtBytes(List list) {
        for (Map.Entry entry : this.textMap.entrySet()) {
            List contentList = (List)entry.getValue();
            Iterator content = contentList.iterator();
            while (content.hasNext()) {
                list.add(this.gettEXtBytes((String)entry.getKey(), (String)content.next()));
            }
        }
    }

    private byte[] gettEXtBytes(String keyword, String content) {
        byte[] keywordBytes = DasPNGEncoder.getISO8859_1Bytes(keyword);
        byte[] contentBytes = DasPNGEncoder.getISO8859_1Bytes(content);
        byte[] array = new byte[keywordBytes.length + contentBytes.length + 13];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putInt(keywordBytes.length + contentBytes.length + 1);
        buffer.put(DasPNGEncoder.getISO8859_1Bytes("tEXt"));
        buffer.put(keywordBytes);
        buffer.put((byte)0);
        buffer.put(contentBytes);
        CRC32 crc = new CRC32();
        crc.update(array, 4, keywordBytes.length + contentBytes.length + 5);
        buffer.putInt((int)crc.getValue());
        return array;
    }
}

