/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImageUtil {
    private static final Logger logger = LoggerManager.getLogger("das2.util");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJSONMetadata(File file) throws IOException {
        File plotInfoFile;
        String plotInfoName = file.getName();
        int i = plotInfoName.lastIndexOf(".");
        if (i > -1) {
            plotInfoName = plotInfoName.substring(0, i) + ".plotInfo";
        }
        if ((plotInfoFile = new File(file.getParentFile(), plotInfoName)).exists()) {
            return FileUtil.readFileToString(plotInfoFile);
        }
        try (ImageInputStream iis = ImageIO.createImageInputStream(file);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (!readers.hasNext()) return null;
            ImageReader reader = readers.next();
            reader.setInput(iis, true);
            IIOMetadata metadata = reader.getImageMetadata(0);
            try {
                IIOMetadataNode n = (IIOMetadataNode)metadata.getAsTree("javax_imageio_png_1.0");
                NodeList nl = n.getElementsByTagName("tEXtEntry");
                i = 0;
                while (i < nl.getLength()) {
                    Element e = (Element)nl.item(i);
                    String n3 = e.getAttribute("keyword");
                    if (n3.equals("plotInfo")) {
                        String string = e.getAttribute("value");
                        return string;
                    }
                    ++i;
                }
                return null;
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.FINE, ex.getMessage());
                String string = null;
                if (iis == null) return string;
                if (var5_6 != null) {
                    try {
                        iis.close();
                        return string;
                    }
                    catch (Throwable throwable) {
                        var5_6.addSuppressed(throwable);
                        return string;
                    }
                }
                iis.close();
                return string;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getScriptURI(File file) throws IOException {
        try (ImageInputStream iis = ImageIO.createImageInputStream(file);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (!readers.hasNext()) return null;
            ImageReader reader = readers.next();
            reader.setInput(iis, true);
            IIOMetadata metadata = reader.getImageMetadata(0);
            try {
                IIOMetadataNode n = (IIOMetadataNode)metadata.getAsTree("javax_imageio_png_1.0");
                NodeList nl = n.getElementsByTagName("tEXtEntry");
                int i = 0;
                while (i < nl.getLength()) {
                    Element e = (Element)nl.item(i);
                    String n3 = e.getAttribute("keyword");
                    if (n3.equals("ScriptURI")) {
                        String string = e.getAttribute("value");
                        return string;
                    }
                    ++i;
                }
                return null;
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.FINE, ex.getMessage());
                String string = null;
                if (iis == null) return string;
                if (var2_3 != null) {
                    try {
                        iis.close();
                        return string;
                    }
                    catch (Throwable throwable) {
                        var2_3.addSuppressed(throwable);
                        return string;
                    }
                }
                iis.close();
                return string;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int thumbSize) {
        int w0 = img.getWidth();
        int h0 = img.getHeight();
        double aspect = 1.0 * (double)w0 / (double)h0;
        int thumbH = (int)Math.sqrt(Math.pow(thumbSize, 2.0) / (aspect * aspect + 1.0));
        int thumbW = (int)((double)thumbH * aspect);
        return ImageUtil.getScaledInstance(img, thumbW, thumbH, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int width, int height, boolean pad) {
        int thumbW;
        int thumbH;
        int h0;
        double inAspect = 1.0 * (double)width / (double)height;
        int w0 = img.getWidth();
        double aspect = 1.0 * (double)w0 / (double)(h0 = img.getHeight());
        if (inAspect > aspect) {
            thumbH = height;
            thumbW = (int)((double)height * aspect);
        } else {
            thumbW = width;
            thumbH = (int)(1.0 * (double)width / aspect);
        }
        BufferedImage result = ImageUtil.getScaledInstance(img, thumbW, thumbH, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
        if (pad) {
            BufferedImage r;
            if (inAspect > aspect) {
                r = new BufferedImage(width, height, result.getType());
                r.getGraphics().drawImage(result, (width - thumbW) / 2, 0, null);
            } else {
                r = new BufferedImage(width, height, result.getType());
                r.getGraphics().drawImage(result, 0, (height - thumbH) / 2, null);
            }
            result = r;
        }
        return result;
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        int count = 0;
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (++count < 50 && (w != targetWidth || h != targetHeight));
        if (count == 50) {
            logger.log(Level.WARNING, "ran out of iterations in imageResize");
        }
        return ret;
    }
}

