/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

public final class LoggerManager {
    private static final Set<String> loggers = new HashSet<String>();
    private static final Map<String, Logger> log = new HashMap<String, Logger>();
    private static final Set<Handler> extraHandlers = new HashSet<Handler>();
    private static boolean isTimeTaggingLoggers = false;
    private static final Level[] levels = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    private static boolean disableTimers = true;
    private static int timerCycleCount = 0;
    private static PrintStream timerLogger = System.err;
    private static final Map<Thread, TimerInfo> timers = new WeakHashMap<Thread, TimerInfo>();
    private static int lastEvent = 0;
    private static long lastEventTime = 0L;

    public static synchronized void setUseTimeTaggingLoggers(boolean t) {
        isTimeTaggingLoggers = t;
        loggers.clear();
        extraHandlers.clear();
        log.clear();
    }

    public static synchronized boolean isUseTimeTaggingLoggers() {
        return isTimeTaggingLoggers;
    }

    public static synchronized Logger getLogger(String id) {
        Logger result = log.get(id);
        if (result != null) {
            return result;
        }
        result = isTimeTaggingLoggers ? new TimeTaggingLogger(id) : Logger.getLogger(id);
        log.put(id, result);
        for (Handler h : extraHandlers) {
            result.addHandler(h);
        }
        loggers.add(id);
        return result;
    }

    public static Set<String> getLoggers() {
        return loggers;
    }

    public static void addHandlerToAll(Handler handler) {
        for (String l : loggers) {
            log.get(l).addHandler(handler);
        }
        extraHandlers.add(handler);
    }

    public static boolean isEnableTimers() {
        return !disableTimers;
    }

    public static void setEnableTimers(boolean enableTimers) {
        disableTimers = !enableTimers;
        timerCycleCount = 0;
        if (!enableTimers && timerLogger != System.err) {
            timerLogger.close();
        }
    }

    public static void setTimerLogfile(String f) throws FileNotFoundException {
        timerLogger = new PrintStream(f);
    }

    public static void resetTimer() {
        if (disableTimers) {
            return;
        }
        LoggerManager.resetTimer(null);
    }

    public static void resetTimer(String task) {
        if (disableTimers) {
            return;
        }
        if (task == null) {
            task = Thread.currentThread().getName();
        } else if (EventQueue.isDispatchThread()) {
            task = task + " (GUI)";
        }
        timerLogger.println(String.format("== %s ==", task));
        timers.put(Thread.currentThread(), new TimerInfo(System.nanoTime()));
        timerLogger.println(String.format("Cycle Count Time(ms) TimeSinceLast(ms) Message", new Object[0]));
        ++timerCycleCount;
    }

    public static void markTime() {
        if (disableTimers) {
            return;
        }
        LoggerManager.markTime(null);
    }

    public static void markTime(String message) {
        if (disableTimers) {
            return;
        }
        TimerInfo timerInfo = timers.get(Thread.currentThread());
        if (timerInfo != null) {
            if (message == null) {
                message = Thread.currentThread().getName();
            }
            long t = System.nanoTime();
            timerLogger.println(String.format("%d %d %.6f %.6f %s", timerCycleCount, timerInfo.count, (double)(t - timerInfo.birthNs) / 1000000.0, (double)(t - timerInfo.lastNs) / 1000000.0, message));
            timerInfo.lastNs = t;
            ++timerInfo.count;
        }
    }

    public static void clearTimer() {
        if (disableTimers) {
            return;
        }
        timers.remove(Thread.currentThread());
    }

    private static Container findReferenceComponent(Container c) {
        Container child = null;
        while (c != null) {
            child = c;
            if ((c = c.getParent()) instanceof JTabbedPane) {
                return child;
            }
            if (c instanceof JPanel && ((JPanel)c).getBorder() instanceof TitledBorder) {
                return c;
            }
            if (c instanceof JDialog) {
                return c;
            }
            if (c == null || !c.getClass().getName().startsWith("org")) continue;
            return c;
        }
        return child;
    }

    private static String labelFor(Component c) {
        if (c instanceof JPopupMenu) {
            return ((JPopupMenu)c).getLabel();
        }
        if (c.getParent() instanceof JTabbedPane) {
            JTabbedPane tp = (JTabbedPane)c.getParent();
            int itab = tp.indexOfComponent(c);
            return tp.getTitleAt(itab);
        }
        if (c instanceof JPanel && ((JPanel)c).getBorder() instanceof TitledBorder) {
            TitledBorder tb = (TitledBorder)((JPanel)c).getBorder();
            String title = tb.getTitle();
            if (title.endsWith(" [?]")) {
                title = title.substring(0, title.length() - 4);
            }
            return title;
        }
        return c.getName();
    }

    private static void logGuiEvent(Object source, String thisRef) {
        String ssrc;
        if (!EventQueue.isDispatchThread()) {
            return;
        }
        lastEventTime = System.currentTimeMillis();
        AWTEvent evt = EventQueue.getCurrentEvent();
        if (evt != null) {
            int thisEvent = evt.hashCode();
            if (thisEvent == lastEvent) {
                return;
            }
            lastEvent = thisEvent;
        }
        if ((ssrc = source.toString()).length() > 10) {
            int i = ssrc.indexOf("[");
            if (i > -1) {
                ssrc = ssrc.substring(0, i);
            }
            if (source instanceof JComponent) {
                String text;
                StringBuilder src;
                JComponent c = (JComponent)source;
                Container cc = LoggerManager.findReferenceComponent(c);
                if (cc instanceof JPanel && ((JPanel)cc).getBorder() instanceof TitledBorder) {
                    String title = LoggerManager.labelFor(c);
                    src = new StringBuilder(" of \"" + title + "\"");
                } else {
                    src = new StringBuilder();
                }
                Container w = cc.getParent();
                if (!(w instanceof JTabbedPane) && (w = LoggerManager.findReferenceComponent(c.getParent())) != null) {
                    if (w.getParent() instanceof JViewport) {
                        w = w.getParent();
                    }
                    if (w.getParent() instanceof JScrollPane) {
                        w = w.getParent();
                    }
                    if (w.getParent() instanceof JTabbedPane) {
                        JTabbedPane tp = (JTabbedPane)w.getParent();
                        int itab = tp.indexOfComponent(w);
                        String n = tp.getTitleAt(itab);
                        src.append(" of \"").append(n).append("\"");
                    }
                }
                if (src.length() == 0 && cc instanceof JPopupMenu) {
                    String t = ((JPopupMenu)cc).getLabel();
                    if (t != null && t.length() == 0) {
                        t = cc.getName();
                    }
                    if (t == null) {
                        Component inv = ((JPopupMenu)cc).getInvoker();
                        while (inv instanceof JMenu) {
                            t = ((JMenu)inv).getText();
                            src.append(" of menu \"").append(t).append("\"");
                            Container inv1 = inv.getParent();
                            if (inv1 instanceof JPopupMenu) {
                                inv = ((JPopupMenu)inv1).getInvoker();
                                continue;
                            }
                            inv = null;
                        }
                        if (inv != null) {
                            src.append(" of \"").append(LoggerManager.labelFor(inv)).append("\"");
                        }
                    } else {
                        src.append(" of menu \"").append(t).append("\"");
                    }
                } else if (c instanceof JComboBox) {
                    src.append(c.getName());
                } else if (c instanceof AbstractButton) {
                    text = ((AbstractButton)c).getText();
                    if (text == null || text.length() == 0) {
                        text = c.getName();
                    }
                    src.append("\"").append(text).append("\"");
                } else if (c instanceof JTextField) {
                    text = ((JTextField)c).getText();
                    if (text == null || text.length() == 0) {
                        text = c.getName();
                    }
                    src.append("\"").append(text).append("\"");
                } else if (c instanceof JTextField) {
                    text = ((JTextField)c).getText();
                    if (text == null || text.length() == 0) {
                        text = c.getName();
                    }
                    src.append("\"").append(text).append("\"");
                }
                Window h = SwingUtilities.getWindowAncestor(c);
                Object htitle = null;
                if (h instanceof Dialog) {
                    src.append(" of \"").append(((Dialog)h).getTitle()).append("\"");
                } else if (h instanceof JFrame) {
                    src.append(" of \"").append(((JFrame)h).getTitle()).append("\"");
                }
                ssrc = src.toString();
            }
        }
        if (thisRef.length() > 30) {
            LoggerManager.getLogger("gui").log(Level.FINE, "{1}", new Object[]{ssrc});
        } else {
            LoggerManager.getLogger("gui").log(Level.FINE, "\"{0}\" from {1}", new Object[]{thisRef, ssrc});
        }
    }

    public static void logGuiEvent(ActionEvent e) {
        if (e == null) {
            LoggerManager.getLogger("gui").log(Level.FINEST, "null ActionEvent");
            return;
        }
        if (!LoggerManager.getLogger("gui").isLoggable(Level.FINE)) {
            return;
        }
        if (e.getSource() instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)e.getSource();
            LoggerManager.logGuiEvent(e.getSource(), (cb.isSelected() ? "select " : "deselect ") + e.getActionCommand());
        } else if (e.getSource() instanceof JComboBox) {
            JComboBox cb = (JComboBox)e.getSource();
            LoggerManager.logGuiEvent(e.getSource(), cb.getEditor().getItem().toString());
        } else {
            LoggerManager.logGuiEvent(e.getSource(), e.getActionCommand());
        }
    }

    public static void logExitGuiEvent(ActionEvent e) {
        long t1 = System.currentTimeMillis();
        LoggerManager.getLogger("gui").log(Level.FINE, "handled \"{0}\" in (ms): {1}", new Object[]{"actionEvent", t1 - lastEventTime});
    }

    public static void logGuiEvent(ChangeEvent e) {
        if (!LoggerManager.getLogger("gui").isLoggable(Level.FINE)) {
            return;
        }
        LoggerManager.logGuiEvent(e.getSource(), "changeEvent");
    }

    public static void logExitGuiEvent(ChangeEvent e) {
        long t1 = System.currentTimeMillis();
        LoggerManager.getLogger("gui").log(Level.FINE, "handled \"{0}\" in (ms): {1}", new Object[]{"changeEvent", t1 - lastEventTime});
    }

    public static void logGuiEvent(ItemEvent e) {
        if (!LoggerManager.getLogger("gui").isLoggable(Level.FINE)) {
            return;
        }
        LoggerManager.logGuiEvent(e.getSource(), "itemEvent");
    }

    public static void logExitGuiEvent(ItemEvent e) {
        long t1 = System.currentTimeMillis();
        LoggerManager.getLogger("gui").log(Level.FINE, "handled \"{0}\" in (ms): {1}", new Object[]{"itemEvent", t1 - lastEventTime});
    }

    public static void logGuiEvent(FocusEvent e) {
        if (!LoggerManager.getLogger("gui").isLoggable(Level.FINE)) {
            return;
        }
        LoggerManager.logGuiEvent(e.getSource(), "focusEvent");
    }

    public static void logExitGuiEvent(FocusEvent e) {
        long t1 = System.currentTimeMillis();
        LoggerManager.getLogger("gui").log(Level.FINE, "handled \"{0}\" in (ms): {1}", new Object[]{"focusEvent", t1 - lastEventTime});
    }

    public static void logPropertyChangeEvent(PropertyChangeEvent e) {
        LoggerManager.getLogger("gui").log(Level.FINE, "PropertyChange {0}={1}", new Object[]{e.getPropertyName(), e.getNewValue()});
    }

    public static void logPropertyChangeEvent(PropertyChangeEvent e, String source) {
        if (e.getPropertyName().equals("paintingForPrint")) {
            LoggerManager.getLogger("gui").log(Level.FINER, "PropertyChange {0}={1} {2}", new Object[]{e.getPropertyName(), e.getNewValue(), source});
        } else {
            LoggerManager.getLogger("gui").log(Level.FINE, "PropertyChange {0}={1} {2}", new Object[]{e.getPropertyName(), e.getNewValue(), source});
        }
    }

    public static void readConfiguration() {
        String configfile = System.getProperty("java.util.logging.config.file");
        LoggerManager.readConfiguration(configfile);
    }

    public static void readConfiguration(String configfile) {
        if (configfile == null) {
            System.err.println("no config file, set java property java.util.logging.config.file like so:");
            System.err.println("-Djava.util.logging.config.file=/tmp/logging.properties");
            return;
        }
        File ff = new File(configfile);
        if (ff.isAbsolute()) {
            System.err.println("loading logging configuration from " + ff);
        } else {
            ff = ff.getAbsoluteFile();
            System.err.println("loading logging configuration from " + ff);
        }
        try (FileInputStream in = new FileInputStream(configfile);){
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static class TimerInfo {
        long birthNs;
        long lastNs;
        long count;

        private TimerInfo(long birthNs) {
            this.lastNs = this.birthNs = birthNs;
        }
    }

    public static final class TimeTaggingLogger
    extends Logger {
        private long lastTime = 0L;
        private long lastLoggedTime = 0L;

        private TimeTaggingLogger(String id) {
            super(id, null);
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public void log(LogRecord record) {
            super.log(record);
            long t = record.getMillis();
            if (this.isLoggable(record.getLevel())) {
                this.lastLoggedTime = t;
            }
            this.lastTime = t;
        }

        public long getLastTime() {
            return this.lastTime;
        }

        public long getLastLoggedTime() {
            return this.lastLoggedTime;
        }
    }
}

