/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.text.MessageFormat;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class NBConsoleFormatter
extends Formatter {
    boolean coalesce = true;
    String lastMessage = null;
    int coalesceHits = 0;

    @Override
    public String format(LogRecord rec) {
        if (this.coalesce && this.lastMessage != null && this.lastMessage.equals(rec.getMessage())) {
            ++this.coalesceHits;
            return "";
        }
        StackTraceElement[] st = new Throwable().getStackTrace();
        int len = Math.min(9, st.length);
        String msg = MessageFormat.format(String.valueOf(rec.getMessage()), rec.getParameters());
        String result = rec.getLoggerName() + "  [" + Thread.currentThread().getName() + "]\n" + rec.getLevel().getLocalizedName() + ": " + msg;
        if (len > 2) {
            result = result + "\n\tat " + st[len - 2] + "\n\tat " + st[len - 1] + "\n";
        }
        if (this.coalesceHits > 0) {
            result = "(Last message repeats " + (this.coalesceHits + 1) + " times)\n" + result;
        }
        this.coalesceHits = 0;
        this.lastMessage = rec.getMessage();
        return result;
    }
}

