/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTransmogrifier {
    Pattern p;
    String result;
    int nf;
    String[] byName;
    int[] byIndex;

    public StringTransmogrifier(String regex, String result) {
        this.p = Pattern.compile(regex);
        String[] ss = result.split("\\$");
        this.nf = ss.length - 1;
        this.byIndex = new int[this.nf];
        this.byName = new String[this.nf];
        StringBuilder resultb = new StringBuilder(ss[0]);
        int fieldNum = 0;
        for (int i = 1; i < ss.length; ++i) {
            if (ss[i].length() == 0) {
                ++i;
                resultb.append("$");
                this.nf -= 2;
                continue;
            }
            String s = ss[i];
            if (Character.isDigit(s.charAt(0))) {
                resultb.append("%s");
                if (s.length() > 1 && Character.isDigit(s.charAt(1))) {
                    this.byIndex[fieldNum] = (s.charAt(0) - 48) * 10 + (s.charAt(1) - 48);
                    resultb.append(s.substring(2));
                } else {
                    this.byIndex[fieldNum] = s.charAt(0) - 48;
                    resultb.append(s.substring(1));
                }
            } else if (s.charAt(0) == '{') {
                int i2 = s.indexOf("}");
                this.byName[fieldNum] = s.substring(1, i2);
                resultb.append("%s");
                resultb.append(s.substring(i2 + 1));
            } else {
                this.byName[fieldNum] = s.substring(0, 1);
                resultb.append("%s");
                resultb.append(s.substring(1));
            }
            ++fieldNum;
        }
        if (fieldNum < this.byName.length) {
            this.byName = Arrays.copyOf(this.byName, fieldNum);
            this.byIndex = Arrays.copyOf(this.byIndex, fieldNum);
            this.nf = fieldNum;
        }
        this.result = resultb.toString();
    }

    private String[] getFields(Matcher m) {
        if (this.nf == -1) {
            throw new IllegalArgumentException("getFields cannot be called until transmogrify is called");
        }
        String[] result = new String[this.nf];
        for (int i = 0; i < this.nf; ++i) {
            result[i] = this.byName[i] != null ? m.group(this.byName[i]) : m.group(this.byIndex[i]);
        }
        return result;
    }

    public String transmogrify(String string) {
        Matcher m = this.p.matcher(string);
        if (m.matches()) {
            Object[] args = this.getFields(m);
            return String.format(this.result, args);
        }
        return this.result;
    }
}

