/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.das2.util.Base64;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.HttpUtil;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.monitor.CancelledOperationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlUtil {
    private static final Logger logger = LoggerManager.getLogger("das2.filesystem.htmlutil");
    protected static final Logger loggerUrl = LoggerManager.getLogger("das2.url");

    public static boolean isDirectory(URL url) {
        String file = url.getFile();
        return file.charAt(file.length() - 1) != '/';
    }

    @Deprecated
    public static void consumeStream(InputStream err) throws IOException {
        HttpUtil.consumeStream(err);
    }

    private static URL[] getDirectoryListingAmazonS3(URL root, String content) {
        try {
            StringReader reader = new StringReader(content);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(reader);
            Document document = builder.parse(source);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            NodeList fs = (NodeList)xpath.evaluate("/ListBucketResult/Contents/Key", document, XPathConstants.NODESET);
            int n = fs.getLength();
            URL[] result = new URL[n];
            for (int i = 0; i < n; ++i) {
                Node nn = fs.item(i);
                try {
                    result[i] = new URL(root, nn.getTextContent());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URL[] getDirectoryListing(URL url, InputStream urlStream) throws IOException, CancelledOperationException {
        return HtmlUtil.getDirectoryListing(url, urlStream, true);
    }

    public static URL[] getDirectoryListing(URL url, InputStream urlStream, boolean childCheck) throws IOException, CancelledOperationException {
        long t0 = System.currentTimeMillis();
        byte[] b = new byte[10000];
        int numRead = urlStream.read(b);
        StringBuilder contentBuffer = new StringBuilder(10000);
        if (numRead != -1) {
            contentBuffer.append(new String(b, 0, numRead, "UTF-8"));
        }
        while (numRead != -1) {
            logger.finest("download listing");
            numRead = urlStream.read(b);
            if (numRead == -1) continue;
            String newContent = new String(b, 0, numRead, "UTF-8");
            contentBuffer.append(newContent);
        }
        urlStream.close();
        logger.log(Level.FINER, "read listing data in {0} millis", System.currentTimeMillis() - t0);
        String content = contentBuffer.toString();
        if (content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ListBucketResult")) {
            return HtmlUtil.getDirectoryListingAmazonS3(url, content);
        }
        String hrefRegex = "(?i)href\\s*=\\s*([\"'])(.+?)\\1";
        Pattern hrefPattern = Pattern.compile(hrefRegex);
        Matcher matcher = hrefPattern.matcher(content);
        ArrayList<URL> urlList = new ArrayList<URL>();
        String surl = url.toString();
        while (matcher.find()) {
            URL urlLink;
            String strLink;
            block8: {
                strLink = matcher.group(2);
                logger.log(Level.FINEST, "parse listing {0}", strLink);
                try {
                    urlLink = new URL(url, URLDecoder.decode(strLink, "UTF-8"));
                    if ((strLink = urlLink.toString()).contains("data-item-type=")) continue;
                    if (strLink.contains("#")) {
                    }
                    break block8;
                }
                catch (MalformedURLException e) {
                    logger.log(Level.SEVERE, "bad URL: {0} {1}", new Object[]{url, strLink});
                }
                continue;
            }
            if (childCheck) {
                String file;
                if (!strLink.startsWith(surl) || strLink.length() <= surl.length() || null != urlLink.getQuery() || (file = strLink.substring(surl.length())).startsWith("../")) continue;
                urlList.add(urlLink);
                continue;
            }
            urlList.add(urlLink);
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    public static URL[] getDirectoryListing(URL url) throws IOException, CancelledOperationException {
        logger.log(Level.FINER, "listing {0}", url);
        String file = url.getFile();
        if (file.charAt(file.length() - 1) != '/') {
            url = new URL(url.toString() + '/');
        }
        InputStream urlStream = HtmlUtil.getInputStream(url);
        return HtmlUtil.getDirectoryListing(url, urlStream);
    }

    public static InputStream getInputStream(URL url) throws IOException, CancelledOperationException {
        loggerUrl.log(Level.FINE, "getInputStream {0}", new Object[]{url});
        long t0 = System.currentTimeMillis();
        String userInfo = KeyChain.getDefault().getUserInfo(url);
        loggerUrl.log(Level.FINE, "openConnect {0}", new Object[]{url});
        URLConnection urlConnection = url.openConnection();
        urlConnection.setAllowUserInteraction(false);
        urlConnection.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
        logger.log(Level.FINER, "connected in {0} millis", System.currentTimeMillis() - t0);
        if (userInfo != null) {
            String encode = Base64.getEncoder().encodeToString(userInfo.getBytes());
            urlConnection.setRequestProperty("Authorization", "Basic " + encode);
        }
        urlConnection = HttpUtil.checkRedirect(urlConnection);
        InputStream ins = urlConnection.getInputStream();
        boolean keepResponseForDebugging = false;
        if (!keepResponseForDebugging) {
            return ins;
        }
        StringBuilder keep = new StringBuilder();
        byte[] buf = new byte[4096];
        int bytesRead = ins.read(buf);
        int totalBytesRead = 0;
        while (bytesRead > 0) {
            totalBytesRead += bytesRead;
            for (int i = 0; i < bytesRead; ++i) {
                keep.append((char)buf[i]);
            }
            bytesRead = ins.read(buf);
        }
        long t02 = System.currentTimeMillis() - 1718399881869L;
        File file = new File("/tmp/ap/" + url.getFile().hashCode() + "." + String.format("%09d", t02) + ".html");
        FileUtil.writeStringToFile(file, keep.toString());
        logger.log(Level.INFO, "writing html listing to {0}", file);
        return new FileInputStream(file);
    }

    public static String readToString(URL url) throws IOException, CancelledOperationException {
        InputStream ins = HtmlUtil.getInputStream(url);
        StringBuilder build = new StringBuilder();
        byte[] buf = new byte[2048];
        int i = ins.read(buf);
        Charset charset = Charset.forName("UTF-8");
        while (i > -1) {
            build.append(new String(buf, 0, i, charset));
            i = ins.read(buf);
        }
        return build.toString();
    }

    @Deprecated
    public static Map<String, String> getMetadata(URL url, Map<String, String> props) throws IOException {
        return HttpUtil.getMetadata(url, props);
    }

    @Deprecated
    public static URLConnection checkRedirect(URLConnection urlConnection) throws IOException {
        return HttpUtil.checkRedirect(urlConnection);
    }

    public static List<URL> getLinks(URL url, String content) {
        String hrefRegex = "(?i)href\\s*=\\s*([\"'])(.+?)\\1";
        Pattern hrefPattern = Pattern.compile(hrefRegex);
        Matcher matcher = hrefPattern.matcher(content);
        ArrayList<URL> urlList = new ArrayList<URL>();
        while (matcher.find()) {
            String strLink = matcher.group(2);
            logger.log(Level.FINEST, "parse listing {0}", strLink);
            try {
                URL urlLink = new URL(url, URLDecoder.decode(strLink, "UTF-8"));
                urlList.add(urlLink);
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, "bad URL: {0} {1}", new Object[]{url, strLink});
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(HtmlUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return urlList;
    }
}

