/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.ZipFileSystem;
import org.das2.util.monitor.ProgressMonitor;

public class ZipFileObject
extends FileObject {
    private ZipFileSystem zfs;
    private ZipEntry zipEntry;
    private ZipFileObject parent;
    private String name;
    private ArrayList<ZipFileObject> children;
    private boolean unzip;

    protected ZipFileObject(ZipFileSystem zfs, ZipEntry zipEntry, ZipFileObject par) {
        this(zfs, zipEntry, par, null);
    }

    protected ZipFileObject(ZipFileSystem zfs, ZipEntry zipEntry, ZipFileObject par, String name) {
        this.zfs = zfs;
        this.zipEntry = zipEntry;
        this.parent = par;
        this.name = name;
        this.unzip = zipEntry != null && name != null && zipEntry.getName().endsWith(".gz") && !name.endsWith(".gz");
        this.children = new ArrayList();
    }

    protected void addChildObject(ZipFileObject child) {
        this.children.add(child);
    }

    @Override
    public boolean canRead() {
        return this.exists();
    }

    @Override
    public FileObject[] getChildren() throws IOException {
        return this.children.toArray(new ZipFileObject[this.children.size()]);
    }

    @Override
    public InputStream getInputStream(ProgressMonitor monitor) throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException("file not found in zip: " + this.name);
        }
        if (this.unzip) {
            return new GZIPInputStream(this.zfs.getZipFile().getInputStream(this.zipEntry));
        }
        return this.zfs.getZipFile().getInputStream(this.zipEntry);
    }

    @Override
    public ReadableByteChannel getChannel(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        return ((FileInputStream)this.getInputStream(monitor)).getChannel();
    }

    @Override
    public synchronized File getFile(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(String.format("file %s does not exist in %s", this.name, this.zfs.toString()));
        }
        String tmpFileName = this.unzip ? this.zfs.getLocalRoot().getAbsoluteFile() + "/" + this.name : this.zfs.getLocalRoot().getAbsoluteFile() + "/" + this.zipEntry.getName();
        File tmpFile = new File(tmpFileName);
        File tmpDir = tmpFile.getParentFile();
        FileSystemUtil.maybeMkdirs(tmpDir);
        if (tmpFile.exists()) {
            if (tmpFile.lastModified() < new File(this.zfs.getZipFile().getName()).lastModified()) {
                if (!tmpFile.delete()) {
                    throw new IOException("unable to delete old unzipped file: " + tmpFile);
                }
            } else {
                return tmpFile;
            }
        }
        if (!tmpFile.createNewFile()) {
            throw new IllegalArgumentException("unable to create file " + tmpFile);
        }
        try (InputStream zStream = this.getInputStream(monitor);){
            FileSystemUtil.dumpToFile(zStream, tmpFile);
        }
        return tmpFile;
    }

    @Override
    public FileObject getParent() {
        return this.parent;
    }

    @Override
    public long getSize() {
        if (this.zipEntry == null) {
            return 0L;
        }
        return this.zipEntry.getSize();
    }

    @Override
    public boolean isData() {
        if (this.zipEntry == null) {
            return false;
        }
        return !this.zipEntry.isDirectory();
    }

    @Override
    public boolean isFolder() {
        if (this.zipEntry == null) {
            return true;
        }
        return this.zipEntry.isDirectory();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean exists() {
        return this.zipEntry != null && this.parent != null;
    }

    @Override
    public String getNameExt() {
        if (this.isRoot()) {
            return "/";
        }
        if (this.zipEntry != null) {
            return "/" + this.zipEntry.getName();
        }
        return this.parent.getNameExt() + this.name + "/";
    }

    @Override
    public Date lastModified() {
        if (this.isRoot()) {
            File f = new File(this.zfs.getZipFile().getName());
            return new Date(f.lastModified());
        }
        long when = this.zipEntry.getTime();
        return when > 0L ? new Date(when) : new Date(0L);
    }
}

