/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;

public class AbstractProgressMonitor
implements ProgressMonitor {
    private static final Logger logger = LoggerManager.getLogger("das2.system");
    private long taskSize = -1L;
    private int cancelCheck = 0;
    private String progressMessage;
    private long position = 0L;
    private boolean started = false;
    private boolean finished = false;
    private boolean cancelled = false;
    private String label;

    @Override
    public void setTaskSize(long taskSize) {
        if (taskSize < 1L) {
            logger.log(Level.FINER, "taskSize set to {0}, resetting", taskSize);
            this.taskSize = -1L;
        } else {
            this.taskSize = taskSize;
        }
    }

    @Override
    public long getTaskSize() {
        return this.taskSize;
    }

    @Override
    public void setProgressMessage(String message) {
        this.progressMessage = message;
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    @Override
    public void setTaskProgress(long position) throws IllegalArgumentException {
        this.position = position;
    }

    @Override
    public long getTaskProgress() {
        return this.position;
    }

    @Override
    public void started() {
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void finished() {
        if (this.finished) {
            logger.warning("AbstractProgressMonitor.finished called twice, which could cause problems in the future");
        } else {
            logger.fine("enter monitor finished");
        }
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public boolean isCancelled() {
        ++this.cancelCheck;
        return this.cancelled;
    }

    @Override
    @Deprecated
    public void setAdditionalInfo(String s) {
    }

    @Override
    public void setLabel(String s) {
        this.label = s;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return "" + this.position + " of " + this.taskSize;
    }

    @Override
    public ProgressMonitor getSubtaskMonitor(int start, int end, String label) {
        if (label != null) {
            this.setProgressMessage(label);
        }
        return SubTaskMonitor.create(this, start, end);
    }

    @Override
    public ProgressMonitor getSubtaskMonitor(String label) {
        if (label != null) {
            this.setProgressMessage(label);
        }
        return SubTaskMonitor.create(this, true);
    }

    @Override
    public boolean canBeCancelled() {
        return this.cancelCheck > 0;
    }
}

