/*
 * Decompiled with CFR 0.152.
 */
package org.das2;

import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.security.AllPermission;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import org.das2.NameContext;
import org.das2.client.InputStreamMeter;
import org.das2.dataset.DataSetCache;
import org.das2.dataset.LimitSizeBytesDataSetCache;
import org.das2.dataset.NullDataSetCache;
import org.das2.graph.DasAnnotation;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.system.DasLogger;
import org.das2.system.DefaultMonitorFactory;
import org.das2.system.LoggerId;
import org.das2.system.MonitorFactory;
import org.das2.system.NullMonitorFactory;
import org.das2.util.ClassMap;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DefaultExceptionHandler;
import org.das2.util.ExceptionHandler;
import org.das2.util.Splash;
import org.das2.util.ThrowRuntimeExceptionHandler;
import org.das2.util.filesystem.FileSystemSettings;

public class DasApplication {
    private static DasApplication DEFAULT;
    private JFrame mainFrame;
    private Boolean applet = null;
    private Boolean headless;
    private NameContext nameContext;
    private DataSetCache dataSetCache;
    static ClassMap classNameMap;
    private Map hitsMap = new HashMap();
    private static boolean restrictPermission;
    InputStreamMeter meter;
    private boolean interactive = true;
    private MonitorFactory monitorFactory;
    ExceptionHandler exceptionHandler;

    public Logger getLogger() {
        return DasLogger.getLogger();
    }

    public Logger getLogger(LoggerId id) {
        return DasLogger.getLogger(id);
    }

    private DasApplication() {
        this.nameContext = new NameContext();
    }

    public NameContext getNameContext() {
        return this.nameContext;
    }

    public String suggestNameFor(Object c) {
        String type = (String)classNameMap.get(c.getClass());
        Integer hits = (Integer)this.hitsMap.get(type);
        int ihits = hits == null ? 0 : hits + 1;
        this.hitsMap.put(type, ihits);
        return type + "_" + ihits;
    }

    public static DasApplication getDefaultApplication() {
        if (DEFAULT == null) {
            DEFAULT = new DasApplication();
        }
        return DEFAULT;
    }

    public static void resetDefaultApplication() {
        DEFAULT = null;
    }

    public final boolean isApplet() {
        if (this.applet == null) {
            return Thread.currentThread().getContextClassLoader().getClass().getName().indexOf("plugin") > -1;
        }
        return this.applet;
    }

    public final boolean isJavaWebStart() {
        return System.getProperty("javawebstart.version", null) != null;
    }

    public static boolean hasAllPermission() {
        try {
            if (restrictPermission) {
                return false;
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new AllPermission());
            }
            return true;
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public static void setRestrictPermission(boolean v) {
        restrictPermission = v;
        FileSystemSettings.setRestrictPermission((boolean)v);
    }

    public static String getProperty(String name, String deft) {
        try {
            return System.getProperty(name, deft);
        }
        catch (SecurityException ex) {
            return deft;
        }
    }

    public void setApplet(boolean applet) {
        this.applet = applet;
    }

    public void setReloadLoggingProperties(boolean v) {
        if (v) {
            try {
                DasLogger.reload();
                DasLogger.printStatus();
            }
            catch (IOException e) {
                this.getExceptionHandler().handle((Throwable)e);
            }
        }
    }

    public boolean isReloadLoggingProperties() {
        return false;
    }

    private static boolean isX11() {
        String osName = System.getProperty("os.name");
        return "SunOS".equals(osName) || "Linux".equals(osName);
    }

    public static File getDas2UserDirectory() {
        File local = DasApplication.getProperty("user.name", "Web").equals("Web") ? new File("/tmp") : new File(System.getProperty("user.home"));
        local = new File(local, ".das2");
        return local;
    }

    private static boolean isHeadAvailable() {
        return true;
    }

    public boolean isHeadless() {
        if (this.headless != null) {
            return this.headless;
        }
        return "true".equals(DasApplication.getProperty("java.awt.headless", "false"));
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
        if (headless) {
            System.setProperty("java.awt.headless", "true");
        } else {
            if (!DasApplication.isHeadAvailable()) {
                throw new IllegalArgumentException("attempt to unset headless when environment is headless.");
            }
            System.setProperty("java.awt.headless", "false");
        }
    }

    public InputStreamMeter getInputStreamMeter() {
        if (this.meter == null) {
            this.meter = new InputStreamMeter();
        }
        return this.meter;
    }

    public JFrame createMainFrame(Container container) {
        return this.createMainFrame("Das2", container);
    }

    public JFrame createMainFrame(String title, Container container) {
        JFrame frame = this.createMainFrame(title);
        frame.getContentPane().add(container);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public JFrame createMainFrame() {
        return this.createMainFrame("Das2");
    }

    public JFrame createMainFrame(String title) {
        this.mainFrame = new JFrame(title);
        Preferences prefs = Preferences.userNodeForPackage(DasApplication.class);
        int xlocation = prefs.getInt("xlocation", 20);
        int ylocation = prefs.getInt("ylocation", 20);
        this.mainFrame.setLocation(xlocation, ylocation);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DasApplication.this.quit();
            }
        });
        this.mainFrame.setDefaultCloseOperation(0);
        System.setProperty("sun.awt.exception.handler", DasExceptionHandler.class.getName());
        return this.mainFrame;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(JFrame frame) {
        this.mainFrame = frame;
    }

    public void quit() {
        Preferences prefs = Preferences.userNodeForPackage(DasApplication.class);
        prefs.putInt("xlocation", this.mainFrame.getLocation().x);
        prefs.putInt("ylocation", this.mainFrame.getLocation().y);
        System.out.println("bye!" + this.mainFrame.getLocation());
        System.exit(0);
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public String getDas2Version() {
        return Splash.getVersion();
    }

    public MonitorFactory getMonitorFactory() {
        if (this.monitorFactory == null) {
            this.monitorFactory = !this.isHeadless() ? new DefaultMonitorFactory() : new NullMonitorFactory();
        }
        return this.monitorFactory;
    }

    public DataSetCache getDataSetCache() {
        if (this.dataSetCache == null) {
            this.dataSetCache = this.isHeadless() ? new NullDataSetCache() : new LimitSizeBytesDataSetCache(30000000L);
        }
        return this.dataSetCache;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = this.isHeadless() ? new ThrowRuntimeExceptionHandler() : new DefaultExceptionHandler();
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler h) {
        this.exceptionHandler = h;
    }

    static {
        classNameMap = new ClassMap();
        classNameMap.put(DasPlot.class, (Object)"plot");
        classNameMap.put(DasAxis.class, (Object)"axis");
        classNameMap.put(DasColorBar.class, (Object)"colorbar");
        classNameMap.put(DasRow.class, (Object)"row");
        classNameMap.put(DasColumn.class, (Object)"column");
        classNameMap.put(DasAnnotation.class, (Object)"annotation");
        classNameMap.put(Object.class, (Object)"object");
        classNameMap.put(DasCanvasComponent.class, (Object)"canvasComponent");
        classNameMap.put(DasCanvas.class, (Object)"canvas");
        restrictPermission = false;
    }
}

