/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.das2.dasml.FormBase;
import org.das2.dasml.FormChoice;
import org.das2.dasml.ListOption;
import org.das2.dasml.OptionList;

public class OptionListEditor
extends JButton
implements OptionList,
TableCellEditor,
PropertyEditor {
    EventListenerList listenerList = new EventListenerList();
    ListOption editing;
    JDialog dialog;
    JPanel editorPanel;
    JLabel labelLabel;
    JLabel valueLabel;
    JTextField labelField;
    JTextField valueField;
    JList optionList;
    AllPurposeListener listener = new AllPurposeListener();
    JButton add;
    JButton moveUp;
    JButton moveDown;
    JButton delete;
    JButton commitChanges;
    JButton cancelEdit;
    private final ListModel EMPTY_MODEL = new ListModel(){

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }

        public Object getElementAt(int index) {
            return "<no data>";
        }

        @Override
        public int getSize() {
            return 1;
        }
    };

    public OptionListEditor() {
        super("edit");
        this.addActionListener(this.listener);
        this.labelLabel = new JLabel("label:", 2);
        this.labelField = new JTextField(20);
        this.labelField.addFocusListener(this.listener);
        this.valueLabel = new JLabel("value:", 2);
        this.valueField = new JTextField(20);
        this.valueField.addFocusListener(this.listener);
        this.optionList = new JList(this.EMPTY_MODEL);
        this.optionList.setVisibleRowCount(10);
        this.optionList.setSelectionMode(0);
        this.optionList.addListSelectionListener(this.listener);
        this.editorPanel = new JPanel(new BorderLayout());
        this.editorPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.editorPanel.add(new JScrollPane(this.optionList, 22, 30));
        JPanel rightPanel = new JPanel();
        rightPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        this.add = new JButton("Add");
        this.moveUp = new JButton("Move up");
        this.moveDown = new JButton("Move down");
        this.delete = new JButton("Delete");
        this.add.addActionListener(this.listener);
        this.moveUp.addActionListener(this.listener);
        this.moveDown.addActionListener(this.listener);
        this.delete.addActionListener(this.listener);
        Dimension size = this.moveDown.getPreferredSize();
        this.add.setPreferredSize(size);
        this.add.setMaximumSize(size);
        this.moveUp.setPreferredSize(size);
        this.moveUp.setMaximumSize(size);
        this.moveDown.setPreferredSize(size);
        this.moveDown.setMaximumSize(size);
        this.delete.setPreferredSize(size);
        this.delete.setMaximumSize(size);
        rightPanel.add(this.add);
        rightPanel.add(this.moveUp);
        rightPanel.add(this.moveDown);
        rightPanel.add(this.delete);
        this.editorPanel.add((Component)rightPanel, "East");
        JPanel buttonPanel = new JPanel();
        this.commitChanges = new JButton("Commit changes");
        this.commitChanges.addActionListener(this.listener);
        this.cancelEdit = new JButton("Cancel Edit");
        this.cancelEdit.addActionListener(this.listener);
        buttonPanel.add(this.commitChanges);
        buttonPanel.add(this.cancelEdit);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        this.labelLabel.setAlignmentX(0.0f);
        this.labelField.setAlignmentX(0.0f);
        this.valueLabel.setAlignmentX(0.0f);
        this.valueField.setAlignmentX(0.0f);
        buttonPanel.setAlignmentX(0.0f);
        bottomPanel.add(this.labelLabel);
        bottomPanel.add(this.labelField);
        bottomPanel.add(this.valueLabel);
        bottomPanel.add(this.valueField);
        bottomPanel.add(buttonPanel);
        this.editorPanel.add((Component)bottomPanel, "South");
    }

    public void showDialog() {
        if (this.dialog == null) {
            Window w = SwingUtilities.windowForComponent(this);
            if (w instanceof Dialog) {
                this.dialog = new JDialog((Dialog)w, true);
            } else if (w instanceof Frame) {
                this.dialog = new JDialog((Frame)w, true);
            } else {
                this.dialog = new JDialog();
                this.dialog.setModal(true);
            }
            this.dialog.setContentPane(this.editorPanel);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.addWindowListener(this.listener);
        }
        this.dialog.setVisible(true);
    }

    private void addOption() {
        DefaultListModel model = this.getListModel();
        model.addElement(new ListOption("label", "value"));
        this.optionList.setSelectedIndex(model.getSize() - 1);
    }

    private DefaultListModel getListModel() {
        return (DefaultListModel)this.optionList.getModel();
    }

    private void moveUp(int index) {
        if (index >= 0) {
            if (index == 0) {
                return;
            }
            DefaultListModel model = this.getListModel();
            Object option = model.getElementAt(index);
            model.removeElementAt(index);
            model.insertElementAt(option, index - 1);
            this.optionList.setSelectedIndex(index - 1);
        }
    }

    private void moveDown(int index) {
        if (index >= 0) {
            DefaultListModel model = this.getListModel();
            if (index == model.getSize()) {
                return;
            }
            Object option = model.getElementAt(index);
            model.removeElementAt(index);
            model.insertElementAt(option, index + 1);
            this.optionList.setSelectedIndex(index + 1);
        }
    }

    private void deleteOption(int index) {
        if (index >= 0) {
            DefaultListModel model = this.getListModel();
            model.removeElementAt(index);
            this.optionList.clearSelection();
        }
    }

    public static void main(String[] args) {
        JPanel content = new JPanel(new BorderLayout());
        FormBase form = new FormBase(true);
        FormChoice choice = new FormChoice("fred");
        choice.addOption(new ListOption("One", "1"));
        choice.addOption(new ListOption("Two", "2"));
        OptionListEditor editor = new OptionListEditor();
        editor.setOptions(choice.getOptions());
        content.add((Component)choice, "Center");
        content.add((Component)editor, "South");
        JFrame frame = new JFrame();
        frame.setContentPane(content);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    @Override
    public ListOption[] getOptions() {
        DefaultListModel model = this.getListModel();
        ListOption[] options = new ListOption[model.getSize()];
        for (int index = 0; index < options.length; ++index) {
            options[index] = (ListOption)model.getElementAt(index);
        }
        return options;
    }

    @Override
    public void setOptions(ListOption[] options) {
        DefaultListModel<ListOption> model = new DefaultListModel<ListOption>();
        model.ensureCapacity(options.length);
        for (int index = 0; index < options.length; ++index) {
            model.addElement(options[index]);
        }
        this.optionList.setModel(model);
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
        this.dialog.setVisible(false);
    }

    @Override
    public Object getCellEditorValue() {
        return this.getOptions();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ListOption[] options = (ListOption[])value;
        if (this.dialog != null && this.dialog.isVisible()) {
            this.dialog.setVisible(false);
        }
        this.setOptions(options);
        return this;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        this.dialog.setVisible(false);
        return true;
    }

    private void fireEditingCanceled() {
        ChangeEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(e);
        }
    }

    private void fireEditingStopped() {
        ChangeEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(e);
        }
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public String getJavaInitializationString() {
        return "???";
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.getOptions();
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    @Override
    public void setValue(Object value) {
        this.setOptions((ListOption[])value);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    private class AllPurposeListener
    implements ActionListener,
    ListSelectionListener,
    FocusListener,
    WindowListener {
        private AllPurposeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == OptionListEditor.this) {
                OptionListEditor.this.showDialog();
            } else if (source == OptionListEditor.this.add) {
                OptionListEditor.this.addOption();
            } else if (source == OptionListEditor.this.moveUp) {
                OptionListEditor.this.moveUp(OptionListEditor.this.optionList.getSelectedIndex());
            } else if (source == OptionListEditor.this.moveDown) {
                OptionListEditor.this.moveDown(OptionListEditor.this.optionList.getSelectedIndex());
            } else if (source == OptionListEditor.this.delete) {
                OptionListEditor.this.deleteOption(OptionListEditor.this.optionList.getSelectedIndex());
            } else if (source == OptionListEditor.this.commitChanges) {
                OptionListEditor.this.stopCellEditing();
            } else if (source == OptionListEditor.this.cancelEdit) {
                OptionListEditor.this.cancelCellEditing();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int index = OptionListEditor.this.optionList.getSelectedIndex();
            if (index >= 0) {
                OptionListEditor.this.editing = (ListOption)OptionListEditor.this.getListModel().getElementAt(index);
                OptionListEditor.this.labelField.setText(OptionListEditor.this.editing.getLabel());
                OptionListEditor.this.valueField.setText(OptionListEditor.this.editing.getValue());
            } else {
                OptionListEditor.this.editing = null;
                OptionListEditor.this.labelField.setText("");
                OptionListEditor.this.valueField.setText("");
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (OptionListEditor.this.editing != null) {
                if (e.getComponent() == OptionListEditor.this.labelField) {
                    OptionListEditor.this.editing.setLabel(OptionListEditor.this.labelField.getText());
                    OptionListEditor.this.optionList.repaint();
                } else if (e.getComponent() == OptionListEditor.this.valueField) {
                    OptionListEditor.this.editing.setValue(OptionListEditor.this.valueField.getText());
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            OptionListEditor.this.fireEditingCanceled();
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }
}

