/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.das2.dataset.AbstractDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public abstract class AbstractTableDataSet
extends AbstractDataSet
implements DataSet,
TableDataSet {
    private Units zUnits;
    protected List<Map> tableProperties;

    public AbstractTableDataSet(double[] xTags, Units xUnits, Units yUnits, Units zUnits, Map properties) {
        super(xTags, xUnits, yUnits, properties);
        this.zUnits = zUnits;
        this.tableProperties = null;
    }

    @Override
    public Units getZUnits() {
        return this.zUnits;
    }

    @Override
    public VectorDataSet getXSlice(int i) {
        return new XSliceDataSet(this, i);
    }

    @Override
    public VectorDataSet getYSlice(int j, int table) {
        return new YSliceDataSet(this, j, table);
    }

    public String toString() {
        return TableUtil.toString(this);
    }

    @Override
    public Object getProperty(int table, String name) {
        if (this.tableProperties != null) {
            return this.tableProperties.get(table).get(name);
        }
        return null;
    }

    protected static class YSliceDataSet
    extends AbstractDataSet.ViewDataSet
    implements VectorDataSet {
        private final int table;
        private final int jIndex;
        private final TableDataSet ds;

        protected YSliceDataSet(AbstractDataSet ds, int jIndex, int table) {
            this.jIndex = jIndex;
            this.table = table;
            this.ds = (TableDataSet)((Object)ds);
        }

        @Override
        public DataSet getPlanarView(String planeID) {
            return new YSliceDataSet((AbstractDataSet)this.ds.getPlanarView(planeID), this.jIndex, this.table);
        }

        @Override
        public String[] getPlaneIds() {
            return this.ds.getPlaneIds();
        }

        @Override
        public Datum getDatum(int i) {
            int offset = this.ds.tableStart(this.table);
            return this.ds.getDatum(i + offset, this.jIndex);
        }

        @Override
        public double getDouble(int i, Units units) {
            int offset = this.ds.tableStart(this.table);
            return this.ds.getDouble(i + offset, this.jIndex, units);
        }

        @Override
        public int getInt(int i, Units units) {
            int offset = this.ds.tableStart(this.table);
            return this.ds.getInt(i + offset, this.jIndex, units);
        }

        @Override
        public Datum getXTagDatum(int i) {
            int offset = this.ds.tableStart(this.table);
            return this.ds.getXTagDatum(i + offset);
        }

        @Override
        public int getXLength() {
            return this.ds.tableEnd(this.table) - this.ds.tableStart(this.table);
        }

        @Override
        public double getXTagDouble(int i, Units units) {
            int offset = this.ds.tableStart(this.table);
            return this.ds.getXTagDouble(i + offset, units);
        }

        @Override
        public Units getYUnits() {
            return this.ds.getZUnits();
        }

        @Override
        public int getXTagInt(int i, Units units) {
            int offset = this.ds.tableStart(this.table);
            return this.ds.getXTagInt(i + offset, units);
        }

        @Override
        public Object getProperty(String name) {
            return null;
        }

        @Override
        public Map getProperties() {
            return new HashMap();
        }
    }

    protected static class XSliceDataSet
    extends AbstractDataSet.ViewDataSet
    implements VectorDataSet {
        private int iIndex;
        private TableDataSet ds;

        protected XSliceDataSet(AbstractDataSet ds, int i) {
            this.ds = (TableDataSet)((Object)ds);
            this.iIndex = i;
        }

        @Override
        public DataSet getPlanarView(String planeID) {
            return new XSliceDataSet((AbstractDataSet)this.ds.getPlanarView(planeID), this.iIndex);
        }

        @Override
        public String[] getPlaneIds() {
            return this.ds.getPlaneIds();
        }

        @Override
        public Datum getDatum(int i) {
            return this.ds.getDatum(this.iIndex, i);
        }

        @Override
        public double getDouble(int i, Units units) {
            return this.ds.getDouble(this.iIndex, i, units);
        }

        @Override
        public int getInt(int i, Units units) {
            return this.ds.getInt(this.iIndex, i, units);
        }

        @Override
        public Datum getXTagDatum(int i) {
            int table = this.ds.tableOfIndex(this.iIndex);
            return this.ds.getYTagDatum(table, i);
        }

        @Override
        public int getXLength() {
            int table = this.ds.tableOfIndex(this.iIndex);
            return this.ds.getYLength(table);
        }

        @Override
        public Units getXUnits() {
            return this.ds.getYUnits();
        }

        @Override
        public double getXTagDouble(int i, Units units) {
            int table = this.ds.tableOfIndex(this.iIndex);
            return this.ds.getYTagDouble(table, i, units);
        }

        @Override
        public Units getYUnits() {
            return this.ds.getZUnits();
        }

        @Override
        public int getXTagInt(int i, Units units) {
            int table = this.ds.tableOfIndex(this.iIndex);
            return this.ds.getYTagInt(table, i, units);
        }

        @Override
        public Object getProperty(String name) {
            return null;
        }

        public String toString() {
            return VectorUtil.toString(this);
        }

        @Override
        public Map getProperties() {
            return new HashMap();
        }
    }
}

