/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.das2.DasException;
import org.das2.dataset.DataRequestor;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.datum.Datum;
import org.das2.util.monitor.ProgressMonitor;

public class DataRequestThread
extends Thread {
    private static int threadCount = 0;
    private Object lock = new String("DATA_REQUEST_LOCK");
    private DataRequest currentRequest;
    private List queue = Collections.synchronizedList(new LinkedList());

    public DataRequestThread() {
        this.setName("DataRequest_" + threadCount++);
        this.setDaemon(true);
        this.start();
    }

    public void request(DataSetDescriptor dsd, Datum start, Datum end, Datum resolution, DataRequestor requestor, ProgressMonitor monitor) throws InterruptedException {
        this.requestInternal(new DataRequest(dsd, start, end, resolution, requestor, monitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAndWait(DataSetDescriptor dsd, Object params, Datum start, Datum end, Datum resolution, DataRequestor requestor, ProgressMonitor monitor) throws InterruptedException {
        DataRequest request;
        DataRequest dataRequest = request = new DataRequest(dsd, start, end, resolution, requestor, monitor);
        synchronized (dataRequest) {
            this.requestInternal(request);
            request.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestInternal(DataRequest request) {
        this.queue.add(request);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCurrentRequest() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isAlive()) {
                this.interrupt();
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Thread.currentThread() != this) {
            throw new IllegalStateException("This method should not be invoked directly");
        }
        while (true) {
            Object object;
            if (!this.queue.isEmpty()) {
                this.currentRequest = (DataRequest)this.queue.remove(0);
                try {
                    DataSet ds = this.currentRequest.dsd.getDataSet(this.currentRequest.start, this.currentRequest.end, this.currentRequest.resolution, this.currentRequest.monitor);
                    this.currentRequest.requestor.finished(ds);
                }
                catch (DasException e) {
                    this.currentRequest.requestor.exception(e);
                }
                finally {
                    object = this.currentRequest;
                    synchronized (object) {
                        this.currentRequest.notifyAll();
                    }
                }
            }
            object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    private static class DataRequest {
        DataSetDescriptor dsd;
        Datum start;
        Datum end;
        Object params;
        Datum resolution;
        DataRequestor requestor;
        ProgressMonitor monitor;

        DataRequest(DataSetDescriptor dsd, Datum start, Datum end, Datum resolution, DataRequestor requestor, ProgressMonitor monitor) {
            this.dsd = dsd;
            this.start = start;
            this.end = end;
            this.resolution = resolution;
            this.requestor = requestor;
            this.monitor = monitor;
        }
    }
}

