/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.Rank3TableDataSetAdapter;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetAdapter;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.DatumVectorAdapter;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.TagGenDataSet;
import org.das2.qds.WritableDataSet;

public class TableDataSetAdapter
implements TableDataSet {
    Units xunits;
    Units yunits;
    Units zunits;
    QDataSet x;
    QDataSet y;
    QDataSet z;
    HashMap properties = new HashMap();
    HashMap<String, QDataSet> planes = new LinkedHashMap<String, QDataSet>();

    public static TableDataSet create(QDataSet z) {
        if (z.rank() == 2) {
            Units xunits;
            QDataSet cadence;
            QDataSet sort;
            QDataSet yds;
            QDataSet xds = (QDataSet)z.property("DEPEND_0");
            if (xds == null) {
                xds = new IndexGenDataSet(z.length());
            }
            if ((yds = (QDataSet)z.property("DEPEND_1")) == null) {
                if (z.length() > 0 && z.property("DEPEND_0", 0) != null) {
                    Units yunits = null;
                    JoinDataSet jds = new JoinDataSet(2);
                    for (int i = 0; i < z.length(); ++i) {
                        QDataSet d0ds = (QDataSet)z.property("DEPEND_0", i);
                        if (yunits == null) {
                            yunits = (Units)d0ds.property("UNITS");
                            if (yunits == null) {
                                yunits = Units.dimensionless;
                            }
                            jds.putProperty("UNITS", (Object)yunits);
                        } else {
                            Units y0units = (Units)d0ds.property("UNITS");
                            if (y0units == null) {
                                y0units = Units.dimensionless;
                            }
                            if (y0units != yunits) {
                                throw new IllegalArgumentException("yunits change");
                            }
                        }
                        jds.join(d0ds);
                    }
                    yds = jds;
                } else {
                    yds = new IndexGenDataSet(z.length(0));
                }
            }
            if (xds.length() > 1 && !DataSetUtil.isMonotonic((QDataSet)xds)) {
                sort = DataSetOps.sort((QDataSet)xds);
                cadence = (QDataSet)xds.property("CADENCE");
                z = DataSetOps.applyIndex((QDataSet)z, (int)0, (QDataSet)sort, (boolean)false);
                xds = DataSetOps.applyIndex((QDataSet)xds, (int)0, (QDataSet)sort, (boolean)false);
                if (cadence != null && cadence.value() < 0.0) {
                    cadence = DataSetUtil.asDataSet((Datum)DataSetUtil.asDatum((QDataSet)cadence).multiply(-1.0));
                    ((WritableDataSet)xds).putProperty("CADENCE", (Object)cadence);
                }
            }
            if (yds.rank() == 1 && !DataSetUtil.isMonotonic((QDataSet)yds)) {
                sort = DataSetOps.sort((QDataSet)yds);
                cadence = (QDataSet)yds.property("CADENCE");
                z = DataSetOps.applyIndex((QDataSet)z, (int)1, (QDataSet)sort, (boolean)false);
                yds = DataSetOps.applyIndex((QDataSet)yds, (int)0, (QDataSet)sort, (boolean)false);
                if (cadence != null && cadence.value() < 0.0) {
                    cadence = DataSetUtil.asDataSet((Datum)DataSetUtil.asDatum((QDataSet)cadence).multiply(-1.0));
                    ((WritableDataSet)yds).putProperty("CADENCE", (Object)cadence);
                }
            }
            if (UnitsUtil.isTimeLocation((Units)(xunits = SemanticOps.getUnits((QDataSet)xds)))) {
                UnitsConverter uc = UnitsConverter.getConverter((Units)xunits, (Units)Units.us2000);
                ArrayDataSet xx = ArrayDataSet.copy((QDataSet)xds);
                for (int i = 0; i < xds.length(); ++i) {
                    xx.putValue(i, uc.convert(xx.value(i)));
                }
                xx.putProperty("UNITS", (Object)Units.us2000);
                xds = xx;
            }
            return new TableDataSetAdapter(z, xds, yds);
        }
        if (z.rank() == 3) {
            JoinDataSet xds = new JoinDataSet(2);
            JoinDataSet yds = new JoinDataSet(2);
            int ix = 0;
            boolean iy = false;
            boolean haveX = true;
            boolean haveY = true;
            Units xunits = null;
            boolean haveXUnits = true;
            Units yunits = null;
            boolean haveYUnits = true;
            for (int i0 = 0; i0 < z.length(); ++i0) {
                QDataSet xds1 = (QDataSet)z.property("DEPEND_0", i0);
                if (xds1 == null) {
                    haveX = true;
                    xds1 = new TagGenDataSet(z.length(i0), 1.0, (double)ix);
                    ix += z.length(i0);
                } else {
                    Units u = (Units)xds1.property("UNITS");
                    if (u != null && xunits != null && xunits != u) {
                        haveXUnits = false;
                    } else if (u != null && xunits == null) {
                        xunits = u;
                    }
                }
                QDataSet yds1 = (QDataSet)z.property("DEPEND_1", i0);
                if (yds1 == null) {
                    yds1 = new IndexGenDataSet(z.length(i0, 0));
                } else {
                    Units u = (Units)yds1.property("UNITS");
                    if (u != null && yunits != null && yunits != u) {
                        haveYUnits = false;
                    } else if (u != null && yunits == null) {
                        yunits = u;
                    }
                }
                if (haveX) {
                    if (UnitsUtil.isTimeLocation((Units)xunits)) {
                        UnitsConverter uc = UnitsConverter.getConverter((Units)xunits, (Units)Units.us2000);
                        ArrayDataSet xx = ArrayDataSet.copy((QDataSet)xds1);
                        for (int i = 0; i < xds1.length(); ++i) {
                            xx.putValue(i, uc.convert(xx.value(i)));
                        }
                        xx.putProperty("UNITS", (Object)Units.us2000);
                        xds1 = xx;
                    }
                    xds.join(xds1);
                }
                if (!haveY) continue;
                yds.join(yds1);
            }
            if ((haveX || haveY) && !(z instanceof MutablePropertyDataSet)) {
                z = DDataSet.maybeCopy((QDataSet)z);
            }
            if (haveX && haveXUnits) {
                xds.putProperty("UNITS", (Object)Units.us2000);
            }
            if (haveY && haveYUnits) {
                yds.putProperty("UNITS", yunits);
            }
            return new Rank3TableDataSetAdapter(z, (QDataSet)xds, (QDataSet)yds);
        }
        throw new IllegalArgumentException("rank must be 2 or 3");
    }

    public TableDataSetAdapter(QDataSet z, QDataSet x, QDataSet y) {
        Datum dcadence;
        QDataSet cadence;
        this.planes.put("", z);
        this.xunits = (Units)x.property("UNITS");
        this.yunits = (Units)y.property("UNITS");
        this.zunits = (Units)z.property("UNITS");
        if (this.xunits == null) {
            this.xunits = Units.dimensionless;
        }
        if (this.yunits == null) {
            this.yunits = Units.dimensionless;
        }
        if (this.zunits == null) {
            this.zunits = Units.dimensionless;
        }
        this.x = x;
        this.y = y;
        this.z = z;
        Boolean xMono = (Boolean)x.property("MONOTONIC");
        if (xMono != null && xMono.booleanValue()) {
            this.properties.put("xMonotonic", Boolean.TRUE);
        }
        if ((cadence = (QDataSet)x.property("CADENCE")) != null) {
            dcadence = DataSetUtil.asDatum((QDataSet)cadence);
            this.properties.put("xTagWidth", dcadence);
        }
        if ((cadence = (QDataSet)y.property("CADENCE")) != null) {
            dcadence = DataSetUtil.asDatum((QDataSet)cadence);
            this.properties.put("yTagWidth", dcadence);
        }
        if (z.property("FILL_VALUE") != null || z.property("VALID_MIN") != null || z.property("VALID_MAX") != null) {
            QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)z);
            this.planes.put("weights", wds);
        }
    }

    @Override
    public Units getZUnits() {
        return this.zunits;
    }

    @Override
    public Datum getDatum(int i, int j) {
        return this.zunits.createDatum(this.z.value(i, j));
    }

    @Override
    public double getDouble(int i, int j, Units units) {
        return this.zunits.convertDoubleTo(units, this.z.value(i, j));
    }

    @Override
    public double[] getDoubleScan(int i, Units units) {
        double[] zz = new double[this.getYLength(this.tableOfIndex(i))];
        for (int j = 0; j < zz.length; ++j) {
            zz[j] = this.getDouble(i, j, this.getZUnits());
        }
        return zz;
    }

    @Override
    public DatumVector getScan(int i) {
        double[] zz = this.getDoubleScan(i, this.getZUnits());
        return DatumVector.newDatumVector((double[])zz, (Units)this.getZUnits());
    }

    @Override
    public int getInt(int i, int j, Units units) {
        return (int)this.getDouble(i, j, units);
    }

    @Override
    public DatumVector getYTags(int table) {
        if (this.y.rank() == 1) {
            return DatumVectorAdapter.toDatumVector((QDataSet)this.y);
        }
        return DatumVectorAdapter.toDatumVector((QDataSet)this.y.slice(table));
    }

    @Override
    public Datum getYTagDatum(int table, int j) {
        if (this.y.rank() == 1) {
            if (table > 0) {
                throw new IllegalArgumentException("table>0");
            }
            return this.yunits.createDatum(this.y.value(j));
        }
        return this.yunits.createDatum(this.y.value(table, j));
    }

    @Override
    public double getYTagDouble(int table, int j, Units units) {
        if (this.y.rank() == 1) {
            if (table > 0) {
                throw new IllegalArgumentException("table>0");
            }
            return this.yunits.convertDoubleTo(units, this.y.value(j));
        }
        return this.yunits.convertDoubleTo(units, this.y.value(table, j));
    }

    @Override
    public int getYTagInt(int table, int j, Units units) {
        return (int)this.getYTagDouble(table, j, units);
    }

    @Override
    public int getYLength(int table) {
        if (this.y.rank() == 1) {
            return this.y.length();
        }
        return this.y.length(table);
    }

    @Override
    public int tableStart(int table) {
        if (this.y.rank() == 1) {
            return 0;
        }
        return table;
    }

    @Override
    public int tableEnd(int table) {
        if (this.y.rank() == 1) {
            return this.getXLength();
        }
        return table + 1;
    }

    @Override
    public int tableCount() {
        if (this.y.rank() == 1) {
            return 1;
        }
        return this.y.length();
    }

    @Override
    public int tableOfIndex(int i) {
        if (this.y.rank() == 1) {
            return 0;
        }
        return i;
    }

    @Override
    public VectorDataSet getXSlice(int i) {
        if (this.y.rank() == 1) {
            return new VectorDataSetAdapter(this.z.slice(i), this.y);
        }
        return new VectorDataSetAdapter(this.z.slice(i), this.y.slice(i));
    }

    @Override
    public VectorDataSet getYSlice(int j, int table) {
        if (this.y.rank() == 1) {
            return new VectorDataSetAdapter((QDataSet)DataSetOps.slice1((QDataSet)this.z, (int)j), this.x);
        }
        return new VectorDataSetAdapter((QDataSet)DataSetOps.slice1((QDataSet)this.z, (int)j), this.x);
    }

    @Override
    public Object getProperty(String name) {
        Object result = this.properties.get(name);
        return result != null ? result : this.z.property(name);
    }

    @Override
    public Object getProperty(int table, String name) {
        return this.getProperty(name);
    }

    @Override
    public Map getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("UNITS", null);
        HashMap m = new HashMap(DataSetUtil.getProperties((QDataSet)this.z, result));
        m.putAll(this.properties);
        return m;
    }

    @Override
    public Units getXUnits() {
        return this.xunits;
    }

    @Override
    public Units getYUnits() {
        return this.yunits;
    }

    @Override
    public Datum getXTagDatum(int i) {
        return this.xunits.createDatum(this.x.value(i));
    }

    @Override
    public double getXTagDouble(int i, Units units) {
        return this.xunits.convertDoubleTo(units, this.x.value(i));
    }

    @Override
    public int getXTagInt(int i, Units units) {
        return (int)this.xunits.convertDoubleTo(units, this.x.value(i));
    }

    @Override
    public int getXLength() {
        return this.x.length();
    }

    @Override
    public DataSet getPlanarView(String planeID) {
        if (planeID.equals("")) {
            return this;
        }
        if (this.planes.containsKey(planeID)) {
            return new TableDataSetAdapter(this.planes.get(planeID), this.x, this.y);
        }
        return null;
    }

    @Override
    public String[] getPlaneIds() {
        return this.planes.keySet().toArray(new String[this.planes.keySet().size()]);
    }

    public String toString() {
        return DataSetUtil.toString((QDataSet)this.z);
    }
}

