/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset.test;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.das2.DasException;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DefaultVectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.util.monitor.ProgressMonitor;

public class SineWaveDataSetDescriptor
extends DataSetDescriptor {
    Datum amplitude;
    Datum period;
    Datum phase;

    public SineWaveDataSetDescriptor(Datum amplitude, Datum period) {
        this(amplitude, period, null);
    }

    public SineWaveDataSetDescriptor(Datum amplitude, Datum period, Datum phase) {
        super(null);
        if (0.0 == period.doubleValue(period.getUnits())) {
            throw new IllegalArgumentException("period is zero");
        }
        this.amplitude = amplitude;
        this.period = period;
        this.phase = phase;
    }

    @Override
    public DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        if (resolution == null) {
            resolution = end.subtract(start).divide(1000.0);
        }
        int nstep = 2 + (int)(end.subtract(start).doubleValue(resolution.getUnits()) / resolution.doubleValue(resolution.getUnits()));
        int stepSize = 1;
        nstep /= stepSize;
        if (this.phase == null) {
            this.phase = start;
        }
        double[] yvalues = new double[nstep];
        double[] xtags = new double[nstep];
        Units xunits = this.phase.getUnits();
        Units offsetUnits = this.period.getUnits();
        Units yunits = this.amplitude.getUnits();
        for (int i = 0; i < nstep; ++i) {
            Datum x = start.add(resolution.multiply((double)(i * stepSize)));
            double y = this.amplitude.doubleValue(yunits) * Math.sin(Math.PI * 2 * (x.subtract(this.phase).doubleValue(offsetUnits) / this.period.doubleValue(offsetUnits)));
            xtags[i] = x.doubleValue(xunits);
            yvalues[i] = y;
        }
        DefaultVectorDataSet result = new DefaultVectorDataSet(xtags, xunits, yvalues, yunits, new HashMap());
        return result;
    }

    @Override
    public Units getXUnits() {
        return this.period.getUnits();
    }

    public static SineWaveDataSetDescriptor newDataSetDescriptor(Map map) throws DasException {
        String periodStr = (String)map.get("period");
        String xUnitsStr = (String)map.get("xUnits");
        String amplitudeStr = (String)map.get("amplitude");
        String yUnitsStr = (String)map.get("yUnits");
        if (periodStr == null || amplitudeStr == null) {
            throw new DasException("period and amplitude must be specified for SineWaveDataSetDescriptors");
        }
        Units xUnits = xUnitsStr == null ? Units.dimensionless : Units.getByName((String)xUnitsStr);
        Units yUnits = xUnitsStr == null ? Units.dimensionless : Units.getByName((String)yUnitsStr);
        try {
            Datum period = xUnits.getOffsetUnits().parse(periodStr);
            Datum amplitude = yUnits.parse(amplitudeStr);
            return new SineWaveDataSetDescriptor(amplitude, period);
        }
        catch (ParseException pe) {
            throw new DasException(pe.getMessage());
        }
    }
}

