/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import org.das2.datum.Datum;
import org.das2.event.DragRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;

public class HorizontalFrequencyDragRenderer
implements DragRenderer,
KeyListener {
    private Rectangle dirtyBounds;
    DasCanvasComponent parent;
    DasAxis axis;
    int ncycles;

    public HorizontalFrequencyDragRenderer(DasCanvasComponent parent, DasAxis axis) {
        this.parent = parent;
        parent.addKeyListener(this);
        this.axis = axis;
        this.dirtyBounds = new Rectangle();
        this.ncycles = 1;
    }

    public void renderLabel(Graphics g1, Point p1, Point p2, String report) {
        int dxMax = Integer.MIN_VALUE;
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fm = this.parent.getGraphics().getFontMetrics();
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 200));
        Dimension d = this.parent.getSize();
        int dx = fm.stringWidth(report) + 6;
        if (dxMax < dx) {
            dxMax = dx;
        }
        int dy = fm.getAscent() + fm.getDescent();
        int xp = p2.x + 3;
        int yp = p2.y - 3 - dy;
        if (xp + dxMax > d.width - 3 && p2.x - 3 - dx > 0) {
            xp = p2.x - 3 - dx;
        }
        if (yp < 13) {
            yp = p2.y + 3;
        }
        Rectangle bg = new Rectangle(xp, yp, dx, dy);
        g.fill(bg);
        g.setColor(new Color(20, 20, 20));
        g.drawString(report, xp + 3, yp + fm.getAscent());
        g.setColor(color0);
        this.dirtyBounds.add(bg);
    }

    @Override
    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        int x2 = p2.x;
        int x1 = p1.x;
        if (x2 < x1) {
            int t = x2;
            x2 = x1;
            x1 = t;
        }
        int y = p2.y;
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 128));
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        this.internalRender(g, this.dirtyBounds, x1, x2, y);
        g.setStroke(new BasicStroke());
        g.setColor(color0);
        this.internalRender(g, this.dirtyBounds, x1, x2, y);
        Datum periodDatum = this.axis.invTransform(x2).subtract(this.axis.invTransform(x1));
        double period = periodDatum.doubleValue(periodDatum.getUnits());
        double freq = (double)this.ncycles / period;
        DecimalFormat df = new DecimalFormat("0.00");
        this.renderLabel(g1, p1, p2, "T:" + df.format(period) + " f:" + df.format(freq));
        return new Rectangle[]{this.dirtyBounds};
    }

    private void internalRender(Graphics2D g, Rectangle dirtyBounds, int x1, int x2, int y) {
        double width = x2 - x1;
        if (width > 6.0) {
            g.drawLine(x1 + 3, y, x2 - 3, y);
        }
        g.drawLine(x1, y + 2, x1, y - 2);
        g.drawLine(x2, y + 2, x2, y - 2);
        dirtyBounds.setRect(x1 - 2, y - 5, 4.0, 10.0);
        double rwidth = width / (double)this.ncycles;
        if (width > (double)(3 * this.ncycles)) {
            double ii;
            for (ii = (double)x2 + rwidth; ii < (double)this.axis.getColumn().getWidth(); ii += rwidth) {
                g.drawLine((int)ii, y + 2, (int)ii, y - 2);
                dirtyBounds.add((int)ii + 2, y - 5);
            }
            for (ii = (double)x2 - rwidth; ii > 0.0; ii -= rwidth) {
                g.drawLine((int)ii, y + 2, (int)ii, y - 2);
                dirtyBounds.add((int)ii - 2, y - 5);
            }
        }
    }

    @Override
    public boolean isPointSelection() {
        return false;
    }

    @Override
    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    @Override
    public boolean isUpdatingDragSelection() {
        return false;
    }

    @Override
    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        return null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '1') {
            this.ncycles = 1;
        } else if (e.getKeyChar() == '2') {
            this.ncycles = 2;
        } else if (e.getKeyChar() == '3') {
            this.ncycles = 3;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

