/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.event.DragRenderer;
import org.das2.event.GesturesRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseRangeSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.util.GrannyTextRenderer;

public class HorizontalRangeGesturesRenderer
implements DragRenderer {
    private final Rectangle dirtyBounds;
    DasCanvasComponent parent;
    GesturesRenderer gr;

    public HorizontalRangeGesturesRenderer(DasCanvasComponent parent) {
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
        this.gr = new GesturesRenderer(parent);
    }

    @Override
    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        double dy = -1 * (p2.y - p1.y);
        double dx = p2.x - p1.x;
        double radius = Math.sqrt(dy * dy + dx * dx);
        if (radius < 20.0) {
            this.gr.renderDrag(g, p1, p2);
            this.dirtyBounds.setBounds(this.gr.getDirtyBounds());
        } else {
            int x2 = p2.x;
            int x1 = p1.x;
            if (x2 < x1) {
                int t = x2;
                x2 = x1;
                x1 = t;
            }
            int width = x2 - x1;
            int y = p2.y;
            Color color0 = g.getColor();
            g.setColor(new Color(255, 255, 255, 100));
            g.setStroke(new BasicStroke(3.0f, 1, 1));
            if (width > 6) {
                g.drawLine(x1 + 3, y, x2 - 3, y);
            }
            g.drawLine(x1, y + 2, x1, y - 2);
            g.drawLine(x2, y + 2, x2, y - 2);
            g.setStroke(new BasicStroke());
            g.setColor(color0);
            if (width > 6) {
                g.drawLine(x1 + 3, y, x2 - 3, y);
            }
            g.drawLine(x1, y + 2, x1, y - 2);
            g.drawLine(x2, y + 2, x2, y - 2);
            if (width > 6) {
                g.drawLine(x1 + 3, y, x2 - 3, y);
            }
            g.drawLine(x1, y + 2, x1, y - 2);
            g.drawLine(x2, y + 2, x2, y - 2);
            this.dirtyBounds.setLocation(x1 - 2, y + 3);
            this.dirtyBounds.add(x2 + 2, y - 3);
            if (this.parent instanceof DasAxis && (x1 < this.parent.getColumn().getDMinimum() || x2 > this.parent.getColumn().getDMaximum())) {
                DasAxis p = (DasAxis)this.parent;
                DatumRange dr = DatumRangeUtil.union((Datum)p.invTransform(x1), (Datum)p.invTransform(x2));
                dr = p.getTickV().enclosingRange(dr, true);
                g.setColor(new Color(255, 255, 255, 200));
                GrannyTextRenderer gtr = new GrannyTextRenderer();
                gtr.setString(g1, "" + dr);
                Rectangle r = gtr.getBounds();
                int x = x2 > this.parent.getColumn().getDMaximum() ? x1 + 3 : x2 - 3 - (int)gtr.getWidth();
                r.translate(x, y + g.getFontMetrics().getHeight());
                g.fill(r);
                g.setColor(color0);
                gtr.draw((Graphics)g, (float)x, (float)(y + g.getFontMetrics().getHeight()));
                this.dirtyBounds.add(x, y + g.getFontMetrics().getHeight());
            }
        }
        return new Rectangle[]{this.dirtyBounds};
    }

    @Override
    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        double dy = -1 * (p2.y - p1.y);
        double dx = p2.x - p1.x;
        double radius = Math.sqrt(dy * dy + dx * dx);
        if (radius < 20.0) {
            return this.gr.getMouseDragEvent(source, p1, p2, isModified);
        }
        return new MouseRangeSelectionEvent(source, p1.x, p2.x, isModified);
    }

    @Override
    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    @Override
    public boolean isPointSelection() {
        return false;
    }

    @Override
    public boolean isUpdatingDragSelection() {
        return false;
    }
}

