/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;

public class ZoomPanMouseModule
extends MouseModule {
    DasAxis xAxis;
    DasAxis.Lock xAxisLock;
    DasAxis yAxis;
    DasAxis.Lock yAxisLock;
    Point p0;
    DatumRange xAxisRange0;
    DatumRange yAxisRange0;
    long t0;
    long tbirth;

    public ZoomPanMouseModule(DasCanvasComponent parent, DasAxis horizontalAxis, DasAxis verticalAxis) {
        super(parent);
        this.setLabel("Zoom Pan");
        this.xAxis = horizontalAxis;
        this.yAxis = verticalAxis;
        this.t0 = System.nanoTime();
        this.tbirth = System.nanoTime();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int i;
        DatumRange dr;
        double nmax;
        double nmin;
        double xshift = 0.0;
        double yshift = 0.0;
        if (e.isShiftDown()) {
            logger.fine("shift is down but no longer has any effect.  Use control to pan.");
            this.parent.getDasMouseInputAdapter().getFeedback().setMessage("shift has no effect, press control to pan");
            return;
        }
        if (e.isControlDown()) {
            if (this.xAxis != null && this.yAxis != null) {
                this.parent.getDasMouseInputAdapter().getFeedback().setMessage("pan is disabled when there are two axes");
                return;
            }
            double rot = e.getPreciseWheelRotation();
            if (rot < -2.0) {
                rot = -2.0;
            }
            if (rot > 2.0) {
                rot = 2.0;
            }
            nmin = 0.2 * rot;
            nmax = nmin + 1.0;
        } else {
            Point ep = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
            MouseModule.Pos xpos = this.xAxis == null ? MouseModule.Pos._null : this.position(this.xAxis.getColumn(), ep.x, 20);
            MouseModule.Pos ypos = this.yAxis == null ? MouseModule.Pos._null : this.position(this.yAxis.getRow(), ep.y, 20);
            double rot = e.getPreciseWheelRotation();
            if (rot < -2.0) {
                rot = -2.0;
            }
            if (rot > 2.0) {
                rot = 2.0;
            }
            if (rot < 0.0) {
                nmin = 0.1 * (-1.0 * rot);
                nmax = 1.0 - nmin;
            } else {
                nmin = -0.125 * rot;
                nmax = 1.0 - nmin;
            }
            switch (xpos) {
                case min: {
                    xshift = -nmin;
                    break;
                }
                case max: {
                    xshift = nmin;
                    break;
                }
                default: {
                    logger.log(Level.FINE, "xpos: {0}", (Object)xpos);
                }
            }
            switch (ypos) {
                case min: {
                    yshift = nmin;
                    break;
                }
                case max: {
                    yshift = -nmin;
                    break;
                }
                default: {
                    logger.log(Level.FINE, "ypos: {0}", (Object)ypos);
                }
            }
        }
        int clickMag = 1;
        long t1 = System.nanoTime();
        long limitNanos = 40000000L;
        if ((t1 - this.t0) / (long)clickMag < limitNanos) {
            clickMag = (int)Math.floor((double)(t1 - this.t0) / (double)limitNanos);
        }
        if (clickMag == 0) {
            return;
        }
        this.t0 = System.nanoTime();
        DatumRange xdrnew = null;
        DatumRange ydrnew = null;
        logger.log(Level.FINEST, ":ns:  {0}  {1}", new Object[]{System.nanoTime() - this.tbirth, clickMag});
        if (ZoomPanMouseModule.axisIsAdjustable(this.xAxis)) {
            dr = this.xAxis.getDatumRange();
            for (i = 0; i < clickMag; ++i) {
                dr = this.xAxis.isLog() ? DatumRangeUtil.rescaleLog((DatumRange)dr, (double)(nmin + xshift), (double)(nmax + xshift)) : DatumRangeUtil.rescale((DatumRange)dr, (double)(nmin + xshift), (double)(nmax + xshift));
            }
            if (!DatumRangeUtil.isAcceptable((DatumRange)(dr = ZoomPanMouseModule.maybeRound(this.xAxis, dr)), (boolean)this.xAxis.isLog())) {
                dr = null;
            }
            xdrnew = dr;
        }
        if (ZoomPanMouseModule.axisIsAdjustable(this.yAxis)) {
            dr = this.yAxis.getDatumRange();
            for (i = 0; i < clickMag; ++i) {
                dr = this.yAxis.isLog() ? DatumRangeUtil.rescaleLog((DatumRange)dr, (double)(nmin + yshift), (double)(nmax + yshift)) : DatumRangeUtil.rescale((DatumRange)dr, (double)(nmin + yshift), (double)(nmax + yshift));
            }
            if (!DatumRangeUtil.isAcceptable((DatumRange)(dr = ZoomPanMouseModule.maybeRound(this.yAxis, dr)), (boolean)this.yAxis.isLog())) {
                dr = null;
            }
            ydrnew = dr;
        }
        if (ZoomPanMouseModule.axisIsAdjustable(this.xAxis) && xdrnew == null) {
            return;
        }
        if (ZoomPanMouseModule.axisIsAdjustable(this.yAxis) && ydrnew == null) {
            return;
        }
        if (ZoomPanMouseModule.axisIsAdjustable(this.xAxis)) {
            this.xAxis.setDatumRange(xdrnew);
        }
        if (ZoomPanMouseModule.axisIsAdjustable(this.yAxis)) {
            this.yAxis.setDatumRange(ydrnew);
        }
        super.mouseWheelMoved(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.xAxis != null) {
            this.xAxisLock.unlock();
            this.xAxisLock = null;
        }
        if (this.yAxis != null) {
            this.yAxisLock.unlock();
            this.yAxisLock = null;
        }
        this.doPan(e);
        this.parent.getCanvas().getGlassPane().setCursor(null);
    }

    private void doPan(MouseEvent e) {
        DatumRange dr;
        Point p2 = e.getPoint();
        if (ZoomPanMouseModule.axisIsAdjustable(this.xAxis)) {
            Datum delta;
            if (this.xAxis.isLog()) {
                if (UnitsUtil.isRatioMeasurement((Units)this.xAxis.getUnits())) {
                    delta = this.xAxis.invTransform(this.p0.getX()).divide(this.xAxis.invTransform(p2.getX()));
                    dr = new DatumRange(this.xAxisRange0.min().multiply(delta), this.xAxisRange0.max().multiply(delta));
                } else {
                    dr = this.xAxisRange0;
                }
            } else {
                delta = this.xAxis.invTransform(this.p0.getX()).subtract(this.xAxis.invTransform(p2.getX()));
                dr = new DatumRange(this.xAxisRange0.min().add(delta), this.xAxisRange0.max().add(delta));
            }
            dr = ZoomPanMouseModule.maybeRound(this.xAxis, dr);
            this.xAxis.setDatumRange(dr);
        }
        if (ZoomPanMouseModule.axisIsAdjustable(this.yAxis)) {
            Datum ydelta;
            if (this.yAxis.isLog()) {
                if (UnitsUtil.isRatioMeasurement((Units)this.yAxis.getUnits())) {
                    ydelta = this.yAxis.invTransform(this.p0.getY()).divide(this.yAxis.invTransform(p2.getY()));
                    dr = new DatumRange(this.yAxisRange0.min().multiply(ydelta), this.yAxisRange0.max().multiply(ydelta));
                } else {
                    dr = this.yAxisRange0;
                }
            } else {
                ydelta = this.yAxis.invTransform(this.p0.getY()).subtract(this.yAxis.invTransform(p2.getY()));
                dr = new DatumRange(this.yAxisRange0.min().add(ydelta), this.yAxisRange0.max().add(ydelta));
            }
            dr = ZoomPanMouseModule.maybeRound(this.yAxis, dr);
            this.yAxis.setDatumRange(dr);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        this.doPan(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.p0 = e.getPoint();
        if (this.xAxis != null) {
            this.xAxisRange0 = this.xAxis.getDatumRange();
            this.xAxisLock = this.xAxis.mutatorLock();
            this.xAxisLock.lock();
        }
        if (this.yAxis != null) {
            this.yAxisRange0 = this.yAxis.getDatumRange();
            this.yAxisLock = this.yAxis.mutatorLock();
            this.yAxisLock.lock();
        }
        this.parent.getCanvas().getGlassPane().setCursor(new Cursor(13));
    }
}

