/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;

public class BoundsRenderer
extends Renderer {
    private GeneralPath context = null;
    private Color color = new Color(0, 0, 0);
    private Color fillColor = new Color(0, 0, 0, 128);
    public static final String PROP_COLOR = "color";
    public static final String PROP_FILL_COLOR = "fillColor";
    private String fillTexture = "solid";
    public static final String PROP_FILLTEXTURE = "fillTexture";
    private boolean polar = false;
    public static final String PROP_POLAR = "polar";

    private void expectDs() {
        this.getParent().postException(this, new IllegalArgumentException("Expect rank 2 bins or rank 3 array of bins dataset"));
    }

    @Override
    public boolean acceptsDataSet(QDataSet ds) {
        return ds.rank() == 1 || Schemes.isBoundingBox((QDataSet)ds) || Schemes.isArrayOfBoundingBox((QDataSet)ds);
    }

    @Override
    public boolean acceptContext(int x, int y) {
        return this.context == null ? false : this.context.contains(x, y);
    }

    public Area selectionArea() {
        if (this.context == null) {
            return null;
        }
        return new Area(this.context);
    }

    @Override
    public Icon getListIcon() {
        BufferedImage i = new BufferedImage(16, 16, 2);
        Graphics2D g = (Graphics2D)((Image)i).getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle2D.Double pbox = new Rectangle2D.Double(0.0, 0.0, 15.0, 15.0);
        GeneralPath p = new GeneralPath();
        p.append(pbox.getPathIterator(null), true);
        p.closePath();
        GraphUtil.fillWithTexture(g, p, this.fillColor, this.fillTexture);
        g.draw(p);
        return new ImageIcon(i);
    }

    @Override
    public String getListLabel() {
        return "" + (this.getLegendLabel().length() > 0 ? this.getLegendLabel() + " " : "bounds");
    }

    public static QDataSet doAutorange(QDataSet ds) {
        if (ds.length() == 0) {
            return null;
        }
        if (Schemes.isBoundingBox((QDataSet)ds)) {
            QDataSet xxx = Ops.slice0((QDataSet)ds, (int)0);
            QDataSet yyy = Ops.slice0((QDataSet)ds, (int)1);
            xxx = Ops.rescaleRangeLogLin((QDataSet)xxx, (double)-0.1, (double)1.1);
            yyy = Ops.rescaleRangeLogLin((QDataSet)yyy, (double)-0.1, (double)1.1);
            return Ops.join((QDataSet)xxx, (QDataSet)yyy);
        }
        if (Schemes.isArrayOfBoundingBox((QDataSet)ds)) {
            QDataSet xx = null;
            QDataSet yy = null;
            for (int i = 0; i < ds.length(); ++i) {
                QDataSet ds1 = ds.slice(i);
                QDataSet xxx = Ops.slice0((QDataSet)ds1, (int)0);
                QDataSet yyy = Ops.slice0((QDataSet)ds1, (int)1);
                xx = xx == null ? xxx : Ops.extent((QDataSet)xx, (QDataSet)xxx);
                yy = yy == null ? yyy : Ops.extent((QDataSet)yy, (QDataSet)yyy);
            }
            xx = Ops.rescaleRangeLogLin(xx, (double)-0.1, (double)1.1);
            yy = Ops.rescaleRangeLogLin(yy, (double)-0.1, (double)1.1);
            return Ops.join((QDataSet)xx, (QDataSet)yy);
        }
        QDataSet xxx = Ops.slice1((QDataSet)ds, (int)0);
        QDataSet yyy = Ops.slice1((QDataSet)ds, (int)1);
        QDataSet yext = Ops.extent((QDataSet)yyy);
        QDataSet xext = Ops.extent((QDataSet)xxx);
        yext = Ops.rescaleRangeLogLin((QDataSet)yext, (double)-0.1, (double)1.1);
        xext = Ops.rescaleRangeLogLin((QDataSet)xext, (double)-0.1, (double)1.1);
        return Ops.join((QDataSet)xext, (QDataSet)yext);
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put(PROP_FILL_COLOR, BoundsRenderer.encodeColorControl(this.fillColor));
        controls.put(PROP_COLOR, BoundsRenderer.encodeColorControl(this.color));
        if (!this.fillTexture.isEmpty()) {
            controls.put(PROP_FILLTEXTURE, this.fillTexture);
        }
        if (this.polar) {
            controls.put(PROP_POLAR, BoundsRenderer.encodeBooleanControl(this.polar));
        }
        return Renderer.formatControl(controls);
    }

    @Override
    public void setControl(String s) {
        String oldControl = this.getControl();
        super.setControl(s);
        this.color = this.getColorControl(PROP_COLOR, this.color);
        this.fillColor = this.getColorControl(PROP_FILL_COLOR, this.fillColor);
        this.fillTexture = this.getControl(PROP_FILLTEXTURE, this.fillTexture);
        this.polar = this.getBooleanControl(PROP_POLAR, false);
        if (!oldControl.equals(s)) {
            this.updateCacheImage();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color old = this.color;
        this.color = color;
        if (!color.equals(old)) {
            this.updateCacheImage();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR, old, color);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        Color old = this.fillColor;
        this.fillColor = color;
        if (!color.equals(old)) {
            this.updateCacheImage();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR, old, color);
    }

    public String getFillTexture() {
        return this.fillTexture;
    }

    public void setFillTexture(String fillTexture) {
        String old = this.fillTexture;
        this.fillTexture = fillTexture;
        if (!old.equals(fillTexture)) {
            this.updateCacheImage();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_FILLTEXTURE, old, fillTexture);
    }

    public boolean isPolar() {
        return this.polar;
    }

    public void setPolar(boolean polar) {
        boolean old = this.polar;
        this.polar = polar;
        if (old != polar) {
            this.updateCacheImage();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_POLAR, old, polar);
    }

    @Override
    public void render(Graphics2D g1, DasAxis xAxis, DasAxis yAxis) {
        Graphics2D g = g1;
        QDataSet d = this.getDataSet();
        if (d == null) {
            if (this.getLastException() != null) {
                this.renderException(g, xAxis, yAxis, this.lastException);
            } else {
                this.getParent().postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
            }
            return;
        }
        if (d.length() == 0) {
            return;
        }
        if (d.rank() != 1 && d.rank() != 2 && d.rank() != 3) {
            this.expectDs();
            return;
        }
        if (Schemes.isBoundingBox((QDataSet)d) || Schemes.isBoundingBox((QDataSet)d.slice(0))) {
            if (d.rank() == 2) {
                d = Ops.join(null, (QDataSet)d);
            }
            GeneralPath pbox = new GeneralPath();
            for (int i = 0; i < d.length(); ++i) {
                double x0;
                QDataSet d1 = d.slice(i);
                Path2D.Double p = new Path2D.Double();
                if (this.polar) {
                    x0 = xAxis.transform(0.0, xAxis.getUnits());
                    double y0 = yAxis.transform(0.0, yAxis.getUnits());
                    QDataSet radDs = d1.slice(1);
                    double v1 = radDs.slice(0).value();
                    double v2 = radDs.slice(1).value();
                    QDataSet angds = d1.slice(0);
                    double a0 = Ops.datum((Object)angds.slice(0)).value();
                    double a1 = Ops.datum((Object)angds.slice(1)).value();
                    double r0x = xAxis.transform(v1, xAxis.getUnits()) - x0;
                    double r0y = y0 - yAxis.transform(v1, yAxis.getUnits());
                    double r1x = xAxis.transform(v2, xAxis.getUnits()) - x0;
                    double r1y = y0 - yAxis.transform(v2, yAxis.getUnits());
                    p.moveTo(x0 + Math.cos(a0) * r0x, y0 - Math.sin(a0) * r0y);
                    p.lineTo(x0 + Math.cos(a0) * r1x, y0 - Math.sin(a0) * r1y);
                    Arc2D.Double arc0 = new Arc2D.Double(x0 - r1x, y0 - r1y, r1x * 2.0, r1y * 2.0, Math.toDegrees(a0), Math.toDegrees(a1 - a0), 0);
                    p.append(arc0.getPathIterator(null), true);
                    p.lineTo(x0 + Math.cos(a1) * r0x, y0 - Math.sin(a1) * r0y);
                    Arc2D.Double arc1 = new Arc2D.Double(x0 - r0x, y0 - r0y, r0x * 2.0, r0y * 2.0, Math.toDegrees(a1), Math.toDegrees(a0 - a1), 0);
                    p.append(arc1.getPathIterator(null), true);
                    p.lineTo(x0 + Math.cos(a0) * r0x, y0 - Math.sin(a0) * r0y);
                } else {
                    x0 = xAxis.transform(d1.slice(0).slice(0));
                    double x1 = xAxis.transform(d1.slice(0).slice(1));
                    double y0 = yAxis.transform(d1.slice(1).slice(0));
                    double y1 = yAxis.transform(d1.slice(1).slice(1));
                    p.moveTo(x0, y1);
                    p.lineTo(x1, y1);
                    p.lineTo(x1, y0);
                    p.lineTo(x0, y0);
                    p.lineTo(x0, y1);
                }
                pbox.append(p, false);
            }
            GraphUtil.fillWithTexture(g, pbox, this.fillColor, this.fillTexture);
            g.setColor(this.getColor());
            g.draw(pbox);
            this.context = pbox;
        } else if (d.rank() == 1) {
            QDataSet xx = SemanticOps.xtagsDataSet((QDataSet)d);
            QDataSet yy = d;
            GeneralPath path = GraphUtil.getPath(xAxis, yAxis, Ops.link((QDataSet)xx, (QDataSet)yy), false, false);
            path.closePath();
            GraphUtil.fillWithTexture(g, path, this.fillColor, this.fillTexture);
            g.setColor(this.getColor());
            g.draw(path);
            this.context = path;
        } else if (Schemes.isTrajectory((QDataSet)this.ds)) {
            QDataSet xx = Ops.slice1((QDataSet)this.ds, (int)0);
            QDataSet yy = Ops.slice1((QDataSet)this.ds, (int)1);
            GeneralPath path = GraphUtil.getPath(xAxis, yAxis, xx, yy, false, false);
            path.closePath();
            GraphUtil.fillWithTexture(g, path, this.fillColor, this.fillTexture);
            g.setColor(this.getColor());
            g.draw(path);
            this.context = path;
        } else {
            QDataSet mins = Ops.slice1((QDataSet)d, (int)0);
            QDataSet maxs = Ops.slice1((QDataSet)d, (int)1);
            if (mins.property("UNITS") == null && UnitsUtil.isRatioMeasurement((Units)yAxis.getUnits())) {
                mins = Ops.putProperty((QDataSet)mins, (String)"UNITS", (Object)yAxis.getUnits());
            }
            if (maxs.property("UNITS") == null && UnitsUtil.isRatioMeasurement((Units)yAxis.getUnits())) {
                maxs = Ops.putProperty((QDataSet)maxs, (String)"UNITS", (Object)yAxis.getUnits());
            }
            QDataSet s1 = mins.trim(0, 1);
            GeneralPath path = GraphUtil.getPath(xAxis, yAxis, Ops.append((QDataSet)mins, (QDataSet)Ops.append((QDataSet)Ops.reverse((QDataSet)maxs), (QDataSet)s1)), false, false);
            path.closePath();
            GraphUtil.fillWithTexture(g, path, this.fillColor, this.fillTexture);
            g.setColor(this.getColor());
            g.draw(path);
            this.context = path;
        }
    }
}

