/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.util.Map;
import org.das2.dataset.DataSetDescriptor;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.graph.DasColorBar;
import org.das2.graph.SpectrogramRenderer;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class CollapseSpectrogramRenderer
extends SpectrogramRenderer {
    private QDataSet collapseDataSet;
    private int minIndex;
    private int maxIndex;
    private int collapseDimension = 2;
    private int prevMinIndex;
    private int prevMaxIndex;
    private DatumRange dataRange;
    private DataRangeSelectionListener dataRangeSelectionListener = new DataRangeSelectionListener(){

        @Override
        public void dataRangeSelected(DataRangeSelectionEvent e) {
            CollapseSpectrogramRenderer.this.setDataRange(e.getDatumRange());
        }
    };

    public CollapseSpectrogramRenderer(DataSetDescriptor dsd, DasColorBar colorBar) {
        super(dsd, colorBar);
    }

    public DatumRange getDataRange() {
        return this.dataRange;
    }

    public void setDataRange(DatumRange dataRange) {
        this.dataRange = dataRange;
        this.prevMinIndex = this.minIndex;
        this.prevMaxIndex = this.maxIndex;
        QDataSet minIndexDs = Ops.findex((Object)this.getDataSet().property("DEPEND_" + this.collapseDimension), (Object)dataRange.min());
        this.minIndex = (int)Math.round(minIndexDs.value());
        QDataSet maxIndexDs = Ops.findex((Object)this.getDataSet().property("DEPEND_" + this.collapseDimension), (Object)dataRange.max());
        this.maxIndex = (int)Math.round(maxIndexDs.value());
        this.averageCollapseDataSet();
    }

    public int getCollapseDimension() {
        return this.collapseDimension;
    }

    public void setCollapseDimension(int collapseDimension) {
        if (collapseDimension < 0 || collapseDimension > 2) {
            throw new IllegalArgumentException("collapse dimension must be 0, 1, or 2");
        }
        this.collapseDimension = collapseDimension;
    }

    public DataRangeSelectionListener sliceRangeListener() {
        return this.dataRangeSelectionListener;
    }

    private void dataBounds(QDataSet qds) {
        double min = Double.MAX_VALUE;
        double max = -4.9E-324;
        if (qds.rank() == 1) {
            for (int i = 0; i < qds.length(); ++i) {
                if (qds.value(i) < min) {
                    min = qds.value(i);
                }
                if (!(qds.value(i) > max)) continue;
                max = qds.value(i);
            }
        } else if (qds.rank() == 2) {
            for (int i = 0; i < qds.length(); ++i) {
                for (int j = 0; j < qds.length(0); ++j) {
                    if (qds.value(i, j) < min) {
                        min = qds.value(i, j);
                    }
                    if (!(qds.value(i, j) > max)) continue;
                    max = qds.value(i, j);
                }
            }
        } else {
            throw new IllegalArgumentException("Ds rank should be 1 or 2.");
        }
        Units units = (Units)qds.property("UNITS");
    }

    private static double value(QDataSet ds, int dim, int i, int j, int k) {
        switch (dim) {
            case 0: {
                return ds.value(k, i, j);
            }
            case 1: {
                return ds.value(i, k, j);
            }
            case 2: {
                return ds.value(i, j, k);
            }
        }
        throw new IllegalStateException("Collapse dimension must be 0, 1, or 2.");
    }

    private void averageCollapseDataSet() {
        int i;
        DDataSet ds;
        QDataSet uncollapsedDs = this.getDataSet();
        switch (this.collapseDimension) {
            case 0: {
                ds = DDataSet.createRank2((int)uncollapsedDs.length(0), (int)uncollapsedDs.length(0, 0));
                break;
            }
            case 1: {
                ds = DDataSet.createRank2((int)uncollapsedDs.length(), (int)uncollapsedDs.length(0, 0));
                break;
            }
            case 2: {
                ds = DDataSet.createRank2((int)uncollapsedDs.length(), (int)uncollapsedDs.length(0));
                break;
            }
            default: {
                throw new IllegalStateException("collapse dimension must be 0, 1, or 2.");
            }
        }
        if (this.collapseDataSet == null || (this.maxIndex - this.prevMinIndex) * (this.prevMaxIndex - this.minIndex) <= 0) {
            for (i = 0; i < ds.length(); ++i) {
                for (int j = 0; j < ds.length(0); ++j) {
                    double sum = 0.0;
                    for (int k = this.minIndex; k <= this.maxIndex; ++k) {
                        sum += CollapseSpectrogramRenderer.value(uncollapsedDs, this.collapseDimension, i, j, k);
                    }
                    ds.putValue(i, j, sum / (double)(this.maxIndex - this.minIndex + 1));
                }
            }
        } else if (this.minIndex == this.maxIndex) {
            for (i = 0; i < ds.length(); ++i) {
                for (int j = 0; j < ds.length(0); ++j) {
                    double value = CollapseSpectrogramRenderer.value(uncollapsedDs, this.collapseDimension, i, j, this.minIndex);
                    ds.putValue(i, j, value);
                }
            }
        } else {
            for (i = 0; i < ds.length(); ++i) {
                for (int j = 0; j < ds.length(0); ++j) {
                    double newValue;
                    int n;
                    int k;
                    ds.putValue(i, j, this.collapseDataSet.value(i, j));
                    if (this.prevMinIndex > this.minIndex) {
                        for (k = this.prevMinIndex; k > this.minIndex; --k) {
                            n = this.prevMaxIndex - k + 1;
                            newValue = (CollapseSpectrogramRenderer.value(uncollapsedDs, this.collapseDimension, i, j, k - 1) + (double)n * ds.value(i, j)) / (double)(n + 1);
                            ds.putValue(i, j, newValue);
                        }
                    } else if (this.prevMinIndex < this.minIndex) {
                        for (k = this.prevMinIndex; k < this.minIndex; ++k) {
                            n = this.prevMaxIndex - k + 1;
                            newValue = ((double)n * ds.value(i, j) - CollapseSpectrogramRenderer.value(uncollapsedDs, this.collapseDimension, i, j, k)) / (double)(n - 1);
                            ds.putValue(i, j, newValue);
                        }
                    }
                    if (this.prevMaxIndex > this.maxIndex) {
                        for (k = this.prevMaxIndex; k > this.maxIndex; --k) {
                            n = k - this.minIndex + 1;
                            newValue = ((double)n * ds.value(i, j) - CollapseSpectrogramRenderer.value(uncollapsedDs, this.collapseDimension, i, j, k)) / (double)(n - 1);
                            ds.putValue(i, j, newValue);
                        }
                        continue;
                    }
                    if (this.prevMaxIndex >= this.maxIndex) continue;
                    for (k = this.prevMaxIndex; k < this.maxIndex; ++k) {
                        n = k - this.minIndex + 1;
                        newValue = ((double)n * ds.value(i, j) + CollapseSpectrogramRenderer.value(uncollapsedDs, this.collapseDimension, i, j, k + 1)) / (double)(n + 1);
                        ds.putValue(i, j, newValue);
                    }
                }
            }
        }
        Map props = DataSetUtil.getProperties((QDataSet)uncollapsedDs);
        props = DataSetOps.sliceProperties((Map)props, (int)this.collapseDimension);
        DataSetUtil.putProperties((Map)props, (MutablePropertyDataSet)ds);
        this.collapseDataSet = ds;
        this.clearPlotImage();
        this.update();
    }

    @Override
    public void setDataSet(QDataSet qds) {
        super.setDataSet(qds);
        this.prevMinIndex = -1;
        this.prevMaxIndex = -1;
        if (this.collapseDimension == 0) {
            QDataSet depDs = (QDataSet)this.ds.property("DEPEND_0");
            this.setDataRange(new DatumRange(depDs.value(0), depDs.value(depDs.length() - 1), (Units)depDs.property("UNITS")));
        } else if (this.collapseDimension == 1) {
            QDataSet depDs = (QDataSet)this.ds.property("DEPEND_1");
            this.setDataRange(new DatumRange(depDs.value(0), depDs.value(depDs.length() - 1), (Units)depDs.property("UNITS")));
        } else if (this.collapseDimension == 2) {
            QDataSet depDs = (QDataSet)this.ds.property("DEPEND_2");
            this.setDataRange(new DatumRange(depDs.value(0), depDs.value(depDs.length() - 1), (Units)depDs.property("UNITS")));
        } else {
            throw new IllegalArgumentException("Only supports up to dimension 2");
        }
    }

    @Override
    protected QDataSet getInternalDataSet() {
        return this.collapseDataSet;
    }
}

