/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.das2.CancelledOperationException;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasProperties;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.LoggerManager;
import org.das2.datum.OrbitDatumRange;
import org.das2.datum.Orbits;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.BoxZoomMouseModule;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.DisplayDataMouseModule;
import org.das2.event.HorizontalRangeSelectorMouseModule;
import org.das2.event.LengthDragRenderer;
import org.das2.event.LengthMouseModule;
import org.das2.event.MouseModule;
import org.das2.event.VerticalRangeSelectorMouseModule;
import org.das2.event.ZoomPanMouseModule;
import org.das2.graph.Customizer;
import org.das2.graph.CustomizerKey;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasRendererUpdateEvent;
import org.das2.graph.DigitalRenderer;
import org.das2.graph.GraphUtil;
import org.das2.graph.LegendPosition;
import org.das2.graph.Painter;
import org.das2.graph.Renderer;
import org.das2.graph.TickVDescriptor;
import org.das2.graph.dnd.TransferableRenderer;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.util.ColorUtil;
import org.das2.util.DnDSupport;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class DasPlot
extends DasCanvasComponent {
    private static final List<CustomizerKey> CUSTOMIZER_KEYS = new ArrayList<CustomizerKey>();
    private static final Map<CustomizerKey, Customizer> PLOT_CUSTOMIZERS = new HashMap<CustomizerKey, Customizer>();
    private static final boolean DEBUG_GRAPHICS = System.getProperty("das2.graph.dasplot.debuggraphics", "false").equals("true");
    private int legendWidthLimitPx = 100;
    public static final String PROP_LEGEND_WIDTH_LIMIT_PX = "legendWidthLimitPx";
    public static final String PROP_TITLE = "title";
    private DasAxis xAxis;
    private DasAxis yAxis;
    DasAxis.Memento xmemento;
    DasAxis.Memento ymemento;
    private boolean reduceOutsideLegendTopMargin = false;
    private String plotTitle = "";
    protected boolean displayTitle = true;
    protected RebinListener rebinListener = new RebinListener();
    protected transient PropertyChangeListener ticksListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (DasPlot.this.drawGrid || DasPlot.this.drawMinorGrid) {
                DasPlot.this.invalidateCacheImage();
            }
        }
    };
    DnDSupport dndSupport;
    static final Logger logger = LoggerManager.getLogger((String)"das2.graphics.plot");
    private JMenuItem editRendererMenuItem;
    boolean cacheImageValid = false;
    BufferedImage cacheImage;
    Rectangle cacheImageBounds;
    boolean preview = false;
    private final AtomicInteger paintComponentCount = new AtomicInteger(0);
    private int titleHeight = 0;
    private boolean drawInactiveInLegend = false;
    private static String testSentinal = null;
    private boolean reluctantLegendIcons = "true".equals(System.getProperty("reluctantLegendIcons", "false"));
    protected Renderer focusRenderer = null;
    public static final String PROP_FOCUSRENDERER = "focusRenderer";
    private float multiLineTextAlignment = 0.0f;
    public static final String PROP_MULTILINETEXTALIGNMENT = "multiLineTextAlignment";
    private static final Icon NULL_ICON = new ImageIcon(new BufferedImage(1, 1, 2));
    private ActionListener repaintActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DasPlot.this.repaint();
        }
    };
    public Action DUMP_TO_FILE_ACTION = new AbstractAction("Dump Data Set to File"){

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Renderer> renderers1 = Arrays.asList(DasPlot.this.getRenderers());
            if (renderers1.isEmpty()) {
                return;
            }
            Renderer renderer = renderers1.get(0);
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileNameExtensionFilter("das2streams", "d2s"));
            int result = chooser.showSaveDialog(DasPlot.this);
            if (result == 0) {
                File selected = chooser.getSelectedFile();
                if (!selected.getName().endsWith(".d2s")) {
                    selected = new File(selected.getPath() + ".d2s");
                }
                try {
                    FileChannel out = new FileOutputStream(selected).getChannel();
                    DataSet ds = DataSetAdapter.createLegacyDataSet((QDataSet)DataSetUtil.canonizeFill((QDataSet)renderer.getDataSet()));
                    if (ds instanceof TableDataSet) {
                        TableUtil.dumpToAsciiStream((TableDataSet)ds, out);
                    } else if (ds instanceof VectorDataSet) {
                        VectorUtil.dumpToAsciiStream((VectorDataSet)ds, out);
                    }
                }
                catch (IOException ioe) {
                    DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)ioe);
                }
            }
        }
    };
    public static final int INFO = Level.INFO.intValue();
    public static final int WARNING = Level.WARNING.intValue();
    public static final int SEVERE = Level.SEVERE.intValue();
    List<MessageDescriptor> messages;
    List<LegendElement> legendElements;
    public static final String PROP_DISPLAYTITLE = "displayTitle";
    protected Painter bottomDecorator = null;
    public static final String PROP_BOTTOMDECORATOR = "bottomDecorator";
    protected Painter topDecorator = null;
    public static final String PROP_TOPDECORATOR = "topDecorator";
    public static final String PROP_CONTEXT = "context";
    private DatumRange context = null;
    public static final String PROP_DISPLAY_CONTEXT = "displayContext";
    DatumRange displayContext = null;
    private List<Renderer> renderers = null;
    public static final String PROP_RENDERERS = "renderers";
    private LegendPosition legendPosition = LegendPosition.NE;
    public static final String PROP_LEGENDPOSITION = "legendPosition";
    public static final String PROP_LEGENDRELATIVESIZESIZE = "legendRelativeFontSize";
    private int legendRelativeFontSize = 0;
    private String legendFontSize = "1em";
    public static final String PROP_LEGENDFONTSIZE = "legendFontSize";
    private String fontSize = "1em";
    public static final String PROP_FONTSIZE = "fontSize";
    private boolean displayLegend = true;
    public static final String PROP_DISPLAYLEGEND = "displayLegend";
    private Color drawBackground = new Color(0, 0, 0, 0);
    public static final String PROP_DRAWBACKGROUND = "drawBackground";
    private Color drawGridColor = new Color(0, 0, 0, 0);
    public static final String PROP_DRAWGRIDCOLOR = "drawGridColor";
    private boolean drawGrid = false;
    public static final String PROP_DRAWGRID = "drawGrid";
    private boolean drawMinorGrid;
    public static final String PROP_DRAWMINORGRID = "drawMinorGrid";
    private boolean drawGridOver = true;
    public static final String PROP_DRAWGRIDOVER = "drawGridOver";
    private String lineThickness = "1px";
    public static final String PROP_LINETHICKNESS = "lineThickness";
    private boolean plotVisible = true;
    public static final String PROP_PLOTVISIBLE = "plotVisible";
    private boolean overSize = false;
    public static final String PROP_OVERSIZE = "overSize";
    private boolean longTitles = false;
    public static final String PROP_LONGTITLES = "longTitles";
    public static final String PROP_LOG_LEVEL = "logLevel";
    private Level logLevel = Level.INFO;
    private Level printingLogLevel = Level.ALL;
    public static final String PROP_PRINTINGLOGLEVEL = "printingLogLevel";
    private int logTimeoutSec = Integer.MAX_VALUE;
    public static final String PROP_LOG_TIMEOUT_SEC = "logTimeoutSec";
    public static final String PROP_ISOTROPIC = "isotropic";
    private boolean isotropic = false;
    public String PROP_DRAWDEBUGMESSAGES = "debugMessages";
    private boolean drawDebugMessages = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CustomizerKey> getCustomizerKeys() {
        List<CustomizerKey> list = CUSTOMIZER_KEYS;
        synchronized (list) {
            return new ArrayList<CustomizerKey>(CUSTOMIZER_KEYS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCustomizer(CustomizerKey key, Customizer customizer) {
        List<CustomizerKey> list = CUSTOMIZER_KEYS;
        synchronized (list) {
            if (PLOT_CUSTOMIZERS.containsKey(key)) {
                PLOT_CUSTOMIZERS.put(key, customizer);
            } else {
                PLOT_CUSTOMIZERS.put(key, customizer);
                CUSTOMIZER_KEYS.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Customizer getCustomizer(CustomizerKey key) {
        List<CustomizerKey> list = CUSTOMIZER_KEYS;
        synchronized (list) {
            return PLOT_CUSTOMIZERS.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCustomizer(CustomizerKey key) {
        List<CustomizerKey> list = CUSTOMIZER_KEYS;
        synchronized (list) {
            CUSTOMIZER_KEYS.remove(key);
            PLOT_CUSTOMIZERS.remove(key);
        }
    }

    public int getLegendWidthLimitPx() {
        return this.legendWidthLimitPx;
    }

    public void setLegendWidthLimitPx(int legendWidthLimitPx) {
        int oldLegendWidthLimitPx = this.legendWidthLimitPx;
        this.legendWidthLimitPx = legendWidthLimitPx;
        this.firePropertyChange(PROP_LEGEND_WIDTH_LIMIT_PX, oldLegendWidthLimitPx, legendWidthLimitPx);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DasPlot(DasAxis xAxis, DasAxis yAxis) {
        this.addMouseListener(new MouseInputAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mousePressed(MouseEvent e) {
                int ir;
                Renderer r = null;
                DasPlot dasPlot = DasPlot.this;
                synchronized (dasPlot) {
                    ir = DasPlot.this.findRendererAt(DasPlot.this.getX() + e.getX(), DasPlot.this.getY() + e.getY());
                    if (ir > -1) {
                        r = (Renderer)DasPlot.this.renderers.get(ir);
                    }
                    if (r == null) {
                        for (int i = DasPlot.this.renderers.size() - 1; i >= 0; --i) {
                            if (((Renderer)DasPlot.this.renderers.get(i)).isActive()) continue;
                            r = (Renderer)DasPlot.this.renderers.get(i);
                            break;
                        }
                    }
                    DasPlot.this.setFocusRenderer(r);
                }
                if (DasPlot.this.editRendererMenuItem != null) {
                    DasPlot.this.editRendererMenuItem.setText("Renderer Properties");
                    if (ir > -1 && r != null) {
                        DasPlot.this.editRendererMenuItem.setEnabled(true);
                        DasPlot.this.editRendererMenuItem.setIcon(r.getListIcon());
                    } else {
                        DasPlot.this.editRendererMenuItem.setEnabled(false);
                        DasPlot.this.editRendererMenuItem.setIcon(null);
                    }
                }
            }
        });
        this.setOpaque(false);
        this.renderers = new ArrayList<Renderer>();
        this.xAxis = xAxis;
        if (xAxis != null) {
            if (!xAxis.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            xAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            xAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            xAxis.addPropertyChangeListener("datumRange", this.rebinListener);
            xAxis.addPropertyChangeListener("log", this.rebinListener);
            xAxis.addPropertyChangeListener("flipped", this.rebinListener);
            xAxis.addPropertyChangeListener("ticks", this.ticksListener);
        }
        this.yAxis = yAxis;
        if (yAxis != null) {
            if (yAxis.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            yAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            yAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            yAxis.addPropertyChangeListener("datumRange", this.rebinListener);
            yAxis.addPropertyChangeListener("log", this.rebinListener);
            yAxis.addPropertyChangeListener("flipped", this.rebinListener);
            yAxis.addPropertyChangeListener("ticks", this.ticksListener);
        }
        if (!"true".equals(DasApplication.getProperty("java.awt.headless", "false"))) {
            this.addDefaultMouseModules();
        }
        List<CustomizerKey> list = CUSTOMIZER_KEYS;
        synchronized (list) {
            for (CustomizerKey k : CUSTOMIZER_KEYS) {
                PLOT_CUSTOMIZERS.get(k).customize(this);
            }
        }
    }

    public Renderer getFocusRenderer() {
        return this.focusRenderer;
    }

    public void setFocusRenderer(Renderer focusRenderer) {
        Renderer oldFocusRenderer = this.focusRenderer;
        this.focusRenderer = focusRenderer;
        this.firePropertyChange(PROP_FOCUSRENDERER, null, focusRenderer);
    }

    public float getMultiLineTextAlignment() {
        return this.multiLineTextAlignment;
    }

    public void setMultiLineTextAlignment(float multiLineTextAlignment) {
        float oldMultiLineTextAlignment = this.multiLineTextAlignment;
        this.multiLineTextAlignment = multiLineTextAlignment;
        this.firePropertyChange(PROP_MULTILINETEXTALIGNMENT, oldMultiLineTextAlignment, multiLineTextAlignment);
        this.repaint();
    }

    private Rectangle getLegendBounds(Graphics2D graphics, int msgx, int msgy, List<LegendElement> llegendElements) {
        Rectangle mrect;
        int maxIconWidth = 0;
        Rectangle boundRect = null;
        int em = (int)this.getEmSize();
        if (llegendElements == null) {
            return null;
        }
        if (graphics == null) {
            return null;
        }
        DatumRange lcontext = this.context;
        String contextStr = lcontext == null ? "" : lcontext.toString();
        for (LegendElement le : llegendElements) {
            Icon icon;
            Renderer r = le.renderer;
            if ((r == null || !r.isActive()) && le.icon == null && !this.drawInactiveInLegend) continue;
            Icon icon2 = le.icon != null ? le.icon : (icon = r == null ? null : r.getListIcon());
            if (icon == null) {
                icon = NULL_ICON;
            }
            GrannyTextRenderer gtr = GraphUtil.newGrannyTextRenderer();
            String theLabel = String.valueOf(le.label).trim().replaceAll("%\\{CONTEXT\\}", contextStr);
            QDataSet ds = r.getDataSet();
            if (ds != null) {
                String unitsString = SemanticOps.getUnits((QDataSet)r.getDataSet()).toString();
                theLabel = theLabel.replaceAll("%\\{UNITS\\}", unitsString);
            }
            gtr.setString((Graphics)graphics, theLabel);
            mrect = gtr.getBounds();
            maxIconWidth = Math.max(maxIconWidth, icon.getIconWidth());
            if (this.reluctantLegendIcons && llegendElements.size() == 1) {
                maxIconWidth = 0;
            }
            int theheight = Math.max(mrect.height, icon.getIconHeight());
            mrect.translate(msgx, msgy + (int)gtr.getAscent());
            mrect.height = theheight;
            if (boundRect == null) {
                boundRect = mrect;
            } else {
                boundRect.add(mrect);
            }
            msgy += theheight;
        }
        if (boundRect == null) {
            return null;
        }
        int iconColumnWidth = maxIconWidth + em / 4;
        mrect = new Rectangle(boundRect);
        mrect.width += iconColumnWidth;
        if (null == this.legendPosition) {
            throw new IllegalArgumentException("not supported: " + this.legendPosition);
        }
        switch (this.legendPosition) {
            case NE: 
            case NW: {
                mrect.y = this.yAxis.getRow().getDMinimum() + em / 2;
                if (this.legendPosition == LegendPosition.NE) {
                    mrect.x = this.xAxis.getColumn().getDMaximum() - em - mrect.width;
                    break;
                }
                if (this.legendPosition != LegendPosition.NW) break;
                mrect.x = this.xAxis.getColumn().getDMinimum() + em;
                break;
            }
            case SE: 
            case SW: {
                mrect.y = this.yAxis.getRow().getDMaximum() - boundRect.height - em;
                if (this.legendPosition == LegendPosition.SE) {
                    mrect.x = this.xAxis.getColumn().getDMaximum() - em - mrect.width;
                    break;
                }
                if (this.legendPosition != LegendPosition.SW) break;
                mrect.x = this.xAxis.getColumn().getDMinimum() + em;
                break;
            }
            case OutsideNE: {
                boundRect.x = mrect.x = this.xAxis.getColumn().getDMaximum() + em + maxIconWidth;
                mrect.y = this.yAxis.getRow().getDMinimum();
                break;
            }
            case OutsideSE: {
                boundRect.x = mrect.x = this.xAxis.getColumn().getDMaximum() + em + maxIconWidth;
                mrect.y = this.yAxis.getRow().getDMaximum() - boundRect.height;
                break;
            }
            default: {
                throw new IllegalArgumentException("not supported: " + this.legendPosition);
            }
        }
        Rectangle axisBounds = DasDevicePosition.toRectangle(this.getRow(), this.getColumn());
        axisBounds.width = Math.max(axisBounds.width, mrect.x + mrect.width - axisBounds.x);
        Rectangle2D rr = mrect.createIntersection(axisBounds);
        return new Rectangle((int)rr.getX(), (int)rr.getY(), (int)rr.getWidth(), (int)rr.getHeight());
    }

    private void drawLegend(Graphics2D g, List<LegendElement> llegendElements) {
        Graphics2D graphics = (Graphics2D)g.create();
        double legendFontSizeImpl = GraphUtil.parseLayoutLength(this.legendFontSize, 0.0, this.getFont().getSize2D());
        if (legendFontSizeImpl == (double)this.getFont().getSize2D()) {
            graphics.setFont(this.getFont().deriveFont(this.getFont().getSize2D() + (float)this.legendRelativeFontSize));
        } else {
            if (this.legendRelativeFontSize != 0) {
                logger.warning("legendRelativeFontSize ignored because legendFontSize is set");
            }
            graphics.setFont(this.getFont().deriveFont((float)legendFontSizeImpl));
        }
        Color backColor = GraphUtil.getRicePaperColor();
        int em = (int)this.getEmSize();
        int msgx = this.xAxis.getColumn().getDMiddle() + em;
        int msgy = this.yAxis.getRow().getDMinimum() + em / 2;
        int maxIconWidth = 0;
        for (LegendElement le : llegendElements) {
            Icon icon;
            Icon icon2 = icon = le.icon != null ? le.icon : le.renderer.getListIcon();
            if (icon == null) {
                icon = NULL_ICON;
            }
            maxIconWidth = Math.max(maxIconWidth, icon.getIconWidth());
            if (!this.reluctantLegendIcons || llegendElements.size() != 1) continue;
            maxIconWidth = 0;
        }
        Rectangle mrect = this.getLegendBounds(graphics, msgx, msgy, llegendElements);
        if (mrect == null) {
            return;
        }
        msgx = mrect.x;
        msgy = mrect.y;
        if (this.legendPosition != LegendPosition.OutsideNE && this.legendPosition != LegendPosition.OutsideSE) {
            msgx += maxIconWidth + em / 4;
            Rectangle legendBounds = new Rectangle(mrect.x - em / 4, mrect.y - em / 4, mrect.width + em / 2, mrect.height + em / 2);
            int canvasWidth = this.getParent().getWidth();
            Rectangle clip = legendBounds.intersection(new Rectangle(0, this.getRow().getDMinimum(), 2 * canvasWidth, this.getRow().getHeight()));
            ++clip.height;
            ++clip.width;
            graphics.clip(clip);
            graphics.setColor(backColor);
            graphics.fillRoundRect(legendBounds.x, legendBounds.y, legendBounds.width, legendBounds.height, 5, 5);
            graphics.setColor(this.getForeground());
            graphics.drawRoundRect(legendBounds.x, legendBounds.y, legendBounds.width, legendBounds.height, 5, 5);
        }
        String contextStr = this.context == null ? "" : this.context.toString();
        for (LegendElement le : llegendElements) {
            Icon icon;
            if ((le.renderer == null || !le.renderer.isActive()) && le.icon == null && !this.drawInactiveInLegend) continue;
            Icon icon3 = icon = le.icon != null ? le.icon : le.renderer.getListIcon();
            if (icon == null) {
                icon = NULL_ICON;
            }
            if (llegendElements.size() == 1 && this.reluctantLegendIcons) {
                icon = NULL_ICON;
            }
            GrannyTextRenderer gtr = GraphUtil.newGrannyTextRenderer();
            gtr.setAlignment(0.0f);
            String theLabel = String.valueOf(le.label).trim().replaceAll("%\\{CONTEXT\\}", contextStr);
            QDataSet ds = le.renderer.getDataSet();
            if (ds != null) {
                String unitsString = SemanticOps.getUnits((QDataSet)le.renderer.getDataSet()).toString();
                theLabel = theLabel.replaceAll("%\\{UNITS\\}", unitsString);
            }
            gtr.setString((Graphics)graphics, theLabel);
            mrect = gtr.getBounds();
            mrect.translate(msgx, msgy + (int)gtr.getAscent());
            int theheight = Math.max(mrect.height, icon.getIconHeight());
            int icony = theheight / 2 - icon.getIconHeight() / 2;
            int texty = theheight / 2 - (int)gtr.getHeight() / 2 + (int)gtr.getAscent();
            if (this.reduceOutsideLegendTopMargin) {
                texty = theheight / 2;
            }
            gtr.draw((Graphics)graphics, (float)msgx, (float)(msgy + texty));
            mrect.height = theheight;
            Rectangle imgBounds = new Rectangle(msgx - (icon.getIconWidth() + em / 4), msgy + icony, icon.getIconWidth(), icon.getIconHeight());
            if (le.icon != null) {
                graphics.drawImage(((ImageIcon)icon).getImage(), imgBounds.x, imgBounds.y, null);
            } else if (llegendElements.size() != 1 || !this.reluctantLegendIcons) {
                le.drawIcon(graphics, msgx - (icon.getIconWidth() + em / 4), msgy + icony);
            }
            msgy = (int)((double)msgy + mrect.getHeight());
            mrect.add(imgBounds);
            if (msgy > this.getRow().bottom()) break;
            le.bounds = mrect;
        }
        graphics.dispose();
    }

    private void drawMessages(Graphics2D g, List<MessageDescriptor> lmessages) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.clip(DasDevicePosition.toRectangle(this.getRow(), this.getColumn()));
        boolean isPrint = this.getCanvas().isPrintingThread();
        Font font0 = graphics.getFont();
        int msgem = (int)Math.max(8.0f, font0.getSize2D() / 2.0f);
        graphics.setFont(font0.deriveFont((float)msgem));
        int em = (int)this.getEmSize();
        boolean rightJustify = false;
        int msgx = this.xAxis.getColumn().getDMinimum() + em;
        int msgy = this.yAxis.getRow().getDMinimum() + em;
        if (this.legendPosition == LegendPosition.NW) {
            rightJustify = true;
            msgx = this.xAxis.getColumn().getDMaximum() - em;
        }
        Color warnColor = new Color(255, 255, 100, 200);
        Color severeColor = new Color(255, 140, 140, 200);
        List<Renderer> renderers1 = Arrays.asList(this.getRenderers());
        long tnow = System.currentTimeMillis();
        boolean needRepaintSoon = false;
        long repaintDelay = 0L;
        Iterator<MessageDescriptor> iterator = lmessages.iterator();
        while (iterator.hasNext()) {
            MessageDescriptor lmessage;
            MessageDescriptor message = lmessage = iterator.next();
            if (message.messageType < this.logLevel.intValue() || isPrint && message.messageType < this.printingLogLevel.intValue() && message.birthMilli < Long.MAX_VALUE || this.logTimeoutSec < 2147483 && message.birthMilli < tnow - (long)(this.logTimeoutSec * 1000)) continue;
            if (!isPrint && this.logTimeoutSec < 1000 && message.birthMilli < Long.MAX_VALUE) {
                needRepaintSoon = true;
                repaintDelay = Math.max(repaintDelay, (long)(this.logTimeoutSec * 1000) - (tnow - message.birthMilli));
            }
            Icon icon = null;
            if (message.renderer != null && renderers1.size() > 1) {
                icon = message.renderer.getListIcon();
            }
            GrannyTextRenderer gtr = GraphUtil.newGrannyTextRenderer();
            gtr.setAlignment(0.0f);
            gtr.setString((Graphics)graphics, String.valueOf(message.text));
            Rectangle mrect = gtr.getBounds();
            if (icon != null && mrect.height < icon.getIconHeight()) {
                mrect.height = icon.getIconHeight();
            }
            int spc = 2;
            if (icon != null) {
                mrect.width += icon.getIconWidth() + spc;
            }
            int msgx1 = msgx;
            if (rightJustify) {
                msgx1 = msgx - (int)mrect.getWidth();
            }
            mrect.translate(msgx1, msgy);
            Color backColor = GraphUtil.getRicePaperColor();
            if (message.messageType == WARNING) {
                backColor = warnColor;
            } else if (message.messageType == SEVERE) {
                backColor = severeColor;
            }
            graphics.setColor(backColor);
            graphics.fillRoundRect(mrect.x - em / 4, mrect.y, mrect.width + em / 2, mrect.height, 5, 5);
            graphics.setColor(this.getForeground());
            if (icon != null) {
                icon.paintIcon(this, graphics, mrect.x, mrect.y);
            }
            graphics.drawRoundRect(mrect.x - em / 4, mrect.y, mrect.width + em / 2, mrect.height, 5, 5);
            if (icon != null) {
                gtr.draw((Graphics)graphics, (float)(msgx1 + icon.getIconWidth() + spc), (float)msgy);
            } else {
                gtr.draw((Graphics)graphics, (float)msgx1, (float)msgy);
            }
            message.bounds = mrect;
            msgy = (int)((double)msgy + (gtr.getHeight() + (double)(msgem / 2)));
        }
        if (needRepaintSoon) {
            logger.log(Level.FINER, "need to repaint in {0} ms", repaintDelay);
            Timer timer = new Timer((int)repaintDelay, this.repaintActionListener);
            timer.setRepeats(false);
            timer.start();
        }
        graphics.dispose();
    }

    private void maybeDrawGrid(Graphics2D plotGraphics) {
        DatumVector yticks;
        DatumVector xticks;
        Color minorGridColor;
        Color gridColor;
        if (this.drawGridColor.getAlpha() > 0) {
            gridColor = this.drawGridColor;
            minorGridColor = this.drawGridColor;
        } else {
            gridColor = new Color(128, 128, 128, 70);
            minorGridColor = new Color(128, 128, 128, 40);
        }
        DasAxis lxaxis = this.getXAxis();
        DasAxis lyaxis = this.getYAxis();
        if (lxaxis == null || lyaxis == null) {
            return;
        }
        TickVDescriptor xtickv = lxaxis.getTickV();
        TickVDescriptor ytickv = lyaxis.getTickV();
        if (this.drawMinorGrid && this.plotVisible) {
            xticks = null;
            yticks = null;
            if (xtickv != null && lxaxis.getOrientation() == 2) {
                xticks = xtickv.getMinorTicks();
            }
            if (ytickv != null && lyaxis.getOrientation() == 3) {
                yticks = ytickv.getMinorTicks();
            }
            plotGraphics.setColor(minorGridColor);
            this.drawGrid(plotGraphics, xticks, yticks);
        }
        if (this.drawGrid && this.plotVisible) {
            xticks = null;
            yticks = null;
            if (xtickv != null && lxaxis.getOrientation() == 2) {
                xticks = xtickv.getMajorTicks();
            }
            if (ytickv != null && lyaxis.getOrientation() == 3) {
                yticks = ytickv.getMajorTicks();
            }
            plotGraphics.setColor(gridColor);
            this.drawGrid(plotGraphics, xticks, yticks);
        }
    }

    private void drawDecorator(Graphics2D plotGraphics, Painter p) {
        try {
            Graphics2D g = (Graphics2D)plotGraphics.create();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            p.paint(g);
            g.dispose();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void drawCacheImage(Graphics2D plotGraphics, DasAxis lxaxis, DasAxis lyaxis) {
        this.messages = new ArrayList<MessageDescriptor>();
        this.legendElements = new ArrayList<LegendElement>();
        if (!this.drawGridOver) {
            this.maybeDrawGrid((Graphics2D)plotGraphics.create());
        }
        if (this.bottomDecorator != null) {
            this.drawDecorator(plotGraphics, this.bottomDecorator);
        }
        this.drawContent(plotGraphics);
        List<Renderer> renderers1 = Arrays.asList(this.getRenderers());
        boolean noneActive = true;
        for (int i = 0; i < renderers1.size(); ++i) {
            Renderer rend = renderers1.get(i);
            if (rend.isActive()) {
                logger.log(Level.FINEST, "rendering #{0}: {1}", new Object[]{i, rend});
                try {
                    rend.incrementRenderCount();
                    Painter p = rend.bottomDecorator;
                    if (p != null) {
                        this.drawDecorator(plotGraphics, p);
                    }
                    rend.render((Graphics2D)plotGraphics.create(), lxaxis, lyaxis);
                    p = rend.topDecorator;
                    if (p != null) {
                        this.drawDecorator(plotGraphics, p);
                    }
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                    this.postException(rend, ex);
                }
                noneActive = false;
                if (!rend.isDrawLegendLabel()) continue;
                this.addToLegend(rend, null, 0, rend.getLegendLabel());
                continue;
            }
            if (!rend.isDrawLegendLabel()) continue;
            this.addToLegend(rend, null, 0, rend.getLegendLabel() + " (inactive)");
        }
        if (this.drawGridOver) {
            this.maybeDrawGrid((Graphics2D)plotGraphics.create());
        }
        if (this.topDecorator != null) {
            this.drawDecorator(plotGraphics, this.topDecorator);
        }
        if (this.isPlotVisible()) {
            if (renderers1.isEmpty()) {
                this.postMessage(null, "(no renderers)", INFO, null, null);
                logger.fine("dasPlot has no renderers");
            } else if (noneActive) {
                this.postMessage(null, "(no active renderers)", INFO, null, null);
            }
        }
    }

    public int findRendererAt(int x, int y) {
        int result;
        int i;
        List<Renderer> renderers1 = Arrays.asList(this.getRenderers());
        for (i = 0; this.messages != null && i < this.messages.size(); ++i) {
            MessageDescriptor message = this.messages.get(i);
            if (message.bounds == null || !message.bounds.contains(x, y) || message.renderer == null || (result = renderers1.indexOf(message.renderer)) == -1) continue;
            return result;
        }
        for (i = 0; this.legendElements != null && i < this.legendElements.size(); ++i) {
            LegendElement legendElement = this.legendElements.get(i);
            if (legendElement.bounds == null || !legendElement.bounds.contains(x, y) || legendElement.renderer == null || (result = renderers1.indexOf(legendElement.renderer)) == -1) continue;
            return result;
        }
        for (i = renderers1.size() - 1; i >= 0; --i) {
            Renderer rend = renderers1.get(i);
            if (!rend.isActive() || !rend.acceptContext(x, y)) continue;
            return i;
        }
        return -1;
    }

    private Action getEditAction() {
        return new AbstractAction("Renderer Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point p = DasPlot.this.getDasMouseInputAdapter().getMousePressPositionOnCanvas();
                int i = DasPlot.this.findRendererAt(p.x, p.y);
                if (i > -1) {
                    Renderer rend = DasPlot.this.getRenderer(i);
                    PropertyEditor editor = new PropertyEditor(rend);
                    editor.showDialog(DasPlot.this);
                }
            }
        };
    }

    private void addDefaultMouseModules() {
        HorizontalRangeSelectorMouseModule hrs = new HorizontalRangeSelectorMouseModule(this, this.xAxis);
        this.mouseAdapter.addMouseModule(hrs);
        hrs.addDataRangeSelectionListener(this.xAxis);
        VerticalRangeSelectorMouseModule vrs = new VerticalRangeSelectorMouseModule(this, this.yAxis);
        this.mouseAdapter.addMouseModule(vrs);
        vrs.addDataRangeSelectionListener(this.yAxis);
        MouseModule x = CrossHairMouseModule.create(this);
        this.mouseAdapter.addMouseModule(x);
        this.mouseAdapter.setSecondaryModule(new ZoomPanMouseModule((DasCanvasComponent)this, this.getXAxis(), this.getYAxis()));
        this.mouseAdapter.setPrimaryModule(x);
        this.mouseAdapter.addMouseModule(new BoxZoomMouseModule(this, null, this.getXAxis(), this.getYAxis()));
        x = new LengthMouseModule((DasCanvasComponent)this, new LengthDragRenderer(this, this.getXAxis(), this.getYAxis()), "Length");
        this.mouseAdapter.addMouseModule(x);
        x = new DisplayDataMouseModule(this);
        this.mouseAdapter.addMouseModule(x);
        this.setEnableRenderPropertiesAction(true);
        if (DasApplication.hasAllPermission()) {
            JMenuItem dumpMenuItem = new JMenuItem(this.DUMP_TO_FILE_ACTION);
            this.mouseAdapter.addMenuItem(dumpMenuItem);
        }
    }

    public void setXAxis(DasAxis xAxis) {
        DasAxis oldValue = this.xAxis;
        Container parent = this.getParent();
        if (this.xAxis != null) {
            DasProperties.getLogger().fine("setXAxis upsets the dmia");
            if (parent != null) {
                parent.remove(this.xAxis);
            }
            this.xAxis.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.xAxis.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.xAxis.removePropertyChangeListener("datumRange", this.rebinListener);
            this.xAxis.removePropertyChangeListener("log", this.rebinListener);
            this.xAxis.removePropertyChangeListener("flipped", this.rebinListener);
            this.xAxis.removePropertyChangeListener("ticks", this.ticksListener);
        }
        this.xAxis = xAxis;
        if (xAxis != null) {
            if (!xAxis.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            xAxis.setRow(this.getRow());
            xAxis.setColumn(this.getColumn());
            if (parent != null) {
                parent.add(this.xAxis);
                parent.validate();
            }
            xAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            xAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            xAxis.addPropertyChangeListener("datumRange", this.rebinListener);
            xAxis.addPropertyChangeListener("log", this.rebinListener);
            xAxis.addPropertyChangeListener("flipped", this.rebinListener);
            xAxis.addPropertyChangeListener("ticks", this.ticksListener);
        }
        if (xAxis != oldValue) {
            this.firePropertyChange("xAxis", oldValue, xAxis);
        }
        if (xAxis != null) {
            xAxis.updateTickV();
        }
    }

    public void setYAxis(DasAxis yAxis) {
        DasAxis oldValue = this.yAxis;
        logger.log(Level.FINE, "setYAxis({0}), removes {1}", new Object[]{yAxis == null ? "null" : yAxis.getName(), this.yAxis});
        Container parent = this.getParent();
        if (this.yAxis != null) {
            DasProperties.getLogger().fine("setYAxis upsets the dmia");
            if (parent != null) {
                parent.remove(this.yAxis);
            }
            this.yAxis.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.yAxis.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.yAxis.removePropertyChangeListener("datumRange", this.rebinListener);
            this.yAxis.removePropertyChangeListener("log", this.rebinListener);
            this.yAxis.removePropertyChangeListener("flipped", this.rebinListener);
            this.yAxis.removePropertyChangeListener("ticks", this.ticksListener);
        }
        this.yAxis = yAxis;
        if (yAxis != null) {
            if (yAxis.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            yAxis.setRow(this.getRow());
            yAxis.setColumn(this.getColumn());
            if (parent != null) {
                parent.add(this.yAxis);
                parent.validate();
            }
            yAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            yAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            yAxis.addPropertyChangeListener("datumRange", this.rebinListener);
            yAxis.addPropertyChangeListener("log", this.rebinListener);
            yAxis.addPropertyChangeListener("flipped", this.rebinListener);
            yAxis.addPropertyChangeListener("ticks", this.ticksListener);
        }
        if (yAxis != oldValue) {
            this.firePropertyChange("yAxis", oldValue, yAxis);
        }
        if (yAxis != null) {
            yAxis.updateTickV();
        }
    }

    @Override
    protected void updateImmediately() {
        Renderer[] renderers1;
        super.updateImmediately();
        logger.finer("DasPlot.updateImmediately");
        for (Renderer renderers11 : renderers1 = this.getRenderers()) {
            Renderer rend = renderers11;
            if (rend == null) {
                logger.info("odd branch presumed to be caused by thread mis-management.");
                continue;
            }
            rend.update();
        }
    }

    protected AffineTransform getAffineTransform(DasAxis xAxis, DasAxis yAxis) {
        if (this.xmemento == null) {
            logger.fine("unable to calculate AT, because old transform is not defined.");
            return null;
        }
        AffineTransform at = new AffineTransform();
        at = xAxis.getAffineTransform(this.xmemento, at);
        at = yAxis.getAffineTransform(this.ymemento, at);
        return at;
    }

    private static boolean isIdentity(AffineTransform at) {
        return at.isIdentity() || Math.abs(at.getScaleX() - 1.0) < 0.001 && Math.abs(at.getScaleY() - 1.0) < 0.001 && Math.abs(at.getTranslateX()) < 0.001 && Math.abs(at.getTranslateY()) < 0.001;
    }

    private void paintInvalidScreen(Graphics atGraphics, AffineTransform at) {
        Color c = GraphUtil.getRicePaperColor();
        atGraphics.setColor(c);
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        atGraphics.fillRect(x - 1, y - 1, this.getWidth(), this.getHeight());
        boolean debug = false;
        logger.finest(" using cacheImage with ricepaper to invalidate");
    }

    private synchronized void resetCacheImageBounds(boolean printing, int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width (" + width + ") and height (" + height + ") must be > 0");
        }
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        if (this.overSize && !printing) {
            Rectangle lcacheImageBounds = new Rectangle();
            lcacheImageBounds.width = 16 * width / 10;
            lcacheImageBounds.height = height;
            lcacheImageBounds.x = x - 3 * width / 10;
            lcacheImageBounds.y = y;
            this.cacheImageBounds = lcacheImageBounds;
        } else {
            Rectangle lcacheImageBounds = new Rectangle();
            lcacheImageBounds.width = width;
            lcacheImageBounds.height = height;
            if (lcacheImageBounds.width == 0 || lcacheImageBounds.height == 0) {
                logger.warning("cheesy code to fix getHeight=0 when printing");
                Thread.yield();
                lcacheImageBounds.width = width;
                lcacheImageBounds.height = height;
            }
            if (lcacheImageBounds.width == 0 || lcacheImageBounds.height == 0) {
                throw new IllegalArgumentException("width or height is 0.");
            }
            logger.log(Level.FINE, "create cacheImage {0}x{1}", new Object[]{lcacheImageBounds.width, lcacheImageBounds.height});
            BufferedImage lcacheImage = new BufferedImage(lcacheImageBounds.width, lcacheImageBounds.height, 6);
            lcacheImageBounds.x = x;
            lcacheImageBounds.y = y;
            this.cacheImageBounds = lcacheImageBounds;
            this.cacheImage = lcacheImage;
        }
    }

    @Override
    protected void printComponent(Graphics g) {
        boolean doInvalidate = this.getCanvas().isPrintingThread();
        if (doInvalidate) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w == 0 || h == 0) {
                logger.warning("width or height is zero.  Try printing again.");
                return;
            }
            this.resetCacheImageBounds(true, w, h);
            DasAxis lxaxis = (DasAxis)this.xAxis.clone();
            DasAxis lyaxis = (DasAxis)this.yAxis.clone();
            List<Renderer> renderers1 = Arrays.asList(this.getRenderers());
            for (int i = 0; i < renderers1.size(); ++i) {
                Renderer rend = renderers1.get(i);
                if (!rend.isActive()) continue;
                logger.log(Level.FINEST, "updating renderer #{0}: {1}", new Object[]{i, rend});
                try {
                    rend.updatePlotImage(lxaxis, lyaxis, (ProgressMonitor)new NullProgressMonitor());
                    continue;
                }
                catch (DasException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        super.printComponent(g);
        if (doInvalidate) {
            this.invalidateCacheImage();
        }
    }

    private Font getCanvasRenderFont(Font f0) {
        try {
            double[] dd = DasDevicePosition.parseLayoutStr(this.getFontSize());
            if (dd[1] == 1.0 && dd[2] == 0.0) {
                return f0;
            }
            Font f = f0;
            double parentSize = f.getSize2D();
            double newSize = dd[1] * parentSize + dd[2];
            f = f.deriveFont((float)newSize);
            return f;
        }
        catch (ParseException ex) {
            return f0;
        }
    }

    public Rectangle getAxisClip() {
        return DasDevicePosition.toRectangle(this.getRow(), this.getColumn());
    }

    private String implementMacros(String title) {
        if (title.contains("%{CONTEXT}")) {
            String contextStr = this.context == null ? "" : this.context.toString();
            title = title.replace("%{CONTEXT}", contextStr);
        }
        DatumRange tr = null;
        DatumRange context1 = this.getContext();
        if (this.xAxis != null && UnitsUtil.isTimeLocation((Units)this.xAxis.getRange().getUnits())) {
            tr = this.xAxis.getDatumRange();
        } else if (context1 != null && UnitsUtil.isTimeLocation((Units)context1.getUnits())) {
            tr = context1;
        }
        if (tr == null) {
            return title;
        }
        Pattern pop = Pattern.compile("(.*)\\%\\{TIMERANGE(.*?)\\}(.*)");
        String insert = tr == null ? "(no timerange)" : tr.toString();
        Matcher m = pop.matcher(title);
        if (m.matches()) {
            String control = m.group(2).trim();
            HashMap<String, String> controls = new HashMap<String, String>();
            if (control.length() > 0) {
                String[] ss;
                char delim = control.charAt(0);
                for (String s : ss = control.substring(1).split("\\" + delim)) {
                    int i = s.indexOf("=");
                    if (i == -1) {
                        controls.put(s, "");
                        continue;
                    }
                    controls.put(s.substring(0, i), s.substring(i + 1));
                }
            }
            if (!controls.isEmpty()) {
                Orbits o;
                String s;
                String context;
                if (controls.containsKey("CONTEXT") && (context = (String)controls.get("CONTEXT")) != null && (s = (o = Orbits.getOrbitsFor((String)context)).getOrbit(tr.middle())) != null) {
                    try {
                        DatumRange drtest = o.getDatumRange(s);
                        if (Math.abs(DatumRangeUtil.normalize((DatumRange)tr, (Datum)drtest.min())) < 0.05 && Math.abs(DatumRangeUtil.normalize((DatumRange)tr, (Datum)drtest.max()) - 1.0) < 0.05) {
                            tr = DatumRangeUtil.parseTimeRange((String)("orbit:" + context + ":" + s));
                        }
                    }
                    catch (ParseException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
                if (controls.containsKey("NOORBIT")) {
                    if (tr != null) {
                        insert = tr instanceof OrbitDatumRange ? DatumRangeUtil.formatTimeRange((DatumRange)tr, (boolean)false) + " (Orbit " + ((OrbitDatumRange)tr).getOrbit() + ")" : DatumRangeUtil.formatTimeRange((DatumRange)tr, (boolean)false);
                    }
                } else if (controls.containsKey("FORMAT")) {
                    String format = (String)controls.get("FORMAT");
                    if (format.equals("$o") || format.equals("%o")) {
                        insert = tr instanceof OrbitDatumRange ? ((OrbitDatumRange)tr).getOrbit() : "???";
                    } else {
                        TimeParser tp = TimeParser.create((String)format);
                        if (tr != null) {
                            insert = tp.format(tr);
                        }
                    }
                }
            }
            title = m.group(1) + insert + m.group(3);
        }
        return title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void paintComponent(Graphics graphics0) {
        ArrayList<LegendElement> llegendElements;
        ArrayList<MessageDescriptor> lmessages;
        Color c0;
        Object atGraphics;
        Shape saveClip;
        logger.log(Level.FINER, "dasPlot.paintComponent {0}", this.getDasName());
        if (this.getCanvas().isValueAdjusting()) {
            this.repaint();
            return;
        }
        String localPlotTitle = this.getTitle();
        double lineThicknessDouble = this.getLineThicknessDouble(this.lineThickness);
        if (this.isOpaque()) {
            Color co = graphics0.getColor();
            graphics0.setColor(this.getBackground());
            Rectangle clip = DasDevicePosition.toRectangle(this.getRow(), this.getColumn());
            int dy = this.getRow().top() - this.getY();
            graphics0.fillRect(0, dy, clip.width + 1, clip.height + dy);
            graphics0.setColor(co);
        }
        if (!this.getCanvas().isPrintingThread() && !EventQueue.isDispatchThread()) {
            throw new RuntimeException("not event thread: " + Thread.currentThread().getName());
        }
        this.paintComponentCount.incrementAndGet();
        if (this.getCanvas().isPrintingThread()) {
            logger.fine("* printing thread *");
            if (testSentinal != null && this.getName().equals("plot_0")) {
                System.err.println("here we are...");
            }
        }
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        int xSize = this.getColumn().getDMaximum() - x;
        int ySize = this.getRow().getDMaximum() - y;
        if (this.getCanvas().isPrintingThread()) {
            saveClip = graphics0.getClip();
            graphics0.setClip(null);
        } else {
            saveClip = null;
        }
        logger.log(Level.FINEST, "DasPlot clip={0} @ {1},{2}", new Object[]{graphics0.getClip(), this.getX(), this.getY()});
        Rectangle clip = graphics0.getClipBounds();
        if (clip != null && clip.y + this.getY() >= y + ySize) {
            logger.finer("returning because clip indicates nothing to be done.");
            return;
        }
        boolean disableImageCache = false;
        Graphics2D graphics = (Graphics2D)graphics0.create();
        if (lineThicknessDouble != 1.0) {
            if (lineThicknessDouble > 1.0) {
                graphics.setStroke(new BasicStroke((float)lineThicknessDouble, 1, 1));
            } else {
                graphics.setStroke(new BasicStroke((float)lineThicknessDouble));
            }
        }
        if (this.drawBackground.getAlpha() > 0) {
            Color c02 = graphics0.getColor();
            graphics.setColor(this.drawBackground);
            Rectangle bckg = DasDevicePosition.toRectangle(this.getRow(), this.getColumn());
            bckg.translate(-x, -this.getRow().top() + this.titleHeight);
            graphics.fillRect(bckg.x, bckg.y, bckg.width + 1, bckg.height + 1);
            graphics.setColor(c02);
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(-this.getX(), -this.getY());
        Rectangle lcacheImageBounds = this.cacheImageBounds;
        BufferedImage lcacheImage = this.cacheImage;
        boolean useCacheImage = this.cacheImageValid && !this.getCanvas().isPrintingThread() && !disableImageCache && lcacheImageBounds.width == lcacheImage.getWidth();
        Rectangle cacheImageClip = DasDevicePosition.toRectangle(this.getRow(), this.getColumn());
        logger.log(Level.FINE, "draw plot useCacheImage: {0}", useCacheImage);
        if (useCacheImage) {
            atGraphics = (Graphics2D)graphics.create();
            ((Graphics2D)atGraphics).clip(cacheImageClip);
            AffineTransform at = this.getAffineTransform(this.xAxis, this.yAxis);
            if (at == null || !this.preview && !DasPlot.isIdentity(at)) {
                ((Graphics)atGraphics).drawImage(lcacheImage, lcacheImageBounds.x, lcacheImageBounds.y, lcacheImageBounds.width, lcacheImageBounds.height, this);
                this.paintInvalidScreen((Graphics)atGraphics, at);
            } else {
                if (!at.isIdentity()) {
                    String atDesc = GraphUtil.getATScaleTranslateString(at);
                    logger.log(Level.FINEST, " using cacheImage w/AT {0}", atDesc);
                    ((Graphics2D)atGraphics).transform(at);
                } else {
                    logger.log(Level.FINEST, " using cacheImage {0} {1} {2}", new Object[]{lcacheImageBounds, this.xmemento, this.ymemento});
                }
                if (lcacheImageBounds.width != lcacheImage.getWidth()) {
                    logger.log(Level.WARNING, " cbw: {0}  ciw:{1}", new Object[]{lcacheImageBounds.width, lcacheImage.getWidth()});
                }
                ((Graphics)atGraphics).drawImage(lcacheImage, lcacheImageBounds.x, lcacheImageBounds.y, lcacheImageBounds.width, lcacheImageBounds.height, this);
            }
            ((Graphics)atGraphics).dispose();
        } else {
            atGraphics = this;
            synchronized (atGraphics) {
                int h;
                int w;
                Graphics2D plotGraphics;
                if (this.getCanvas().isPrintingThread() || disableImageCache) {
                    plotGraphics = (Graphics2D)graphics.create(x, y, xSize, ySize);
                    w = this.getWidth();
                    h = this.getHeight();
                    if (w == 0 || h == 0) {
                        return;
                    }
                    this.resetCacheImageBounds(true, w, h);
                    logger.finest(" printing thread, drawing");
                    lcacheImage = null;
                    lcacheImageBounds = null;
                } else {
                    w = this.getWidth();
                    h = this.getHeight();
                    if (w == 0 || h == 0) {
                        return;
                    }
                    this.resetCacheImageBounds(false, w, h);
                    lcacheImageBounds = this.cacheImageBounds;
                    if (lcacheImageBounds.width == 0 || lcacheImageBounds.height == 0) {
                        logger.info("https://sourceforge.net/p/autoplot/bugs/1076/");
                        return;
                    }
                    lcacheImage = new BufferedImage(lcacheImageBounds.width, lcacheImageBounds.height, 6);
                    plotGraphics = (Graphics2D)lcacheImage.getGraphics();
                    plotGraphics.setBackground(this.getBackground());
                    plotGraphics.setColor(this.getForeground());
                    plotGraphics.setFont(this.getFont());
                    plotGraphics.setRenderingHints(DasProperties.getRenderingHints());
                    if (this.overSize) {
                        plotGraphics.translate(x - lcacheImageBounds.x, y - lcacheImageBounds.y);
                    }
                    logger.finest(" rebuilding cacheImage");
                }
                plotGraphics.translate(-x, -y);
                plotGraphics.clip(cacheImageClip);
                Renderer[] rends = this.getRenderers();
                DasAxis lxaxis = (DasAxis)this.getXAxis().clone();
                DasAxis lyaxis = (DasAxis)this.getYAxis().clone();
                DasAxis.Memento xmem = lxaxis.getMemento();
                DasAxis.Memento ymem = lyaxis.getMemento();
                if (rends.length > 0) {
                    for (Renderer r : rends) {
                        boolean dirt = false;
                        if (r.getXmemento() == null || !r.getXmemento().equals(xmem)) {
                            dirt = true;
                        }
                        if (r.getYmemento() == null || !r.getYmemento().equals(ymem)) {
                            dirt = true;
                        }
                        if (dirt) {
                            try {
                                logger.log(Level.FINE, "calling updatePlotImage again because of memento");
                                r.updatePlotImage(lxaxis, lyaxis, (ProgressMonitor)new NullProgressMonitor());
                            }
                            catch (DasException ex) {
                                ex.printStackTrace();
                                logger.log(Level.SEVERE, ex.getMessage(), ex);
                            }
                            continue;
                        }
                        logger.log(Level.FINE, "skipping updatePlotImage because memento indicates things are okay");
                    }
                }
                this.drawCacheImage(plotGraphics, lxaxis, lyaxis);
                plotGraphics.dispose();
            }
            if (!disableImageCache && !this.getCanvas().isPrintingThread()) {
                assert (lcacheImageBounds != null);
                this.cacheImageValid = true;
                graphics.drawImage(lcacheImage, lcacheImageBounds.x, lcacheImageBounds.y, lcacheImageBounds.width, lcacheImageBounds.height, this);
                this.xmemento = this.xAxis.getMemento();
                this.ymemento = this.yAxis.getMemento();
                logger.log(Level.FINEST, "recalc cacheImage, xmemento={0} ymemento={1}", new Object[]{this.xmemento, this.ymemento});
                this.cacheImage = lcacheImage;
                this.cacheImageBounds = lcacheImageBounds;
            }
        }
        graphics.setColor(this.getForeground());
        if (this.plotVisible) {
            graphics.drawRect(x, y, xSize, ySize);
        }
        if (this.displayTitle && localPlotTitle != null && localPlotTitle.length() != 0) {
            boolean drawBack;
            String t = localPlotTitle;
            t = this.implementMacros(t);
            if (this.fontSize.length() > 0 && !this.fontSize.equals("1em")) {
                try {
                    double[] dd = DasDevicePosition.parseLayoutStr(this.getFontSize());
                    if (dd[1] != 1.0 || dd[2] != 0.0) {
                        Font f = graphics.getFont();
                        double parentSize = f.getSize2D();
                        double newSize = dd[1] * parentSize + dd[2];
                        f = f.deriveFont((float)newSize);
                        graphics.setFont(f);
                    }
                }
                catch (ParseException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            GrannyTextRenderer gtr = GraphUtil.newGrannyTextRenderer();
            gtr.setAlignment(0.5f);
            gtr.setString((Graphics)graphics, t);
            int titleWidth = (int)gtr.getWidth();
            int titleX = x + (xSize - titleWidth) / 2;
            int titleY = y - (int)gtr.getDescent() - (int)gtr.getAscent() / 2;
            if (DEBUG_GRAPHICS) {
                Rectangle r = gtr.getBounds();
                r.translate(titleX, titleY);
                Graphics2D g = (Graphics2D)graphics.create();
                g.setColor(ColorUtil.CADET_BLUE);
                g.drawRect(r.x, r.y, r.width, r.height);
                g.dispose();
            }
            if (drawBack = this.isOpaqueBackground()) {
                Rectangle2D back = gtr.getBounds2D();
                back = new Rectangle2D.Double((double)titleX + back.getX(), (double)titleY + back.getY(), back.getWidth(), back.getHeight());
                c0 = graphics.getColor();
                graphics.setColor(Color.WHITE);
                graphics.fill(back);
                graphics.setColor(c0);
            }
            gtr.draw((Graphics)graphics, (float)titleX, (float)titleY);
        }
        ArrayList<MessageDescriptor> arrayList = lmessages = this.messages == null ? null : new ArrayList<MessageDescriptor>(this.messages);
        if (lmessages != null && lmessages.size() > 0) {
            this.drawMessages(graphics, lmessages);
        }
        ArrayList<LegendElement> arrayList2 = llegendElements = this.legendElements == null ? null : new ArrayList<LegendElement>(this.legendElements);
        if (llegendElements != null && llegendElements.size() > 0 && this.displayLegend && (xSize > this.legendWidthLimitPx || this.legendPosition == LegendPosition.OutsideNE)) {
            this.drawLegend(graphics, llegendElements);
        }
        if (this.drawDebugMessages) {
            int nr = this.getRenderers().length;
            int size = 30;
            if (nr > 5) {
                size = 20;
                graphics.setFont(graphics.getFont().deriveFont(7.0f));
            }
            int ir = 0;
            int xx = x + xSize - 100 - size / 3;
            int yy = y + ySize - nr * size - size / 3 - graphics.getFontMetrics().getHeight();
            c0 = graphics.getColor();
            graphics.setColor(new Color(255, 200, 255, 200));
            graphics.fillRoundRect(xx, yy, 100, nr * size + graphics.getFontMetrics().getHeight(), 10, 10);
            graphics.setColor(c0);
            graphics.drawRoundRect(xx, yy, 100, nr * size + graphics.getFontMetrics().getHeight(), 10, 10);
            for (Renderer r : this.getRenderers()) {
                GrannyTextRenderer gtr = GraphUtil.newGrannyTextRenderer();
                gtr.setString((Graphics)graphics, String.format("update: %d!crender: %d!c", r.getUpdateCount(), r.getRenderCount()));
                gtr.draw((Graphics)graphics, (float)(xx + 10), (float)(yy + 10 + ir * size));
                ++ir;
            }
            graphics.drawString("paint: " + this.paintComponentCount, xx + 10, yy + 20 + ir * 30 - graphics.getFontMetrics().getHeight());
        }
        graphics.dispose();
        this.getDasMouseInputAdapter().paint(graphics0);
        if (saveClip != null) {
            graphics0.setClip(saveClip);
        }
    }

    public void setEnableRenderPropertiesAction(boolean b) {
        if (b) {
            this.editRendererMenuItem = new JMenuItem(this.getEditAction());
            this.getDasMouseInputAdapter().addMenuItem(this.editRendererMenuItem);
        } else {
            if (this.editRendererMenuItem != null) {
                this.getDasMouseInputAdapter().removeMenuItem(this.editRendererMenuItem.getText());
            }
            this.editRendererMenuItem = null;
        }
    }

    private boolean isEnableRenderPropertiesAction() {
        return this.editRendererMenuItem != null;
    }

    public void releaseAll() {
        this.uninstallComponent();
        DasMouseInputAdapter dmia = this.getDasMouseInputAdapter();
        dmia.releaseAll();
        this.xAxis.getDasMouseInputAdapter().releaseAll();
        this.yAxis.getDasMouseInputAdapter().releaseAll();
    }

    public void postMessage(Renderer renderer, String message, int messageType, Datum x, Datum y) {
        if (this.messages != null) {
            this.messages.add(new MessageDescriptor(renderer, message, messageType, x, y));
        }
    }

    public void postMessage(Renderer renderer, String message, Level messageLevel, Datum x, Datum y) {
        if (this.messages != null) {
            this.messages.add(new MessageDescriptor(renderer, message, messageLevel.intValue(), x, y));
        }
    }

    public void postException(Renderer renderer, Exception exception) {
        String message = exception.getMessage();
        if (message == null || message.length() < 7) {
            message = String.valueOf(exception);
        }
        int errorLevel = SEVERE;
        if (exception instanceof CancelledOperationException) {
            errorLevel = INFO;
            if (exception.getMessage() == null) {
                message = "Operation Cancelled";
            }
        }
        this.postMessage(renderer, message, errorLevel, null, null);
    }

    public void addToLegend(Renderer renderer, ImageIcon icon, int pos, String message) {
        this.legendElements.add(new LegendElement(icon, renderer, message));
    }

    public void setReduceOutsideLegendTopMargin(boolean reduceOutsideLegendTopMargin) {
        this.reduceOutsideLegendTopMargin = reduceOutsideLegendTopMargin;
        this.update();
    }

    private void drawGrid(Graphics2D g, DatumVector xticks, DatumVector yticks) {
        int i;
        Rectangle lcacheImageBounds = this.getCacheImageBounds();
        int xmin = lcacheImageBounds.x;
        int xmax = lcacheImageBounds.x + lcacheImageBounds.width;
        int ymin = lcacheImageBounds.y;
        int ymax = lcacheImageBounds.y + lcacheImageBounds.height;
        if (yticks != null && yticks.getUnits().isConvertibleTo(this.yAxis.getUnits())) {
            for (i = 0; i < yticks.getLength(); ++i) {
                int y = (int)this.yAxis.transform(yticks.get(i));
                g.drawLine(xmin, y, xmax, y);
            }
        }
        if (xticks != null && xticks.getUnits().isConvertibleTo(this.xAxis.getUnits())) {
            for (i = 0; i < xticks.getLength(); ++i) {
                int x = (int)this.xAxis.transform(xticks.get(i));
                g.drawLine(x, ymin, x, ymax);
            }
        }
    }

    protected void drawContent(Graphics2D g) {
    }

    @Override
    public void resize() {
        logger.finer("resize DasPlot");
        if (this.isDisplayable()) {
            Rectangle oldBounds = this.getBounds();
            GrannyTextRenderer gtr = GraphUtil.newGrannyTextRenderer();
            gtr.setAlignment(this.multiLineTextAlignment);
            Font f = this.getCanvasRenderFont(this.getFont());
            gtr.setString(f, this.getTitle());
            this.titleHeight = (int)gtr.getHeight() + (int)gtr.getAscent() / 2;
            ArrayList<LegendElement> llegendElements = this.legendElements == null ? null : new ArrayList<LegendElement>(this.legendElements);
            Rectangle legendBounds = this.getLegendBounds((Graphics2D)this.getGraphics(), 0, 0, llegendElements);
            double lineThicknessDouble = this.getLineThicknessDouble(this.lineThickness);
            Rectangle bounds = new Rectangle();
            bounds.x = this.getColumn().getDMinimum() - 1 - (int)(lineThicknessDouble / 2.0);
            bounds.y = this.getRow().getDMinimum() - 1 - (int)(lineThicknessDouble / 2.0);
            bounds.width = this.getColumn().getDMaximum() - bounds.x + 1 + (int)(lineThicknessDouble / 2.0);
            if (this.longTitles) {
                if (this.getYAxis().getOrientation() == 3) {
                    bounds.x = this.getYAxis().getBounds().x;
                    int yaxiswidth = this.getColumn().getDMinimum() - this.getYAxis().getBounds().x;
                    bounds.width = this.getColumn().getDMaximum() - bounds.x + yaxiswidth;
                } else {
                    int yaxiswidth = this.getYAxis().getBounds().width;
                    bounds.x -= yaxiswidth;
                    bounds.width += 2 * yaxiswidth;
                }
            }
            bounds.height = this.getRow().getDMaximum() - bounds.y + 1 + (int)(lineThicknessDouble / 2.0);
            if (this.displayTitle && !this.getTitle().equals("")) {
                bounds.y -= this.titleHeight;
                bounds.height += this.titleHeight;
            }
            if (legendBounds != null) {
                bounds.add(legendBounds);
            }
            logger.log(Level.FINER, "DasPlot setBounds {0}", bounds);
            if (!bounds.equals(oldBounds)) {
                this.setBounds(bounds);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        List<Renderer> renderers1 = Arrays.asList(DasPlot.this.getRenderers());
                        for (Renderer renderers11 : renderers1) {
                            renderers11.refresh();
                        }
                        DasPlot.this.invalidateCacheImage();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String t) {
        String oldValue;
        DasPlot dasPlot = this;
        synchronized (dasPlot) {
            oldValue = this.plotTitle;
            this.plotTitle = t;
        }
        logger.log(Level.FINE, "setTitle(\"{0}\")", t);
        if (t == null) {
            t = "";
        }
        if (this.getCanvas() != null) {
            FontMetrics fm = this.getFontMetrics(this.getCanvas().getFont());
            this.titleHeight = fm.getHeight() + fm.getHeight() / 2;
            this.resize();
            this.invalidateCacheImage();
        }
        if (!t.equals(oldValue)) {
            this.firePropertyChange(PROP_TITLE, oldValue, t);
        }
    }

    public synchronized String getTitle() {
        return this.plotTitle;
    }

    public boolean isDisplayTitle() {
        return this.displayTitle;
    }

    public void setDisplayTitle(boolean v) {
        boolean old = this.displayTitle;
        this.displayTitle = v;
        this.firePropertyChange(PROP_DISPLAYTITLE, old, v);
        this.resize();
        this.invalidateCacheImage();
    }

    public Painter getBottomDecorator() {
        return this.bottomDecorator;
    }

    public void setBottomDecorator(Painter bottomDecorator) {
        Painter oldBottomDecorator = this.bottomDecorator;
        this.bottomDecorator = bottomDecorator;
        this.firePropertyChange(PROP_BOTTOMDECORATOR, oldBottomDecorator, bottomDecorator);
        this.invalidateCacheImage();
        this.repaint();
    }

    public Painter getTopDecorator() {
        return this.topDecorator;
    }

    public void setTopDecorator(Painter topDecorator) {
        Painter oldTopDecorator = this.topDecorator;
        this.topDecorator = topDecorator;
        this.firePropertyChange(PROP_TOPDECORATOR, oldTopDecorator, topDecorator);
        this.invalidateCacheImage();
        this.repaint();
    }

    public DatumRange getContext() {
        return this.context;
    }

    public void setContext(DatumRange context) {
        DatumRange old = this.context;
        this.context = context;
        this.firePropertyChange(PROP_CONTEXT, old, context);
    }

    public DatumRange getDisplayContext() {
        return this.displayContext;
    }

    public void setDisplayContext(DatumRange displayContext) {
        DatumRange old = this.displayContext;
        this.displayContext = displayContext;
        this.firePropertyChange(PROP_DISPLAY_CONTEXT, old, displayContext);
    }

    public DasAxis getXAxis() {
        return this.xAxis;
    }

    public DasAxis getYAxis() {
        return this.yAxis;
    }

    public DasColorBar getDasColorBar() {
        Renderer[] rr = this.getRenderers();
        for (int i = rr.length - 1; i >= 0; --i) {
            DasColorBar cb = rr[i].getColorBar();
            if (cb == null) continue;
            return cb;
        }
        return null;
    }

    @Override
    protected void installComponent() {
        Renderer[] r;
        super.installComponent();
        if (this.xAxis != null) {
            this.getCanvas().add(this.xAxis, this.getRow(), this.getColumn());
        }
        if (this.yAxis != null) {
            this.getCanvas().add(this.yAxis, this.getRow(), this.getColumn());
        }
        for (Renderer r1 : r = this.getRenderers()) {
            r1.installRenderer();
        }
        if (!"true".equals(DasApplication.getProperty("java.awt.headless", "false"))) {
            this.dndSupport = new PlotDnDSupport(this.getCanvas().dndSupport);
        }
    }

    @Override
    protected void uninstallComponent() {
        Renderer[] r;
        super.uninstallComponent();
        if (this.xAxis != null && this.xAxis.getCanvas() != null) {
            this.xAxis.getCanvas().remove(this.xAxis);
        }
        if (this.yAxis != null && this.yAxis.getCanvas() != null) {
            this.yAxis.getCanvas().remove(this.yAxis);
        }
        for (Renderer r1 : r = this.getRenderers()) {
            if (r1 == null) {
                System.err.println("strange hudson case of NullPointerException");
                continue;
            }
            r1.uninstallRenderer();
        }
    }

    public void addRenderer(Renderer rend) {
        logger.log(Level.FINE, "addRenderer({0})", rend);
        if (rend == null) {
            throw new NullPointerException("added renderer was null");
        }
        DasPlot parent = rend.getParent();
        if (parent != null) {
            parent.removeRenderer(rend);
        }
        Renderer[] oldValue = this.renderers.toArray(new Renderer[this.renderers.size()]);
        this.renderers.add(rend);
        rend.setParent(this);
        if (this.getCanvas() != null) {
            rend.installRenderer();
        }
        this.firePropertyChange(PROP_RENDERERS, oldValue, this.renderers.toArray(new Renderer[this.renderers.size()]));
        rend.update();
        this.invalidateCacheImage();
    }

    public void addRenderer(int index, Renderer rend) {
        logger.log(Level.FINE, "addRenderer({0},{1})", new Object[]{index, rend});
        if (rend == null) {
            throw new NullPointerException("added renderer was null");
        }
        DasPlot parent = rend.getParent();
        if (parent != null) {
            parent.removeRenderer(rend);
        }
        Renderer[] oldValue = this.renderers.toArray(new Renderer[this.renderers.size()]);
        this.renderers.add(index, rend);
        rend.setParent(this);
        if (this.getCanvas() != null) {
            rend.installRenderer();
        }
        this.firePropertyChange(PROP_RENDERERS, oldValue, this.renderers.toArray(new Renderer[this.renderers.size()]));
        rend.update();
        this.invalidateCacheImage();
    }

    public void removeRenderer(Renderer rend) {
        logger.log(Level.FINE, "removeRenderer({0})", new Object[]{rend});
        if (!this.renderers.contains(rend)) {
            logger.log(Level.WARNING, "*** plot doesn''t contain renderer: {0}", rend);
        }
        if (this.getCanvas() != null) {
            rend.uninstallRenderer();
        }
        if (this.focusRenderer == rend) {
            this.setFocusRenderer(null);
        }
        Renderer[] oldValue = this.renderers.toArray(new Renderer[this.renderers.size()]);
        this.renderers.remove(rend);
        this.firePropertyChange(PROP_RENDERERS, oldValue, this.renderers.toArray(new Renderer[this.renderers.size()]));
        rend.setParent(null);
        this.invalidateCacheImage();
    }

    @Override
    public boolean contains(int x, int y) {
        if (!this.plotVisible) {
            boolean contains = false;
            for (Renderer r : this.renderers) {
                if (!r.isActive()) continue;
                contains = true;
            }
            return contains;
        }
        return super.contains(x, y);
    }

    public boolean containsRenderer(Renderer rend) {
        return this.renderers.contains(rend);
    }

    public synchronized void removeRenderers() {
        if (this.getCanvas() != null) {
            for (Renderer rend : this.renderers) {
                rend.uninstallRenderer();
                rend.setParent(null);
            }
            this.setFocusRenderer(null);
            this.renderers.clear();
        }
        this.invalidateCacheImage();
    }

    public static DasPlot createDummyPlot() {
        DasAxis xAxis = new DasAxis(Datum.create((int)-10), Datum.create((int)10), 2);
        DasAxis yAxis = new DasAxis(Datum.create((int)-10), Datum.create((int)10), 3);
        DasPlot result = new DasPlot(xAxis, yAxis);
        return result;
    }

    public static DasPlot createPlot(DatumRange xrange, DatumRange yrange) {
        DasAxis xAxis = new DasAxis(xrange, 2);
        DasAxis yAxis = new DasAxis(yrange, 3);
        DasPlot result = new DasPlot(xAxis, yAxis);
        return result;
    }

    public synchronized Renderer getRenderer(int index) {
        return this.renderers.get(index);
    }

    public synchronized Renderer[] getRenderers() {
        Renderer[] rr = this.renderers.toArray(new Renderer[this.renderers.size()]);
        while (this.renderers.size() != rr.length) {
            rr = this.renderers.toArray(new Renderer[this.renderers.size()]);
            logger.warning("things are transitioning");
        }
        for (int i = 0; i < rr.length; ++i) {
            if (rr[i] != null) continue;
            logger.warning("found null");
        }
        return rr;
    }

    @Override
    public Shape getActiveRegion() {
        return this.getBounds();
    }

    @Override
    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        if (existingEvent instanceof DasRendererUpdateEvent && newEvent instanceof DasRendererUpdateEvent) {
            DasRendererUpdateEvent e1 = (DasRendererUpdateEvent)existingEvent;
            DasRendererUpdateEvent e2 = (DasRendererUpdateEvent)newEvent;
            if (e1.getRenderer() == e2.getRenderer()) {
                return existingEvent;
            }
            return null;
        }
        return super.coalesceEvents(existingEvent, newEvent);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof DasRendererUpdateEvent) {
            logger.fine("process DasRendererUpdateEvent");
            DasRendererUpdateEvent drue = (DasRendererUpdateEvent)e;
            drue.getRenderer().updateImmediately();
            this.cacheImageValid = false;
            this.repaint();
        } else {
            super.processEvent(e);
        }
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    public void invalidateCacheImage() {
        if (!this.cacheImageValid) {
            logger.fine("cacheImage was already invalid, reposting update.");
        } else {
            this.cacheImageValid = false;
        }
        this.markDirty("invalidateCacheImage");
        this.update();
    }

    public void invalidateCacheImageNoUpdate() {
        this.cacheImageValid = false;
    }

    public boolean isCacheImageValid() {
        return this.cacheImageValid;
    }

    @Override
    void markDirty() {
        logger.finer("DasPlot.markDirty");
        super.markDirty("withRepaint");
        this.repaint();
    }

    public LegendPosition getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(LegendPosition newlegendPosition) {
        LegendPosition oldlegendPosition = this.legendPosition;
        this.legendPosition = newlegendPosition;
        this.firePropertyChange(PROP_LEGENDPOSITION, oldlegendPosition, newlegendPosition);
        this.resize();
        this.repaint();
    }

    public int getLegendRelativeFontSize() {
        return this.legendRelativeFontSize;
    }

    public void setLegendRelativeFontSize(int size) {
        int oldF = this.legendRelativeFontSize;
        this.legendRelativeFontSize = size;
        this.firePropertyChange(PROP_LEGENDRELATIVESIZESIZE, oldF, size);
        this.repaint();
    }

    public String getLegendFontSize() {
        return this.legendFontSize;
    }

    public void setLegendFontSize(String legendFontSize) {
        String oldLegendFontSize = this.legendFontSize;
        this.legendFontSize = legendFontSize;
        this.firePropertyChange(PROP_LEGENDFONTSIZE, oldLegendFontSize, legendFontSize);
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        String oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.firePropertyChange(PROP_FONTSIZE, oldFontSize, fontSize);
    }

    public boolean isDisplayLegend() {
        return this.displayLegend;
    }

    public void setDisplayLegend(boolean displayLegend) {
        boolean oldDisplayLegend = this.displayLegend;
        this.displayLegend = displayLegend;
        this.firePropertyChange(PROP_DISPLAYLEGEND, oldDisplayLegend, displayLegend);
        this.resize();
        this.repaint();
    }

    public Color getDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(Color drawBackground) {
        Color oldDrawBackground = this.drawBackground;
        this.drawBackground = drawBackground;
        this.invalidateCacheImage();
        this.repaint();
        this.firePropertyChange(PROP_DRAWBACKGROUND, oldDrawBackground, drawBackground);
    }

    public Color getDrawGridColor() {
        return this.drawGridColor;
    }

    public void setDrawGridColor(Color drawGridColor) {
        Color oldDrawGridColor = this.drawGridColor;
        this.drawGridColor = drawGridColor;
        this.invalidateCacheImage();
        this.repaint();
        this.firePropertyChange(PROP_DRAWGRIDCOLOR, oldDrawGridColor, drawGridColor);
    }

    public boolean isDrawGrid() {
        return this.drawGrid;
    }

    public void setDrawGrid(boolean drawGrid) {
        boolean bOld = this.drawGrid;
        this.drawGrid = drawGrid;
        this.invalidateCacheImage();
        this.repaint();
        if (bOld != drawGrid) {
            this.firePropertyChange(PROP_DRAWGRID, bOld, drawGrid);
        }
    }

    public boolean isDrawMinorGrid() {
        return this.drawMinorGrid;
    }

    public void setDrawMinorGrid(boolean newdrawMinorGrid) {
        boolean olddrawMinorGrid = this.drawMinorGrid;
        this.drawMinorGrid = newdrawMinorGrid;
        this.invalidateCacheImage();
        this.repaint();
        this.firePropertyChange(PROP_DRAWMINORGRID, olddrawMinorGrid, newdrawMinorGrid);
    }

    public boolean isDrawGridOver() {
        return this.drawGridOver;
    }

    public void setDrawGridOver(boolean gridOver) {
        boolean oldGridOver = this.drawGridOver;
        this.drawGridOver = gridOver;
        this.invalidateCacheImage();
        this.repaint();
        this.firePropertyChange(PROP_DRAWGRIDOVER, oldGridOver, gridOver);
    }

    public String getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(String lineThickness) {
        String oldLineThickness = this.lineThickness;
        this.lineThickness = lineThickness;
        this.repaint();
        this.firePropertyChange(PROP_LINETHICKNESS, oldLineThickness, lineThickness);
    }

    public void setPreviewEnabled(boolean preview) {
        this.preview = preview;
    }

    public boolean isPreviewEnabled() {
        return this.preview;
    }

    public void setAxisPlotVisible(boolean visible) {
        this.setVisible(visible);
        this.xAxis.setVisible(visible);
        this.yAxis.setVisible(visible);
    }

    public boolean isPlotVisible() {
        return this.plotVisible;
    }

    public void setPlotVisible(boolean plotVisible) {
        boolean oldPlotVisible = this.plotVisible;
        this.plotVisible = plotVisible;
        this.firePropertyChange(PROP_PLOTVISIBLE, oldPlotVisible, plotVisible);
    }

    public boolean isOverSize() {
        return this.overSize;
    }

    public void setOverSize(boolean overSize) {
        boolean oldOverSize = this.overSize;
        this.overSize = overSize;
        this.invalidateCacheImage();
        this.firePropertyChange(PROP_OVERSIZE, oldOverSize, overSize);
    }

    public boolean isLongTitles() {
        return this.longTitles;
    }

    public void setLongTitles(boolean longTitles) {
        boolean oldLongTitles = this.longTitles;
        this.longTitles = longTitles;
        this.firePropertyChange(PROP_LONGTITLES, oldLongTitles, longTitles);
    }

    public void setLogLevel(Level level) {
        Level oldLevel = this.logLevel;
        this.logLevel = level;
        if (!oldLevel.equals(level)) {
            this.repaint();
        }
        this.firePropertyChange(PROP_LOG_LEVEL, oldLevel, level);
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public Level getPrintingLogLevel() {
        return this.printingLogLevel;
    }

    public void setPrintingLogLevel(Level printingLogLevel) {
        Level oldPrintingLogLevel = this.printingLogLevel;
        this.printingLogLevel = printingLogLevel;
        this.firePropertyChange(PROP_PRINTINGLOGLEVEL, oldPrintingLogLevel, printingLogLevel);
    }

    public int getLogTimeoutSec() {
        return this.logTimeoutSec;
    }

    public void setLogTimeoutSec(int logTimeoutSec) {
        int oldLogTimeoutSec = this.logTimeoutSec;
        this.logTimeoutSec = logTimeoutSec;
        this.repaint();
        this.firePropertyChange(PROP_LOG_TIMEOUT_SEC, oldLogTimeoutSec, logTimeoutSec);
    }

    public boolean isIsotropic() {
        return this.isotropic;
    }

    public void setIsotropic(boolean isotropic) {
        boolean oldvalud = this.isotropic;
        this.isotropic = isotropic;
        if (oldvalud != isotropic) {
            this.firePropertyChange(PROP_ISOTROPIC, oldvalud, isotropic);
        }
        if (isotropic) {
            this.checkIsotropic(this, null);
        }
    }

    protected Rectangle getUpdateImageBounds() {
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        Rectangle lcacheImageBounds = new Rectangle();
        if (this.overSize) {
            lcacheImageBounds.width = 16 * this.getWidth() / 10;
            lcacheImageBounds.height = this.getHeight();
            lcacheImageBounds.x = x - 3 * this.getWidth() / 10;
        } else {
            lcacheImageBounds.width = this.getWidth();
            lcacheImageBounds.height = this.getHeight();
            lcacheImageBounds.x = x - 1;
        }
        lcacheImageBounds.y = y - 1;
        this.setCacheImageBounds(lcacheImageBounds);
        return lcacheImageBounds;
    }

    protected synchronized Rectangle getCacheImageBounds() {
        Rectangle lcacheImageBounds = new Rectangle(this.cacheImageBounds);
        return lcacheImageBounds;
    }

    protected void setCacheImageBounds(Rectangle cacheImageBounds) {
        this.cacheImageBounds = new Rectangle(cacheImageBounds);
    }

    private void checkIsotropic(DasPlot dasPlot, DasAxis axis) {
        Datum scalex = dasPlot.getXAxis().getDatumRange().width().divide((double)dasPlot.getXAxis().getDLength());
        Datum scaley = dasPlot.getYAxis().getDatumRange().width().divide((double)dasPlot.getYAxis().getDLength());
        if (!scalex.getUnits().isConvertibleTo(scaley.getUnits()) || dasPlot.getXAxis().isLog() || dasPlot.getYAxis().isLog()) {
            return;
        }
        if (dasPlot.getXAxis().getDLength() == 1 || dasPlot.getYAxis().getDLength() == 1) {
            return;
        }
        if (axis == null) {
            DasAxis dasAxis = axis = scalex.gt(scaley) ? dasPlot.getXAxis() : dasPlot.getYAxis();
        }
        if (axis == dasPlot.getXAxis() || axis == dasPlot.getYAxis()) {
            DatumRange otherRange;
            Datum otherScale;
            Datum scale;
            double expand;
            DasAxis otherAxis = dasPlot.getYAxis();
            if (axis == dasPlot.getYAxis()) {
                otherAxis = dasPlot.getXAxis();
            }
            if (Math.abs(expand = ((scale = axis.getDatumRange().width().divide((double)axis.getDLength())).divide(otherScale = (otherRange = otherAxis.getDatumRange()).width().divide((double)otherAxis.getDLength())).value() - 1.0) / 2.0) > 1.0E-4) {
                logger.log(Level.FINE, "expand={0} scale={1} otherScale={2}", new Object[]{expand, scale, otherScale});
                DatumRange newOtherRange = DatumRangeUtil.rescale((DatumRange)otherRange, (double)(0.0 - expand), (double)(1.0 + expand));
                otherAxis.setDatumRange(newOtherRange);
            }
        }
    }

    public int getPaintCount() {
        return this.paintComponentCount.intValue();
    }

    public void resetPaintCount() {
        Renderer[] lrenderers = this.getRenderers();
        this.paintComponentCount.set(0);
        for (Renderer r : lrenderers) {
            r.resetCounters();
        }
    }

    public void setDrawDebugMessages(boolean v) {
        this.drawDebugMessages = v;
        this.resetPaintCount();
        this.repaint();
    }

    public boolean isDrawDebugMessages() {
        return this.drawDebugMessages;
    }

    private class PlotDnDSupport
    extends DnDSupport {
        PlotDnDSupport(DnDSupport parent) {
            super((Component)DasPlot.this, 3, parent);
        }

        public void drop(DropTargetDropEvent dtde) {
        }

        protected int canAccept(DataFlavor[] flavors, int x, int y, int action) {
            for (DataFlavor flavor : flavors) {
                if (!flavor.equals(TransferableRenderer.RENDERER_FLAVOR)) continue;
                return action;
            }
            return -1;
        }

        protected void done() {
        }

        protected boolean importData(Transferable t, int x, int y, int action) {
            boolean success = false;
            try {
                Renderer r = (Renderer)t.getTransferData(TransferableRenderer.RENDERER_FLAVOR);
                DasPlot.this.addRenderer(r);
                DasPlot.this.revalidate();
                success = true;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
            return success;
        }

        protected Transferable getTransferable(int x, int y, int action) {
            return null;
        }

        protected void exportDone(Transferable t, int action) {
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            logger.log(Level.FINE, "rebin listener got property change: {0}", e.getNewValue());
            if (DasPlot.this.isotropic && e.getSource() instanceof DasAxis) {
                DasAxis axis = (DasAxis)e.getSource();
                DasPlot.this.checkIsotropic(DasPlot.this, axis);
            }
            DasPlot.this.markDirty("rebinListener");
            DasPlot.this.update();
        }
    }

    private static class LegendElement {
        ImageIcon icon;
        Renderer renderer;
        String label;
        Rectangle bounds;

        LegendElement(ImageIcon icon, Renderer rend, String label) {
            this.icon = icon;
            this.renderer = rend;
            this.label = label;
        }

        protected void drawIcon(Graphics2D graphics, int x, int y) {
            this.renderer.drawListIcon(graphics, x, y);
        }
    }

    private static class MessageDescriptor {
        Renderer renderer;
        String text;
        int messageType;
        Rectangle bounds;
        long birthMilli;

        MessageDescriptor(Renderer renderer, String text, int messageType, Datum x, Datum y) {
            this.renderer = renderer;
            this.text = text;
            this.messageType = messageType;
            this.birthMilli = renderer instanceof DigitalRenderer ? Long.MAX_VALUE : System.currentTimeMillis();
        }
    }
}

