/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.graph.Arrow;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.TickVDescriptor;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;

public class PitchAngleDistributionRenderer
extends Renderer {
    PropertyChangeListener rebinListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            PitchAngleDistributionRenderer.this.update();
            PitchAngleDistributionRenderer.this.updateCacheImage();
        }
    };
    public static final String PROP_ORIGINNORTH = "originNorth";
    protected boolean originNorth = false;
    private boolean clockwise = false;
    public static final String PROP_CLOCKWISE = "clockwise";
    public static final String PROP_ORIGIN = "origin";
    protected String origin = "";
    private boolean drawPolarAxes = false;
    public static final String PROP_DRAWPOLARAXES = "drawPolarAxes";
    protected boolean mirror = false;
    public static final String PROP_MIRROR = "mirror";

    public PitchAngleDistributionRenderer(DasColorBar cb) {
        this.setColorBar(cb);
    }

    private static Double isAngleRange(QDataSet ds) {
        Units u = SemanticOps.getUnits((QDataSet)ds);
        if (u == Units.radians) {
            return 1.0;
        }
        if (u == Units.deg || u == Units.degrees) {
            return Math.PI / 180;
        }
        QDataSet extent = Ops.extent((QDataSet)ds);
        double delta = extent.value(1) - extent.value(0);
        if (u == Units.dimensionless && (delta > 160.0 && delta < 181.0 || delta > 320.0 && delta < 362.0)) {
            return Math.PI / 180;
        }
        if (u == Units.dimensionless && (delta > 2.792526803190927 && delta < 3.159045946109736 || delta > 5.585053606381854 && delta < 6.318091892219472)) {
            return 1.0;
        }
        return null;
    }

    public static boolean acceptsData(QDataSet ds) {
        if (ds.rank() == 2) {
            if (SemanticOps.isTimeSeries((QDataSet)ds)) {
                return false;
            }
            if (SemanticOps.isBundle((QDataSet)ds)) {
                return false;
            }
            QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)ds);
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
            if (PitchAngleDistributionRenderer.isAngleRange(xds) != null) {
                return true;
            }
            return PitchAngleDistributionRenderer.isAngleRange(yds) != null;
        }
        return false;
    }

    @Override
    public Icon getListIcon() {
        return new ImageIcon(SpectrogramRenderer.class.getResource("/images/icons/pitchAngleDistribution.png"));
    }

    @Override
    public final void setColorBar(DasColorBar colorBar) {
        DasColorBar oldColorBar = this.colorBar;
        if (this.colorBar != null) {
            this.colorBar.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("log", this.rebinListener);
            this.colorBar.removePropertyChangeListener("type", this.rebinListener);
            this.colorBar.removePropertyChangeListener("fillColor", this.rebinListener);
        }
        this.colorBar = colorBar;
        if (this.colorBar != null) {
            colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            colorBar.addPropertyChangeListener("log", this.rebinListener);
            colorBar.addPropertyChangeListener("type", this.rebinListener);
            colorBar.addPropertyChangeListener("fillColor", this.rebinListener);
        }
        this.propertyChangeSupport.firePropertyChange("colorBar", oldColorBar, colorBar);
    }

    public static QDataSet doAutorange(QDataSet tds) {
        DDataSet xdesc;
        QDataSet zdesc = Ops.extent((QDataSet)tds);
        if (zdesc.value(0) == zdesc.value(1)) {
            if (zdesc.value(0) > 0.0) {
                zdesc = DDataSet.wrap((double[])new double[]{0.0, zdesc.value(1)});
                zdesc = Ops.putProperty((QDataSet)zdesc, (String)"UNITS", (Object)tds.property("UNITS"));
            } else {
                zdesc = DDataSet.wrap((double[])new double[]{0.0, 1.0});
                zdesc = Ops.putProperty((QDataSet)zdesc, (String)"UNITS", (Object)tds.property("UNITS"));
            }
        }
        zdesc = Ops.putProperty((QDataSet)zdesc, (String)"SCALE_TYPE", (Object)tds.property("SCALE_TYPE"));
        QDataSet ads = SemanticOps.xtagsDataSet((QDataSet)tds);
        QDataSet rds = SemanticOps.ytagsDataSet((QDataSet)tds);
        if (PitchAngleDistributionRenderer.isAngleRange(rds) != null && PitchAngleDistributionRenderer.isAngleRange(ads) == null) {
            rds = SemanticOps.xtagsDataSet((QDataSet)tds);
        }
        Units yunits = SemanticOps.getUnits((QDataSet)rds);
        DDataSet ydesc = xdesc = DDataSet.wrap((double[])new double[]{0.0, Ops.extent((QDataSet)rds).value(1)}, (Units)yunits);
        xdesc = ArrayDataSet.maybeCopy((QDataSet)Ops.rescaleRangeLogLin((QDataSet)xdesc, (double)-1.1, (double)1.1));
        ydesc = ArrayDataSet.maybeCopy((QDataSet)Ops.rescaleRangeLogLin((QDataSet)ydesc, (double)-1.1, (double)1.1));
        String l = rds.property("LABEL") == null ? "(Parallel)" : String.format("%s (Parallel)", rds.property("LABEL"));
        xdesc.putProperty("LABEL", (Object)l);
        l = rds.property("LABEL") == null ? "(Perp)" : String.format("%s (Perp)", rds.property("LABEL"));
        ydesc.putProperty("LABEL", (Object)l);
        JoinDataSet bds = new JoinDataSet(2);
        bds.join((QDataSet)xdesc);
        bds.join((QDataSet)ydesc);
        bds.join(zdesc);
        return bds;
    }

    @Override
    public void render(Graphics2D g1, DasAxis xAxis, DasAxis yAxis) {
        QDataSet tds = this.ds;
        if (tds == null) {
            logger.fine("null data set");
            this.postMessage("no data set", DasPlot.INFO, null, null);
            return;
        }
        if (!SemanticOps.isTableDataSet((QDataSet)tds)) {
            this.postException(new IllegalArgumentException("expected Table: " + tds));
            return;
        }
        if (!xAxis.getUnits().isConvertibleTo(yAxis.getUnits())) {
            this.postException(new IllegalArgumentException("x and y axes have different units, x=" + xAxis.getUnits() + " y=" + yAxis.getUnits()));
            return;
        }
        Graphics2D g = g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.colorBar == null) {
            return;
        }
        this.colorBar.setSpecialColors(this.getControl("specialColors", ""));
        QDataSet ads = SemanticOps.xtagsDataSet((QDataSet)tds);
        QDataSet rds = SemanticOps.ytagsDataSet((QDataSet)tds);
        Units yunits = SemanticOps.getUnits((QDataSet)rds);
        Double angleFactor = PitchAngleDistributionRenderer.isAngleRange(ads);
        if (PitchAngleDistributionRenderer.isAngleRange(rds) != null && angleFactor == null) {
            rds = SemanticOps.xtagsDataSet((QDataSet)tds);
            ads = SemanticOps.ytagsDataSet((QDataSet)tds);
            yunits = SemanticOps.getUnits((QDataSet)rds);
            tds = Ops.transpose((QDataSet)tds);
            angleFactor = PitchAngleDistributionRenderer.isAngleRange(ads);
        }
        if (angleFactor == null) {
            throw new IllegalArgumentException("neither dimension appears to be angles");
        }
        if (angleFactor != 1.0) {
            ads = Ops.multiply((Object)ads, (Object)angleFactor);
        }
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)tds);
        float[][] xx = new float[tds.length() + 1][tds.length(0) + 1];
        float[][] yy = new float[tds.length() + 1][tds.length(0) + 1];
        Units zunits = SemanticOps.getUnits((QDataSet)tds);
        double amin = Double.NEGATIVE_INFINITY;
        double amax = Double.POSITIVE_INFINITY;
        double da = (ads.value(1) - ads.value(0)) / 2.0;
        QDataSet rangea = Ops.extent((QDataSet)ads);
        if (rangea.value(1) - rangea.value(0) < 4.71238898038469) {
            amin = Math.PI * (double)((int)(ads.value(1) / 180.0));
            amax = Math.PI * (double)(1 + (int)(ads.value(ads.length() - 2) / 180.0));
        }
        ArrayDataSet damin = ArrayDataSet.copy((QDataSet)ads);
        ArrayDataSet damax = ArrayDataSet.copy((QDataSet)ads);
        for (int i = 0; i < damin.length(); ++i) {
            if (i == 0) {
                damin.putValue(i, Math.max(amin, ads.value(i) - da));
                damax.putValue(i, (ads.value(i + 1) + ads.value(i)) / 2.0);
                continue;
            }
            if (i < damin.length() - 1) {
                damin.putValue(i, (ads.value(i - 1) + ads.value(i)) / 2.0);
                damax.putValue(i, (ads.value(i + 1) + ads.value(i)) / 2.0);
                continue;
            }
            damin.putValue(i, (ads.value(i - 1) + ads.value(i)) / 2.0);
            damax.putValue(i, Math.min(amax, ads.value(i) + da));
        }
        double x0 = xAxis.transform(0.0, yunits);
        double y0 = yAxis.transform(0.0, yunits);
        QDataSet rwds = Ops.valid((QDataSet)rds);
        QDataSet daminWds = Ops.valid((QDataSet)damin);
        QDataSet damaxWds = Ops.valid((QDataSet)damax);
        for (int iflip = 0; iflip < 2; ++iflip) {
            if (!this.mirror && iflip == 1) continue;
            for (int j = 0; j < rds.length() - 1; ++j) {
                if (rwds.value(j) <= 0.0 || rwds.value(j + 1) <= 0.0) continue;
                double v1 = rds.value(j);
                double v2 = rds.value(j + 1);
                double r0x = xAxis.transform(v1, yunits) - x0;
                double r0y = y0 - yAxis.transform(v1, yunits);
                double r1x = xAxis.transform(v2, yunits) - x0;
                double r1y = y0 - yAxis.transform(v2, yunits);
                for (int i = 0; i < ads.length(); ++i) {
                    if (daminWds.value(i) <= 0.0 || damaxWds.value(i) <= 0.0) continue;
                    double a0 = damin.value(i);
                    double a1 = damax.value(i);
                    if (this.clockwise) {
                        a0 = -a0;
                        a1 = -a1;
                    }
                    if (iflip == 1) {
                        a0 = -a0;
                        a1 = -a1;
                    }
                    if (this.origin.length() > 0) {
                        if (this.origin.equalsIgnoreCase("N")) {
                            a0 += 1.5707963267948966;
                            a1 += 1.5707963267948966;
                        } else if (!this.origin.equalsIgnoreCase("E")) {
                            if (this.origin.equalsIgnoreCase("S")) {
                                a0 -= 1.5707963267948966;
                                a1 -= 1.5707963267948966;
                            } else if (this.origin.equalsIgnoreCase("W")) {
                                a0 += Math.PI;
                                a1 += Math.PI;
                            }
                        }
                    }
                    if (this.originNorth) {
                        yy[i][j] = (float)(y0 - Math.cos(a0) * r0y);
                        xx[i][j] = (float)(x0 - Math.sin(a0) * r0x);
                        yy[i][j + 1] = (float)(y0 - Math.cos(a0) * r1y);
                        xx[i][j + 1] = (float)(x0 - Math.sin(a0) * r1x);
                        yy[i + 1][j] = (float)(y0 - Math.cos(a1) * r0y);
                        xx[i + 1][j] = (float)(x0 - Math.sin(a1) * r0x);
                        yy[i + 1][j + 1] = (float)(y0 - Math.cos(a1) * r1y);
                        xx[i + 1][j + 1] = (float)(x0 - Math.sin(a1) * r1x);
                    } else {
                        xx[i][j] = (float)(x0 + Math.cos(a0) * r0x);
                        yy[i][j] = (float)(y0 - Math.sin(a0) * r0y);
                        xx[i][j + 1] = (float)(x0 + Math.cos(a0) * r1x);
                        yy[i][j + 1] = (float)(y0 - Math.sin(a0) * r1y);
                        xx[i + 1][j] = (float)(x0 + Math.cos(a1) * r0x);
                        yy[i + 1][j] = (float)(y0 - Math.sin(a1) * r0y);
                        xx[i + 1][j + 1] = (float)(x0 + Math.cos(a1) * r1x);
                        yy[i + 1][j + 1] = (float)(y0 - Math.sin(a1) * r1y);
                    }
                    if (!(wds.value(i, j) > 0.0)) continue;
                    int zz = this.colorBar.rgbTransform(tds.value(i, j), zunits);
                    g.setColor(new Color(zz));
                    GeneralPath gp = new GeneralPath(1, 6);
                    gp.moveTo(xx[i][j], yy[i][j]);
                    gp.lineTo(xx[i][j + 1], yy[i][j + 1]);
                    Arc2D.Double arc0 = new Arc2D.Double(x0 - r0x, y0 - r0y, r0x * 2.0, r0y * 2.0, Math.toDegrees(a0), Math.toDegrees(a1 - a0), 0);
                    gp.append(arc0.getPathIterator(null), true);
                    gp.lineTo(xx[i + 1][j + 1], yy[i + 1][j + 1]);
                    Arc2D.Double arc1 = new Arc2D.Double(x0 - r1x, y0 - r1y, r1x * 2.0, r1y * 2.0, Math.toDegrees(a1), Math.toDegrees(a0 - a1), 0);
                    gp.append(arc1.getPathIterator(null), true);
                    gp.lineTo(xx[i][j], yy[i][j]);
                    g.fill(gp);
                    g.draw(gp);
                }
            }
        }
        if (this.drawPolarAxes) {
            double xc1;
            double yc0;
            double xc0;
            Datum t;
            int i;
            Font f0 = g.getFont();
            g.setFont(f0.deriveFont((float)f0.getSize() / 2.0f));
            g.setColor(xAxis.getForeground());
            g.setStroke(new BasicStroke(0.4f));
            int dx = f0.getSize() / 6;
            DatumFormatter df = xAxis.getDatumFormatter();
            TickVDescriptor rr = xAxis.getTickV();
            DatumVector ticks = rr.tickV;
            Units u = ticks.getUnits();
            for (i = 0; i < ticks.getLength(); ++i) {
                t = ticks.get(i);
                if (!(t.doubleValue(ticks.getUnits()) > 0.0)) continue;
                xc0 = xAxis.transform(t.multiply(-1.0));
                yc0 = yAxis.transform(t);
                xc1 = xAxis.transform(t);
                double yc1 = yAxis.transform(t.multiply(-1.0));
                g.drawOval((int)xc0, (int)yc0, (int)(xc1 - xc0), (int)(yc1 - yc0));
                if (xAxis.isVisible()) continue;
                g.drawString(df.format(t, xAxis.getUnits()), (int)xc1 + dx, (int)y0 - dx);
                g.drawString(df.format(t, xAxis.getUnits()), (int)xc0 + dx, (int)y0 - dx);
            }
            ticks = rr.minorTickV;
            for (i = 0; i < ticks.getLength(); ++i) {
                t = ticks.get(i);
                if (!(t.doubleValue(ticks.getUnits()) > 0.0)) continue;
                xc0 = xAxis.transform(t.multiply(-1.0));
                yc0 = yAxis.transform(t);
                xc1 = xAxis.transform(t);
                double yc1 = yAxis.transform(t.multiply(-1.0));
                g.drawLine((int)xc0, (int)y0 - 1, (int)xc0, (int)(y0 + 1.0));
                g.drawLine((int)xc1, (int)y0 - 1, (int)xc1, (int)(y0 + 1.0));
                g.drawLine((int)x0 - 1, (int)yc0, (int)(x0 + 1.0), (int)yc0);
                g.drawLine((int)x0 - 1, (int)yc1, (int)(x0 + 1.0), (int)yc1);
            }
            g.setFont(f0);
            Datum rmax = ticks.get(0).abs();
            Datum rmax1 = ticks.get(ticks.getLength() - 1);
            if (rmax.lt(rmax1)) {
                rmax = rmax1;
            }
            for (int i2 = 0; i2 < 360; i2 += 30) {
                double xr0 = xAxis.transform(0.0, u);
                double yr0 = yAxis.transform(0.0, u);
                double xr1 = xAxis.transform(rmax.value() * Math.cos((double)i2 * Math.PI / 180.0), u);
                double yr1 = yAxis.transform(rmax.value() * Math.sin((double)i2 * Math.PI / 180.0), u);
                g.drawLine((int)xr0, (int)yr0, (int)xr1, (int)yr1);
            }
            if (this.originNorth) {
                Point2D.Double p1 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.transform(0.0, u));
                Point2D.Double p0 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.getRow().getDMinimum());
                Arrow.paintArrow(g, p0, p1, 10.0, Arrow.HeadStyle.DRAFTING);
            } else if (this.origin.length() > 0) {
                if (this.origin.equalsIgnoreCase("N")) {
                    Point2D.Double p1 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.transform(0.0, u));
                    Point2D.Double p0 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.getRow().getDMinimum());
                    Arrow.paintArrow(g, p0, p1, 10.0, Arrow.HeadStyle.DRAFTING);
                } else if (this.origin.equalsIgnoreCase("S")) {
                    Point2D.Double p1 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.transform(0.0, u));
                    Point2D.Double p0 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.getRow().getDMaximum());
                    Arrow.paintArrow(g, p0, p1, 10.0, Arrow.HeadStyle.DRAFTING);
                } else if (this.origin.equalsIgnoreCase("W")) {
                    Point2D.Double p1 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.transform(0.0, u));
                    Point2D.Double p0 = new Point2D.Double(xAxis.getColumn().getDMinimum(), yAxis.transform(0.0, u));
                    Arrow.paintArrow(g, p0, p1, 10.0, Arrow.HeadStyle.DRAFTING);
                } else if (this.origin.equalsIgnoreCase("E")) {
                    Point2D.Double p1 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.transform(0.0, u));
                    Point2D.Double p0 = new Point2D.Double(xAxis.getColumn().getDMaximum(), yAxis.transform(0.0, u));
                    Arrow.paintArrow(g, p0, p1, 10.0, Arrow.HeadStyle.DRAFTING);
                }
            } else {
                Point2D.Double p1 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.transform(0.0, u));
                Point2D.Double p0 = new Point2D.Double(xAxis.getColumn().getDMaximum(), yAxis.transform(0.0, u));
                Arrow.paintArrow(g, p0, p1, 10.0, Arrow.HeadStyle.DRAFTING);
            }
            if (!xAxis.isVisible()) {
                // empty if block
            }
        }
    }

    @Override
    protected void installRenderer() {
        DasPlot parent = this.getParent();
        if (parent != null && parent.getCanvas() != null && this.colorBar != null) {
            parent.getCanvas().add(this.colorBar, parent.getRow(), this.colorBar.getColumn());
        }
    }

    @Override
    protected void uninstallRenderer() {
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put(PROP_MIRROR, PitchAngleDistributionRenderer.encodeBooleanControl(this.mirror));
        controls.put(PROP_ORIGINNORTH, PitchAngleDistributionRenderer.encodeBooleanControl(this.originNorth));
        controls.put(PROP_DRAWPOLARAXES, PitchAngleDistributionRenderer.encodeBooleanControl(this.drawPolarAxes));
        if (this.origin.length() > 0 && this.origin.equalsIgnoreCase("E")) {
            controls.put(PROP_ORIGIN, this.origin);
            controls.remove(PROP_ORIGINNORTH);
        }
        if (this.clockwise) {
            controls.put(PROP_CLOCKWISE, "T");
        }
        return Renderer.formatControl(controls);
    }

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.mirror = this.getBooleanControl(PROP_MIRROR, false);
        this.originNorth = this.getBooleanControl(PROP_ORIGINNORTH, false);
        this.drawPolarAxes = this.getBooleanControl(PROP_DRAWPOLARAXES, false);
        this.origin = this.getControl(PROP_ORIGIN, "");
        this.clockwise = this.getBooleanControl(PROP_CLOCKWISE, false);
    }

    public boolean isOriginNorth() {
        return this.originNorth;
    }

    public void setOriginNorth(boolean originNorth) {
        boolean oldOriginNorth = this.originNorth;
        this.originNorth = originNorth;
        this.propertyChangeSupport.firePropertyChange(PROP_ORIGINNORTH, oldOriginNorth, originNorth);
        this.update();
    }

    public boolean isClockwise() {
        return this.clockwise;
    }

    public void setClockwise(boolean clockwise) {
        boolean oldClockwise = this.clockwise;
        this.clockwise = clockwise;
        this.propertyChangeSupport.firePropertyChange(PROP_CLOCKWISE, oldClockwise, clockwise);
        this.update();
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        String oldOrigin = this.origin;
        this.origin = origin;
        this.propertyChangeSupport.firePropertyChange(PROP_ORIGIN, oldOrigin, origin);
        this.update();
    }

    public boolean isDrawPolarAxes() {
        return this.drawPolarAxes;
    }

    public void setDrawPolarAxes(boolean drawPolarAxes) {
        boolean oldDrawPolarAxes = this.drawPolarAxes;
        this.drawPolarAxes = drawPolarAxes;
        this.propertyChangeSupport.firePropertyChange(PROP_DRAWPOLARAXES, oldDrawPolarAxes, drawPolarAxes);
        this.update();
    }

    public boolean isMirror() {
        return this.mirror;
    }

    public void setMirror(boolean mirror) {
        boolean oldMirror = this.mirror;
        this.mirror = mirror;
        this.propertyChangeSupport.firePropertyChange(PROP_MIRROR, oldMirror, mirror);
        this.update();
    }
}

