/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Graphics2D;
import java.awt.Point;
import org.das2.datum.Units;
import org.das2.graph.Arrow;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;

public class VectorPlotRenderer
extends Renderer {
    protected double scale = 1.0;
    public static final String PROP_SCALE = "scale";

    public static boolean acceptsData(QDataSet ds) {
        if (ds.rank() != 2) {
            return false;
        }
        return ds.length() == 0 || ds.length(0) == 4;
    }

    public static QDataSet doAutorange(QDataSet ds) {
        QDataSet xrange = VectorPlotRenderer.doRange(DataSetOps.unbundle((QDataSet)ds, (int)0), DataSetOps.unbundle((QDataSet)ds, (int)2));
        QDataSet yrange = VectorPlotRenderer.doRange(DataSetOps.unbundle((QDataSet)ds, (int)1), DataSetOps.unbundle((QDataSet)ds, (int)3));
        JoinDataSet bds = new JoinDataSet(2);
        bds.join(xrange);
        bds.join(yrange);
        return bds;
    }

    private static QDataSet doRange(QDataSet xds, QDataSet dxds) {
        double scale = 1.0;
        QDataSet xrange = Ops.extent((QDataSet)xds);
        MutablePropertyDataSet vxds = (MutablePropertyDataSet)Ops.multiply((QDataSet)dxds, (QDataSet)DataSetUtil.asDataSet((double)scale));
        vxds.putProperty("UNITS", xds.property("UNITS"));
        xrange = Ops.extent((QDataSet)Ops.add((QDataSet)xds, (QDataSet)vxds), (QDataSet)xrange);
        if (xrange.value(1) == xrange.value(0)) {
            xrange = !"log".equals(xrange.property("SCALE_TYPE")) ? DDataSet.wrap((double[])new double[]{xrange.value(0) - 1.0, xrange.value(1) + 1.0}).setUnits(SemanticOps.getUnits((QDataSet)xrange)) : DDataSet.wrap((double[])new double[]{xrange.value(0) / 10.0, xrange.value(1) * 10.0}).setUnits(SemanticOps.getUnits((QDataSet)xrange));
        }
        xrange = Ops.rescaleRangeLogLin((QDataSet)xrange, (double)-0.1, (double)1.1);
        xrange = Ops.rescaleRangeLogLin((QDataSet)xrange, (double)-0.1, (double)1.1);
        return xrange;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        double oldScale = this.scale;
        this.scale = scale;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_SCALE, oldScale, scale);
    }

    @Override
    public void render(Graphics2D g1, DasAxis xAxis, DasAxis yAxis) {
        Graphics2D g = g1;
        QDataSet lds = this.getDataSet();
        DasPlot parent = this.getParent();
        if (lds == null) {
            if (this.getLastException() != null) {
                this.renderException(g, xAxis, yAxis, this.lastException);
            } else {
                parent.postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
            }
            return;
        }
        if (lds.length() == 0) {
            parent.postException(this, new IllegalArgumentException("no data to plot"));
            return;
        }
        if (lds.rank() != 2 || lds.length(0) != 4) {
            parent.postException(this, new IllegalArgumentException("plot must be rank 2 and be of the form ds[:,4]"));
            return;
        }
        QDataSet x = DataSetOps.unbundle((QDataSet)lds, (int)0);
        QDataSet y = DataSetOps.unbundle((QDataSet)lds, (int)1);
        QDataSet dx = DataSetOps.unbundle((QDataSet)lds, (int)2);
        QDataSet dy = DataSetOps.unbundle((QDataSet)lds, (int)3);
        Units xunits = SemanticOps.getUnits((QDataSet)x);
        Units yunits = SemanticOps.getUnits((QDataSet)y);
        QDataSet wdx = SemanticOps.weightsDataSet((QDataSet)dx);
        QDataSet wdy = SemanticOps.weightsDataSet((QDataSet)dy);
        QDataSet wx = SemanticOps.weightsDataSet((QDataSet)x);
        QDataSet wy = SemanticOps.weightsDataSet((QDataSet)y);
        for (int i = 0; i < lds.length(); ++i) {
            if (wdx.value(i) * wdy.value(i) * wx.value(i) * wy.value(i) == 0.0) continue;
            double ix = xAxis.transform(x.value(i), xunits);
            double iy = yAxis.transform(y.value(i), yunits);
            double idx = xAxis.transform(x.value(i) + dx.value(i) * this.scale, xunits);
            double idy = yAxis.transform(y.value(i) + dy.value(i) * this.scale, yunits);
            Arrow.paintArrow(g, new Point((int)idx, (int)idy), new Point((int)ix, (int)iy), 10.0, Arrow.HeadStyle.DRAFTING);
        }
    }
}

