/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

import org.das2.math.RealPoint;
import org.das2.math.Vector;

class Circle {
    RealPoint c;
    float r;

    Circle() {
        this.c = new RealPoint();
        this.r = 0.0f;
    }

    Circle(RealPoint c, float r) {
        this.c = c;
        this.r = r;
    }

    public RealPoint center() {
        return this.c;
    }

    public float radius() {
        return this.r;
    }

    public void set(RealPoint c, float r) {
        this.c = c;
        this.r = r;
    }

    public boolean inside(RealPoint p) {
        return this.c.distanceSq(p) < this.r * this.r;
    }

    public void circumCircle(RealPoint p1, RealPoint p2, RealPoint p3) {
        float cp = Vector.crossProduct(p1, p2, p3);
        if ((double)cp != 0.0) {
            float p1Sq = p1.x() * p1.x() + p1.y() * p1.y();
            float p2Sq = p2.x() * p2.x() + p2.y() * p2.y();
            float p3Sq = p3.x() * p3.x() + p3.y() * p3.y();
            float num = p1Sq * (p2.y() - p3.y()) + p2Sq * (p3.y() - p1.y()) + p3Sq * (p1.y() - p2.y());
            float cx = num / (2.0f * cp);
            num = p1Sq * (p3.x() - p2.x()) + p2Sq * (p1.x() - p3.x()) + p3Sq * (p2.x() - p1.x());
            float cy = num / (2.0f * cp);
            this.c.set(cx, cy);
        }
        this.r = this.c.distance(p1);
    }
}

