/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.das2.DasException;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamProcessor;
import org.das2.stream.StreamTool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GUnzipStreamProcessor
extends StreamProcessor {
    @Override
    public void process(InputStream in0, OutputStream out) throws IOException {
        int bytesRead;
        PushbackInputStream in = new PushbackInputStream(in0);
        byte[] tag = new byte[4];
        boolean isCompressed = false;
        for (int offset = bytesRead = in.read(tag, 0, 4); bytesRead != -1 && offset < 4; offset += bytesRead) {
            bytesRead = in.read(tag, offset, 4 - offset);
        }
        if (!Arrays.equals(tag, "[00]".getBytes())) {
            throw new IOException("Expected [00], got " + new String(tag));
        }
        byte[] header = StreamTool.readXML(in);
        try {
            String compression;
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(header));
            Document document = StreamDescriptor.parseHeader(reader);
            Element docNode = document.getDocumentElement();
            if (!docNode.getAttribute("compression").equals("") && !(isCompressed = (compression = docNode.getAttribute("compression")).equals("gzip"))) {
                throw new IOException("unsupported compression used: " + compression);
            }
            docNode.setAttribute("compression", "none");
            header = StreamDescriptor.createHeader(document).getBytes();
            out.write("[00]".getBytes());
            out.write(header);
        }
        catch (DasException e) {
            out.write(this.getDasExceptionStream(e));
        }
        if (isCompressed) {
            in = new PushbackInputStream(new GZIPInputStream(in));
        }
        int ib = 0;
        byte[] buf = new byte[2048];
        while (ib != -1) {
            ib = in.read(buf);
            if (ib <= -1) continue;
            out.write(buf, 0, ib);
        }
    }

    public static void main(String[] args) {
        InputStream in = null;
        OutputStream out = null;
        if (args.length > 0) {
            try {
                in = new FileInputStream(args[0]);
            }
            catch (FileNotFoundException ex) {
                System.err.println("Input file not found");
                System.err.println("  file=" + args[0]);
                System.exit(-1);
            }
        } else {
            in = System.in;
        }
        if (args.length > 1) {
            try {
                out = new FileOutputStream(args[1]);
            }
            catch (FileNotFoundException ex) {}
        } else {
            out = System.out;
        }
        try {
            new GUnzipStreamProcessor().process(in, out);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

