/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.LoggerManager;
import org.das2.stream.SkeletonDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamScalarDescriptor;
import org.das2.stream.StreamTool;
import org.das2.stream.StreamXDescriptor;
import org.das2.stream.StreamYDescriptor;
import org.das2.stream.StreamYScanDescriptor;
import org.das2.stream.StreamZDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PacketDescriptor
implements Cloneable {
    private static Logger logger = LoggerManager.getLogger((String)"das2.d2s");
    private StreamXDescriptor xDescriptor;
    private SkeletonDescriptor[] yDescriptors = new SkeletonDescriptor[6];
    private int yCount = 0;
    private Map properties;
    private int id = -99;
    private static final Pattern LABEL_PATTERN = Pattern.compile("\\s*label\\((\\d+)\\)\\s*");

    public PacketDescriptor(Element element) throws StreamException {
        this(-99, element);
    }

    public PacketDescriptor(int id, Element element) throws StreamException {
        this.properties = new HashMap();
        this.id = id;
        if (element.getTagName().equals("packet")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    public int getId() {
        return this.id;
    }

    private void processElement(Element element) throws StreamException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Cloneable d;
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String name = child.getTagName();
            logger.log(Level.FINE, "process element type {0}", name);
            if (name.equals("x")) {
                this.xDescriptor = new StreamXDescriptor(child);
                continue;
            }
            if (name.equals("y")) {
                d = new StreamYDescriptor(child);
                this.addYDescriptor((SkeletonDescriptor)((Object)d));
                continue;
            }
            if (name.equals("z")) {
                d = new StreamZDescriptor(child);
                this.addYDescriptor((SkeletonDescriptor)((Object)d));
                continue;
            }
            if (name.equals("yscan")) {
                d = new StreamYScanDescriptor(child);
                this.addYDescriptor((SkeletonDescriptor)((Object)d));
                continue;
            }
            if (name.equals("properties")) {
                try {
                    NodeList list = element.getElementsByTagName("properties");
                    if (list.getLength() == 0) continue;
                    Element propertiesElement = (Element)list.item(0);
                    Map<String, Object> m = StreamTool.processPropertiesElement(propertiesElement);
                    this.properties.putAll(m);
                    continue;
                }
                catch (StreamException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!name.equals("qdataset")) continue;
            throw new StreamException("das2stream reader found that content appears to be qstream.");
        }
    }

    private void processLegacyElement(Element element) throws StreamException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Cloneable d;
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String name = child.getTagName();
            if (name.equals("X")) {
                this.xDescriptor = new StreamXDescriptor(child);
                continue;
            }
            if (name.equals("YScan")) {
                d = new StreamYScanDescriptor(child);
                this.addYDescriptor((SkeletonDescriptor)((Object)d));
                continue;
            }
            if (!name.equals("MultiY")) continue;
            d = new StreamScalarDescriptor(child);
            this.addYDescriptor((SkeletonDescriptor)((Object)d));
        }
    }

    public PacketDescriptor() {
    }

    public StreamXDescriptor getXDescriptor() {
        return this.xDescriptor;
    }

    public void setXDescriptor(StreamXDescriptor x) {
        this.xDescriptor = x;
    }

    public void addYDescriptor(SkeletonDescriptor y) {
        if (this.yCount == this.yDescriptors.length) {
            SkeletonDescriptor[] temp = new SkeletonDescriptor[this.yCount * 2];
            System.arraycopy(this.yDescriptors, 0, temp, 0, this.yCount);
            this.yDescriptors = temp;
        }
        this.yDescriptors[this.yCount] = y;
        ++this.yCount;
        HashMap<String, String> names = new HashMap<String, String>();
        for (int i = 0; i < this.yCount; ++i) {
            Object pp = this.yDescriptors[i].getProperty("name");
            if (pp == null && this.yDescriptors[i] instanceof StreamYScanDescriptor) {
                pp = ((StreamYScanDescriptor)this.yDescriptors[i]).getName();
            }
            if (pp == null && this.yDescriptors[i] instanceof StreamScalarDescriptor) {
                pp = ((StreamScalarDescriptor)this.yDescriptors[i]).getName();
            }
            if (names.containsKey(pp)) {
                throw new IllegalArgumentException("Das2 Stream Format error: Required Attribute 'name' missing in " + y + " plane.");
            }
            names.put((String)this.yDescriptors[i].getProperty("name"), (String)this.yDescriptors[i].getProperty("name"));
        }
    }

    public int getYCount() {
        return this.yCount;
    }

    public List getYDescriptors() {
        return Collections.unmodifiableList(Arrays.asList(this.yDescriptors).subList(0, this.yCount));
    }

    public SkeletonDescriptor getYDescriptor(int index) {
        if (index < 0 || index >= this.yCount) {
            throw new IndexOutOfBoundsException("index = " + index + ", yCount = " + this.yCount);
        }
        return this.yDescriptors[index];
    }

    public int getSizeBytes() {
        int sizeBytes = this.xDescriptor.getSizeBytes();
        for (int i = 0; i < this.yCount; ++i) {
            sizeBytes += this.yDescriptors[i].getSizeBytes();
        }
        return sizeBytes;
    }

    public DatumVector[] read(ByteBuffer input) {
        DatumVector[] vectors = new DatumVector[this.yCount + 1];
        vectors[0] = this.xDescriptor.read(input);
        for (int i = 0; i < this.yCount; ++i) {
            vectors[i + 1] = this.yDescriptors[i].read(input);
        }
        return vectors;
    }

    public void write(Datum xTag, DatumVector[] vectors, ByteBuffer output) {
        this.xDescriptor.writeDatum(xTag, output);
        for (int i = 0; i < this.yCount; ++i) {
            this.yDescriptors[i].write(vectors[i], output);
        }
        if (this.yDescriptors[this.yCount - 1] instanceof StreamYScanDescriptor && ((StreamYScanDescriptor)this.yDescriptors[this.yCount - 1]).getDataTransferType().isAscii() && Character.isWhitespace((char)output.get(output.position() - 1))) {
            output.put(output.position() - 1, (byte)10);
        } else if (this.yDescriptors[this.yCount - 1] instanceof StreamScalarDescriptor && ((StreamScalarDescriptor)this.yDescriptors[this.yCount - 1]).getDataTransferType().isAscii() && Character.isWhitespace((char)output.get(output.position() - 1))) {
            output.put(output.position() - 1, (byte)10);
        }
    }

    private static String trimComment(String line) {
        int index = line.indexOf(59);
        if (index == 0) {
            return "";
        }
        if (index != -1) {
            return line.substring(0, index);
        }
        return line;
    }

    public static PacketDescriptor createLegacyPacketDescriptor(Map dsdf) {
        PacketDescriptor packetDescriptor = new PacketDescriptor();
        packetDescriptor.setXDescriptor(new StreamXDescriptor());
        if (dsdf.get("form").equals("x_tagged_y_scan")) {
            StreamYScanDescriptor yscan = new StreamYScanDescriptor();
            yscan.setYCoordinates((double[])dsdf.get("y_coordinate"));
            packetDescriptor.addYDescriptor(yscan);
        } else if (dsdf.get("form").equals("x_multi_y") && dsdf.get("ny") != null) {
            StreamScalarDescriptor y = new StreamScalarDescriptor();
            packetDescriptor.addYDescriptor(y);
        } else if (dsdf.get("form").equals("x_multi_y") && dsdf.get("items") != null) {
            List planeList = (List)dsdf.get("plane-list");
            packetDescriptor.addYDescriptor(new StreamScalarDescriptor());
            for (int index = 0; index < planeList.size(); ++index) {
                StreamScalarDescriptor y = new StreamScalarDescriptor();
                y.setName((String)planeList.get(index));
                packetDescriptor.addYDescriptor(y);
            }
        }
        return packetDescriptor;
    }

    private static String[] ensureCapacity(String[] array, int capacity) {
        if (array == null) {
            return new String[capacity];
        }
        if (array.length >= capacity) {
            return array;
        }
        String[] temp = new String[capacity];
        System.arraycopy(array, 0, temp, 0, array.length);
        return temp;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("packet");
        element.appendChild(this.xDescriptor.getDOMElement(document));
        for (int i = 0; i < this.yCount; ++i) {
            element.appendChild(this.yDescriptors[i].getDOMElement(document));
        }
        return element;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object clone() {
        try {
            PacketDescriptor clone = (PacketDescriptor)super.clone();
            clone.xDescriptor = (StreamXDescriptor)this.xDescriptor.clone();
            clone.yDescriptors = new SkeletonDescriptor[this.yCount];
            for (int i = 0; i < this.yCount; ++i) {
                clone.yDescriptors[i] = (SkeletonDescriptor)this.yDescriptors[i].clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public String toString() {
        return "PacketDescriptor " + this.yCount + " ydescriptors";
    }
}

