/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.DatumVector;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.stream.DataTransferType;
import org.das2.stream.SkeletonDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamTool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StreamYScanDescriptor
implements SkeletonDescriptor,
Cloneable {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.d2s.yscan");
    private static final String[] g_sCkAry = new String[]{"name", "type", "nitems", "yTags", "yTagInterval", "yTagMin", "yTagMax"};
    private Units yUnits = Units.dimensionless;
    private Units zUnits = Units.dimensionless;
    private double[] yTags;
    private int nitems;
    private String name = "";
    private DataTransferType transferType = DataTransferType.SUN_REAL4;
    Map properties = new HashMap();
    private double[] values;

    public StreamYScanDescriptor(Element element) throws StreamException {
        if (element.getTagName().equals("yscan")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private double[] makeYtagsUsingInterval(Element element, int nItems, double rInterval) throws StreamException {
        String sMin = element.getAttribute("yTagMin");
        String sMax = element.getAttribute("yTagMax");
        double[] lYtags = new double[nItems];
        if (sMin.isEmpty() && sMax.isEmpty()) {
            for (int i = 0; i < nItems; ++i) {
                lYtags[i] = rInterval * (double)i;
            }
        } else if (sMax.isEmpty()) {
            double rMin = Double.parseDouble(sMin);
            for (int i = 0; i < nItems; ++i) {
                lYtags[i] = rInterval * (double)i + rMin;
            }
        } else {
            double rMax = Double.parseDouble(sMin);
            for (int i = 0; i < nItems; ++i) {
                lYtags[nItems - 1 - i] = rMax - rInterval * (double)i;
            }
        }
        return lYtags;
    }

    private void processElement(Element element) throws StreamException {
        String lname;
        String zUnitsString;
        DataTransferType type;
        int i;
        boolean doCheck = false;
        if (doCheck) {
            for (String s : g_sCkAry) {
                if (element.hasAttribute(s)) continue;
                throw new StreamException("Das2 Stream Format error: Required Attribute '" + s + "' missing in <" + element.getTagName() + "> plane.");
            }
            if (!element.hasAttribute("yUnits")) {
                logger.warning("required attribute yUnits is missing, using dimensionless.");
            }
            if (!element.hasAttribute("zUnits")) {
                logger.warning("required attribute zUnits is missing, using dimensionless.");
            }
        }
        this.nitems = Integer.parseInt(element.getAttribute("nitems"));
        if (this.nitems < 1) {
            throw new StreamException("yscan 'nitems' value is less than 1");
        }
        String yTagsText = element.getAttribute("yTags");
        if (yTagsText.length() > 0) {
            this.yTags = new double[this.nitems];
            String[] tokens = yTagsText.split("\\s*,\\s*");
            for (i = 0; i < this.nitems; ++i) {
                this.yTags[i] = Double.parseDouble(tokens[i]);
            }
        } else {
            String sInterval = element.getAttribute("yTagInterval");
            if (sInterval.length() > 0) {
                double rInterval = Double.parseDouble(sInterval);
                this.yTags = this.makeYtagsUsingInterval(element, this.nitems, rInterval);
            } else {
                this.yTags = new double[this.nitems];
                for (i = 0; i < this.nitems; ++i) {
                    this.yTags[i] = i;
                }
            }
        }
        String typeStr = element.getAttribute("type");
        this.transferType = type = DataTransferType.getByName(typeStr);
        String yUnitsString = element.getAttribute("yUnits");
        if (yUnitsString != null) {
            this.yUnits = Units.lookupUnits((String)yUnitsString);
        }
        if ((zUnitsString = element.getAttribute("zUnits")) != null) {
            this.zUnits = Units.lookupUnits((String)zUnitsString);
        }
        if ((lname = element.getAttribute("name")) != null) {
            this.name = lname;
        }
        NodeList nl = element.getElementsByTagName("properties");
        logger.log(Level.FINER, "element y has {0} properties", nl.getLength());
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            Element el = (Element)nl.item(i2);
            Map<String, Object> m = StreamTool.processPropertiesElement(el);
            for (String sPropName : m.keySet()) {
                for (String sReserved : g_sCkAry) {
                    if (!sPropName.equals(sReserved)) continue;
                    throw new StreamException("Can't use reserved property name '" + sReserved + "inside a <yscan> plane properties element.");
                }
            }
            this.properties.putAll(m);
        }
    }

    private void processLegacyElement(Element element) {
        try {
            DataTransferType type;
            if (!element.getTagName().equals("YScan")) {
                throw new IllegalArgumentException("xml tree root node is not the right type. Node type is: " + element.getTagName());
            }
            this.nitems = Integer.parseInt(element.getAttribute("nitems"));
            if (element.getAttribute("yCoordinate") != null) {
                String yCoordinateString = element.getAttribute("yCoordinate");
                this.yTags = new double[this.nitems];
                int parseIdx = 0;
                for (int i = 0; i < this.nitems - 1; ++i) {
                    int toIdx = yCoordinateString.indexOf(",", parseIdx) - 1;
                    this.yTags[i] = Double.parseDouble(yCoordinateString.substring(parseIdx, toIdx));
                    parseIdx = toIdx + 2;
                }
                this.yTags[this.nitems - 1] = Double.parseDouble(yCoordinateString.substring(parseIdx));
            }
            String typeStr = element.getAttribute("type");
            this.transferType = type = DataTransferType.getByName(typeStr);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Error in das2stream at yCoordinate");
        }
        this.name = element.getAttribute("name");
    }

    public StreamYScanDescriptor() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double[] getYTags() {
        return (double[])this.yTags.clone();
    }

    public void setYCoordinates(double[] yCoordinates) {
        this.yTags = (double[])yCoordinates.clone();
        this.nitems = yCoordinates.length;
    }

    public int getNItems() {
        return this.nitems;
    }

    public Units getYUnits() {
        return this.yUnits;
    }

    public Units getZUnits() {
        return this.zUnits;
    }

    public void setZUnits(Units units) {
        this.zUnits = units;
    }

    public void setYCoordinates(DatumVector yCoords) {
        this.yUnits = yCoords.getUnits();
        this.yTags = yCoords.toDoubleArray(this.yUnits);
        this.nitems = this.yTags.length;
    }

    public void setDataTransferType(DataTransferType transferType) {
        this.transferType = transferType;
    }

    public DataTransferType getDataTransferType() {
        return this.transferType;
    }

    @Override
    public int getSizeBytes() {
        return this.nitems * this.transferType.getSizeBytes();
    }

    @Override
    public DatumVector read(ByteBuffer input) {
        if (this.values == null) {
            this.values = new double[this.nitems];
        }
        for (int i = 0; i < this.nitems; ++i) {
            this.values[i] = this.transferType.read(input);
        }
        return DatumVector.newDatumVector((double[])this.values, (Units)this.zUnits);
    }

    @Override
    public void write(DatumVector input, ByteBuffer output) {
        this.values = input.toDoubleArray(this.values, this.zUnits);
        for (int i = 0; i < this.nitems; ++i) {
            this.transferType.write(this.values[i], output);
        }
    }

    @Override
    public Element getDOMElement(Document document) {
        Element element = document.createElement("yscan");
        element.setAttribute("nitems", String.valueOf(this.nitems));
        element.setAttribute("yTags", StreamYScanDescriptor.toString(this.yTags));
        element.setAttribute("yUnits", this.yUnits.toString());
        element.setAttribute("zUnits", this.zUnits.toString());
        element.setAttribute("type", this.transferType.toString());
        if (this.name != null && !this.name.equals("")) {
            element.setAttribute("name", this.name);
        }
        return element;
    }

    private static String toString(double[] d) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(d[0]);
        for (int i = 1; i < d.length; ++i) {
            buffer.append(", ").append(d[i]);
        }
        return buffer.toString();
    }

    @Override
    public Object clone() {
        try {
            StreamYScanDescriptor clone = (StreamYScanDescriptor)super.clone();
            clone.yTags = (double[])this.yTags.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public String toString() {
        return "<yScan nitems=" + this.nitems + ">";
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Map getProperties() {
        return new HashMap(this.properties);
    }
}

