/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream.test;

import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.stream.DataTransferType;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamProducer;
import org.das2.stream.StreamScalarDescriptor;
import org.das2.stream.StreamXDescriptor;

public class SineWaveStream {
    private double frequency = 0.1;
    private boolean compress;

    public SineWaveStream(boolean compress) {
        this.compress = compress;
    }

    public void produceSineWaveStream(WritableByteChannel out) {
        try {
            StreamProducer producer = new StreamProducer(out);
            StreamDescriptor sd = new StreamDescriptor();
            if (this.compress) {
                sd.setCompression("deflate");
            }
            producer.streamDescriptor(sd);
            int nx = 3600;
            StreamXDescriptor xDescriptor = new StreamXDescriptor();
            xDescriptor.setDataTransferType(DataTransferType.getByName("ascii24"));
            xDescriptor.setUnits(Units.seconds);
            xDescriptor.setBase(TimeUtil.createValid((String)"2000-001"));
            StreamScalarDescriptor y = new StreamScalarDescriptor();
            y.setDataTransferType(DataTransferType.getByName("ascii10"));
            PacketDescriptor pd = new PacketDescriptor();
            pd.setXDescriptor(xDescriptor);
            pd.addYDescriptor(y);
            producer.packetDescriptor(pd);
            double[] z = new double[1];
            DatumVector[] yValues = new DatumVector[1];
            for (int i = 0; i < nx; ++i) {
                Datum xTag = Datum.create((double)((double)i * 0.001), (Units)Units.seconds);
                z[0] = Math.sin(Math.PI * this.frequency * (double)i);
                yValues[0] = DatumVector.newDatumVector((double[])z, (Units)Units.dimensionless);
                producer.packet(pd, xTag, yValues);
            }
            producer.streamClosed(sd);
        }
        catch (StreamException se) {
            se.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        List<String> argList = Arrays.asList(args);
        boolean c = argList.contains("-c");
        WritableByteChannel out = Channels.newChannel(System.out);
        SineWaveStream rs = new SineWaveStream(c);
        rs.produceSineWaveStream(out);
    }
}

