/*
 * Decompiled with CFR 0.152.
 */
package org.das2.system;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.das2.event.DasUpdateEvent;

public final class EventQueueBlocker {
    private static final Logger logger = Logger.getLogger("das2.system");
    private static final Object lockObject = new Object();
    private static final Runnable clearEventQueueImmediatelyRunnable = new Runnable(){

        @Override
        public void run() {
            EventQueueBlocker.clearEventQueueImmediately();
        }
    };

    private EventQueueBlocker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearEventQueueImmediately() {
        Object object = lockObject;
        synchronized (object) {
            DasUpdateEvent evt = (DasUpdateEvent)Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent(46288);
            if (evt != null) {
                logger.log(Level.FINER, "pending update event: {0}", evt);
                EventQueue.invokeLater(clearEventQueueImmediatelyRunnable);
            } else {
                logger.finer("no update events found ");
                lockObject.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearEventQueue() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must not be called on the EventQueue");
        }
        Object object = lockObject;
        synchronized (object) {
            if (Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent(46288) != null) {
                EventQueue.invokeLater(clearEventQueueImmediatelyRunnable);
                logger.finer("waiting for lockObject to indicate eventQueue is clear");
                try {
                    lockObject.wait();
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            } else {
                logger.finer("no update events found, no runnable submitted ");
            }
        }
    }

    public static void dumpEventQueue(PrintStream out) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        LinkedList<AWTEvent> queue = new LinkedList<AWTEvent>();
        AWTEvent evt = null;
        Object result = null;
        while (eventQueue.peekEvent() != null) {
            try {
                evt = eventQueue.getNextEvent();
                out.println(String.format("%6d %s", evt.getID(), evt.toString()));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            queue.add(evt);
        }
        while (queue.size() > 0) {
            eventQueue.postEvent((AWTEvent)queue.remove());
        }
    }
}

