/*
 * Decompiled with CFR 0.152.
 */
package org.das2.system;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.DasApplication;
import org.das2.graph.DasCanvasComponent;
import org.das2.util.ExceptionHandler;
import org.das2.util.LoggerManager;

public final class RequestProcessor {
    private static final BlockingRequestQueue queue = new BlockingRequestQueue();
    private static final WeakHashMap runnableQueueMap = new WeakHashMap();
    private static final Runner runner = new Runner();
    private static final Runnable SHUTDOWN = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static int maxThreadCount = 8;
    private static int threadCount = 0;
    private static final Object THREAD_COUNT_LOCK = new Object();
    private static final Logger logger = LoggerManager.getLogger((String)"das2.system.requestprocessor");
    private static int threadOrdinal = 0;

    private RequestProcessor() {
    }

    public static void printStatus() {
        ArrayList c = new ArrayList(queue.list);
        System.err.println(String.format("== RequestProcessor (%d jobs) ==", c.size()));
        for (Object t : c) {
            System.err.println(t);
        }
        LinkedHashSet c2 = new LinkedHashSet();
        c2.addAll(runnableQueueMap.entrySet());
        System.err.println(String.format("== RequestProcessor runnableQueueMap (%d) ==", c2.size()));
        for (Object e : c2) {
            Map.Entry e2 = (Map.Entry)e;
            RunnableQueue q = (RunnableQueue)e2.getValue();
            ArrayList c3 = new ArrayList(q.list);
            System.err.println(String.format(" === (%d jobs) ===", c3.size()));
            for (Object t3 : c3) {
                System.err.println(t3);
            }
            System.err.println(e);
        }
    }

    private static void setJob(Runnable job) {
        RequestThread thread = (RequestThread)Thread.currentThread();
        thread.setJob(job);
    }

    private static void newThread() {
        String name = "RequestProcessor[" + threadOrdinal++ + "]";
        RequestThread t = new RequestThread(runner, name);
        t.setPriority(5);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(Runnable run) {
        logger.log(Level.FINE, "invokeLater {0}", String.valueOf(run));
        Object object = THREAD_COUNT_LOCK;
        synchronized (object) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        queue.add(run);
    }

    public static void setThreadCount(int t) {
        if (t < 4) {
            throw new IllegalArgumentException("must be at least 1");
        }
        if (t > 32) {
            throw new IllegalArgumentException("must be no more than 32");
        }
        maxThreadCount = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(Runnable run, Object lock) {
        logger.log(Level.FINE, "invokeLater {0} {1}", new Object[]{String.valueOf(run), lock});
        Object object = THREAD_COUNT_LOCK;
        synchronized (object) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        object = runnableQueueMap;
        synchronized (object) {
            RunnableQueue rq = (RunnableQueue)runnableQueueMap.get(lock);
            if (rq == null) {
                String name = lock instanceof DasCanvasComponent ? ((DasCanvasComponent)lock).getDasName() : lock.toString();
                rq = new RunnableQueue("RQ_" + name);
                runnableQueueMap.put(lock, rq);
            }
            rq.add(run, false);
            queue.add(rq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAfter(Runnable run, Object lock) {
        logger.log(Level.FINE, "invokeAfter {0} {1}", new Object[]{String.valueOf(run), lock});
        Object object = THREAD_COUNT_LOCK;
        synchronized (object) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        object = runnableQueueMap;
        synchronized (object) {
            RunnableQueue rq = (RunnableQueue)runnableQueueMap.get(lock);
            if (rq == null) {
                String name = lock instanceof DasCanvasComponent ? ((DasCanvasComponent)lock).getDasName() : lock.toString();
                rq = new RunnableQueue("RQ_" + name);
                runnableQueueMap.put(lock, rq);
            }
            rq.add(run, true);
            queue.add(rq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(Object lock) throws InterruptedException {
        WaitTask wt;
        WaitTask waitTask = wt = new WaitTask();
        synchronized (waitTask) {
            RequestProcessor.invokeLater(wt, lock);
            wt.wait();
            return;
        }
    }

    public static void shutdown() {
        queue.add(SHUTDOWN);
    }

    private static class BlockingRequestQueue {
        private LinkedList list = new LinkedList();

        BlockingRequestQueue() {
        }

        synchronized void add(Runnable r) {
            this.list.add(r);
            this.notify();
        }

        synchronized Runnable remove() {
            while (this.list.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return (Runnable)this.list.removeFirst();
        }
    }

    private static class RequestEntry {
        Runnable run;
        boolean async;

        private RequestEntry() {
        }
    }

    private static class RunnableQueue
    implements Runnable {
        private LinkedList list = new LinkedList();
        private int readCount = 0;
        private Object writer;
        private String name;

        private RunnableQueue(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RunnableQueue runnableQueue;
            Runnable run = null;
            RequestEntry entry = null;
            while (run == null) {
                runnableQueue = this;
                synchronized (runnableQueue) {
                    entry = (RequestEntry)this.list.getFirst();
                    if (entry.async && this.readCount == 0 && this.writer == null) {
                        this.list.removeFirst();
                        this.writer = entry;
                        run = entry.run;
                    } else if (!entry.async && this.writer == null) {
                        this.list.removeFirst();
                        ++this.readCount;
                        run = entry.run;
                    }
                }
            }
            logger.log(Level.FINE, "Starting :{0}", String.valueOf(run));
            assert (run != null);
            assert (entry != null);
            run.run();
            logger.log(Level.FINE, "Finished :{0}", String.valueOf(run));
            runnableQueue = this;
            synchronized (runnableQueue) {
                if (entry.async) {
                    this.writer = null;
                } else {
                    --this.readCount;
                }
                this.notifyAll();
            }
        }

        synchronized void add(Runnable run, boolean async) {
            RequestEntry entry = new RequestEntry();
            entry.run = run;
            entry.async = async;
            this.list.add(entry);
        }

        public String toString() {
            return "RunnableQueue[" + this.name + "]";
        }
    }

    private static class WaitTask
    implements Runnable {
        private WaitTask() {
        }

        @Override
        public synchronized void run() {
            this.notifyAll();
        }
    }

    private static class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object = THREAD_COUNT_LOCK;
            synchronized (object) {
                threadCount++;
            }
            try {
                while (true) {
                    try {
                        while (true) {
                            Runnable run;
                            if ((run = queue.remove()) == SHUTDOWN) {
                                queue.add(run);
                                return;
                            }
                            logger.log(Level.FINE, "running {0}", String.valueOf(run));
                            if (run != null) {
                                RequestProcessor.setJob(run);
                                run.run();
                                logger.log(Level.FINE, "completed {0}", String.valueOf(run));
                                run = null;
                            }
                            Object object2 = THREAD_COUNT_LOCK;
                            synchronized (object2) {
                                if (threadCount > maxThreadCount) {
                                    return;
                                }
                            }
                        }
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        logger.log(Level.INFO, "uncaught exception " + t.getMessage(), t);
                        ExceptionHandler eh = DasApplication.getDefaultApplication().getExceptionHandler();
                        eh.handleUncaught(t);
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
            }
            finally {
                object = THREAD_COUNT_LOCK;
                synchronized (object) {
                    threadCount--;
                }
            }
        }
    }

    private static class RequestThread
    extends Thread {
        private WeakReference job;

        private RequestThread(Runnable run, String name) {
            super(run, name);
        }

        private void setJob(Runnable job) {
            this.job = new WeakReference<Runnable>(job);
        }

        private Runnable getJob() {
            return (Runnable)this.job.get();
        }
    }
}

