/*
 * Decompiled with CFR 0.152.
 */
package test.datum;

import java.text.ParseException;
import java.util.List;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;

public class TestDatumRangeUtil {
    public static void main(String[] args) throws ParseException {
        TestDatumRangeUtil.testParse8601();
    }

    public static void testIntersection() {
        List list1 = DatumRangeUtil.generateList((DatumRange)DatumRangeUtil.parseTimeRangeValid((String)"2009"), (DatumRange)DatumRangeUtil.parseTimeRangeValid((String)"jan-2009"));
        List list2 = DatumRangeUtil.generateList((DatumRange)DatumRangeUtil.parseTimeRangeValid((String)"2008-12-1 to 2010-3-1"), (DatumRange)DatumRangeUtil.parseTimeRangeValid((String)"jan-2009-10"));
        List list3 = DatumRangeUtil.generateList((DatumRange)DatumRangeUtil.parseTimeRangeValid((String)"2009-6-1 to 2009-10-5"), (DatumRange)DatumRangeUtil.parseTimeRangeValid((String)"jan-2009-10"));
        list2.removeAll(list3);
        List r = DatumRangeUtil.intersection((List)list1, (List)list2, (boolean)true);
        System.err.println("containers: " + r);
        System.err.println("not contained: " + list2);
    }

    public static void testParse8601_1(String test, String ref) throws ParseException {
        DatumRange dr = DatumRangeUtil.parseISO8601Range((String)test);
        DatumRange drref = DatumRangeUtil.parseISO8601Range((String)ref);
        if (drref.equals((Object)dr)) {
            System.err.println(test);
        } else {
            System.err.println(test + " != " + ref + ", " + dr + "!=" + drref);
            dr = DatumRangeUtil.parseISO8601Range((String)test);
            drref = DatumRangeUtil.parseISO8601Range((String)ref);
        }
    }

    public static void testParse8601() throws ParseException {
        TestDatumRangeUtil.testParse8601_1("2000-01-01T13:00Z/PT1H", "2000-01-01T13:00Z/2000-01-01T14:00");
        TestDatumRangeUtil.testParse8601_1("20000101T1300Z/PT1H", "2000-01-01T13:00Z/2000-01-01T14:00");
        TestDatumRangeUtil.testParse8601_1("2000-01-01T00:00Z/P1D", "2000-01-01T00:00Z/2000-01-01T24:00");
        TestDatumRangeUtil.testParse8601_1("2007-03-01T13:00:00Z/P1Y2M10DT2H30M", "2007-03-01T13:00:00Z/2008-05-11T15:30:00Z");
        TestDatumRangeUtil.testParse8601_1("2007-03-01T13:00:00Z/2008-05-11T15:30:00Z", "2007-03-01T13:00:00Z/2008-05-11T15:30:00Z");
        TestDatumRangeUtil.testParse8601_1("P1Y2M10DT2H30M/2008-05-11T15:30:00Z", "2007-03-01T13:00:00Z/2008-05-11T15:30:00Z");
        TestDatumRangeUtil.testParse8601_1("2008-05-10/2008-05-11", "2008-05-10T00:00:00Z/2008-05-11T00:00:00Z");
        TestDatumRangeUtil.testParse8601_1("2008-009/2008-010", "2008-01-09T00:00:00Z/2008-01-10T00:00:00Z");
    }
}

