/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.graph.Customizer;
import org.das2.graph.CustomizerKey;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.qds.QDataSet;
import org.das2.qds.QFunction;
import org.das2.qds.ops.Ops;
import test.graph.QFunctionLarry;

public class SimpleDemo2 {
    public static void main(String[] args) throws ParseException {
        int width = 500;
        int height = 400;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        DasCanvas canvas = new DasCanvas(width, height);
        canvas.setAntiAlias(true);
        panel.add((Component)canvas, "Center");
        QDataSet yds = Ops.sin((QDataSet)Ops.linspace((double)0.0, (double)10.0, (int)1000));
        QDataSet tds = Ops.timegen((String)"2010-01-01T00:00", (String)"1 s", (int)1000);
        QDataSet ds = Ops.link((QDataSet)tds, (QDataSet)yds);
        final DasAxis xaxis = GraphUtil.guessXAxis(ds);
        DasAxis yaxis = GraphUtil.guessYAxis(ds);
        DasPlot.addCustomizer(CustomizerKey.of("myc"), new Customizer(){

            @Override
            public void customize(DasPlot plot) {
                JMenuItem newProps = new JMenuItem("Propertiez");
                newProps.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PropertyEditor newP = new PropertyEditor(xaxis);
                        newP.setListenForExternalChanges(true);
                        newP.showDialog(xaxis);
                    }
                });
                xaxis.getDasMouseInputAdapter().replaceMenuItem("Properties", newProps);
            }
        });
        DasPlot plot = new DasPlot(xaxis, yaxis);
        Renderer r = GraphUtil.guessRenderer(ds);
        plot.addRenderer(r);
        if (r instanceof SeriesRenderer) {
            ((SeriesRenderer)r).setAntiAliased(true);
        }
        xaxis.setTcaFunction((QFunction)new QFunctionLarry());
        xaxis.setDrawTca(true);
        canvas.add(plot, DasRow.create(canvas, null, "0%+2em", "100%-5em"), DasColumn.create(canvas, null, "0%+14em", "100%-4em"));
        JFrame frame = new JFrame();
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
    }
}

