/*
 * Decompiled with CFR 0.152.
 */
package test.graph.bugs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasPlot;
import org.das2.graph.GraphUtil;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;

public class DemoAPBug1129 {
    JPanel contentPane;
    private DasCanvas canvas;
    protected DasPlot plot;
    private DasColorBar cb;

    private synchronized JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
        }
        return this.contentPane;
    }

    public JFrame showFrame() {
        JFrame frame = new JFrame("Axis Demo");
        frame.getContentPane().add(this.getContentPane());
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        return frame;
    }

    public DemoAPBug1129() {
        int width = 400;
        int height = 200;
        LoggerManager.getLogger((String)"das2.graphics").setLevel(Level.FINER);
        MyHandler h = new MyHandler();
        h.setLevel(Level.ALL);
        LoggerManager.getLogger((String)"das2.graphics").addHandler(h);
        this.getContentPane().setLayout(new BorderLayout());
        this.canvas = new DasCanvas(width, height);
        this.getContentPane().add((Component)this.canvas, "Center");
        DatumRange xrange = DatumRange.newDatumRange((double)-5.0, (double)35.0, (Units)Units.dimensionless);
        DatumRange yrange = DatumRange.newDatumRange((double)-5.0, (double)35.0, (Units)Units.dimensionless);
        DatumRange zrange = DatumRange.newDatumRange((double)-0.2, (double)1.2, (Units)Units.dimensionless);
        this.cb = new DasColorBar(zrange.min(), zrange.max(), false);
        this.plot = GraphUtil.newDasPlot(this.canvas, xrange, yrange);
        this.canvas.add(this.cb, this.plot.getRow(), this.plot.getColumn().createAttachedColumn(1.05, 1.1));
        this.plot.setPreviewEnabled(true);
        this.plot.addRenderer(new SpectrogramRenderer(null, this.cb));
        SeriesRenderer r = new SeriesRenderer();
        r.setAntiAliased(true);
        r.setColor(Color.WHITE);
        this.plot.addRenderer(r);
        this.plot.getColumn().setEmMaximum(-10.0);
    }

    private void writeImage(int j, char a) {
        try {
            this.canvas.waitUntilIdle(true);
            this.canvas.writeToPng(String.format("/tmp/ap/%05d%s.png", j, Character.valueOf(a)));
        }
        catch (IOException ex) {
            Logger.getLogger(DemoAPBug1129.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DemoAPBug1129.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private ArrayDataSet getDataSet() {
        ArrayDataSet ds = ArrayDataSet.copy((QDataSet)Ops.replicate((double)0.5, (int)30, (int)30));
        for (int i = 0; i < 30; ++i) {
            ds.putValue(i, i, 0.0);
        }
        return ds;
    }

    private void initalize() {
        ArrayDataSet ds = this.getDataSet();
        this.plot.getRenderer(0).setDataSet((QDataSet)ds);
        this.plot.getRenderer(1).setDataSet(Ops.link((Object)new double[]{3.0, 15.0}, (Object)new double[]{3.0, 15.0}));
    }

    private void stressIt() {
        ArrayDataSet ds = this.getDataSet();
        DatumRange xr1 = DatumRangeUtil.rescale((DatumRange)this.plot.getXAxis().getDatumRange(), (double)-0.02, (double)0.98);
        this.plot.getColumn().setMinimum(0.1);
        this.plot.getColumn().setMaximum(0.9);
        DatumRange xr2 = DatumRangeUtil.rescale((DatumRange)this.plot.getXAxis().getDatumRange(), (double)0.02, (double)1.02);
        if (new File("/tmp/ap/").exists() && !FileUtil.deleteFileTree((File)new File("/tmp/ap/"))) {
            throw new RuntimeException("unable to delete old tree");
        }
        if (!new File("/tmp/ap/").mkdirs()) {
            throw new RuntimeException("mkdirs");
        }
        int j = 0;
        while (true) {
            this.plot.getColumn().setMinimum(0.1);
            this.plot.getColumn().setMaximum(0.9);
            this.plot.getXAxis().setDatumRange(xr1);
            this.writeImage(j, 'a');
            if (this.canvas.broken != null) {
                // empty if block
            }
            this.plot.getXAxis().setDatumRange(xr2);
            this.plot.getColumn().setMinimum(0.12);
            this.plot.getColumn().setMaximum(0.92);
            this.writeImage(j, 'b');
            if (this.canvas.broken != null) {
                // empty if block
            }
            if (++j % 900 != 0) continue;
            ds = this.getDataSet();
        }
    }

    public static void main(String[] args) {
        DemoAPBug1129 app = new DemoAPBug1129();
        app.showFrame();
        app.initalize();
        app.stressIt();
    }

    private class MyHandler
    extends Handler {
        private MyHandler() {
        }

        @Override
        public void publish(LogRecord rec) {
            Object[] parms = rec.getParameters();
            String recMsg = parms == null || parms.length == 0 ? rec.getMessage() : MessageFormat.format(rec.getMessage(), parms);
            System.err.println(recMsg);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

