/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.aggregator;

import org.autoplot.aggregator.AggregatingDataSource;
import org.das2.DasException;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.TableDataSetAdapter;
import org.das2.dataset.VectorDataSetAdapter;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.qds.QDataSet;
import org.das2.util.monitor.ProgressMonitor;

public class DataSetDescriptorAdapter
extends DataSetDescriptor {
    AggregatingDataSource source;

    public DataSetDescriptorAdapter(AggregatingDataSource source) {
        this.source = source;
    }

    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        this.source.setViewRange(new DatumRange(start, end));
        try {
            QDataSet ds = this.source.getDataSet(monitor);
            if (ds.rank() == 1) {
                return VectorDataSetAdapter.create((QDataSet)ds);
            }
            return TableDataSetAdapter.create((QDataSet)ds);
        }
        catch (Exception e) {
            throw new DasException(e.getMessage());
        }
    }

    public Units getXUnits() {
        return Units.us2000;
    }
}

