/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.InputVerifier;
import org.das2.util.LoggerManager;

public class RecentComboBox
extends JComboBox {
    private static final int RECENT_SIZE = 20;
    File bookmarksFolder = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks");
    File recentFile;
    String preferenceNode = "";
    boolean dirty = false;
    public static final String PREF_NODE_TIMERANGE = "timerange";
    private static final Logger logger = org.das2.datum.LoggerManager.getLogger((String)"apdss.uri.recent");
    InputVerifier verifier = null;

    public RecentComboBox() {
        this.setEditable(true);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && RecentComboBox.this.preferenceNode.length() > 0) {
                    logger.finer("set dirty=true");
                    RecentComboBox.this.dirty = true;
                }
            }
        });
    }

    public void setPreferenceNode(String pref) {
        this.preferenceNode = pref;
        this.recentFile = new File(this.bookmarksFolder, "recent." + pref + ".txt");
        this.dirty = false;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                RecentComboBox.this.loadRecent();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(run, "loadRecent-" + this.preferenceNode).start();
        } else {
            run.run();
        }
    }

    public void setVerifier(InputVerifier v) {
        this.verifier = v;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setText(String text) {
        logger.log(Level.FINER, "setText({0})", text);
        this.setSelectedItem(text);
        this.dirty = false;
    }

    public String getText() {
        String s;
        Object o = this.getSelectedItem();
        String string = s = o == null ? "" : o.toString();
        if (s == null) {
            return "";
        }
        if (this.dirty) {
            this.addToRecent(s);
        }
        logger.log(Level.FINER, "getText()->{0}", s);
        return s;
    }

    private void loadRecent() {
        logger.log(Level.FINER, "loadRecent()");
        ArrayList<String> items = new ArrayList<String>(22);
        try {
            if (this.recentFile != null && this.recentFile.exists()) {
                boolean empty = true;
                try (BufferedReader r = new BufferedReader(new FileReader(this.recentFile));){
                    String s = r.readLine();
                    while (s != null) {
                        if (this.verifier != null && !this.verifier.verify(s)) {
                            s = r.readLine();
                            continue;
                        }
                        empty = false;
                        items.add(s);
                        s = r.readLine();
                    }
                }
                if (empty && !this.recentFile.delete()) {
                    logger.fine("unable to remove empty file");
                }
            }
            Collections.reverse(items);
            ArrayList<String> nitems = new ArrayList<String>(items.size());
            for (String item : items) {
                if (nitems.contains(item)) continue;
                nitems.add(item);
            }
            items = nitems;
            final ArrayList<String> fitems = items;
            int n = items.size();
            if (n > 20) {
                items = items.subList(0, 20);
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    Object s = RecentComboBox.this.getModel().getSelectedItem();
                    DefaultComboBoxModel<Object> newModel = new DefaultComboBoxModel<Object>(fitems.toArray());
                    newModel.setSelectedItem(s);
                    RecentComboBox.this.setModel(newModel);
                }
            };
            SwingUtilities.invokeLater(run);
            this.saveRecent(items);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void addAdditionalToRecentItems(List<String> items) {
        ComboBoxModel mm = this.getModel();
        if (mm instanceof DefaultComboBoxModel) {
            DefaultComboBoxModel dmm = (DefaultComboBoxModel)mm;
            for (int i = 0; i < items.size(); ++i) {
                String item = items.get(i);
                dmm.insertElementAt(item, i);
            }
        }
    }

    private void saveRecent(List<String> items) {
        File recentFileTemp;
        logger.log(Level.FINER, "saveRecent({0} items)", items.size());
        if (this.recentFile == null || !this.bookmarksFolder.exists()) {
            return;
        }
        boolean empty = true;
        try {
            recentFileTemp = File.createTempFile("recent." + this.preferenceNode, ".txt", this.bookmarksFolder);
        }
        catch (IOException ex) {
            logger.warning(ex.getMessage());
            return;
        }
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new FileWriter(recentFileTemp));
            items = new ArrayList<String>(items);
            Collections.reverse(items);
            for (String s : items) {
                w.append(s, 0, s.length());
                w.append("\n");
                empty = false;
            }
            w.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (this.recentFile.exists() && !this.recentFile.delete()) {
            logger.log(Level.WARNING, "unable to delete recent file {0}", this.recentFile);
        } else if (empty) {
            recentFileTemp.delete();
        } else if (!recentFileTemp.renameTo(this.recentFile)) {
            logger.log(Level.WARNING, "unable to overwrite file {0}", this.recentFile);
        }
    }

    public void addToRecent(String s) {
        this.addToRecent(s, true);
    }

    public void addToRecent(final String s, final boolean reload) {
        logger.log(Level.FINE, "addToRecent({0})", s);
        if (this.verifier != null && !this.verifier.verify(s)) {
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ArrayList<String> items = new ArrayList<String>();
                if (RecentComboBox.this.recentFile != null) {
                    try (BufferedReader r = new BufferedReader(new FileReader(RecentComboBox.this.recentFile));){
                        String l;
                        while ((l = r.readLine()) != null) {
                            items.add(items.size(), l);
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, null, ex);
                    }
                }
                items.add(s);
                Collections.reverse(items);
                RecentComboBox.this.saveRecent(items);
                if (reload) {
                    RecentComboBox.this.loadRecent();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(run, "addToRecent-" + this.preferenceNode).start();
        } else {
            run.run();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LoggerManager.logGuiEvent((ActionEvent)e);
        super.actionPerformed(e);
        String s = this.getSelectedItem().toString();
        this.addToRecent(s);
    }

    public static void main(String[] args) {
        JOptionPane.showConfirmDialog(null, new RecentComboBox());
    }
}

