/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.aggregator.AggregatingDataSourceFactory;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.capability.Streaming;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeUtil;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class RecordIterator
implements Iterator<QDataSet> {
    int index;
    int lastIndex = -1;
    QDataSet src = null;
    Iterator<QDataSet> streamingIterator = null;
    private DatumRange depend0Constraint = null;
    QDataSet nextRecord = null;
    QDataSet sortDataSet = null;
    private static final Logger logger = Logger.getLogger("apdss.recordIterator");

    private QDataSet getDataSet(String suri, DatumRange timeRange, ProgressMonitor monitor) throws URISyntaxException, Exception {
        Streaming streaming;
        logger.log(Level.FINE, "getDataSet(\"{0}\",DatumRangeUtil.parseTimeRange({1}),monitor)", new Object[]{suri, timeRange});
        URI uri = DataSetURI.getURI(suri);
        DataSourceFactory factory = DataSetURI.getDataSourceFactory(uri, (ProgressMonitor)new NullProgressMonitor());
        if (factory == null) {
            throw new IllegalArgumentException("no data source factory found for URI: " + uri);
        }
        TimeSeriesBrowse tsb = factory.getCapability(TimeSeriesBrowse.class);
        if (tsb != null) {
            tsb.setURI(suri);
            tsb.setTimeRange(timeRange);
            uri = new URI(tsb.getURI());
        }
        DataSource result = factory.getDataSource(uri);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((streaming = result.getCapability(Streaming.class)) != null) {
            logger.fine("this data could be streamed");
        }
        if ((tsb = result.getCapability(TimeSeriesBrowse.class)) != null) {
            tsb.setTimeRange(timeRange);
        } else {
            logger.fine("TimeSeriesBrowse capability not found, simply returning dataset.");
        }
        QDataSet rds = result.getDataSet(monitor);
        if (rds == null && factory instanceof AggregatingDataSourceFactory) {
            logger.info("strange condition where occasional null is returned because of reference caching.  This needs to be studied more.");
            monitor = new NullProgressMonitor();
            monitor.setLabel("strange condition where occasional null...");
            rds = result.getDataSet(monitor);
        }
        return rds;
    }

    public RecordIterator(String suri, DatumRange timeRange) throws Exception {
        this(suri, timeRange, true);
    }

    public RecordIterator(String suri, DatumRange timeRange, boolean allowStream) throws Exception {
        DataSource result;
        Streaming streaming;
        URI uri = DataSetURI.getURI(suri);
        DataSourceFactory factory = DataSetURI.getDataSourceFactory(uri, (ProgressMonitor)new NullProgressMonitor());
        if (factory == null) {
            throw new IllegalArgumentException("no data source factory found for URI: " + uri);
        }
        DatumRange timeRangeExt = new DatumRange(TimeUtil.prev((int)5, (Datum)timeRange.min()), TimeUtil.next((int)5, (Datum)timeRange.max()));
        TimeSeriesBrowse tsb = factory.getCapability(TimeSeriesBrowse.class);
        if (tsb != null) {
            tsb.setURI(suri);
            tsb.setTimeRange(timeRangeExt);
            uri = new URI(tsb.getURI());
        }
        if ((streaming = (result = factory.getDataSource(uri)).getCapability(Streaming.class)) != null && allowStream) {
            this.streamingIterator = streaming.streamDataSet((ProgressMonitor)new NullProgressMonitor());
        } else {
            QDataSet ds = this.getDataSet(uri.toString(), timeRangeExt, (ProgressMonitor)new NullProgressMonitor());
            if (ds == null) {
                this.index = 0;
                this.lastIndex = 0;
                return;
            }
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
            if (dep0 != null) {
                if (ds.rank() == 1) {
                    this.src = Ops.bundle((QDataSet)dep0, (QDataSet)ds);
                } else if (ds.rank() == 2) {
                    int i;
                    QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
                    this.src = Ops.bundle(null, (QDataSet)dep0);
                    for (i = 0; i < ds.length(0); ++i) {
                        this.src = Ops.bundle((QDataSet)this.src, (QDataSet)Ops.unbundle((QDataSet)ds, (int)i));
                    }
                    if (dep1 != null && dep1.rank() == 2) {
                        for (i = 0; i < dep1.length(0); ++i) {
                            this.src = Ops.bundle((QDataSet)this.src, (QDataSet)Ops.unbundle((QDataSet)dep1, (int)i));
                        }
                    }
                } else if (ds.rank() > 2) {
                    int i;
                    int[] qube = DataSetUtil.qubeDims((QDataSet)ds.slice(0));
                    QDataSet dep2 = (QDataSet)ds.property("DEPEND_2");
                    if (dep2 != null && dep2.rank() == 3) {
                        dep2 = Ops.reform((QDataSet)dep2, (int)dep2.length(), (int[])new int[]{DataSetUtil.product((int[])qube)});
                    }
                    ds = Ops.reform((QDataSet)ds, (int)ds.length(), (int[])new int[]{DataSetUtil.product((int[])qube)});
                    this.src = Ops.bundle((QDataSet)dep0, (QDataSet)Ops.slice1((QDataSet)ds, (int)0));
                    for (i = 1; i < ds.length(0); ++i) {
                        this.src = Ops.bundle((QDataSet)this.src, (QDataSet)Ops.slice1((QDataSet)ds, (int)i));
                    }
                    if (dep2 != null && dep2.rank() > 1) {
                        this.src = Ops.bundle((QDataSet)this.src, (QDataSet)Ops.slice1((QDataSet)dep2, (int)0));
                        for (i = 1; i < dep2.length(0); ++i) {
                            this.src = Ops.bundle((QDataSet)this.src, (QDataSet)Ops.slice1((QDataSet)dep2, (int)i));
                        }
                    }
                }
            } else {
                this.src = ds;
            }
        }
    }

    public final void constrainDepend0(DatumRange dr) {
        if (this.src == null) {
            this.depend0Constraint = dr;
            if (this.streamingIterator != null) {
                if (this.streamingIterator.hasNext()) {
                    logger.finer("advancing streamingIterator to first record");
                    this.nextRecord = this.streamingIterator.next();
                    this.nextRecord = RecordIterator.normalize(this.nextRecord);
                    QDataSet dep0 = this.nextRecord.slice(0);
                    while (DataSetUtil.asDatum((QDataSet)dep0).lt(dr.min()) && this.streamingIterator.hasNext()) {
                        this.nextRecord = this.streamingIterator.next();
                        this.nextRecord = RecordIterator.normalize(this.nextRecord);
                        dep0 = this.nextRecord.slice(0);
                    }
                    if (this.depend0Constraint == null || DataSetUtil.asDatum((QDataSet)dep0).ge(this.depend0Constraint.max())) {
                        this.nextRecord = null;
                    }
                    this.index = -1;
                } else {
                    logger.finer("have streamingIterator, but hasNext()=false");
                }
            } else {
                logger.finer("not streaming, src=null");
                this.nextRecord = null;
            }
            return;
        }
        logger.finer("src does not equal null");
        if (this.src.length() == 0) {
            return;
        }
        this.index = 0;
        this.lastIndex = this.src.length();
        QDataSet dep0 = Ops.slice1((QDataSet)this.src, (int)0);
        if (dep0.length() == 1) {
            Datum d = Ops.datum((Object)dep0.slice(0));
            if (d.ge(dr.min()) && d.lt(dr.max())) {
                this.index = 0;
                this.lastIndex = 1;
            } else if (d.lt(dr.min())) {
                this.index = 0;
                this.lastIndex = 0;
            } else if (d.ge(dr.max())) {
                this.index = 1;
                this.lastIndex = 1;
            }
        } else if (DataSetUtil.isMonotonic((QDataSet)dep0)) {
            QDataSet findeces = Ops.findex((Object)dep0, (Object)dr);
            this.index = (int)Math.ceil(findeces.value(0));
            this.lastIndex = (int)Math.ceil(findeces.value(1));
            this.index = Math.max(0, this.index);
            this.lastIndex = Math.min(this.src.length(), this.lastIndex);
        } else {
            throw new IllegalArgumentException("data dep0 is not monotonic");
        }
    }

    public final void resortFields(int[] sort) {
        if (this.src != null) {
            this.src = DataSetOps.applyIndex((QDataSet)this.src, (int)1, (QDataSet)Ops.dataset((Object)sort), (boolean)true);
        } else if (this.streamingIterator != null) {
            this.sortDataSet = Ops.dataset((Object)sort);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.streamingIterator != null) {
            return this.nextRecord != null;
        }
        return this.index < this.lastIndex;
    }

    private static QDataSet normalize(QDataSet result) {
        QDataSet dep0 = (QDataSet)result.property("CONTEXT_0");
        if (dep0 != null) {
            switch (result.rank()) {
                case 0: {
                    result = Ops.bundle((QDataSet)dep0, (QDataSet)result);
                    break;
                }
                case 1: {
                    QDataSet d = Ops.bundle((QDataSet)dep0, (QDataSet)result.slice(0));
                    for (int j = 1; j < result.length(); ++j) {
                        d = Ops.bundle((QDataSet)d, (QDataSet)result.slice(j));
                    }
                    result = d;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("rank>2 streaming not supported");
                }
            }
        }
        return result;
    }

    @Override
    public QDataSet next() {
        if (this.streamingIterator != null) {
            QDataSet result = this.nextRecord;
            if (this.sortDataSet != null) {
                result = DataSetOps.applyIndex((QDataSet)result, (int)0, (QDataSet)this.sortDataSet, (boolean)true);
            }
            if (this.streamingIterator.hasNext()) {
                QDataSet nextRecord1 = this.streamingIterator.next();
                nextRecord1 = RecordIterator.normalize(nextRecord1);
                QDataSet dep0 = nextRecord1.slice(0);
                this.nextRecord = this.depend0Constraint == null || DataSetUtil.asDatum((QDataSet)dep0).lt(this.depend0Constraint.max()) ? nextRecord1 : null;
            } else {
                this.nextRecord = null;
            }
            return result;
        }
        return this.src.slice(this.index++);
    }

    @Override
    public void remove() {
    }

    public static QDataSet collect(Iterator<QDataSet> qds) {
        DataSetBuilder b;
        QDataSet rec = qds.next();
        DataSetBuilder dep0b = new DataSetBuilder(1, 100);
        switch (rec.rank()) {
            case 0: {
                b = new DataSetBuilder(1, 100);
                break;
            }
            case 1: {
                b = new DataSetBuilder(2, 100, rec.length());
                break;
            }
            case 2: {
                b = new DataSetBuilder(2, 100, rec.length(), rec.length(0));
                break;
            }
            case 3: {
                b = new DataSetBuilder(2, 100, rec.length(), rec.length(0), rec.length(1));
                break;
            }
            default: {
                throw new IllegalArgumentException("bad rank");
            }
        }
        b.nextRecord(rec);
        QDataSet dep0 = (QDataSet)rec.property("CONTEXT_0");
        if (dep0 != null) {
            dep0b.nextRecord();
        }
        while (qds.hasNext()) {
            rec = qds.next();
            b.nextRecord(rec);
            dep0 = (QDataSet)rec.property("CONTEXT_0");
            if (dep0 == null) continue;
            dep0b.nextRecord();
        }
        DDataSet result = b.getDataSet();
        if (dep0b.getLength() > 0) {
            result.putProperty("DEPEND_0", (Object)dep0b.getDataSet());
        }
        return result;
    }
}

