/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.ui;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import org.autoplot.datasource.ui.TableRowHeader;

public class Util {
    private Util() {
    }

    public static boolean isRowHeaderVisible(JTable table) {
        JScrollPane scrollPane;
        JViewport rowHeaderViewPort;
        Container gp;
        Container p = table.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane && (rowHeaderViewPort = (scrollPane = (JScrollPane)gp).getRowHeader()) != null) {
            return rowHeaderViewPort.getView() != null;
        }
        return false;
    }

    public static void removeRowHeader(JTable table) {
        Container gp;
        Container p = table.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            scrollPane.setRowHeader(null);
        }
    }

    public static void setRowHeader(JTable table) {
        Container gp;
        Container p = table.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            scrollPane.setRowHeaderView(new TableRowHeader(table));
        }
    }

    public static void makeJTextFieldLookLikeJLabel(JTextField tf) {
        tf.setEditable(false);
        tf.setOpaque(false);
        tf.setBorder(null);
    }

    public static void enableComponents(Container container, boolean enabled, Component exclude) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            if (component == exclude) continue;
            component.setEnabled(enabled);
            if (!(component instanceof Container)) continue;
            Util.enableComponents((Container)component, enabled, exclude);
        }
    }
}

