/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dods;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import opendap.dap.BaseType;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DArray;
import opendap.dap.DDS;
import opendap.dap.DDSException;
import opendap.dap.DGrid;
import opendap.dap.DSequence;
import opendap.dap.DefaultFactory;
import opendap.dap.NoSuchVariableException;
import opendap.dap.Server.InvalidParameterException;
import opendap.dap.parser.DDSParser;
import opendap.dap.parser.ParseException;

public class MyDDSParser {
    DDS myDDS;

    public void parse(InputStream in) throws ParseException, DDSException {
        DDSParser p = new DDSParser(in);
        this.myDDS = new DDS();
        DefaultFactory factory = new DefaultFactory();
        p.Dataset(this.myDDS, (BaseTypeFactory)factory);
    }

    public int[] getRecDims(String variable) throws NoSuchVariableException {
        BaseType t = this.myDDS.getVariable(variable);
        if (t instanceof DSequence) {
            return null;
        }
        if (t instanceof DGrid) {
            return null;
        }
        DArray darray = (DArray)t;
        int[] result = new int[darray.numDimensions()];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = darray.getDimension(i).getStop();
                continue;
            }
            catch (InvalidParameterException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    String[] getVariableNames() {
        Enumeration en = this.myDDS.getVariables();
        ArrayList<String> result = new ArrayList<String>();
        while (en.hasMoreElements()) {
            BaseType bt = (BaseType)en.nextElement();
            result.add(bt.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    String[] getDepends(String var) throws NoSuchVariableException, InvalidParameterException {
        BaseType bt = this.myDDS.getVariable(var);
        ArrayList<String> result = new ArrayList<String>();
        if (bt instanceof DArray) {
            DArray a = (DArray)bt;
            for (int i = 0; i < a.numDimensions(); ++i) {
                String n = a.getDimension(i).getName();
                result.add(n);
            }
            if (result.size() > 0 && ((String)result.get(0)).equals(var)) {
                return null;
            }
            return result.toArray(new String[result.size()]);
        }
        if (bt instanceof DGrid) {
            DGrid g = (DGrid)bt;
            Enumeration e = g.getVariables();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o instanceof DArray) {
                    DArray a = (DArray)o;
                    result.add(a.getName());
                    continue;
                }
                result.add(null);
            }
            if (result.size() > 0 && ((String)result.get(0)).equals(var)) {
                return result.subList(1, result.size()).toArray(new String[result.size() - 1]);
            }
            return result.toArray(new String[result.size()]);
        }
        return null;
    }
}

