/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DefaultTimeSeriesBrowse;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.Caching;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.hapi.AbstractLineReader;
import org.autoplot.hapi.Connection;
import org.autoplot.hapi.HapiServer;
import org.autoplot.hapi.HapiUtil;
import org.autoplot.hapi.InputStreamBinaryRecordReader;
import org.autoplot.hapi.SingleFileBufferedReader;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.SparseDataSetBuilder;
import org.das2.qds.WritableDataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.qstream.TransferType;
import org.das2.util.ColorUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.HttpUtil;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class HapiDataSource
extends AbstractDataSource {
    protected static final Logger logger = LoggerManager.getLogger((String)"apdss.hapi");
    protected static final Logger loggerUrl = LoggerManager.getLogger((String)"das2.url");
    private static final String WARNING_TIME_MALFORMED = "time malformed";
    private static final String WARNING_TIME_ORDER = "time out-of-order";
    TimeSeriesBrowse tsb;
    public static final double FILL_VALUE = -1.0E38;
    private static final Map<String, Datum> lastRecordFound = new HashMap<String, Datum>();
    private static final Map<String, ArrayList<ByteBuffer>> binaryCache = new ConcurrentHashMap<String, ArrayList<ByteBuffer>>();
    private static final Map<String, ArrayList<String>> csvCache = new ConcurrentHashMap<String, ArrayList<String>>();
    Map<Datum, Color> lookupColorCache = new HashMap<Datum, Color>();

    public HapiDataSource(URI uri) {
        super(uri);
        this.tsb = new DefaultTimeSeriesBrowse();
        String str = (String)this.params.get("timerange");
        if (str != null) {
            try {
                this.tsb.setURI(uri.toString());
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.addCapability(TimeSeriesBrowse.class, this.tsb);
        this.addCapability(Caching.class, new Caching(){

            public boolean satisfies(String surl) {
                return false;
            }

            public void resetURI(String surl) {
            }

            public void reset() {
                logger.fine("reset cache");
                csvCache.clear();
            }
        });
    }

    private static QDataSet getJSONBins(JSONObject binsObject) throws JSONException {
        Object uo;
        boolean foundTimeVarying = false;
        JSONArray bins = null;
        if (binsObject.has("values")) {
            logger.fine("using deprecated bins");
            bins = binsObject.getJSONArray("values");
        } else if (binsObject.has("centers") && (bins = binsObject.optJSONArray("centers")) == null) {
            logger.info("time-varying centers are not supported, yet");
            foundTimeVarying = true;
        }
        JSONArray ranges = null;
        if (binsObject.has("ranges") && (ranges = binsObject.optJSONArray("ranges")) == null) {
            logger.info("time-varying ranges are not supported, yet");
            foundTimeVarying = true;
        }
        if (ranges == null && bins == null) {
            if (foundTimeVarying) {
                logger.info("time-varying detected, not supported yet");
                return null;
            }
            throw new IllegalArgumentException("ranges or centers must be specified");
        }
        int len = ranges == null ? bins.length() : ranges.length();
        DDataSet result = DDataSet.createRank1((int)len);
        DDataSet max = DDataSet.createRank1((int)len);
        DDataSet min = DDataSet.createRank1((int)len);
        boolean hasMin = false;
        boolean hasMax = false;
        boolean hasCenter = false;
        if (len == 0) {
            throw new IllegalArgumentException("bins must have ranges or centers specified");
        }
        if (bins != null) {
            int j;
            hasCenter = true;
            Object o = bins.get(0);
            if (o instanceof Number) {
                for (j = 0; j < len; ++j) {
                    result.putValue(j, bins.getDouble(j));
                }
            } else if (o instanceof JSONObject) {
                for (j = 0; j < len; ++j) {
                    JSONObject jo = bins.getJSONObject(j);
                    result.putValue(j, jo.getDouble("center"));
                    if (hasMin || jo.has("min")) {
                        hasMin = true;
                        min.putValue(j, jo.getDouble("min"));
                    }
                    if (!hasMax && !jo.has("max")) continue;
                    hasMax = true;
                    max.putValue(j, jo.getDouble("max"));
                }
            }
        }
        if (ranges != null) {
            for (int j = 0; j < len; ++j) {
                JSONArray ja1 = ranges.getJSONArray(j);
                hasMax = true;
                hasMin = true;
                min.putValue(j, ja1.getDouble(0));
                max.putValue(j, ja1.getDouble(1));
            }
        }
        if (binsObject.has("units") && (uo = binsObject.get("units")) instanceof String) {
            String sunits = (String)uo;
            Units u = Units.lookupUnits((String)sunits);
            result.putProperty("UNITS", (Object)u);
            if (hasMin && hasMax) {
                min.putProperty("UNITS", (Object)u);
                max.putProperty("UNITS", (Object)u);
            }
        }
        if (hasCenter) {
            if (hasMin && hasMax) {
                result.putProperty("BIN_MIN", (Object)min);
                result.putProperty("BIN_MAX", (Object)max);
            } else if (hasMin || hasMax) {
                logger.warning("need both min and max for bins.");
            }
        } else {
            result = (DDataSet)ArrayDataSet.copy(Double.TYPE, (QDataSet)Ops.bundle((QDataSet)min, (QDataSet)max));
            result.putProperty("BINS_1", (Object)"min,max");
            result.putProperty("UNITS", min.property("UNITS"));
        }
        if (binsObject.has("name")) {
            result.putProperty("NAME", (Object)binsObject.getString("name"));
        }
        if (binsObject.has("description")) {
            result.putProperty("TITLE", (Object)binsObject.getString("description"));
            result.putProperty("LABEL", (Object)binsObject.getString("description"));
        }
        return result;
    }

    private JSONObject maybeGetDiffResolutionInfo(String id) {
        try {
            URL url = HapiServer.createURL(this.resourceURI.toURL(), "semantics");
            String s = HapiServer.readFromURL(url, "json");
            JSONObject o = new JSONObject(s);
            JSONArray a = o.optJSONArray("cadenceVariants");
            if (a != null) {
                for (int i = 0; i < a.length(); ++i) {
                    JSONObject jo2;
                    Object o1 = a.get(i);
                    if (!(o1 instanceof JSONObject) || !(jo2 = (JSONObject)o1).optString("groupId", "").equals(id)) continue;
                    String sourceId = jo2.getString("sourceId");
                    return this.getInfo(sourceId);
                }
            }
            return null;
        }
        catch (JSONException ex) {
            Logger.getLogger(HapiDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HapiDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private JSONObject getInfo(String id) throws MalformedURLException, IOException, JSONException {
        URI server = this.resourceURI;
        if (id.equals("")) {
            throw new IllegalArgumentException("missing id");
        }
        id = URLDecoder.decode(id, "UTF-8");
        JSONArray jo = HapiServer.getCatalog(server.toURL());
        for (int i = 0; i < jo.length(); ++i) {
            JSONObject jo1 = jo.getJSONObject(i);
            if (!jo1.get("id").equals(id)) continue;
            return HapiServer.getInfo(server.toURL(), id);
        }
        JSONObject r = this.maybeGetDiffResolutionInfo(id);
        if (r == null) {
            throw new IllegalArgumentException("Bad id: " + id);
        }
        return r;
    }

    private static URL replaceTimeRangeURL(URL url, DatumRange tr, String vers) {
        try {
            URISplit split = URISplit.parse((URI)url.toURI());
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            String smin = tr.min().toString();
            String smax = tr.max().toString();
            if (smin.endsWith("00:00:00.000Z")) {
                smin = smin.substring(0, smin.length() - 14) + "T00:00Z";
            }
            if (smax.endsWith("00:00:00.000Z")) {
                smax = smax.substring(0, smax.length() - 14) + "T00:00Z";
            }
            if (vers.startsWith("1.") || vers.startsWith("2.")) {
                params.put("time.min", smin);
                params.put("time.max", smax);
            } else {
                params.put("start", smin);
                params.put("stop", smax);
            }
            split.params = URISplit.formatParams((Map)params);
            String surl = URISplit.format((URISplit)split);
            url = new URL(surl);
            return url;
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void printCacheStats() {
        if (csvCache == null || csvCache.isEmpty()) {
            System.err.println("(cache is empty)");
        } else {
            for (Map.Entry<String, ArrayList<String>> entry : csvCache.entrySet()) {
                System.err.println("" + entry.getKey() + ": " + entry.getValue().size() + " records");
            }
        }
        if (binaryCache == null || binaryCache.isEmpty()) {
            System.err.println("(cache is empty)");
        } else {
            for (Map.Entry<String, ArrayList<Object>> entry : binaryCache.entrySet()) {
                System.err.println("" + entry.getKey() + ": " + entry.getValue().size() + " records");
            }
        }
    }

    public static String getHapiCache() {
        String hapiCache = System.getProperty("HAPI_DATA");
        if (hapiCache != null) {
            String home = System.getProperty("user.home");
            if (hapiCache.contains("${HOME}")) {
                hapiCache = hapiCache.replace("${HOME}", home);
            } else if (hapiCache.contains("%{HOME}")) {
                hapiCache = hapiCache.replace("%{HOME}", home);
            }
        }
        if (hapiCache != null && hapiCache.contains("\\")) {
            hapiCache = hapiCache.replaceAll("\\\\", "/");
        }
        if (hapiCache == null) {
            String s = AutoplotSettings.settings().resolveProperty("fscache");
            if (s.endsWith("/")) {
                s = s.substring(0, s.length() - 1);
            }
            hapiCache = s + "/hapi/";
        }
        if (!hapiCache.endsWith("/")) {
            hapiCache = hapiCache + "/";
        }
        if (!hapiCache.endsWith("/")) {
            throw new IllegalArgumentException("hapiCache must end with /");
        }
        if (HapiServer.useCache() && !new File(hapiCache).exists() && !new File(hapiCache).mkdirs()) {
            logger.log(Level.WARNING, "unable to mkdir directories {0}", hapiCache);
        }
        return hapiCache;
    }

    private QDataSet getDataSetCDAWeb(ProgressMonitor monitor) throws Exception {
        JSONObject o;
        URI server = this.resourceURI;
        String id = this.getParam("id", "");
        if (id.equals("")) {
            throw new IllegalArgumentException("missing id");
        }
        id = URLDecoder.decode(id, "UTF-8");
        String pp = this.getParam("parameters", "");
        if (!pp.equals("") && !pp.startsWith("Epoch,")) {
            pp = "Epoch," + pp;
        }
        if (id.equals("")) {
            throw new IllegalArgumentException("missing id");
        }
        id = URLDecoder.decode(id, "UTF-8");
        DatumRange tr = this.tsb.getTimeRange();
        URL url = HapiServer.getDataURL(server.toURL(), id, tr, pp);
        url = new URL(url.toString() + "&include=header&format=json1");
        monitor.started();
        monitor.setProgressMessage("server is preparing data");
        long t0 = System.currentTimeMillis() - 100L;
        int lineNum = 0;
        StringBuilder builder = new StringBuilder();
        logger.log(Level.FINE, "getDocument {0}", url.toString());
        loggerUrl.log(Level.FINE, "GET {0}", new Object[]{url});
        HttpURLConnection httpConnect = (HttpURLConnection)url.openConnection();
        httpConnect.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
        httpConnect.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
        httpConnect = (HttpURLConnection)HttpUtil.checkRedirect((URLConnection)httpConnect);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(httpConnect.getInputStream(), HapiServer.UTF8));){
            String line = in.readLine();
            ++lineNum;
            while (line != null) {
                if (System.currentTimeMillis() - t0 > 100L) {
                    monitor.setProgressMessage("reading line " + lineNum);
                    t0 = System.currentTimeMillis();
                }
                builder.append(line);
                line = in.readLine();
            }
        }
        catch (IOException ex) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileSystemUtil.copyStream((InputStream)httpConnect.getErrorStream(), (OutputStream)baos, (ProgressMonitor)new NullProgressMonitor());
            String s = baos.toString("UTF-8");
            if (s.contains("No data available")) {
                logger.log(Level.FINE, "No data available, server responded with {0}: {1}", new Object[]{httpConnect.getResponseCode(), httpConnect.getResponseMessage()});
                throw new NoDataInIntervalException("No data available");
            }
            if (s.length() < 256) {
                throw new IOException(ex.getMessage() + ": " + s);
            }
            throw ex;
        }
        httpConnect.disconnect();
        JSONObject doc = o = new JSONObject(builder.toString());
        ParamDescription[] pds = HapiDataSource.getParameterDescriptions(doc);
        monitor.setProgressMessage("parsing data");
        int[] nfields = new int[pds.length];
        for (int i = 0; i < pds.length; ++i) {
            nfields[i] = pds[i].size.length == 0 || pds[i].size.length == 1 && pds[i].size[0] == 1 ? 1 : DataSetUtil.product((int[])pds[i].size);
        }
        boolean[] timeVary = new boolean[pds.length];
        QDataSet result = null;
        int ipd = 0;
        for (ParamDescription pd : pds) {
            JSONArray param;
            try {
                param = doc.getJSONArray(pd.name);
            }
            catch (JSONException ex) {
                timeVary[ipd] = false;
                continue;
            }
            timeVary[ipd] = true;
            Units u = pd.units;
            if (nfields[ipd] > 1) {
                int nf = nfields[ipd];
                DDataSet column = DDataSet.createRank2((int)param.length(), (int)nfields[ipd]);
                for (int i = 0; i < param.length(); ++i) {
                    JSONObject jo = param.getJSONObject(i);
                    JSONArray joa = jo.getJSONArray("elements");
                    for (int j = 0; j < nf; ++j) {
                        column.putValue(i, j, u.parse(joa.getString(j)).doubleValue(u));
                    }
                }
                if (pd.hasFill) {
                    column.putProperty("FILL_VALUE", (Object)pd.fillValue);
                }
                column.putProperty("TITLE", (Object)pd.description);
                column.putProperty("UNITS", (Object)pd.units);
                for (int j = 0; j < nf; ++j) {
                    result = Ops.bundle((QDataSet)result, (QDataSet)Ops.slice1((QDataSet)column, (int)j));
                }
            } else {
                DDataSet column = DDataSet.createRank1((int)param.length());
                for (int i = 0; i < param.length(); ++i) {
                    column.putValue(i, u.parse(param.getString(i)).doubleValue(u));
                }
                if (pd.hasFill) {
                    column.putProperty("FILL_VALUE", (Object)pd.fillValue);
                }
                column.putProperty("TITLE", (Object)pd.description);
                column.putProperty("UNITS", (Object)pd.units);
                result = Ops.bundle((QDataSet)result, (QDataSet)column);
            }
            ++ipd;
        }
        monitor.finished();
        int ntimeVary = 0;
        for (boolean b : timeVary) {
            if (!b) continue;
            ++ntimeVary;
        }
        ParamDescription[] newPds = new ParamDescription[ntimeVary];
        int k = 0;
        for (int j = 0; j < pds.length; ++j) {
            if (!timeVary[j]) continue;
            newPds[k++] = pds[j];
        }
        int[] sort = null;
        result = this.repackage(result, newPds, sort);
        return result;
    }

    private static int indexOfParameter(ParamDescription[] pds, String name) {
        for (int i = 0; i < pds.length; ++i) {
            if (!pds[i].name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    private String join(String delim, List<String> pieces) {
        if (pieces.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder(pieces.get(0));
        for (int i = 1; i < pieces.size(); ++i) {
            b.append(delim);
            b.append(pieces.get(i));
        }
        return b.toString();
    }

    private Color lookupColor(Map<Pattern, Color> lookup, Datum d) {
        Color c = this.lookupColorCache.get(d);
        if (c != null) {
            return c;
        }
        for (Map.Entry<Pattern, Color> e : lookup.entrySet()) {
            Pattern p = e.getKey();
            if (!p.matcher(d.toString()).matches()) continue;
            this.lookupColorCache.put(d, e.getValue());
            break;
        }
        return Color.GRAY;
    }

    public synchronized QDataSet getDataSet(ProgressMonitor monitor) throws Exception {
        QDataSet xds;
        Units u;
        JSONObject paramInfo;
        QDataSet ds;
        URI server = this.resourceURI;
        String[] format = this.getParam("format", "csv");
        String serverStr = server.toString();
        if (format.equals("json1") || serverStr.startsWith("http://cdaweb") && serverStr.endsWith("gsfc.nasa.gov/registry/hdp/hapi")) {
            return this.getDataSetCDAWeb(monitor);
        }
        monitor.setTaskSize(100L);
        monitor.started();
        monitor.setProgressMessage("reading info");
        String id = this.getParam("id", "");
        if (id.equals("")) {
            throw new IllegalArgumentException("missing id");
        }
        id = URLDecoder.decode(id, "UTF-8");
        String pp = this.getParam("parameters", "");
        if (pp.contains("%2C")) {
            pp = URLDecoder.decode(pp, "UTF-8");
        }
        JSONObject info = this.getInfo(id);
        info = HapiUtil.resolveRefs(info);
        String vers = info.getString("HAPI");
        monitor.setProgressMessage("got info");
        monitor.setTaskProgress(20L);
        ParamDescription[] pds = HapiDataSource.getParameterDescriptions(info);
        DatumRange tr = this.tsb.getTimeRange();
        if (tr == null) {
            throw new IllegalArgumentException("timerange is missing");
        }
        Datum cadence = null;
        if (info.has("cadence")) {
            try {
                Datum t;
                int[] ii = DatumRangeUtil.parseISO8601Duration((String)info.getString("cadence"));
                cadence = t = TimeUtil.toDatumDuration((int[])ii);
                tr = new DatumRange(tr.min().subtract(cadence), tr.max().add(cadence));
            }
            catch (ParseException ex) {
                logger.log(Level.WARNING, "unable to parse cadence as ISO8601 duration: {0}", info.getString("cadence"));
            }
        }
        String timeStampLocation = "CENTER";
        if (info.has("timeStampLocation")) {
            timeStampLocation = info.getString("timeStampLocation");
        }
        JSONArray parametersArray = info.getJSONArray("parameters");
        int nparam = parametersArray.length();
        if (pp.length() > 0) {
            int i;
            CharSequence[] pps = pp.split(",");
            for (int i2 = 0; i2 < pps.length; ++i2) {
                if (i2 == 0 && (pps[i2].equals("Time") || pps[i2].equals("time"))) {
                    pps[i2] = parametersArray.getJSONObject(0).getString("name");
                }
                pps[i2] = pps[i2].replace("+", " ");
                pps[i2] = pps[i2].replaceAll("\\%2B", "+");
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i3 = 0; i3 < nparam; ++i3) {
                map.put(parametersArray.getJSONObject(i3).getString("name"), i3);
            }
            if (!pps[0].equals(parametersArray.getJSONObject(0).getString("name"))) {
                pp = parametersArray.getJSONObject(0).getString("name") + "," + pp;
                pps = pp.split(",");
            }
            pp = String.join((CharSequence)",", pps);
            ArrayList<String> namesNotFound = new ArrayList<String>();
            ParamDescription[] subsetPds = new ParamDescription[pps.length];
            for (int ip = 0; ip < pps.length; ++ip) {
                Integer ii = (Integer)map.get(pps[ip]);
                if (ii == null) {
                    namesNotFound.add((String)pps[ip]);
                    continue;
                }
                i = (Integer)map.get(pps[ip]);
                subsetPds[ip] = pds[i];
            }
            if (namesNotFound.size() == 1) {
                throw new IllegalArgumentException("Parameter name not found: " + namesNotFound.get(0));
            }
            if (namesNotFound.size() > 1) {
                throw new IllegalArgumentException("Parameter names not found: " + this.join(",", namesNotFound));
            }
            if (subsetPds.length == 2 && subsetPds[1].size.length > 0) {
                Object dependName = null;
                String[] dependNames = null;
                if (subsetPds[1].dependName != null) {
                    dependNames = new String[subsetPds[1].dependName.length];
                    for (i = 0; i < subsetPds[1].dependName.length; ++i) {
                        dependNames[i] = subsetPds[1].dependName[i];
                    }
                } else {
                    logger.warning("depend name missing!");
                }
                if (dependNames != null) {
                    int i4;
                    ArrayList<ParamDescription> subsetPds1 = new ArrayList<ParamDescription>();
                    for (i4 = 0; i4 < subsetPds.length; ++i4) {
                        subsetPds1.add(subsetPds[i4]);
                    }
                    for (i4 = 0; i4 < dependNames.length; ++i4) {
                        if (dependNames[i4] == null) continue;
                        int k = HapiDataSource.indexOfParameter(pds, dependNames[i4]);
                        if (k == -1) {
                            logger.log(Level.WARNING, "unable to find parameter: {0}", (Object)dependName);
                            continue;
                        }
                        subsetPds1.add(pds[k]);
                        pp = pp + "," + dependNames[i4];
                    }
                    subsetPds = subsetPds1.toArray(new ParamDescription[subsetPds1.size()]);
                }
            }
            pds = subsetPds;
            nparam = pds.length;
        }
        DatumRange startStopDate = null;
        try {
            startStopDate = DatumRangeUtil.parseTimeRange((String)(info.getString("startDate") + "/" + info.getString("stopDate")));
            if (!tr.intersects(startStopDate)) {
                if (tr.max().lt(startStopDate.min())) {
                    throw new NoDataInIntervalException("info startDate (" + info.getString("startDate") + ") is after requested time range (" + tr + ")");
                }
                throw new NoDataInIntervalException("info stopDate (" + info.getString("stopDate") + ") is before requested time range (" + tr + ")");
            }
            tr = DatumRangeUtil.sloppyIntersection((DatumRange)tr, (DatumRange)startStopDate);
        }
        catch (ParseException ex) {
            logger.log(Level.INFO, "unable to parse startDate/stopDate: {0}", ex.getMessage());
        }
        catch (NullPointerException ex) {
            logger.info("startDate and stopDate was missing");
        }
        URL url = HapiServer.getDataURL(server.toURL(), id, tr, pp);
        if (!format.equals("csv")) {
            url = new URL(url + "&format=" + (String)format);
        }
        logger.log(Level.FINE, "getDataSet {0}", url.toString());
        int[] nfields = new int[nparam];
        for (int i = 0; i < nparam; ++i) {
            nfields[i] = pds[i].size.length == 0 || pds[i].size.length == 1 && pds[i].size[0] == 1 ? 1 : DataSetUtil.product((int[])pds[i].size);
        }
        int totalFields = DataSetUtil.sum((int[])nfields);
        switch (format) {
            case "binary": {
                ds = HapiDataSource.getDataSetViaBinary(totalFields, monitor, url, pds, tr, nparam, nfields, this.getParam("cache", ""));
                break;
            }
            case "json": {
                ds = HapiDataSource.getDataSetViaJSON(totalFields, monitor, url, pds, tr, nparam, nfields);
                break;
            }
            default: {
                boolean useCache = HapiDataSource.useCache(this.getParam("cache", ""));
                if (useCache) {
                    logger.finer("useCache, so make daily requests to form granules");
                    Datum minMidnight = TimeUtil.prevMidnight((Datum)tr.min());
                    Datum maxMidnight = TimeUtil.nextMidnight((Datum)tr.max());
                    tr = new DatumRange(minMidnight, maxMidnight);
                    tr = DatumRangeUtil.sloppyIntersection((DatumRange)tr, (DatumRange)startStopDate);
                    Datum midnight = TimeUtil.prevMidnight((Datum)tr.min());
                    DatumRange currentDay = new DatumRange(midnight, TimeUtil.next((int)3, (Datum)midnight));
                    QDataSet dsall = null;
                    int nday = (int)Math.ceil(tr.width().doubleValue(Units.days));
                    if (nday > 1) {
                        monitor.setTaskSize((long)(nday * 10));
                        monitor.started();
                    }
                    int iday = 0;
                    while (currentDay.min().le(tr.max())) {
                        logger.log(Level.FINER, "useCache, request {0}", currentDay);
                        ProgressMonitor mon1 = nday == 1 ? monitor : monitor.getSubtaskMonitor(10 * iday, 10 * (iday + 1), "read " + currentDay);
                        try {
                            URL url1;
                            QDataSet ds1;
                            DatumRange oneDaysRange = DatumRangeUtil.sloppyIntersection((DatumRange)currentDay, (DatumRange)startStopDate);
                            if (oneDaysRange.width().value() > 0.0 && (ds1 = HapiDataSource.getDataSetViaCsv(totalFields, mon1, url1 = HapiDataSource.replaceTimeRangeURL(url, oneDaysRange, vers), pds, oneDaysRange, nparam, nfields, this.getParam("cache", ""))).length() > 0) {
                                dsall = Ops.append(dsall, (QDataSet)ds1);
                            }
                        }
                        catch (NoDataInIntervalException ex) {
                            if (!FileSystem.settings().isOffline()) {
                                throw ex;
                            }
                            logger.log(Level.FINE, "no granule found for day, but we are offline: {0}", currentDay);
                        }
                        currentDay = currentDay.next();
                        ++iday;
                    }
                    if (dsall == null) {
                        logger.info("no records found");
                        return null;
                    }
                    logger.finer("done useCache, so make daily requests to form granules");
                    ds = dsall;
                    ds = Ops.putProperty((QDataSet)ds, (String)"UNITS", null);
                    break;
                }
                ds = HapiDataSource.getDataSetViaCsv(totalFields, monitor, url, pds, tr, nparam, nfields, this.getParam("cache", ""));
            }
        }
        if (ds.length() == 0) {
            monitor.finished();
            throw new NoDataInIntervalException("no records found");
        }
        if ((ds = this.repackage(ds, pds, null)).rank() == 1 && pds.length > 1 && pds[1].units instanceof EnumerationUnits && cadence != null && (paramInfo = pds[1].parameter).has("x_colorLookup")) {
            JSONObject colorLookup = paramInfo.getJSONObject("x_colorLookup");
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
            QDataSet dep0Min = Ops.subtract((Object)dep0, (Object)cadence.divide(2.0));
            QDataSet dep0Max = Ops.add((Object)dep0, (Object)cadence.divide(2.0));
            IDataSet colors = IDataSet.createRank1((int)ds.length());
            Iterator iter = colorLookup.keys();
            HashMap<Pattern, Color> pelookUp = new HashMap<Pattern, Color>();
            while (iter.hasNext()) {
                String k = (String)iter.next();
                try {
                    Pattern p = Pattern.compile(k);
                    pelookUp.put(p, ColorUtil.decodeColor((String)colorLookup.getString(k)));
                }
                catch (PatternSyntaxException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            EnumerationUnits eu = (EnumerationUnits)pds[1].units;
            for (int i = 0; i < ds.length(); ++i) {
                Datum d = eu.createDatum((Object)ds.slice(i).svalue());
                Color c = this.lookupColor(pelookUp, d);
                colors.putValue(i, (double)c.getRGB());
            }
            ds = Ops.bundle((QDataSet)dep0Min, (QDataSet)dep0Max, (QDataSet)colors, (QDataSet)ds);
        }
        if ((u = (Units)ds.property("UNITS")) != null && u.toString().trim().length() > 0) {
            String l = (String)ds.property("LABEL");
            ds = l == null ? Ops.putProperty((QDataSet)ds, (String)"LABEL", (Object)"%{UNITS}") : Ops.putProperty((QDataSet)ds, (String)"LABEL", (Object)(l.trim() + " (%{UNITS})"));
        }
        if ((xds = (QDataSet)ds.property("DEPEND_0")) == null && UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)ds))) {
            xds = ds;
        }
        if (!Schemes.isEventsList((QDataSet)ds) && timeStampLocation.equalsIgnoreCase("BEGIN") || timeStampLocation.equalsIgnoreCase("END")) {
            if (cadence == null) {
                cadence = DataSetUtil.asDatum((RankZeroDataSet)DataSetUtil.guessCadenceNew((QDataSet)xds, null));
            }
            if (cadence != null) {
                if (timeStampLocation.equalsIgnoreCase("BEGIN")) {
                    xds = Ops.add((Object)xds, (Object)cadence.divide(2.0));
                } else if (timeStampLocation.equalsIgnoreCase("END")) {
                    xds = Ops.subtract((Object)xds, (Object)cadence.divide(2.0));
                }
            } else {
                logger.info("timetags are identified as BEGIN, but cadence was not available to center the data");
            }
        }
        if (xds != null) {
            ((MutablePropertyDataSet)xds).putProperty("CACHE_TAG", (Object)new CacheTag(tr, null));
        }
        monitor.setTaskProgress(100L);
        monitor.finished();
        return ds;
    }

    private static boolean useCache(String useCacheUriParam) {
        boolean useCache = HapiServer.useCache();
        String cacheParam = useCacheUriParam;
        if (cacheParam.equals("F")) {
            useCache = false;
        }
        return useCache;
    }

    private static AbstractLineReader getCsvReader(Connection hapiConnect) throws IOException {
        InputStream ins1 = hapiConnect.getInputStream();
        InputStreamReader isread = new InputStreamReader(ins1, HapiServer.UTF8);
        SingleFileBufferedReader result = new SingleFileBufferedReader(new BufferedReader(isread));
        return result;
    }

    public static QDataSet getDataSetViaCsv(int totalFields, ProgressMonitor monitor, URL url, ParamDescription[] pds, DatumRange tr, int nparam, int[] nfields, String useCacheUriParam) throws IllegalArgumentException, Exception, IOException {
        DataSetBuilder builder = new DataSetBuilder(2, 100, totalFields);
        monitor.setProgressMessage("reading data");
        monitor.setTaskProgress(20L);
        long t0 = System.currentTimeMillis() - 100L;
        Connection connect = Connection.openConnection(url);
        logger.log(Level.FINER, "parse {0}", url);
        int linenumber = 0;
        LinkedHashMap<String, Integer> warnings = new LinkedHashMap<String, Integer>();
        try (AbstractLineReader in = HapiDataSource.getCsvReader(connect);){
            String line = in.readLine();
            if (line != null && line.startsWith("{")) {
                logger.log(Level.WARNING, "data response starts with \"{\", not data!");
                StringBuilder sb = new StringBuilder();
                while (line != null) {
                    sb.append(line);
                    line = in.readLine();
                }
                String jsonResponse = sb.toString();
                JSONObject jo = new JSONObject(jsonResponse);
                if (!jo.has("HAPI")) {
                    throw new IllegalArgumentException("Expected HAPI version in JSON response");
                }
                String vers = jo.getString("HAPI");
                if (!vers.startsWith("2") && !vers.startsWith("1")) {
                    String msg = "Only version 1 and 2 servers can have JSON response where CSV was expected";
                    if (jsonResponse.length() < 400) {
                        msg = msg + ": " + jsonResponse;
                    }
                    throw new IllegalArgumentException(msg);
                }
                if (!jo.has("status")) {
                    throw new IllegalArgumentException("Expected status in JSON response");
                }
                JSONObject status = jo.getJSONObject("status");
                if (status.getInt("code") == 1201) {
                    throw new NoDataInIntervalException("server responds: " + status.getString("message"));
                }
                throw new IllegalArgumentException("unsupported server response " + status.getInt("code") + ": " + status.getString("message"));
            }
            if (line != null && line.length() > 0 && !Character.isDigit(line.charAt(0))) {
                logger.log(Level.WARNING, "expected first character to be a digit (first of ISO8601 time), but got \"{0}\"", line);
            }
            while (line != null) {
                Datum xx;
                int ifield;
                String[] ss;
                block45: {
                    ++linenumber;
                    ss = HapiDataSource.lineSplit(line);
                    if (ss.length != totalFields) {
                        if (line.trim().length() == 0) {
                            logger.log(Level.WARNING, "expected {0} fields, got empty line at line {1}", new Object[]{totalFields, linenumber});
                            line = in.readLine();
                            continue;
                        }
                        logger.log(Level.WARNING, "expected {0} fields, got {1} at line {2}", new Object[]{totalFields, ss.length, linenumber});
                        if (line.trim().startsWith("{")) {
                            throw new IllegalArgumentException(String.format("expected %d fields, got \"{\" at line %d", totalFields, linenumber));
                        }
                        throw new IllegalArgumentException(String.format("expected %d fields, got %d at line %d", totalFields, ss.length, linenumber));
                    }
                    ifield = 0;
                    try {
                        xx = pds[ifield].units.parse(ss[ifield]);
                        if (System.currentTimeMillis() - t0 <= 100L) break block45;
                        monitor.setProgressMessage("reading " + xx);
                        t0 = System.currentTimeMillis();
                        double d = DatumRangeUtil.normalize((DatumRange)tr, (Datum)xx);
                        monitor.setTaskProgress((long)(20 + (int)(75.0 * d)));
                        if (monitor.isCancelled()) {
                            throw new CancelledOperationException("cancel was pressed");
                        }
                    }
                    catch (ParseException ex) {
                        if (!warnings.containsKey(WARNING_TIME_MALFORMED)) {
                            logger.log(Level.INFO, "malformed time: {0}", ss[ifield]);
                            warnings.put(WARNING_TIME_MALFORMED, 1);
                        } else {
                            warnings.put(WARNING_TIME_MALFORMED, (Integer)warnings.get(WARNING_TIME_MALFORMED) + 1);
                        }
                        line = in.readLine();
                        continue;
                    }
                }
                builder.putValue(-1, ifield, xx);
                ++ifield;
                for (int i = 1; i < nparam; ++i) {
                    for (int j = 0; j < nfields[i]; ++j) {
                        try {
                            String s = ss[ifield];
                            if (pds[i].units instanceof EnumerationUnits) {
                                builder.putValue(-1, ifield, ((EnumerationUnits)pds[i].units).createDatum((Object)s));
                            } else {
                                builder.putValue(-1, ifield, pds[i].units.parse(s));
                            }
                        }
                        catch (ParseException ex) {
                            builder.putValue(-1, ifield, pds[i].fillValue);
                            pds[i].hasFill = true;
                        }
                        ++ifield;
                    }
                }
                builder.nextRecord();
                line = in.readLine();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            monitor.finished();
            if (connect != null) {
                logger.log(Level.WARNING, "IOException when trying to read {0}", connect.getURL());
                throw new IOException(connect.getURL() + " results in\n" + String.valueOf(connect.getResponseCode()) + ": " + connect.getResponseMessage());
            }
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            monitor.finished();
            throw e;
        }
        finally {
            if (connect != null) {
                connect.disconnect();
            }
        }
        if (!warnings.isEmpty()) {
            logger.warning("Warnings encountered:");
            for (Map.Entry e : warnings.entrySet()) {
                logger.log(Level.WARNING, " {0} ({1} times)", new Object[]{e.getKey(), e.getValue()});
            }
        }
        logger.log(Level.FINER, "done parsing {0}", url);
        monitor.setTaskProgress(95L);
        DDataSet ds = builder.getDataSet();
        return ds;
    }

    private static TransferType getTimeTransferType(ParamDescription pdsi) {
        final Units u = pdsi.units;
        final int length = pdsi.length;
        final byte[] bytes = new byte[length];
        return new TransferType(){

            public void write(double d, ByteBuffer buffer) {
            }

            public double read(ByteBuffer buffer) {
                buffer.get(bytes);
                String s = new String(bytes);
                Datum d = ((EnumerationUnits)u).createDatum((Object)s);
                return d.doubleValue(u);
            }

            public int sizeBytes() {
                return length;
            }

            public boolean isAscii() {
                return false;
            }

            public String name() {
                return "string" + length;
            }
        };
    }

    public static QDataSet getDataSetViaBinary(int totalFields, ProgressMonitor monitor, URL url, ParamDescription[] pds, DatumRange tr, int nparam, int[] nfields, String useCacheUriParam) throws IllegalArgumentException, Exception, IOException {
        DataSetBuilder builder = new DataSetBuilder(2, 100, totalFields);
        int icol = 0;
        for (int i = 0; i < pds.length; ++i) {
            ParamDescription pds1 = pds[i];
            for (int j = 0; j < pds1.nFields; ++j) {
                builder.setUnits(icol, pds1.units);
                ++icol;
            }
        }
        monitor.setProgressMessage("reading data");
        monitor.setTaskProgress(20L);
        long t0 = System.currentTimeMillis() - 100L;
        Connection httpConnect = Connection.openConnection(url);
        Datum midnight = TimeUtil.prevMidnight((Datum)tr.min());
        DatumRange currentDay = new DatumRange(midnight, TimeUtil.next((int)3, (Datum)midnight));
        int recordLengthBytes = 0;
        TransferType[] tts = new TransferType[pds.length];
        for (int i = 0; i < pds.length; ++i) {
            if (pds[i].type.startsWith("time")) {
                recordLengthBytes += Integer.parseInt(pds[i].type.substring(4));
                tts[i] = TransferType.getForName((String)pds[i].type, Collections.singletonMap("UNITS", pds[i].units));
            } else if (pds[i].type.startsWith("string")) {
                recordLengthBytes += pds[i].length;
                tts[i] = HapiDataSource.getTimeTransferType(pds[i]);
            } else {
                String type = pds[i].type;
                recordLengthBytes += BufferDataSet.byteCount((Object)type) * DataSetUtil.product((int[])pds[i].size);
                tts[i] = TransferType.getForName((String)type.toString(), Collections.singletonMap("UNITS", pds[i].units));
            }
            if (tts[i] != null) continue;
            throw new IllegalArgumentException("unable to identify transfer type for \"" + pds[i].type + "\"");
        }
        totalFields = DataSetUtil.sum((int[])nfields);
        double[] result = new double[totalFields];
        int recordnumber = 0;
        LinkedHashMap<String, Integer> warnings = new LinkedHashMap<String, Integer>();
        try (InputStreamBinaryRecordReader in = new InputStreamBinaryRecordReader(httpConnect.getInputStream());){
            ByteBuffer buf = TransferType.allocate((int)recordLengthBytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            int bytesRead = in.readRecord(buf);
            if (bytesRead > 0 && (char)buf.get(0) == '{') {
                logger.log(Level.WARNING, "data response starts with \"{\", not data!");
                StringBuilder sb = new StringBuilder();
                while (bytesRead > -1) {
                    if (buf.position() < buf.limit()) {
                        while (bytesRead > -1) {
                            bytesRead = in.readRecord(buf);
                        }
                    }
                    buf.flip();
                    sb.append(new String(buf.array(), 0, buf.limit(), "UTF-8"));
                }
                String jsonResponse = sb.toString();
                JSONObject jo = new JSONObject(jsonResponse);
                if (!jo.has("HAPI")) {
                    throw new IllegalArgumentException("Expected HAPI version in JSON response");
                }
                String vers = jo.getString("HAPI");
                if (!vers.startsWith("2") && !vers.startsWith("1")) {
                    String msg = "Only version 1 and 2 servers can have JSON response where CSV was expected";
                    if (jsonResponse.length() < 400) {
                        msg = msg + ": " + jsonResponse;
                    }
                    throw new IllegalArgumentException(msg);
                }
                if (!jo.has("status")) {
                    throw new IllegalArgumentException("Expected status in JSON response");
                }
                JSONObject status = jo.getJSONObject("status");
                if (status.getInt("code") == 1201) {
                    throw new NoDataInIntervalException("server responds: " + status.getString("message"));
                }
                throw new IllegalArgumentException("unsupported server response " + status.getInt("code") + ": " + status.getString("message"));
            }
            while (bytesRead != -1) {
                Datum xx;
                int ifield;
                block49: {
                    logger.log(Level.FINER, "read record number {0}", ++recordnumber);
                    buf.flip();
                    ifield = 0;
                    for (int i = 0; i < pds.length; ++i) {
                        for (int j = 0; j < nfields[i]; ++j) {
                            result[ifield] = tts[i].read(buf);
                            ++ifield;
                        }
                    }
                    if (ifield != totalFields) {
                        logger.log(Level.WARNING, "expected {0} got {1}", new Object[]{totalFields, ifield});
                    }
                    ifield = 0;
                    try {
                        xx = pds[0].units.createDatum(result[0]);
                        if (System.currentTimeMillis() - t0 <= 100L) break block49;
                        monitor.setProgressMessage("reading " + xx);
                        t0 = System.currentTimeMillis();
                        double d = DatumRangeUtil.normalize((DatumRange)tr, (Datum)xx);
                        monitor.setTaskProgress((long)(20 + (int)(75.0 * d)));
                        if (monitor.isCancelled()) {
                            throw new CancelledOperationException("cancel was pressed");
                        }
                    }
                    catch (RuntimeException ex) {
                        if (!warnings.containsKey(WARNING_TIME_MALFORMED)) {
                            logger.log(Level.INFO, "malformed time");
                            warnings.put(WARNING_TIME_MALFORMED, 1);
                        } else {
                            warnings.put(WARNING_TIME_MALFORMED, (Integer)warnings.get(WARNING_TIME_MALFORMED) + 1);
                        }
                        buf.flip();
                        bytesRead = in.readRecord(buf);
                        continue;
                    }
                }
                if (!currentDay.contains(xx)) {
                    if (!warnings.containsKey(WARNING_TIME_ORDER)) {
                        logger.log(Level.INFO, "something's gone wrong, perhaps out-of-order timetags: {0}", xx);
                        warnings.put(WARNING_TIME_ORDER, 1);
                    } else {
                        warnings.put(WARNING_TIME_ORDER, (Integer)warnings.get(WARNING_TIME_ORDER) + 1);
                    }
                }
                builder.putValue(-1, ifield, xx);
                ++ifield;
                for (int i = 1; i < nparam; ++i) {
                    for (int j = 0; j < nfields[i]; ++j) {
                        builder.putValue(-1, ifield, result[ifield]);
                        ++ifield;
                    }
                }
                builder.nextRecord();
                buf.flip();
                bytesRead = in.readRecord(buf);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            monitor.finished();
            throw new IOException(String.valueOf(httpConnect.getResponseCode()) + ":" + httpConnect.getResponseMessage());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            monitor.finished();
            throw e;
        }
        finally {
            if (httpConnect != null) {
                httpConnect.disconnect();
            }
        }
        monitor.setTaskProgress(95L);
        DDataSet ds = builder.getDataSet();
        return ds;
    }

    private static QDataSet getDataSetViaJSON(int totalFields, ProgressMonitor monitor, URL url, ParamDescription[] pds, DatumRange tr, int nparam, int[] nfields) throws IllegalArgumentException, Exception, IOException {
        monitor.started();
        monitor.setProgressMessage("server is preparing data");
        long t0 = System.currentTimeMillis() - 100L;
        int lineNum = 0;
        StringBuilder builder = new StringBuilder();
        logger.log(Level.FINE, "getDocument {0}", url.toString());
        Connection connect = Connection.openConnection(url);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connect.getInputStream(), HapiServer.UTF8));){
            String line = in.readLine();
            ++lineNum;
            while (line != null) {
                if (System.currentTimeMillis() - t0 > 100L) {
                    monitor.setProgressMessage("reading line " + lineNum);
                    t0 = System.currentTimeMillis();
                }
                builder.append(line);
                line = in.readLine();
            }
        }
        catch (IOException ex) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileSystemUtil.copyStream((InputStream)connect.getErrorStream(), (OutputStream)baos, (ProgressMonitor)new NullProgressMonitor());
            String s = baos.toString("UTF-8");
            if (s.contains("No data available")) {
                logger.log(Level.FINE, "No data available, server responded with {0}: {1}", new Object[]{connect.getResponseCode(), connect.getResponseMessage()});
                throw new NoDataInIntervalException("No data available");
            }
            if (s.length() < 256) {
                throw new IOException(ex.getMessage() + ": " + s);
            }
            throw ex;
        }
        connect.disconnect();
        monitor.setProgressMessage("parsing data");
        JSONObject jo = new JSONObject(builder.toString());
        JSONArray data = jo.getJSONArray("data");
        DataSetBuilder build = new DataSetBuilder(2, data.length(), totalFields);
        for (int i = 0; i < data.length(); ++i) {
            int ipd = 0;
            int ifield = 0;
            JSONArray record = data.getJSONArray(i);
            for (ParamDescription pd : pds) {
                if (nfields[ipd] > 1) {
                    JSONArray fields = record.getJSONArray(ipd);
                    int nf = nfields[ipd];
                    int lastField = nf + ifield;
                    while (ifield < lastField) {
                        build.putValue(-1, ifield, pd.units.parse(fields.getString(ipd)));
                        ++ifield;
                    }
                } else {
                    build.putValue(-1, ifield, pd.units.parse(record.getString(ipd)));
                }
                ifield += nfields[ipd];
                ++ipd;
            }
            build.nextRecord();
        }
        DDataSet result = build.getDataSet();
        return result;
    }

    private static String[] lineSplit(String line) {
        String[] ss = line.split(",", -2);
        for (int i = 0; i < ss.length; ++i) {
            String s = ss[i].trim();
            if (s.startsWith("\"") && s.endsWith("\"")) {
                s = s.substring(1, s.length() - 1);
            }
            ss[i] = s;
        }
        return ss;
    }

    protected static Datum parseTime(String stopDate) throws ParseException {
        try {
            return Units.ms1970.parse(stopDate);
        }
        catch (ParseException ex) {
            switch (stopDate) {
                case "lastday": {
                    stopDate = TimeUtil.prevMidnight((Datum)TimeUtil.now()).toString();
                    logger.warning("\"lastday\" is not a valid time, and this should be fixed.");
                    break;
                }
                case "lasthour": {
                    stopDate = TimeUtil.prev((int)4, (Datum)TimeUtil.now()).toString();
                    logger.warning("\"lasthour\" is not a valid time, and this should be fixed.");
                    break;
                }
                case "now": {
                    stopDate = TimeUtil.now().toString();
                    logger.warning("\"now\" is not a valid time, and this should be fixed.");
                    break;
                }
                default: {
                    throw ex;
                }
            }
            return TimeUtil.create((String)stopDate);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParamDescription[] getParameterDescriptions(JSONObject doc) throws IllegalArgumentException, ParseException, JSONException {
        JSONArray parameters = doc.getJSONArray("parameters");
        int nparameters = parameters.length();
        long modificationDate = 0L;
        if (doc.has("modificationDate")) {
            String s = doc.getString("modificationDate");
            try {
                Datum d = HapiDataSource.parseTime(s);
                modificationDate = (long)d.doubleValue((Units)Units.ms1970);
            }
            catch (ParseException ex) {
                logger.log(Level.INFO, "Unable to use modificationDate, found: \"{0}\"", s);
            }
        }
        ParamDescription[] pds = new ParamDescription[nparameters];
        for (int i = 0; i < nparameters; ++i) {
            JSONArray ja;
            int j;
            String type;
            JSONObject jsonObjecti = parameters.getJSONObject(i);
            String name = jsonObjecti.getString("name");
            logger.log(Level.FINER, "unpacking {0}", name);
            if (name == null) {
                name = "name" + i;
                logger.log(Level.WARNING, "name not found for {0}th parameter", i);
            }
            pds[i] = new ParamDescription(name);
            pds[i].modifiedDateMillis = modificationDate;
            if (jsonObjecti.has("type")) {
                type = jsonObjecti.getString("type");
                if (type == null) {
                    type = "";
                }
            } else {
                type = "";
            }
            if (type.equals("")) {
                logger.log(Level.FINE, "type is not defined: {0}", name);
            }
            pds[i].parameter = jsonObjecti;
            if (type.equalsIgnoreCase("isotime")) {
                if (!type.equals("isotime")) {
                    logger.log(Level.WARNING, "isotime should not be capitalized: {0}", type);
                }
                pds[i].units = Units.us2000;
                if (jsonObjecti.has("length")) {
                    pds[i].type = "time" + jsonObjecti.getInt("length");
                    pds[i].length = jsonObjecti.getInt("length");
                    continue;
                }
                logger.log(Level.FINE, "server doesn''t report length for \"{0}\", assuming 24 characters, and that it doesn''t matter", name);
                pds[i].type = "time24";
                continue;
            }
            pds[i].type = type;
            if (jsonObjecti.has("units")) {
                Object ou = jsonObjecti.get("units");
                if (ou instanceof String) {
                    String sunits = (String)ou;
                    pds[i].units = Units.lookupUnits((String)sunits);
                }
            } else {
                pds[i].units = Units.dimensionless;
            }
            if (type.equals("String")) {
                type = "string";
                logger.warning("String used for type instead of string (lower case)");
            }
            if (type.equals("string")) {
                pds[i].units = EnumerationUnits.create((Object)name);
            }
            if (jsonObjecti.has("fill")) {
                String sfill = jsonObjecti.getString("fill");
                if (sfill != null && !sfill.equals("null")) {
                    if (type.equals("string")) {
                        pds[i].fillValue = ((EnumerationUnits)pds[i].units).createDatum((Object)sfill).doubleValue(pds[i].units);
                        pds[i].hasFill = true;
                    } else {
                        try {
                            pds[i].fillValue = pds[i].units.parse(sfill).doubleValue(pds[i].units);
                            pds[i].hasFill = true;
                        }
                        catch (ParseException ex) {
                            logger.log(Level.WARNING, "unable to use fill value: {0}", sfill);
                        }
                    }
                }
            } else {
                pds[i].fillValue = -1.0E38;
            }
            if (jsonObjecti.has("description")) {
                pds[i].description = jsonObjecti.getString("description");
                if (pds[i].description == null) {
                    pds[i].description = "";
                }
            } else {
                pds[i].description = "";
            }
            if (jsonObjecti.has("label")) {
                Object olabel = jsonObjecti.get("label");
                if (olabel instanceof String) {
                    pds[i].label = (String)olabel;
                    pds[i].labels = null;
                } else if (olabel instanceof JSONArray) {
                    JSONArray array = (JSONArray)olabel;
                    pds[i].labels = new String[array.length()];
                    for (j = 0; j < array.length(); ++j) {
                        pds[i].labels[j] = array.getString(j);
                    }
                }
                if (pds[i].label == null) {
                    pds[i].label = name;
                }
            } else {
                pds[i].label = name;
            }
            if (jsonObjecti.has("length")) {
                pds[i].length = jsonObjecti.getInt("length");
            }
            if (!jsonObjecti.has("size")) continue;
            Object o = jsonObjecti.get("size");
            if (!(o instanceof JSONArray)) {
                if (o.getClass() == Integer.class) {
                    pds[i].size = new int[]{(Integer)o};
                    pds[i].nFields = (Integer)o;
                    logger.log(Level.WARNING, "size should be an int array, found int: {0}", name);
                } else {
                    if (o.getClass() != String.class) throw new IllegalArgumentException(String.format("size should be an int array: %s", name));
                    pds[i].size = new int[]{Integer.parseInt((String)o)};
                    pds[i].nFields = Integer.parseInt((String)o);
                    logger.log(Level.WARNING, "size should be an int array, found String: {0}", name);
                }
            } else {
                JSONArray a = (JSONArray)o;
                pds[i].size = new int[a.length()];
                int nFields = 1;
                for (int j2 = 0; j2 < a.length(); ++j2) {
                    pds[i].size[j2] = a.getInt(j2);
                    nFields *= pds[i].size[j2];
                }
                pds[i].nFields = nFields;
            }
            if (jsonObjecti.has("bins")) {
                int n;
                o = jsonObjecti.get("bins");
                if (o instanceof JSONArray) {
                    ja = (JSONArray)o;
                    pds[i].depend = new QDataSet[ja.length()];
                    pds[i].dependName = new String[ja.length()];
                    for (j = 0; j < ja.length(); ++j) {
                        QDataSet dep;
                        JSONObject bins = ja.getJSONObject(j);
                        if (bins.has("centers")) {
                            Object o1 = bins.get("centers");
                            if (o1 instanceof String) {
                                pds[i].dependName[j] = (String)o1;
                                continue;
                            }
                            pds[i].depend[j] = dep = HapiDataSource.getJSONBins(ja.getJSONObject(j));
                            continue;
                        }
                        if (bins.has("ranges")) {
                            Object o1 = bins.get("ranges");
                            if (o1 instanceof String) {
                                pds[i].dependName[j] = (String)o1;
                            } else {
                                pds[i].depend[j] = dep = HapiDataSource.getJSONBins(ja.getJSONObject(j));
                            }
                            pds[i].renderType = "nnSpectrogram";
                            continue;
                        }
                        if (bins.has("parameter")) {
                            logger.info("parameter found within bins, which is deprecated.");
                            int n2 = pds[i].nFields;
                            pds[i].depend[j] = Ops.findgen((int)n2);
                            pds[i].dependName[j] = bins.getString("parameter");
                            continue;
                        }
                        int n3 = pds[i].size[j];
                        pds[i].depend[j] = Ops.findgen((int)n3);
                    }
                    continue;
                }
                logger.warning("bins should be an array");
                JSONObject bins = jsonObjecti.getJSONObject("bins");
                if (pds[i].depend == null) {
                    pds[i].depend = new QDataSet[1];
                }
                if (pds[i].dependName == null) {
                    pds[i].dependName = new String[1];
                }
                if (bins.has("parameter")) {
                    n = DataSetUtil.product((int[])pds[i].size);
                    pds[i].depend[0] = Ops.findgen((int)n);
                    pds[i].dependName[0] = bins.getString("parameter");
                    continue;
                }
                if (bins.has("values")) {
                    QDataSet dep1;
                    pds[i].depend[0] = dep1 = HapiDataSource.getJSONBins(bins);
                    continue;
                }
                n = DataSetUtil.product((int[])pds[i].size);
                pds[i].depend[0] = Ops.findgen((int)n);
                continue;
            }
            if (!jsonObjecti.has("binsParameter") || !((o = jsonObjecti.get("binsParameter")) instanceof JSONArray)) continue;
            ja = (JSONArray)o;
            pds[i].depend = new QDataSet[ja.length()];
            pds[i].dependName = new String[ja.length()];
            for (j = 0; j < ja.length(); ++j) {
                String s = ja.getString(j);
                int n = DataSetUtil.product((int[])pds[i].size);
                pds[i].depend[j] = Ops.findgen((int)n);
                pds[i].dependName[j] = s;
            }
        }
        return pds;
    }

    private MutablePropertyDataSet copyProperties(QDataSet mpds, ParamDescription pds1) {
        MutablePropertyDataSet ds = Ops.putProperty((QDataSet)mpds, (String)"NAME", (Object)Ops.safeName((String)pds1.name));
        ds = Ops.putProperty((QDataSet)ds, (String)"LABEL", (Object)pds1.label);
        ds = Ops.putProperty((QDataSet)ds, (String)"TITLE", (Object)pds1.description);
        ds = Ops.putProperty((QDataSet)ds, (String)"UNITS", (Object)pds1.units);
        if (pds1.hasFill) {
            ds = Ops.putProperty((QDataSet)ds, (String)"FILL_VALUE", (Object)pds1.fillValue);
        }
        if (pds1.labels != null) {
            MutablePropertyDataSet bds = (MutablePropertyDataSet)ds.property("BUNDLE_1");
            if (bds == null) {
                ds = Ops.putProperty((QDataSet)ds, (String)"DEPEND_1", (Object)Ops.labelsDataset((String[])pds1.labels));
            } else {
                for (int i = 0; i < pds1.labels.length; ++i) {
                    bds.putProperty("LABEL", i, (Object)pds1.labels[i]);
                    bds.putProperty("NAME", i, (Object)Ops.safeName((String)pds1.labels[i]));
                }
                ds = Ops.putProperty((QDataSet)ds, (String)"BUNDLE_1", (Object)bds);
            }
        }
        return ds;
    }

    private QDataSet repackage(QDataSet ds, ParamDescription[] pds, int[] sort) {
        QDataSet bds;
        boolean combineRank2Depend1;
        int nparameters = ds.length(0);
        boolean bl = combineRank2Depend1 = pds.length == 3 && pds[1].dependName != null;
        if (ds.rank() == 2 && (bds = (QDataSet)ds.property("BUNDLE_1")) != null && bds.length() > 1) {
            Units u1 = (Units)bds.property("UNITS", 0);
            Units u2 = (Units)bds.property("UNITS", 1);
            if (u1 != null && u2 != null && UnitsUtil.isTimeLocation((Units)u1) && UnitsUtil.isTimeLocation((Units)u2)) {
                QDataSet start = Ops.slice1((QDataSet)ds, (int)0);
                QDataSet stop = Ops.slice1((QDataSet)ds, (int)1);
                if (Ops.reduceMax((QDataSet)Ops.lt((QDataSet)stop, (QDataSet)start), (int)0).value() == 0.0) {
                    return Ops.createEvents((QDataSet)ds);
                }
            }
        }
        QDataSet depend0 = Ops.slice1((QDataSet)ds, (int)0);
        if (ds.length(0) == 2) {
            ds = Ops.copy((QDataSet)Ops.slice1((QDataSet)ds, (int)1));
            ds = Ops.putProperty((QDataSet)ds, (String)"DEPEND_0", (Object)depend0);
            ds = this.copyProperties(ds, pds[1]);
        } else if (pds.length == 2) {
            ds = Ops.copy((QDataSet)Ops.trim1((QDataSet)ds, (int)1, (int)ds.length(0)));
            if (pds[1].size.length > 1) {
                ds = Ops.reform((QDataSet)ds, (int)ds.length(), (int[])pds[1].size);
            }
            ds = Ops.putProperty((QDataSet)ds, (String)"DEPEND_0", (Object)depend0);
            ds = this.copyProperties(ds, pds[1]);
            if (pds[1].depend != null) {
                for (int j = 0; j < pds[1].size.length; ++j) {
                    ds = Ops.putProperty((QDataSet)ds, (String)("DEPEND_" + (j + 1)), (Object)pds[1].depend[j]);
                }
            }
            if (pds.length == 2 && "nnSpectrogram".equals(pds[1].renderType)) {
                ds = Ops.putProperty((QDataSet)ds, (String)"RENDER_TYPE", (Object)pds[1].renderType);
            }
        } else {
            if (pds.length == 1) {
                ds = Ops.link((QDataSet)depend0, (QDataSet)depend0);
                ds = Ops.putProperty((QDataSet)ds, (String)"RENDER_TYPE", (Object)"eventsBar");
                return ds;
            }
            if (combineRank2Depend1) {
                WritableDataSet theScienceDs = Ops.maybeCopy((QDataSet)Ops.trim1((QDataSet)ds, (int)1, (int)(1 + pds[1].nFields)));
                if (pds[1].size.length > 1) {
                    theScienceDs = Ops.maybeCopy((QDataSet)Ops.reform((QDataSet)theScienceDs, (int)theScienceDs.length(), (int[])pds[1].size));
                }
                SparseDataSetBuilder[] sdsbs = new SparseDataSetBuilder[pds.length];
                int ifield = 1;
                int length1 = ds.length(0);
                for (int i = 1; i < pds.length; ++i) {
                    int j;
                    int startIndex;
                    int nfields1 = pds[i].nFields;
                    SparseDataSetBuilder sdsb = new SparseDataSetBuilder(2);
                    sdsb.setLength(nfields1);
                    int n = startIndex = sort == null ? ifield - 1 : sort[ifield] - 1;
                    if (nfields1 > 1) {
                        sdsb.putProperty("ELEMENT_NAME", startIndex, (Object)Ops.safeName((String)pds[i].name));
                        sdsb.putProperty("ELEMENT_LABEL", startIndex, (Object)pds[i].name);
                        for (j = 0; j < pds[i].size.length; ++j) {
                            sdsb.putValue(startIndex, j, (double)pds[i].size[j]);
                        }
                        if (pds[i].depend != null) {
                            if (pds[i].size.length != pds[i].depend.length) {
                                throw new IllegalArgumentException("pds[i].size.length!=pds[i].depend.length");
                            }
                            for (j = 0; j < pds[i].size.length; ++j) {
                                if (pds[i].dependName[j] != null) continue;
                                sdsb.putProperty("DEPEND_" + (j + 1), startIndex, (Object)pds[i].depend[j]);
                                if (i != 1) continue;
                                theScienceDs.putProperty("DEPEND_" + (j + 1), (Object)pds[i].depend[j]);
                            }
                        }
                    }
                    for (j = 0; j < nfields1; ++j) {
                        if (nfields1 > 1) {
                            sdsb.putProperty("START_INDEX", startIndex + j, (Object)startIndex);
                            sdsb.putProperty("LABEL", startIndex + j, (Object)(pds[i].name + " ch" + j));
                            sdsb.putProperty("NAME", startIndex + j, (Object)(Ops.safeName((String)pds[i].name) + "_" + j));
                        } else {
                            sdsb.putProperty("LABEL", startIndex + j, (Object)pds[i].name);
                            sdsb.putProperty("NAME", startIndex + j, (Object)Ops.safeName((String)pds[i].name));
                        }
                        sdsb.putProperty("TITLE", startIndex + j, (Object)pds[i].description);
                        sdsb.putProperty("UNITS", startIndex + j, (Object)pds[i].units);
                        if (pds[i].hasFill) {
                            sdsb.putProperty("FILL_VALUE", startIndex + j, (Object)pds[i].fillValue);
                        }
                        if (nfields1 > 1) {
                            sdsb.putProperty("START_INDEX", startIndex + j, (Object)startIndex);
                        }
                        ++ifield;
                    }
                    length1 = nfields1;
                    sdsbs[i] = sdsb;
                }
                int start = 1;
                start += length1;
                theScienceDs.putProperty("DEPEND_0", (Object)depend0);
                theScienceDs = this.copyProperties((QDataSet)theScienceDs, pds[1]);
                for (int i = 1; i < pds.length; ++i) {
                    if (pds[i].dependName == null) continue;
                    for (int j = 0; j < pds[i].dependName.length; ++j) {
                        int k;
                        String dependName = pds[i].dependName[j];
                        if (dependName == null) continue;
                        for (k = 1; k < pds.length && !pds[k].name.equals(dependName); ++k) {
                        }
                        if (k >= pds.length) continue;
                        WritableDataSet depds = Ops.copy((QDataSet)Ops.trim1((QDataSet)ds, (int)start, (int)(start + length1)));
                        depds.putProperty("DEPEND_0", (Object)depend0);
                        depds.putProperty("BUNDLE_1", (Object)sdsbs[k].getDataSet());
                        depds = this.copyProperties((QDataSet)depds, pds[k]);
                        start += length1;
                        if (pds[k].size.length > 1) {
                            theScienceDs.putProperty("DEPEND_" + (j + 1), (Object)Ops.reform((QDataSet)depds, (int)depds.length(), (int[])pds[k].size));
                            continue;
                        }
                        theScienceDs.putProperty("DEPEND_" + (j + 1), (Object)depds);
                    }
                }
                ds = theScienceDs;
            } else {
                SparseDataSetBuilder sdsb = new SparseDataSetBuilder(2);
                sdsb.setLength(nparameters - 1);
                int ifield = 1;
                for (int i = 1; i < pds.length; ++i) {
                    int j;
                    int startIndex;
                    int nfields1 = DataSetUtil.product((int[])pds[i].size);
                    int n = startIndex = sort == null ? ifield - 1 : sort[ifield] - 1;
                    if (nfields1 > 1) {
                        sdsb.putProperty("ELEMENT_NAME", startIndex, (Object)Ops.safeName((String)pds[i].name));
                        sdsb.putProperty("ELEMENT_LABEL", startIndex, (Object)pds[i].name);
                        for (j = 0; j < pds[i].size.length; ++j) {
                            sdsb.putValue(startIndex, j, (double)pds[i].size[j]);
                        }
                        if (pds[i].depend != null) {
                            if (pds[i].size.length != pds[i].depend.length) {
                                throw new IllegalArgumentException("pds[i].size.length!=pds[i].depend.length");
                            }
                            for (j = 0; j < pds[i].size.length; ++j) {
                                sdsb.putProperty("DEPEND_" + (j + 1), startIndex, (Object)pds[i].depend[j]);
                            }
                        }
                    }
                    for (j = 0; j < nfields1; ++j) {
                        if (nfields1 > 1) {
                            sdsb.putProperty("START_INDEX", startIndex + j, (Object)startIndex);
                            sdsb.putProperty("LABEL", startIndex + j, (Object)(pds[i].name + " ch" + j));
                            sdsb.putProperty("NAME", startIndex + j, (Object)(Ops.safeName((String)pds[i].name) + "_" + j));
                        } else {
                            sdsb.putProperty("LABEL", startIndex + j, (Object)pds[i].name);
                            sdsb.putProperty("NAME", startIndex + j, (Object)Ops.safeName((String)pds[i].name));
                        }
                        sdsb.putProperty("TITLE", startIndex + j, (Object)pds[i].description);
                        sdsb.putProperty("UNITS", startIndex + j, (Object)pds[i].units);
                        if (pds[i].hasFill) {
                            sdsb.putProperty("FILL_VALUE", startIndex + j, (Object)pds[i].fillValue);
                        }
                        if (nfields1 > 1) {
                            sdsb.putProperty("START_INDEX", startIndex + j, (Object)startIndex);
                        }
                        ++ifield;
                    }
                }
                ds = Ops.copy((QDataSet)Ops.trim1((QDataSet)ds, (int)1, (int)ds.length(0)));
                ds = Ops.putProperty((QDataSet)ds, (String)"DEPEND_0", (Object)depend0);
                ds = Ops.putProperty((QDataSet)ds, (String)"BUNDLE_1", (Object)sdsb.getDataSet());
            }
        }
        return ds;
    }

    public static class ParamDescription {
        boolean hasFill = false;
        double fillValue = -1.0E38;
        Units units = Units.dimensionless;
        String name = "";
        String description = "";
        String label = "";
        String[] labels = null;
        String type = "";
        int[] size = new int[0];
        int nFields = 1;
        int length = 0;
        QDataSet[] depend = null;
        String[] dependName = null;
        long modifiedDateMillis = 0L;
        JSONObject parameter = null;
        String renderType = null;

        private ParamDescription(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

