/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.hapi.HapiDataSource;
import org.das2.datum.DatumRange;
import org.das2.fsm.FileStorageModel;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class HapiUtil {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.hapi");
    public static final String KEY_DEFINITIONS = "definitions";
    public static final String KEY_PARAMETERS = "parameters";
    public static final String KEY_REF = "$ref";
    public static final String KEY_PARAMETER = "parameter";
    public static final String KEY_BINS = "bins";
    public static final String KEY_RANGES = "ranges";
    public static final String KEY_CENTERS = "centers";
    public static final String KEY_LENGTH = "length";
    public static final String KEY_SIZE = "size";
    public static final String KEY_LABEL = "label";
    public static final String KEY_FILL = "fill";
    public static final String KEY_UNITS = "units";
    public static final String KEY_TYPE = "type";
    public static final String KEY_X_COLOR_LOOKUP = "x_colorLookup";

    private static void resolveRefRecursive(JSONObject definitions, JSONObject param) throws JSONException {
        Iterator keys = param.keys();
        while (keys.hasNext()) {
            String k = (String)keys.next();
            Object o = param.get(k);
            if (o instanceof JSONObject) {
                JSONObject maybeRef = (JSONObject)o;
                if (maybeRef.has(KEY_REF)) {
                    String theRef = maybeRef.getString(KEY_REF);
                    if (theRef.startsWith("#/definitions/")) {
                        String theDefinitionsRef = theRef.substring(14);
                        if (definitions.has(theDefinitionsRef)) {
                            Object deref = definitions.get(theDefinitionsRef);
                            param.put(k, deref);
                            continue;
                        }
                        throw new IllegalArgumentException("reference not found within definitions: " + theRef);
                    }
                    throw new IllegalArgumentException("references may only be to nodes within definitions: " + theRef);
                }
                HapiUtil.resolveRefRecursive(definitions, maybeRef);
                continue;
            }
            if (!(o instanceof JSONArray)) continue;
            JSONArray ja = (JSONArray)o;
            for (int i = 0; i < ja.length(); ++i) {
                Object o1 = ja.get(i);
                if (o1 instanceof JSONObject) {
                    JSONObject maybeRef = (JSONObject)o1;
                    if (maybeRef.has(KEY_REF)) {
                        String theRef = maybeRef.getString(KEY_REF);
                        if (theRef.startsWith("#/definitions/")) {
                            String theDefinitionsRef = theRef.substring(14);
                            if (definitions.has(theDefinitionsRef)) {
                                Object deref = definitions.get(theDefinitionsRef);
                                ja.put(i, deref);
                                continue;
                            }
                            throw new IllegalArgumentException("reference not found within definitions: " + theRef);
                        }
                        throw new IllegalArgumentException("references may only be to nodes within definitions: " + theRef);
                    }
                    HapiUtil.resolveRefRecursive(definitions, maybeRef);
                    continue;
                }
                if (o1 instanceof JSONArray) {
                    logger.fine("not resolving array of array, but this is easy to do with a small refactoring");
                    continue;
                }
                if (o1 instanceof Integer || o1 instanceof Double) continue;
                logger.fine("not resolving array of things.");
            }
        }
    }

    public static JSONObject resolveRefs(JSONObject jo) throws JSONException {
        if (!jo.has(KEY_DEFINITIONS)) {
            return jo;
        }
        JSONObject definitions = jo.getJSONObject(KEY_DEFINITIONS);
        JSONArray ja = jo.getJSONArray(KEY_PARAMETERS);
        for (int i = 0; i < ja.length(); ++i) {
            JSONObject param = ja.getJSONObject(i);
            HapiUtil.resolveRefRecursive(definitions, param);
        }
        return jo;
    }

    public static File cacheFolder(URL url, String id) {
        String cache = HapiDataSource.getHapiCache();
        String dsroot = cache + "/" + url.getProtocol() + "/" + url.getHost() + "/" + url.getPath() + "/" + id.replaceAll(" ", "+");
        return new File(dsroot);
    }

    protected static LinkedHashMap<String, DatumRange> getCacheFiles(URL url, String id, String[] parameters, DatumRange timeRange, String format) {
        String s = HapiDataSource.getHapiCache();
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        String u = url.getProtocol() + "/" + url.getHost() + url.getPath();
        u = u + "/data/" + id.replaceAll(" ", "+");
        LinkedHashMap<String, DatumRange> result = new LinkedHashMap<String, DatumRange>();
        try {
            for (String parameter : parameters) {
                String[] ff;
                String theFile = s + "/" + u;
                FileStorageModel fsm = FileStorageModel.create((FileSystem)FileSystem.create((String)("file:" + theFile)), (String)("$Y/$m/$Y$m$d." + parameter + "." + format + ".gz"));
                for (String ff1 : ff = fsm.getNamesFor(null)) {
                    DatumRange tr1 = fsm.getRangeFor(ff1);
                    if (timeRange != null && !timeRange.intersects(tr1)) continue;
                    result.put(ff1, tr1);
                }
            }
        }
        catch (IOException | IllegalArgumentException ex) {
            logger.log(Level.FINE, "exception in cache", ex);
            return null;
        }
        return result;
    }
}

