/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.das2Stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.HtmlResponseIOException;
import org.autoplot.datasource.URISplit;
import org.das2.client.DataSetStreamHandler;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qstream.QDataSetStreamHandler;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamTool;
import org.das2.stream.StreamHandler;
import org.das2.util.FileUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class Das2StreamDataSource
extends AbstractDataSource {
    private static final Logger logger = Logger.getLogger("apdss.d2s");

    public Das2StreamDataSource(URI uri) throws IOException {
        super(uri);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws FileNotFoundException, org.das2.stream.StreamException, IOException, StreamException, NoDataInIntervalException {
        InputStream in = DataSetURI.getInputStream((URI)this.uri, (ProgressMonitor)mon);
        ReadableByteChannel channel = Channels.newChannel(in);
        URISplit split = URISplit.parse((URI)this.uri);
        String ext = split.vapScheme;
        boolean useOldD2sParser = "T".equals(this.getParam("useOldD2sParser", "T"));
        if (ext.equals("vap+qds") || ext.equals("vap+qdst")) {
            try {
                QDataSetStreamHandler h = new QDataSetStreamHandler();
                StreamTool.readStream((ReadableByteChannel)channel, (org.das2.qstream.StreamHandler)h);
                QDataSet result = this.params.get("arg_0") != null ? h.getDataSet((String)this.params.get("arg_0")) : h.getDataSet();
                return result;
            }
            catch (StreamException se) {
                if (se.toString().contains("Expecting stream descriptor header")) {
                    String resp;
                    int i = se.toString().indexOf("beginning \n'");
                    if (i > 0 && se.toString().length() > i + 12 + 5 && DataSourceUtil.isHtmlStream((String)(resp = se.toString().substring(i + 12, i + 12 + 5)))) {
                        throw new HtmlResponseIOException("Expected QStream but got html: " + resp, DataSetURI.getWebURL((URI)this.uri));
                    }
                } else {
                    if ("NoDataInInterval".equals(se.getMessage())) {
                        throw new NoDataInIntervalException(se.getMessage());
                    }
                    if (se.getCause() != null && se.getCause() instanceof NoDataInIntervalException) {
                        throw (NoDataInIntervalException)se.getCause();
                    }
                }
                throw se;
            }
        }
        if (useOldD2sParser) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("file", DataSetURI.fromUri((URI)this.uri));
            DataSetStreamHandler handler = new DataSetStreamHandler(props, mon);
            try {
                org.das2.stream.StreamTool.readStream((ReadableByteChannel)channel, (StreamHandler)handler);
            }
            catch (NullPointerException ex) {
                if ("Linux".equals(System.getProperty("os.name"))) {
                    File ff = new File("/tmp/badd2s.d2s");
                    File infile = DataSetURI.getFile((URI)this.uri, (ProgressMonitor)new NullProgressMonitor());
                    FileUtil.fileCopy((File)infile, (File)ff);
                    logger.warning("bad stream written to /tmp/badd2s.d2s.  Note the data source was reading the stream directly.");
                }
                throw ex;
            }
            in.close();
            DataSet r = handler.getDataSet();
            if (r != null) {
                return DataSetAdapter.create((DataSet)r);
            }
            return null;
        }
        try {
            org.das2.client.QDataSetStreamHandler handler = new org.das2.client.QDataSetStreamHandler();
            try {
                org.das2.stream.StreamTool.readStream((ReadableByteChannel)channel, (StreamHandler)handler);
            }
            catch (NullPointerException ex) {
                if ("Linux".equals(System.getProperty("os.name"))) {
                    File ff = new File("/tmp/badd2s.d2s");
                    File infile = DataSetURI.getFile((URI)this.uri, (ProgressMonitor)new NullProgressMonitor());
                    FileUtil.fileCopy((File)infile, (File)ff);
                    logger.warning("bad stream written to /tmp/badd2s.d2s.  Note the data source was reading the stream directly.");
                }
                throw ex;
            }
            in.close();
            QDataSet r = handler.getDataSet();
            HashMap<String, URI> userProps = new HashMap<String, URI>();
            userProps.put("file", this.uri);
            r = Ops.putProperty((QDataSet)r, (String)"USER_PROPERTIES", userProps);
            return r;
        }
        catch (org.das2.stream.StreamException se) {
            if (se.toString().contains("Expecting stream descriptor header")) {
                String resp;
                int i = se.toString().indexOf("beginning \n'");
                if (i > 0 && se.toString().length() > i + 12 + 5 && DataSourceUtil.isHtmlStream((String)(resp = se.toString().substring(i + 12, i + 12 + 5)))) {
                    throw new HtmlResponseIOException("Expected das2Stream but got html: " + resp, DataSetURI.getWebURL((URI)this.uri));
                }
            } else {
                if ("NoDataInInterval".equals(se.getMessage())) {
                    throw new NoDataInIntervalException(se.getMessage());
                }
                if (se.getCause() != null && se.getCause() instanceof NoDataInIntervalException) {
                    throw (NoDataInIntervalException)se.getCause();
                }
            }
            throw se;
        }
    }
}

