/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.html;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.AsciiParser;
import org.das2.qds.util.DataSetBuilder;

public class AsciiTableMaker {
    DataSetBuilder builder = null;
    QDataSet desc = null;
    List<Units> units = null;
    Units defaultUnits = null;
    List<String> labels = null;
    List<String> names = null;
    List<String> format = null;
    List<AsciiParser.FieldParser> fieldParsers = null;
    int fieldCount = -1;
    boolean initializedFields = false;

    void setUnits(String units) {
        this.defaultUnits = Units.lookupUnits((String)units);
    }

    private void setUnitsAndFormat(List<String> values) {
        for (int i = 0; i < this.fieldCount; ++i) {
            String field = values.get(i).trim();
            boolean isTime = false;
            try {
                if (TimeParser.isIso8601String((String)field)) {
                    Units.cdfTT2000.parse(field);
                    isTime = true;
                } else if (field.matches("\\d+/\\d+/\\d+")) {
                    Units.cdfTT2000.parse(field);
                    isTime = true;
                }
            }
            catch (ParseException ex) {
                Logger.getLogger(AsciiTableMaker.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.units.get(i) != null) continue;
            if (isTime) {
                this.units.set(i, (Units)Units.us2000);
                this.format.set(i, null);
                continue;
            }
            if (field.contains("$")) {
                this.units.set(i, Units.dollars);
                this.format.set(i, "%.2f");
                continue;
            }
            if (field.endsWith("%")) {
                this.units.set(i, Units.percent);
                this.format.set(i, null);
                continue;
            }
            try {
                Integer.parseInt(field);
                this.units.set(i, Units.dimensionless);
                this.format.set(i, "%d");
                continue;
            }
            catch (NumberFormatException ex) {
                try {
                    Double.parseDouble(field);
                    this.units.set(i, Units.dimensionless);
                    this.format.set(i, null);
                    continue;
                }
                catch (NumberFormatException ex2) {
                    String[] ss = field.split("\\s", -2);
                    if (ss.length > 1) {
                        try {
                            Double.parseDouble(ss[0]);
                            this.units.set(i, Units.lookupUnits((String)field.substring(ss[0].length()).trim()));
                            this.format.set(i, null);
                        }
                        catch (NumberFormatException ex3) {
                            this.units.set(i, (Units)new EnumerationUnits("default"));
                            this.format.set(i, null);
                        }
                        continue;
                    }
                    if (field.contains(",") && !field.endsWith(",")) {
                        try {
                            double d = Double.parseDouble(field.replace(",", ""));
                            this.fieldParsers.set(i, this.getCommaFieldParser(Units.dimensionless));
                        }
                        catch (NumberFormatException ex4) {
                            this.units.set(i, (Units)new EnumerationUnits("default"));
                            this.format.set(i, null);
                        }
                        continue;
                    }
                    this.units.set(i, (Units)new EnumerationUnits("default"));
                    this.format.set(i, null);
                }
            }
        }
    }

    AsciiParser.FieldParser getCommaFieldParser(final Units uu) {
        return new AsciiParser.FieldParser(){

            public double parseField(String field, int columnIndex) throws ParseException {
                return uu.parse(field.replaceAll(",", "")).doubleValue(uu);
            }
        };
    }

    void addRecord(List<String> values) {
        if (this.fieldCount == -1) {
            return;
        }
        if (!this.initializedFields) {
            this.setUnitsAndFormat(values);
            this.initializedFields = true;
        }
        for (int i = 0; i < this.fieldCount; ++i) {
            String field = values.get(i).trim();
            Units u = this.units.get(i);
            if (field.trim().length() == 0) {
                if (u instanceof EnumerationUnits) {
                    double d = ((EnumerationUnits)u).createDatum((Object)field).doubleValue(u);
                    this.builder.putValue(-1, i, d);
                    continue;
                }
                this.builder.putValue(-1, i, this.builder.getFillValue());
                continue;
            }
            try {
                double d;
                if (u instanceof EnumerationUnits) {
                    d = ((EnumerationUnits)u).createDatum((Object)field).doubleValue(u);
                } else {
                    AsciiParser.FieldParser p = this.fieldParsers.get(i);
                    if (p != null) {
                        d = p.parseField(field, i);
                    } else {
                        try {
                            d = u.parse(field).doubleValue(u);
                        }
                        catch (ParseException ex) {
                            final Units uu = u;
                            p = new AsciiParser.FieldParser(){

                                public double parseField(String field, int columnIndex) throws ParseException {
                                    return uu.parse(field.replaceAll(",", "")).doubleValue(uu);
                                }
                            };
                            this.fieldParsers.set(i, p);
                            d = p.parseField(field, i);
                        }
                    }
                }
                this.builder.putValue(-1, i, d);
                continue;
            }
            catch (ParseException ex) {
                this.builder.putValue(-1, i, this.builder.getFillValue());
            }
        }
        this.builder.nextRecord();
    }

    void initialize(List<String> values) {
        int i;
        this.fieldCount = values.size();
        this.builder = new DataSetBuilder(2, 100, this.fieldCount);
        this.units = new ArrayList<Units>(this.fieldCount);
        for (i = 0; i < this.fieldCount; ++i) {
            this.units.add(i, this.defaultUnits);
        }
        this.format = new ArrayList<String>(this.fieldCount);
        this.fieldParsers = new ArrayList<AsciiParser.FieldParser>(this.fieldCount);
        this.labels = new ArrayList<String>(this.fieldCount);
        this.names = new ArrayList<String>(this.fieldCount);
        if (this.labels.isEmpty()) {
            for (i = 0; i < this.fieldCount; ++i) {
                this.labels.add(i, values.get(i));
                this.names.add(i, Ops.safeName((String)values.get(i)));
                this.format.add("");
                this.fieldParsers.add(null);
            }
        }
    }

    public boolean hasHeader() {
        return this.fieldCount > -1;
    }

    void addHeader(List<String> values) {
        if (this.fieldCount == -1) {
            this.initialize(values);
        }
    }

    void addUnits(List<String> units) {
    }

    void addUnits(int icol, String units) {
    }

    private QDataSet getBundleDescriptor() {
        return new AbstractDataSet(){

            public int rank() {
                return 2;
            }

            public Object property(String name, int i) {
                if (name.equals("LABEL")) {
                    return AsciiTableMaker.this.labels.get(i);
                }
                if (name.equals("NAME")) {
                    return AsciiTableMaker.this.names.get(i);
                }
                if (name.equals("FORMAT")) {
                    return AsciiTableMaker.this.format.get(i);
                }
                if (name.equals("UNITS")) {
                    return AsciiTableMaker.this.units.get(i);
                }
                return this.property(name);
            }

            public double value(int i0, int i1) {
                return 0.0;
            }

            public int length() {
                return AsciiTableMaker.this.labels.size();
            }

            public int length(int i) {
                return 0;
            }
        };
    }

    DDataSet getDataSet() {
        if (this.builder == null) {
            throw new IllegalArgumentException("no records found");
        }
        DDataSet result = this.builder.getDataSet();
        this.desc = this.getBundleDescriptor();
        result.putProperty("BUNDLE_1", (Object)this.desc);
        return result;
    }
}

