/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.LoggerManager;

public final class HttpUtil {
    private static final Logger logger = LoggerManager.getLogger("das2.filesystem");
    protected static final Logger loggerUrl = LoggerManager.getLogger("das2.url");
    private static final Map<String, MetadataRecord> cache = Collections.synchronizedMap(new HashMap());

    public static void consumeStream(InputStream err) throws IOException {
        byte[] buf = new byte[2048];
        try {
            if (err != null) {
                int ret = 0;
                while ((ret = err.read(buf)) > 0) {
                }
            }
        }
        finally {
            if (err != null) {
                err.close();
            }
        }
    }

    public static URLConnection checkRedirect(URLConnection urlConnection) throws IOException {
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection huc = (HttpURLConnection)urlConnection;
            huc.setInstanceFollowRedirects(true);
            huc.setConnectTimeout(5000);
            huc.setReadTimeout(5000);
            loggerUrl.log(Level.FINEST, "getResponseCode {0}", urlConnection.getURL());
            int responseCode = huc.getResponseCode();
            if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                String newUrl = huc.getHeaderField("Location");
                if (responseCode == 301) {
                    logger.log(Level.FINE, "URL {0} permanently moved to {1}", new Object[]{urlConnection.getURL(), newUrl});
                }
                String cookie = huc.getHeaderField("Cookie");
                String acceptEncoding = huc.getRequestProperty("Accept-Encoding");
                String authorization = huc.getRequestProperty("Authorization");
                String requestMethod = huc.getRequestMethod();
                loggerUrl.log(Level.FINE, "redirect to {0}", newUrl);
                HttpURLConnection newUrlConnection = (HttpURLConnection)new URL(newUrl).openConnection();
                newUrlConnection.addRequestProperty("Referer", urlConnection.getURL().toString());
                if (cookie != null) {
                    newUrlConnection.setRequestProperty("Cookie", cookie);
                }
                if (acceptEncoding != null) {
                    newUrlConnection.setRequestProperty("Accept-Encoding", acceptEncoding);
                }
                if (authorization != null) {
                    newUrlConnection.setRequestProperty("Authorization", authorization);
                }
                if (requestMethod != null) {
                    newUrlConnection.setRequestMethod(requestMethod);
                }
                ((HttpURLConnection)urlConnection).disconnect();
                urlConnection = newUrlConnection;
            }
            return urlConnection;
        }
        return urlConnection;
    }

    private static class MetadataRecord {
        Map<String, String> metadata;
        long birthMilli;

        private MetadataRecord() {
        }
    }
}

