/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.io.Serializable;
import java.text.ParseException;
import org.das2.datum.DatumRange;
import org.das2.datum.Orbits;
import org.das2.datum.Units;

public class OrbitDatumRange
extends DatumRange
implements Serializable {
    String sc;
    String orbit;
    Units unitPref;

    public OrbitDatumRange(String sc, String orbit) throws ParseException {
        super(Orbits.getOrbitsFor(sc).getDatumRange(orbit).min(), Orbits.getOrbitsFor(sc).getDatumRange(orbit).max());
        this.sc = sc;
        this.orbit = Orbits.trimOrbit(orbit);
        this.unitPref = this.min().getUnits();
    }

    public OrbitDatumRange(String sc, String orbit, Units unitPref) throws ParseException {
        super(Orbits.getOrbitsFor(sc).getDatumRange(orbit).min().convertTo(unitPref), Orbits.getOrbitsFor(sc).getDatumRange(orbit).max().convertTo(unitPref));
        this.sc = sc;
        this.orbit = Orbits.trimOrbit(orbit);
        this.unitPref = unitPref;
    }

    @Override
    public DatumRange next() {
        String next = Orbits.getOrbitsFor(this.sc).next(this.orbit);
        if (next == null) {
            return this;
        }
        try {
            return new OrbitDatumRange(this.sc, next, this.unitPref);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public DatumRange previous() {
        String prev = Orbits.getOrbitsFor(this.sc).prev(this.orbit);
        if (prev == null) {
            return this;
        }
        try {
            return new OrbitDatumRange(this.sc, prev);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public DatumRange convertTo(Units u) {
        if (u == this.min().getUnits()) {
            return this;
        }
        try {
            return new OrbitDatumRange(this.sc, this.orbit, u);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof OrbitDatumRange) {
            OrbitDatumRange odr = (OrbitDatumRange)o;
            if (odr.sc.equals(this.sc)) {
                if (odr.orbit.equals(this.orbit)) {
                    return 0;
                }
                return Orbits.getOrbitsFor(this.sc).compare(this.orbit, odr.orbit);
            }
            return super.compareTo(o);
        }
        return super.compareTo(o);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof OrbitDatumRange) {
            OrbitDatumRange odr = (OrbitDatumRange)o;
            if (odr.sc.equals(this.sc)) {
                return odr.orbit.equals(this.orbit);
            }
            return super.equals(o);
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.sc != null ? this.sc.hashCode() : 0);
        hash = 71 * hash + (this.orbit != null ? this.orbit.hashCode() : 0);
        return hash;
    }

    public String getOrbit() {
        return this.orbit;
    }

    @Override
    public String toString() {
        return "orbit:" + this.sc + ":" + this.orbit;
    }
}

