/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.geom2d.Line;
import ProGAL.geom2d.LineSegment;
import ProGAL.geom2d.Vector;
import ProGAL.math.Constants;

public class Point
extends ProGAL.geomNd.Point {
    private static final long serialVersionUID = 8095991200265432551L;
    public static Point origo = new Point(0.0, 0.0);

    public Point() {
        this(0.0, 0.0);
    }

    public Point(double x, double y) {
        super(new double[]{x, y});
    }

    public Point(double[] coords) {
        super(coords);
    }

    public Point(ProGAL.geomNd.Point p) {
        this(p.getCoords());
    }

    public double x() {
        return this.coords[0];
    }

    public double y() {
        return this.coords[1];
    }

    @Override
    public Point clone() {
        return new Point(this.coords[0], this.coords[1]);
    }

    public Vector vectorTo(Point p) {
        return new Vector(p.coords[0] - this.coords[0], p.coords[1] - this.coords[1]);
    }

    public Point add(Vector v) {
        return new Point(this.x() + v.x(), this.y() + v.y());
    }

    public Point add(double a, double b) {
        return new Point(this.x() + a, this.y() + b);
    }

    public Point addThis(Vector v) {
        this.coords[0] = this.coords[0] + v.x();
        this.coords[1] = this.coords[1] + v.y();
        return this;
    }

    public Point addThis(Point p) {
        this.coords[0] = this.coords[0] + p.x();
        this.coords[1] = this.coords[1] + p.y();
        return this;
    }

    public Point addThis(double a, double b) {
        this.coords[0] = this.coords[0] + a;
        this.coords[1] = this.coords[1] + b;
        return this;
    }

    public Point subtract(Vector v) {
        return new Point(this.x() - v.x(), this.y() - v.y());
    }

    public Point subtractThis(Vector v) {
        this.coords[0] = this.coords[0] - v.x();
        this.coords[1] = this.coords[1] - v.y();
        return this;
    }

    public Point subtractThis(Point p) {
        this.coords[0] = this.coords[0] - p.x();
        this.coords[1] = this.coords[1] - p.y();
        return this;
    }

    public static double area(Point a, Point b, Point c) {
        return a.x() * (b.y() - c.y()) + a.y() * (c.x() - b.x()) + b.x() * c.y() - c.x() * b.y();
    }

    public static boolean collinear(Point a, Point b, Point c) {
        return Point.area(a, b, c) < Constants.EPSILON;
    }

    public double getSquaredDistance() {
        return this.x() * this.x() + this.y() * this.y();
    }

    public double getSquaredDistance(Point q) {
        return Math.pow(this.x() - q.x(), 2.0) + Math.pow(this.y() - q.y(), 2.0);
    }

    public double getSquaredDistance(LineSegment s) {
        double squaredSegmentLength = s.getSquaredLength();
        if (squaredSegmentLength == 0.0) {
            return this.getSquaredDistance(s.a);
        }
        double sx = s.b.x() - s.a.x();
        double sy = s.b.y() - s.a.y();
        double t = ((this.x() - s.a.x()) * sx + (this.y() - s.a.y()) * sy) / squaredSegmentLength;
        if (t < 0.0) {
            return this.getSquaredDistance(s.a);
        }
        if (t > 1.0) {
            return this.getSquaredDistance(s.b);
        }
        return this.getSquaredDistance(new Point(s.a.x() + t * sx, s.a.y() + t * sy));
    }

    public double getDistance(LineSegment s) {
        return Math.sqrt(this.getSquaredDistance(s));
    }

    public static double getSignedAngle(Point p1, Point p2, Point p3) {
        Vector v1 = p2.vectorTo(p1);
        Vector v2 = p2.vectorTo(p3);
        return Math.atan2(v1.x() * v2.y() - v1.y() * v2.x(), v1.dot(v2));
    }

    public static double inCircle(Point p, Point q, Point r, Point s) {
        double pp = p.x() * p.x() + p.y() * p.y();
        double qq = q.x() * q.x() + q.y() * q.y();
        double rr = r.x() * r.x() + r.y() * r.y();
        double ss = s.x() * s.x() + s.y() * s.y();
        return pp * (q.x() * (r.y() - s.y()) + q.y() * (s.x() - r.x()) + r.x() * s.y() - r.y() * s.x()) - qq * (p.x() * (r.y() - s.y()) + p.y() * (s.x() - r.x()) + r.x() * s.y() - r.y() * s.x()) + rr * (p.x() * (q.y() - s.y()) + p.y() * (s.x() - q.x()) + q.x() * s.y() - q.y() * s.x()) - ss * (p.x() * (q.y() - r.y()) + p.y() * (r.x() - q.x()) + q.x() * r.y() - q.y() * r.x());
    }

    public double polarAngle() {
        double angle = Math.acos(this.polarAngleCos());
        if (this.coords[1] < 0.0 || this.coords[1] == 0.0 && this.coords[0] < 0.0) {
            angle = Constants.TAU - angle;
        }
        return angle;
    }

    public double polarAngleSin() {
        return this.coords[1] / this.distance();
    }

    public double polarAngleCos() {
        return this.coords[0] / this.distance();
    }

    public static boolean leftTurn(Point a, Point b, Point c) {
        return Point.area(a, b, c) > 0.0;
    }

    public static boolean rightTurn(Point a, Point b, Point c) {
        return Point.area(a, b, c) <= 0.0;
    }

    public static Point midPoint(Point p, Point q) {
        return new Point((p.coords[0] + q.coords[0]) / 2.0, (p.coords[1] + q.coords[1]) / 2.0);
    }

    public static Line getBisector(Point p, Point q) {
        if (!p.equals(q)) {
            return new Line(Point.midPoint(p, q), p.vectorTo(q));
        }
        return null;
    }

    public Line getDualLine() {
        return new Line(this.x(), this.y());
    }

    public boolean equals(Object o) {
        if (o instanceof Point) {
            return this.equals((Point)o);
        }
        return false;
    }

    public boolean equals(Point p) {
        return Math.abs(this.coords[0] - p.coords[0]) < Constants.EPSILON && Math.abs(this.coords[1] - p.coords[1]) < Constants.EPSILON;
    }

    public void rotation(double alpha) {
        double cosA = Math.cos(alpha);
        double sinA = Math.sin(alpha);
        double x = cosA * this.x() - sinA * this.y();
        this.set(1, cosA * this.y() + sinA * this.x());
        this.set(0, x);
    }

    public Point rotationClone(double alpha) {
        double cosA = Math.cos(alpha);
        double sinA = Math.sin(alpha);
        return new Point(cosA * this.x() - sinA * this.y(), cosA * this.y() + sinA * this.x());
    }

    public void rotation(double cos, double sin) {
        double xNew = cos * this.x() - sin * this.y();
        this.set(1, cos * this.y() + sin * this.x());
        this.set(0, xNew);
    }

    public void rotation(Point p, double angle) {
        p.addThis(-this.x(), -this.y());
        p.rotation(angle);
        p.addThis(this.x(), this.y());
    }
}

