/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.tessellation.BowyerWatson;

public class ShewchuckPredicates {
    private static ShewchuckPredicates instance;
    private double splitter;
    private double epsilon;
    private double resulterrbound;
    private double ccwerrboundA;
    private double ccwerrboundB;
    private double ccwerrboundC;
    private double o3derrboundA;
    private double o3derrboundB;
    private double o3derrboundC;
    private double iccerrboundA;
    private double iccerrboundB;
    private double iccerrboundC;
    private double isperrboundA;
    private double isperrboundB;
    private double isperrboundC;

    public static ShewchuckPredicates getInstance() {
        if (instance == null) {
            instance = new ShewchuckPredicates();
        }
        return instance;
    }

    private ShewchuckPredicates() {
        this.exactinit();
    }

    private void exactinit() {
        double lastcheck;
        boolean every_other = true;
        double half = 0.5;
        this.epsilon = 1.0;
        this.splitter = 1.0;
        double check = 1.0;
        do {
            lastcheck = check;
            this.epsilon *= half;
            if (every_other) {
                this.splitter *= 2.0;
            }
            every_other = !every_other;
        } while ((check = 1.0 + this.epsilon) != 1.0 && check != lastcheck);
        this.splitter += 1.0;
        this.resulterrbound = (3.0 + 8.0 * this.epsilon) * this.epsilon;
        this.ccwerrboundA = (3.0 + 16.0 * this.epsilon) * this.epsilon;
        this.ccwerrboundB = (2.0 + 12.0 * this.epsilon) * this.epsilon;
        this.ccwerrboundC = (9.0 + 64.0 * this.epsilon) * this.epsilon * this.epsilon;
        this.o3derrboundA = (7.0 + 56.0 * this.epsilon) * this.epsilon;
        this.o3derrboundB = (3.0 + 28.0 * this.epsilon) * this.epsilon;
        this.o3derrboundC = (26.0 + 288.0 * this.epsilon) * this.epsilon * this.epsilon;
        this.iccerrboundA = (10.0 + 96.0 * this.epsilon) * this.epsilon;
        this.iccerrboundB = (4.0 + 48.0 * this.epsilon) * this.epsilon;
        this.iccerrboundC = (44.0 + 576.0 * this.epsilon) * this.epsilon * this.epsilon;
        this.isperrboundA = (16.0 + 224.0 * this.epsilon) * this.epsilon;
        this.isperrboundB = (5.0 + 72.0 * this.epsilon) * this.epsilon;
        this.isperrboundC = (71.0 + 1408.0 * this.epsilon) * this.epsilon * this.epsilon;
    }

    double insphere(double[] pa, double[] pb, double[] pc, double[] pd, double[] pe) {
        double bexaeyplus;
        double aexbeyplus;
        double aezplus;
        double cexaeyplus;
        double aexceyplus;
        double aexdeyplus;
        double dexaeyplus;
        double dezplus;
        double cexbeyplus;
        double bexceyplus;
        double cezplus;
        double bexdeyplus;
        double dexbeyplus;
        double bezplus;
        double dexceyplus;
        double dex = pd[0] - pe[0];
        double dey = pd[1] - pe[1];
        double dez = pd[2] - pe[2];
        double dlift = dex * dex + dey * dey + dez * dez;
        double aez = pa[2] - pe[2];
        double bex = pb[0] - pe[0];
        double cey = pc[1] - pe[1];
        double bexcey = bex * cey;
        double cex = pc[0] - pe[0];
        double bey = pb[1] - pe[1];
        double cexbey = cex * bey;
        double bc = bexcey - cexbey;
        double bez = pb[2] - pe[2];
        double aex = pa[0] - pe[0];
        double aexcey = aex * cey;
        double aey = pa[1] - pe[1];
        double cexaey = cex * aey;
        double ac = aexcey - cexaey;
        double cez = pc[2] - pe[2];
        double aexbey = aex * bey;
        double bexaey = bex * aey;
        double ab = aexbey - bexaey;
        double abc = aez * bc - bez * ac + cez * ab;
        double clift = cex * cex + cey * cey + cez * cez;
        double bexdey = bex * dey;
        double dexbey = dex * bey;
        double bd = bexdey - dexbey;
        double dexaey = dex * aey;
        double aexdey = aex * dey;
        double da = dexaey - aexdey;
        double dab = dez * ab + aez * bd + bez * da;
        double blift = bex * bex + bey * bey + bez * bez;
        double cexdey = cex * dey;
        double dexcey = dex * cey;
        double cd = cexdey - dexcey;
        double cda = cez * da + dez * ac + aez * cd;
        double alift = aex * aex + aey * aey + aez * aez;
        double bcd = bez * cd - cez * bd + dez * bc;
        double det = dlift * abc - clift * dab + (blift * cda - alift * bcd);
        double cexdeyplus = cexdey >= 0.0 ? cexdey : -cexdey;
        double permanent = ((cexdeyplus + (dexceyplus = dexcey >= 0.0 ? dexcey : -dexcey)) * (bezplus = bez >= 0.0 ? bez : -bez) + ((dexbeyplus = dexbey >= 0.0 ? dexbey : -dexbey) + (bexdeyplus = bexdey >= 0.0 ? bexdey : -bexdey)) * (cezplus = cez >= 0.0 ? cez : -cez) + ((bexceyplus = bexcey >= 0.0 ? bexcey : -bexcey) + (cexbeyplus = cexbey >= 0.0 ? cexbey : -cexbey)) * (dezplus = dez >= 0.0 ? dez : -dez)) * alift + (((dexaeyplus = dexaey >= 0.0 ? dexaey : -dexaey) + (aexdeyplus = aexdey >= 0.0 ? aexdey : -aexdey)) * cezplus + ((aexceyplus = aexcey >= 0.0 ? aexcey : -aexcey) + (cexaeyplus = cexaey >= 0.0 ? cexaey : -cexaey)) * dezplus + (cexdeyplus + dexceyplus) * (aezplus = aez >= 0.0 ? aez : -aez)) * blift + (((aexbeyplus = aexbey >= 0.0 ? aexbey : -aexbey) + (bexaeyplus = bexaey >= 0.0 ? bexaey : -bexaey)) * dezplus + (bexdeyplus + dexbeyplus) * aezplus + (dexaeyplus + aexdeyplus) * bezplus) * clift + ((bexceyplus + cexbeyplus) * aezplus + (cexaeyplus + aexceyplus) * bezplus + (aexbeyplus + bexaeyplus) * cezplus) * dlift;
        double errbound = this.isperrboundA * permanent;
        if (det > errbound || -det > errbound) {
            return det;
        }
        return this.insphereadapt(pa, pb, pc, pd, pe, permanent);
    }

    double insphereadapt(double[] pa, double[] pb, double[] pc, double[] pd, double[] pe, double permanent) {
        double errbound;
        int cdlen;
        double[] ab = new double[4];
        double[] bc = new double[4];
        double[] cd = new double[4];
        double[] da = new double[4];
        double[] ac = new double[4];
        double[] bd = new double[4];
        double[] temp8a = new double[8];
        double[] temp8b = new double[8];
        double[] temp8c = new double[8];
        double[] temp16 = new double[16];
        double[] temp24 = new double[24];
        double[] temp48 = new double[48];
        double[] xdet = new double[96];
        double[] ydet = new double[96];
        double[] zdet = new double[96];
        double[] xydet = new double[192];
        double[] adet = new double[288];
        double[] bdet = new double[288];
        double[] cdet = new double[288];
        double[] ddet = new double[288];
        double[] abdet = new double[576];
        double[] cddet = new double[576];
        double[] fin1 = new double[1152];
        double aex = pa[0] - pe[0];
        double bex = pb[0] - pe[0];
        double cex = pc[0] - pe[0];
        double dex = pd[0] - pe[0];
        double aey = pa[1] - pe[1];
        double bey = pb[1] - pe[1];
        double cey = pc[1] - pe[1];
        double dey = pd[1] - pe[1];
        double aez = pa[2] - pe[2];
        double bez = pb[2] - pe[2];
        double cez = pc[2] - pe[2];
        double dez = pd[2] - pe[2];
        double aexbey1 = aex * bey;
        double c = this.splitter * aex;
        double abig = c - aex;
        double ahi = c - abig;
        double alo = aex - ahi;
        c = this.splitter * bey;
        abig = c - bey;
        double bhi = c - abig;
        double blo = bey - bhi;
        double err1 = aexbey1 - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double aexbey0 = alo * blo - err3;
        double bexaey1 = bex * aey;
        c = this.splitter * bex;
        abig = c - bex;
        ahi = c - abig;
        alo = bex - ahi;
        c = this.splitter * aey;
        abig = c - aey;
        bhi = c - abig;
        blo = aey - bhi;
        err1 = bexaey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bexaey0 = alo * blo - err3;
        double _i = aexbey0 - bexaey0;
        double bvirt = aexbey0 - _i;
        double avirt = _i + bvirt;
        double bround = bvirt - bexaey0;
        double around = aexbey0 - avirt;
        ab[0] = around + bround;
        double _j = aexbey1 + _i;
        bvirt = _j - aexbey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = aexbey1 - avirt;
        double _0 = around + bround;
        _i = _0 - bexaey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bexaey1;
        around = _0 - avirt;
        ab[1] = around + bround;
        double ab3 = _j + _i;
        bvirt = ab3 - _j;
        avirt = ab3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ab[2] = around + bround;
        ab[3] = ab3;
        double bexcey1 = bex * cey;
        c = this.splitter * bex;
        abig = c - bex;
        ahi = c - abig;
        alo = bex - ahi;
        c = this.splitter * cey;
        abig = c - cey;
        bhi = c - abig;
        blo = cey - bhi;
        err1 = bexcey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bexcey0 = alo * blo - err3;
        double cexbey1 = cex * bey;
        c = this.splitter * cex;
        abig = c - cex;
        ahi = c - abig;
        alo = cex - ahi;
        c = this.splitter * bey;
        abig = c - bey;
        bhi = c - abig;
        blo = bey - bhi;
        err1 = cexbey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cexbey0 = alo * blo - err3;
        _i = bexcey0 - cexbey0;
        bvirt = bexcey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cexbey0;
        around = bexcey0 - avirt;
        bc[0] = around + bround;
        _j = bexcey1 + _i;
        bvirt = _j - bexcey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bexcey1 - avirt;
        _0 = around + bround;
        _i = _0 - cexbey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cexbey1;
        around = _0 - avirt;
        bc[1] = around + bround;
        double bc3 = _j + _i;
        bvirt = bc3 - _j;
        avirt = bc3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bc[2] = around + bround;
        bc[3] = bc3;
        double cexdey1 = cex * dey;
        c = this.splitter * cex;
        abig = c - cex;
        ahi = c - abig;
        alo = cex - ahi;
        c = this.splitter * dey;
        abig = c - dey;
        bhi = c - abig;
        blo = dey - bhi;
        err1 = cexdey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cexdey0 = alo * blo - err3;
        double dexcey1 = dex * cey;
        c = this.splitter * dex;
        abig = c - dex;
        ahi = c - abig;
        alo = dex - ahi;
        c = this.splitter * cey;
        abig = c - cey;
        bhi = c - abig;
        blo = cey - bhi;
        err1 = dexcey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dexcey0 = alo * blo - err3;
        _i = cexdey0 - dexcey0;
        bvirt = cexdey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dexcey0;
        around = cexdey0 - avirt;
        cd[0] = around + bround;
        _j = cexdey1 + _i;
        bvirt = _j - cexdey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = cexdey1 - avirt;
        _0 = around + bround;
        _i = _0 - dexcey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dexcey1;
        around = _0 - avirt;
        cd[1] = around + bround;
        double cd3 = _j + _i;
        bvirt = cd3 - _j;
        avirt = cd3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        cd[2] = around + bround;
        cd[3] = cd3;
        double dexaey1 = dex * aey;
        c = this.splitter * dex;
        abig = c - dex;
        ahi = c - abig;
        alo = dex - ahi;
        c = this.splitter * aey;
        abig = c - aey;
        bhi = c - abig;
        blo = aey - bhi;
        err1 = dexaey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dexaey0 = alo * blo - err3;
        double aexdey1 = aex * dey;
        c = this.splitter * aex;
        abig = c - aex;
        ahi = c - abig;
        alo = aex - ahi;
        c = this.splitter * dey;
        abig = c - dey;
        bhi = c - abig;
        blo = dey - bhi;
        err1 = aexdey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double aexdey0 = alo * blo - err3;
        _i = dexaey0 - aexdey0;
        bvirt = dexaey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - aexdey0;
        around = dexaey0 - avirt;
        da[0] = around + bround;
        _j = dexaey1 + _i;
        bvirt = _j - dexaey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = dexaey1 - avirt;
        _0 = around + bround;
        _i = _0 - aexdey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - aexdey1;
        around = _0 - avirt;
        da[1] = around + bround;
        double da3 = _j + _i;
        bvirt = da3 - _j;
        avirt = da3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        da[2] = around + bround;
        da[3] = da3;
        double aexcey1 = aex * cey;
        c = this.splitter * aex;
        abig = c - aex;
        ahi = c - abig;
        alo = aex - ahi;
        c = this.splitter * cey;
        abig = c - cey;
        bhi = c - abig;
        blo = cey - bhi;
        err1 = aexcey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double aexcey0 = alo * blo - err3;
        double cexaey1 = cex * aey;
        c = this.splitter * cex;
        abig = c - cex;
        ahi = c - abig;
        alo = cex - ahi;
        c = this.splitter * aey;
        abig = c - aey;
        bhi = c - abig;
        blo = aey - bhi;
        err1 = cexaey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cexaey0 = alo * blo - err3;
        _i = aexcey0 - cexaey0;
        bvirt = aexcey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cexaey0;
        around = aexcey0 - avirt;
        ac[0] = around + bround;
        _j = aexcey1 + _i;
        bvirt = _j - aexcey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = aexcey1 - avirt;
        _0 = around + bround;
        _i = _0 - cexaey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cexaey1;
        around = _0 - avirt;
        ac[1] = around + bround;
        double ac3 = _j + _i;
        bvirt = ac3 - _j;
        avirt = ac3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ac[2] = around + bround;
        ac[3] = ac3;
        double bexdey1 = bex * dey;
        c = this.splitter * bex;
        abig = c - bex;
        ahi = c - abig;
        alo = bex - ahi;
        c = this.splitter * dey;
        abig = c - dey;
        bhi = c - abig;
        blo = dey - bhi;
        err1 = bexdey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bexdey0 = alo * blo - err3;
        double dexbey1 = dex * bey;
        c = this.splitter * dex;
        abig = c - dex;
        ahi = c - abig;
        alo = dex - ahi;
        c = this.splitter * bey;
        abig = c - bey;
        bhi = c - abig;
        blo = bey - bhi;
        err1 = dexbey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dexbey0 = alo * blo - err3;
        _i = bexdey0 - dexbey0;
        bvirt = bexdey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dexbey0;
        around = bexdey0 - avirt;
        bd[0] = around + bround;
        _j = bexdey1 + _i;
        bvirt = _j - bexdey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bexdey1 - avirt;
        _0 = around + bround;
        _i = _0 - dexbey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dexbey1;
        around = _0 - avirt;
        bd[1] = around + bround;
        double bd3 = _j + _i;
        bvirt = bd3 - _j;
        avirt = bd3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bd[2] = around + bround;
        bd[3] = bd3;
        int temp8alen = this.scale_expansion_zeroelim(4, cd, bez, temp8a);
        int temp8blen = this.scale_expansion_zeroelim(4, bd, -cez, temp8b);
        int temp8clen = this.scale_expansion_zeroelim(4, bc, dez, temp8c);
        int temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        int temp24len = this.fast_expansion_sum_zeroelim(temp8clen, temp8c, temp16len, temp16, temp24);
        int temp48len = this.scale_expansion_zeroelim(temp24len, temp24, aex, temp48);
        int xlen = this.scale_expansion_zeroelim(temp48len, temp48, -aex, xdet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, aey, temp48);
        int ylen = this.scale_expansion_zeroelim(temp48len, temp48, -aey, ydet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, aez, temp48);
        int zlen = this.scale_expansion_zeroelim(temp48len, temp48, -aez, zdet);
        int xylen = this.fast_expansion_sum_zeroelim(xlen, xdet, ylen, ydet, xydet);
        int alen = this.fast_expansion_sum_zeroelim(xylen, xydet, zlen, zdet, adet);
        temp8alen = this.scale_expansion_zeroelim(4, da, cez, temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, ac, dez, temp8b);
        temp8clen = this.scale_expansion_zeroelim(4, cd, aez, temp8c);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp24len = this.fast_expansion_sum_zeroelim(temp8clen, temp8c, temp16len, temp16, temp24);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, bex, temp48);
        xlen = this.scale_expansion_zeroelim(temp48len, temp48, bex, xdet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, bey, temp48);
        ylen = this.scale_expansion_zeroelim(temp48len, temp48, bey, ydet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, bez, temp48);
        zlen = this.scale_expansion_zeroelim(temp48len, temp48, bez, zdet);
        xylen = this.fast_expansion_sum_zeroelim(xlen, xdet, ylen, ydet, xydet);
        int blen = this.fast_expansion_sum_zeroelim(xylen, xydet, zlen, zdet, bdet);
        temp8alen = this.scale_expansion_zeroelim(4, ab, dez, temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, bd, aez, temp8b);
        temp8clen = this.scale_expansion_zeroelim(4, da, bez, temp8c);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp24len = this.fast_expansion_sum_zeroelim(temp8clen, temp8c, temp16len, temp16, temp24);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, cex, temp48);
        xlen = this.scale_expansion_zeroelim(temp48len, temp48, -cex, xdet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, cey, temp48);
        ylen = this.scale_expansion_zeroelim(temp48len, temp48, -cey, ydet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, cez, temp48);
        zlen = this.scale_expansion_zeroelim(temp48len, temp48, -cez, zdet);
        xylen = this.fast_expansion_sum_zeroelim(xlen, xdet, ylen, ydet, xydet);
        int clen = this.fast_expansion_sum_zeroelim(xylen, xydet, zlen, zdet, cdet);
        temp8alen = this.scale_expansion_zeroelim(4, bc, aez, temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, ac, -bez, temp8b);
        temp8clen = this.scale_expansion_zeroelim(4, ab, cez, temp8c);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp24len = this.fast_expansion_sum_zeroelim(temp8clen, temp8c, temp16len, temp16, temp24);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, dex, temp48);
        xlen = this.scale_expansion_zeroelim(temp48len, temp48, dex, xdet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, dey, temp48);
        ylen = this.scale_expansion_zeroelim(temp48len, temp48, dey, ydet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, dez, temp48);
        zlen = this.scale_expansion_zeroelim(temp48len, temp48, dez, zdet);
        xylen = this.fast_expansion_sum_zeroelim(xlen, xdet, ylen, ydet, xydet);
        int dlen = this.fast_expansion_sum_zeroelim(xylen, xydet, zlen, zdet, ddet);
        int ablen = this.fast_expansion_sum_zeroelim(alen, adet, blen, bdet, abdet);
        int finlength = this.fast_expansion_sum_zeroelim(ablen, abdet, cdlen = this.fast_expansion_sum_zeroelim(clen, cdet, dlen, ddet, cddet), cddet, fin1);
        double det = this.estimate(finlength, fin1);
        if (det >= (errbound = this.isperrboundB * permanent) || -det >= errbound) {
            return det;
        }
        bvirt = pa[0] - aex;
        avirt = aex + bvirt;
        bround = bvirt - pe[0];
        around = pa[0] - avirt;
        double aextail = around + bround;
        bvirt = pa[1] - aey;
        avirt = aey + bvirt;
        bround = bvirt - pe[1];
        around = pa[1] - avirt;
        double aeytail = around + bround;
        bvirt = pa[2] - aez;
        avirt = aez + bvirt;
        bround = bvirt - pe[2];
        around = pa[2] - avirt;
        double aeztail = around + bround;
        bvirt = pb[0] - bex;
        avirt = bex + bvirt;
        bround = bvirt - pe[0];
        around = pb[0] - avirt;
        double bextail = around + bround;
        bvirt = pb[1] - bey;
        avirt = bey + bvirt;
        bround = bvirt - pe[1];
        around = pb[1] - avirt;
        double beytail = around + bround;
        bvirt = pb[2] - bez;
        avirt = bez + bvirt;
        bround = bvirt - pe[2];
        around = pb[2] - avirt;
        double beztail = around + bround;
        bvirt = pc[0] - cex;
        avirt = cex + bvirt;
        bround = bvirt - pe[0];
        around = pc[0] - avirt;
        double cextail = around + bround;
        bvirt = pc[1] - cey;
        avirt = cey + bvirt;
        bround = bvirt - pe[1];
        around = pc[1] - avirt;
        double ceytail = around + bround;
        bvirt = pc[2] - cez;
        avirt = cez + bvirt;
        bround = bvirt - pe[2];
        around = pc[2] - avirt;
        double ceztail = around + bround;
        bvirt = pd[0] - dex;
        avirt = dex + bvirt;
        bround = bvirt - pe[0];
        around = pd[0] - avirt;
        double dextail = around + bround;
        bvirt = pd[1] - dey;
        avirt = dey + bvirt;
        bround = bvirt - pe[1];
        around = pd[1] - avirt;
        double deytail = around + bround;
        bvirt = pd[2] - dez;
        avirt = dez + bvirt;
        bround = bvirt - pe[2];
        around = pd[2] - avirt;
        double deztail = around + bround;
        if (aextail == 0.0 && aeytail == 0.0 && aeztail == 0.0 && bextail == 0.0 && beytail == 0.0 && beztail == 0.0 && cextail == 0.0 && ceytail == 0.0 && ceztail == 0.0 && dextail == 0.0 && deytail == 0.0 && deztail == 0.0) {
            return det;
        }
        errbound = this.isperrboundC * permanent + this.resulterrbound * (det >= 0.0 ? det : -det);
        double daeps = dex * aeytail + aey * dextail - (dey * aextail + aex * deytail);
        double aceps = aex * ceytail + cey * aextail - (aey * cextail + cex * aeytail);
        double cdeps = cex * deytail + dey * cextail - (cey * dextail + dex * ceytail);
        double bceps = bex * ceytail + cey * bextail - (bey * cextail + cex * beytail);
        double abeps = aex * beytail + bey * aextail - (aey * bextail + bex * aeytail);
        double bdeps = bex * deytail + dey * bextail - (bey * dextail + dex * beytail);
        if ((det += (bex * bex + bey * bey + bez * bez) * (cez * daeps + dez * aceps + aez * cdeps + (ceztail * da3 + deztail * ac3 + aeztail * cd3)) + (dex * dex + dey * dey + dez * dez) * (aez * bceps - bez * aceps + cez * abeps + (aeztail * bc3 - beztail * ac3 + ceztail * ab3)) - ((aex * aex + aey * aey + aez * aez) * (bez * cdeps - cez * bdeps + dez * bceps + (beztail * cd3 - ceztail * bd3 + deztail * bc3)) + (cex * cex + cey * cey + cez * cez) * (dez * abeps + aez * bdeps + bez * daeps + (deztail * ab3 + aeztail * bd3 + beztail * da3))) + 2.0 * ((bex * bextail + bey * beytail + bez * beztail) * (cez * da3 + dez * ac3 + aez * cd3) + (dex * dextail + dey * deytail + dez * deztail) * (aez * bc3 - bez * ac3 + cez * ab3) - ((aex * aextail + aey * aeytail + aez * aeztail) * (bez * cd3 - cez * bd3 + dez * bc3) + (cex * cextail + cey * ceytail + cez * ceztail) * (dez * ab3 + aez * bd3 + bez * da3)))) >= errbound || -det >= errbound) {
            return det;
        }
        return this.insphereexact(pa, pb, pc, pd, pe);
    }

    double insphereexact(double[] pa, double[] pb, double[] pc, double[] pd, double[] pe) {
        int i;
        double[] ab = new double[4];
        double[] bc = new double[4];
        double[] cd = new double[4];
        double[] de = new double[4];
        double[] ea = new double[4];
        double[] ac = new double[4];
        double[] bd = new double[4];
        double[] ce = new double[4];
        double[] da = new double[4];
        double[] eb = new double[4];
        double[] temp8a = new double[8];
        double[] temp8b = new double[8];
        double[] temp16 = new double[16];
        double[] abc = new double[24];
        double[] bcd = new double[24];
        double[] cde = new double[24];
        double[] dea = new double[24];
        double[] eab = new double[24];
        double[] abd = new double[24];
        double[] bce = new double[24];
        double[] cda = new double[24];
        double[] deb = new double[24];
        double[] eac = new double[24];
        double[] temp48a = new double[48];
        double[] temp48b = new double[48];
        double[] abcd = new double[96];
        double[] bcde = new double[96];
        double[] cdea = new double[96];
        double[] deab = new double[96];
        double[] eabc = new double[96];
        double[] temp192 = new double[192];
        double[] det384x = new double[384];
        double[] det384y = new double[384];
        double[] det384z = new double[384];
        double[] detxy = new double[768];
        double[] adet = new double[1152];
        double[] bdet = new double[1152];
        double[] cdet = new double[1152];
        double[] ddet = new double[1152];
        double[] edet = new double[1152];
        double[] abdet = new double[2304];
        double[] cddet = new double[2304];
        double[] cdedet = new double[3456];
        double[] deter = new double[5760];
        double axby1 = pa[0] * pb[1];
        double c = this.splitter * pa[0];
        double abig = c - pa[0];
        double ahi = c - abig;
        double alo = pa[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        double bhi = c - abig;
        double blo = pb[1] - bhi;
        double err1 = axby1 - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double axby0 = alo * blo - err3;
        double bxay1 = pb[0] * pa[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = bxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxay0 = alo * blo - err3;
        double _i = axby0 - bxay0;
        double bvirt = axby0 - _i;
        double avirt = _i + bvirt;
        double bround = bvirt - bxay0;
        double around = axby0 - avirt;
        ab[0] = around + bround;
        double _j = axby1 + _i;
        bvirt = _j - axby1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = axby1 - avirt;
        double _0 = around + bround;
        _i = _0 - bxay1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bxay1;
        around = _0 - avirt;
        ab[1] = around + bround;
        ab[3] = _j + _i;
        bvirt = ab[3] - _j;
        avirt = ab[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ab[2] = around + bround;
        double bxcy1 = pb[0] * pc[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = bxcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxcy0 = alo * blo - err3;
        double cxby1 = pc[0] * pb[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        bhi = c - abig;
        blo = pb[1] - bhi;
        err1 = cxby1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxby0 = alo * blo - err3;
        _i = bxcy0 - cxby0;
        bvirt = bxcy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxby0;
        around = bxcy0 - avirt;
        bc[0] = around + bround;
        _j = bxcy1 + _i;
        bvirt = _j - bxcy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bxcy1 - avirt;
        _0 = around + bround;
        _i = _0 - cxby1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxby1;
        around = _0 - avirt;
        bc[1] = around + bround;
        bc[3] = _j + _i;
        bvirt = bc[3] - _j;
        avirt = bc[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bc[2] = around + bround;
        double cxdy1 = pc[0] * pd[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = cxdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxdy0 = alo * blo - err3;
        double dxcy1 = pd[0] * pc[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = dxcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxcy0 = alo * blo - err3;
        _i = cxdy0 - dxcy0;
        bvirt = cxdy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxcy0;
        around = cxdy0 - avirt;
        cd[0] = around + bround;
        _j = cxdy1 + _i;
        bvirt = _j - cxdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = cxdy1 - avirt;
        _0 = around + bround;
        _i = _0 - dxcy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxcy1;
        around = _0 - avirt;
        cd[1] = around + bround;
        cd[3] = _j + _i;
        bvirt = cd[3] - _j;
        avirt = cd[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        cd[2] = around + bround;
        double dxey1 = pd[0] * pe[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pe[1];
        abig = c - pe[1];
        bhi = c - abig;
        blo = pe[1] - bhi;
        err1 = dxey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxey0 = alo * blo - err3;
        double exdy1 = pe[0] * pd[1];
        c = this.splitter * pe[0];
        abig = c - pe[0];
        ahi = c - abig;
        alo = pe[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = exdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double exdy0 = alo * blo - err3;
        _i = dxey0 - exdy0;
        bvirt = dxey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - exdy0;
        around = dxey0 - avirt;
        de[0] = around + bround;
        _j = dxey1 + _i;
        bvirt = _j - dxey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = dxey1 - avirt;
        _0 = around + bround;
        _i = _0 - exdy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - exdy1;
        around = _0 - avirt;
        de[1] = around + bround;
        de[3] = _j + _i;
        bvirt = de[3] - _j;
        avirt = de[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        de[2] = around + bround;
        double exay1 = pe[0] * pa[1];
        c = this.splitter * pe[0];
        abig = c - pe[0];
        ahi = c - abig;
        alo = pe[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = exay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double exay0 = alo * blo - err3;
        double axey1 = pa[0] * pe[1];
        c = this.splitter * pa[0];
        abig = c - pa[0];
        ahi = c - abig;
        alo = pa[0] - ahi;
        c = this.splitter * pe[1];
        abig = c - pe[1];
        bhi = c - abig;
        blo = pe[1] - bhi;
        err1 = axey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double axey0 = alo * blo - err3;
        _i = exay0 - axey0;
        bvirt = exay0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axey0;
        around = exay0 - avirt;
        ea[0] = around + bround;
        _j = exay1 + _i;
        bvirt = _j - exay1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = exay1 - avirt;
        _0 = around + bround;
        _i = _0 - axey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axey1;
        around = _0 - avirt;
        ea[1] = around + bround;
        ea[3] = _j + _i;
        bvirt = ea[3] - _j;
        avirt = ea[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ea[2] = around + bround;
        double axcy1 = pa[0] * pc[1];
        c = this.splitter * pa[0];
        abig = c - pa[0];
        ahi = c - abig;
        alo = pa[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = axcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double axcy0 = alo * blo - err3;
        double cxay1 = pc[0] * pa[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = cxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxay0 = alo * blo - err3;
        _i = axcy0 - cxay0;
        bvirt = axcy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxay0;
        around = axcy0 - avirt;
        ac[0] = around + bround;
        _j = axcy1 + _i;
        bvirt = _j - axcy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = axcy1 - avirt;
        _0 = around + bround;
        _i = _0 - cxay1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxay1;
        around = _0 - avirt;
        ac[1] = around + bround;
        ac[3] = _j + _i;
        bvirt = ac[3] - _j;
        avirt = ac[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ac[2] = around + bround;
        double bxdy1 = pb[0] * pd[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = bxdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxdy0 = alo * blo - err3;
        double dxby1 = pd[0] * pb[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        bhi = c - abig;
        blo = pb[1] - bhi;
        err1 = dxby1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxby0 = alo * blo - err3;
        _i = bxdy0 - dxby0;
        bvirt = bxdy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxby0;
        around = bxdy0 - avirt;
        bd[0] = around + bround;
        _j = bxdy1 + _i;
        bvirt = _j - bxdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bxdy1 - avirt;
        _0 = around + bround;
        _i = _0 - dxby1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxby1;
        around = _0 - avirt;
        bd[1] = around + bround;
        bd[3] = _j + _i;
        bvirt = bd[3] - _j;
        avirt = bd[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bd[2] = around + bround;
        double cxey1 = pc[0] * pe[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pe[1];
        abig = c - pe[1];
        bhi = c - abig;
        blo = pe[1] - bhi;
        err1 = cxey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxey0 = alo * blo - err3;
        double excy1 = pe[0] * pc[1];
        c = this.splitter * pe[0];
        abig = c - pe[0];
        ahi = c - abig;
        alo = pe[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = excy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double excy0 = alo * blo - err3;
        _i = cxey0 - excy0;
        bvirt = cxey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - excy0;
        around = cxey0 - avirt;
        ce[0] = around + bround;
        _j = cxey1 + _i;
        bvirt = _j - cxey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = cxey1 - avirt;
        _0 = around + bround;
        _i = _0 - excy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - excy1;
        around = _0 - avirt;
        ce[1] = around + bround;
        ce[3] = _j + _i;
        bvirt = ce[3] - _j;
        avirt = ce[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ce[2] = around + bround;
        double dxay1 = pd[0] * pa[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = dxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxay0 = alo * blo - err3;
        double axdy1 = pa[0] * pd[1];
        c = this.splitter * pa[0];
        abig = c - pa[0];
        ahi = c - abig;
        alo = pa[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = axdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double axdy0 = alo * blo - err3;
        _i = dxay0 - axdy0;
        bvirt = dxay0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axdy0;
        around = dxay0 - avirt;
        da[0] = around + bround;
        _j = dxay1 + _i;
        bvirt = _j - dxay1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = dxay1 - avirt;
        _0 = around + bround;
        _i = _0 - axdy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axdy1;
        around = _0 - avirt;
        da[1] = around + bround;
        da[3] = _j + _i;
        bvirt = da[3] - _j;
        avirt = da[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        da[2] = around + bround;
        double exby1 = pe[0] * pb[1];
        c = this.splitter * pe[0];
        abig = c - pe[0];
        ahi = c - abig;
        alo = pe[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        bhi = c - abig;
        blo = pb[1] - bhi;
        err1 = exby1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double exby0 = alo * blo - err3;
        double bxey1 = pb[0] * pe[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pe[1];
        abig = c - pe[1];
        bhi = c - abig;
        blo = pe[1] - bhi;
        err1 = bxey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxey0 = alo * blo - err3;
        _i = exby0 - bxey0;
        bvirt = exby0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bxey0;
        around = exby0 - avirt;
        eb[0] = around + bround;
        _j = exby1 + _i;
        bvirt = _j - exby1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = exby1 - avirt;
        _0 = around + bround;
        _i = _0 - bxey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bxey1;
        around = _0 - avirt;
        eb[1] = around + bround;
        eb[3] = _j + _i;
        bvirt = eb[3] - _j;
        avirt = eb[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        eb[2] = around + bround;
        int temp8alen = this.scale_expansion_zeroelim(4, bc, pa[2], temp8a);
        int temp8blen = this.scale_expansion_zeroelim(4, ac, -pb[2], temp8b);
        int temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, ab, pc[2], temp8a);
        int abclen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, abc);
        temp8alen = this.scale_expansion_zeroelim(4, cd, pb[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, bd, -pc[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, bc, pd[2], temp8a);
        int bcdlen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, bcd);
        temp8alen = this.scale_expansion_zeroelim(4, de, pc[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, ce, -pd[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, cd, pe[2], temp8a);
        int cdelen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, cde);
        temp8alen = this.scale_expansion_zeroelim(4, ea, pd[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, da, -pe[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, de, pa[2], temp8a);
        int dealen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, dea);
        temp8alen = this.scale_expansion_zeroelim(4, ab, pe[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, eb, -pa[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, ea, pb[2], temp8a);
        int eablen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, eab);
        temp8alen = this.scale_expansion_zeroelim(4, bd, pa[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, da, pb[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, ab, pd[2], temp8a);
        int abdlen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, abd);
        temp8alen = this.scale_expansion_zeroelim(4, ce, pb[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, eb, pc[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, bc, pe[2], temp8a);
        int bcelen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, bce);
        temp8alen = this.scale_expansion_zeroelim(4, da, pc[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, ac, pd[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, cd, pa[2], temp8a);
        int cdalen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, cda);
        temp8alen = this.scale_expansion_zeroelim(4, eb, pd[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, bd, pe[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, de, pb[2], temp8a);
        int deblen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, deb);
        temp8alen = this.scale_expansion_zeroelim(4, ac, pe[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, ce, pa[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, ea, pc[2], temp8a);
        int eaclen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, eac);
        int temp48alen = this.fast_expansion_sum_zeroelim(cdelen, cde, bcelen, bce, temp48a);
        int temp48blen = this.fast_expansion_sum_zeroelim(deblen, deb, bcdlen, bcd, temp48b);
        for (i = 0; i < temp48blen; ++i) {
            temp48b[i] = -temp48b[i];
        }
        int bcdelen = this.fast_expansion_sum_zeroelim(temp48alen, temp48a, temp48blen, temp48b, bcde);
        int xlen = this.scale_expansion_zeroelim(bcdelen, bcde, pa[0], temp192);
        xlen = this.scale_expansion_zeroelim(xlen, temp192, pa[0], det384x);
        int ylen = this.scale_expansion_zeroelim(bcdelen, bcde, pa[1], temp192);
        ylen = this.scale_expansion_zeroelim(ylen, temp192, pa[1], det384y);
        int zlen = this.scale_expansion_zeroelim(bcdelen, bcde, pa[2], temp192);
        zlen = this.scale_expansion_zeroelim(zlen, temp192, pa[2], det384z);
        int xylen = this.fast_expansion_sum_zeroelim(xlen, det384x, ylen, det384y, detxy);
        int alen = this.fast_expansion_sum_zeroelim(xylen, detxy, zlen, det384z, adet);
        temp48alen = this.fast_expansion_sum_zeroelim(dealen, dea, cdalen, cda, temp48a);
        temp48blen = this.fast_expansion_sum_zeroelim(eaclen, eac, cdelen, cde, temp48b);
        for (i = 0; i < temp48blen; ++i) {
            temp48b[i] = -temp48b[i];
        }
        int cdealen = this.fast_expansion_sum_zeroelim(temp48alen, temp48a, temp48blen, temp48b, cdea);
        xlen = this.scale_expansion_zeroelim(cdealen, cdea, pb[0], temp192);
        xlen = this.scale_expansion_zeroelim(xlen, temp192, pb[0], det384x);
        ylen = this.scale_expansion_zeroelim(cdealen, cdea, pb[1], temp192);
        ylen = this.scale_expansion_zeroelim(ylen, temp192, pb[1], det384y);
        zlen = this.scale_expansion_zeroelim(cdealen, cdea, pb[2], temp192);
        zlen = this.scale_expansion_zeroelim(zlen, temp192, pb[2], det384z);
        xylen = this.fast_expansion_sum_zeroelim(xlen, det384x, ylen, det384y, detxy);
        int blen = this.fast_expansion_sum_zeroelim(xylen, detxy, zlen, det384z, bdet);
        temp48alen = this.fast_expansion_sum_zeroelim(eablen, eab, deblen, deb, temp48a);
        temp48blen = this.fast_expansion_sum_zeroelim(abdlen, abd, dealen, dea, temp48b);
        for (i = 0; i < temp48blen; ++i) {
            temp48b[i] = -temp48b[i];
        }
        int deablen = this.fast_expansion_sum_zeroelim(temp48alen, temp48a, temp48blen, temp48b, deab);
        xlen = this.scale_expansion_zeroelim(deablen, deab, pc[0], temp192);
        xlen = this.scale_expansion_zeroelim(xlen, temp192, pc[0], det384x);
        ylen = this.scale_expansion_zeroelim(deablen, deab, pc[1], temp192);
        ylen = this.scale_expansion_zeroelim(ylen, temp192, pc[1], det384y);
        zlen = this.scale_expansion_zeroelim(deablen, deab, pc[2], temp192);
        zlen = this.scale_expansion_zeroelim(zlen, temp192, pc[2], det384z);
        xylen = this.fast_expansion_sum_zeroelim(xlen, det384x, ylen, det384y, detxy);
        int clen = this.fast_expansion_sum_zeroelim(xylen, detxy, zlen, det384z, cdet);
        temp48alen = this.fast_expansion_sum_zeroelim(abclen, abc, eaclen, eac, temp48a);
        temp48blen = this.fast_expansion_sum_zeroelim(bcelen, bce, eablen, eab, temp48b);
        for (i = 0; i < temp48blen; ++i) {
            temp48b[i] = -temp48b[i];
        }
        int eabclen = this.fast_expansion_sum_zeroelim(temp48alen, temp48a, temp48blen, temp48b, eabc);
        xlen = this.scale_expansion_zeroelim(eabclen, eabc, pd[0], temp192);
        xlen = this.scale_expansion_zeroelim(xlen, temp192, pd[0], det384x);
        ylen = this.scale_expansion_zeroelim(eabclen, eabc, pd[1], temp192);
        ylen = this.scale_expansion_zeroelim(ylen, temp192, pd[1], det384y);
        zlen = this.scale_expansion_zeroelim(eabclen, eabc, pd[2], temp192);
        zlen = this.scale_expansion_zeroelim(zlen, temp192, pd[2], det384z);
        xylen = this.fast_expansion_sum_zeroelim(xlen, det384x, ylen, det384y, detxy);
        int dlen = this.fast_expansion_sum_zeroelim(xylen, detxy, zlen, det384z, ddet);
        temp48alen = this.fast_expansion_sum_zeroelim(bcdlen, bcd, abdlen, abd, temp48a);
        temp48blen = this.fast_expansion_sum_zeroelim(cdalen, cda, abclen, abc, temp48b);
        for (i = 0; i < temp48blen; ++i) {
            temp48b[i] = -temp48b[i];
        }
        int abcdlen = this.fast_expansion_sum_zeroelim(temp48alen, temp48a, temp48blen, temp48b, abcd);
        xlen = this.scale_expansion_zeroelim(abcdlen, abcd, pe[0], temp192);
        xlen = this.scale_expansion_zeroelim(xlen, temp192, pe[0], det384x);
        ylen = this.scale_expansion_zeroelim(abcdlen, abcd, pe[1], temp192);
        ylen = this.scale_expansion_zeroelim(ylen, temp192, pe[1], det384y);
        zlen = this.scale_expansion_zeroelim(abcdlen, abcd, pe[2], temp192);
        zlen = this.scale_expansion_zeroelim(zlen, temp192, pe[2], det384z);
        xylen = this.fast_expansion_sum_zeroelim(xlen, det384x, ylen, det384y, detxy);
        int elen = this.fast_expansion_sum_zeroelim(xylen, detxy, zlen, det384z, edet);
        int ablen = this.fast_expansion_sum_zeroelim(alen, adet, blen, bdet, abdet);
        int cdlen = this.fast_expansion_sum_zeroelim(clen, cdet, dlen, ddet, cddet);
        cdelen = this.fast_expansion_sum_zeroelim(cdlen, cddet, elen, edet, cdedet);
        int deterlen = this.fast_expansion_sum_zeroelim(ablen, abdet, cdelen, cdedet, deter);
        return deter[deterlen - 1];
    }

    double orient(double[] pa, double[] pb, double[] pc, double[] pd) {
        double adz = pa[2] - pd[2];
        double bdx = pb[0] - pd[0];
        double cdy = pc[1] - pd[1];
        double bdxcdy = bdx * cdy;
        double cdx = pc[0] - pd[0];
        double bdy = pb[1] - pd[1];
        double cdxbdy = cdx * bdy;
        double bdz = pb[2] - pd[2];
        double ady = pa[1] - pd[1];
        double cdxady = cdx * ady;
        double adx = pa[0] - pd[0];
        double adxcdy = adx * cdy;
        double cdz = pc[2] - pd[2];
        double adxbdy = adx * bdy;
        double bdxady = bdx * ady;
        double det = adz * (bdxcdy - cdxbdy) + bdz * (cdxady - adxcdy) + cdz * (adxbdy - bdxady);
        double permanent = ((bdxcdy >= 0.0 ? bdxcdy : -bdxcdy) + (cdxbdy >= 0.0 ? cdxbdy : -cdxbdy)) * (adz >= 0.0 ? adz : -adz) + ((cdxady >= 0.0 ? cdxady : -cdxady) + (adxcdy >= 0.0 ? adxcdy : -adxcdy)) * (bdz >= 0.0 ? bdz : -bdz) + ((adxbdy >= 0.0 ? adxbdy : -adxbdy) + (bdxady >= 0.0 ? bdxady : -bdxady)) * (cdz >= 0.0 ? cdz : -cdz);
        double errbound = this.o3derrboundA * permanent;
        if (det > errbound || -det > errbound) {
            return det;
        }
        return this.orient3dadapt(pa, pb, pc, pd, permanent);
    }

    double orient3dadapt(double[] pa, double[] pb, double[] pc, double[] pd, double permanent) {
        double u3;
        double _k;
        int vlength;
        int ct_blen;
        int ct_alen;
        int bt_alen;
        int bt_clen;
        double negate;
        int at_clen;
        int at_blen;
        double errbound;
        double[] bc = new double[4];
        double[] ca = new double[4];
        double[] ab = new double[4];
        double[] adet = new double[8];
        double[] bdet = new double[8];
        double[] cdet = new double[8];
        double[] abdet = new double[16];
        double[] fin1 = new double[192];
        double[] fin2 = new double[192];
        double[] at_b = new double[4];
        double[] at_c = new double[4];
        double[] bt_c = new double[4];
        double[] bt_a = new double[4];
        double[] ct_a = new double[4];
        double[] ct_b = new double[4];
        double[] bct = new double[8];
        double[] cat = new double[8];
        double[] abt = new double[8];
        double[] u = new double[4];
        double[] v = new double[12];
        double[] w = new double[16];
        double adx = pa[0] - pd[0];
        double bdx = pb[0] - pd[0];
        double cdx = pc[0] - pd[0];
        double ady = pa[1] - pd[1];
        double bdy = pb[1] - pd[1];
        double cdy = pc[1] - pd[1];
        double adz = pa[2] - pd[2];
        double bdz = pb[2] - pd[2];
        double cdz = pc[2] - pd[2];
        double bdxcdy1 = bdx * cdy;
        double c = this.splitter * bdx;
        double abig = c - bdx;
        double ahi = c - abig;
        double alo = bdx - ahi;
        c = this.splitter * cdy;
        abig = c - cdy;
        double bhi = c - abig;
        double blo = cdy - bhi;
        double err1 = bdxcdy1 - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double bdxcdy0 = alo * blo - err3;
        double cdxbdy1 = cdx * bdy;
        c = this.splitter * cdx;
        abig = c - cdx;
        ahi = c - abig;
        alo = cdx - ahi;
        c = this.splitter * bdy;
        abig = c - bdy;
        bhi = c - abig;
        blo = bdy - bhi;
        err1 = cdxbdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cdxbdy0 = alo * blo - err3;
        double _i = bdxcdy0 - cdxbdy0;
        double bvirt = bdxcdy0 - _i;
        double avirt = _i + bvirt;
        double bround = bvirt - cdxbdy0;
        double around = bdxcdy0 - avirt;
        bc[0] = around + bround;
        double _j = bdxcdy1 + _i;
        bvirt = _j - bdxcdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bdxcdy1 - avirt;
        double _0 = around + bround;
        _i = _0 - cdxbdy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cdxbdy1;
        around = _0 - avirt;
        bc[1] = around + bround;
        double bc3 = _j + _i;
        bvirt = bc3 - _j;
        avirt = bc3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bc[2] = around + bround;
        bc[3] = bc3;
        int alen = this.scale_expansion_zeroelim(4, bc, adz, adet);
        double cdxady1 = cdx * ady;
        c = this.splitter * cdx;
        abig = c - cdx;
        ahi = c - abig;
        alo = cdx - ahi;
        c = this.splitter * ady;
        abig = c - ady;
        bhi = c - abig;
        blo = ady - bhi;
        err1 = cdxady1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cdxady0 = alo * blo - err3;
        double adxcdy1 = adx * cdy;
        c = this.splitter * adx;
        abig = c - adx;
        ahi = c - abig;
        alo = adx - ahi;
        c = this.splitter * cdy;
        abig = c - cdy;
        bhi = c - abig;
        blo = cdy - bhi;
        err1 = adxcdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double adxcdy0 = alo * blo - err3;
        _i = cdxady0 - adxcdy0;
        bvirt = cdxady0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - adxcdy0;
        around = cdxady0 - avirt;
        ca[0] = around + bround;
        _j = cdxady1 + _i;
        bvirt = _j - cdxady1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = cdxady1 - avirt;
        _0 = around + bround;
        _i = _0 - adxcdy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - adxcdy1;
        around = _0 - avirt;
        ca[1] = around + bround;
        double ca3 = _j + _i;
        bvirt = ca3 - _j;
        avirt = ca3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ca[2] = around + bround;
        ca[3] = ca3;
        int blen = this.scale_expansion_zeroelim(4, ca, bdz, bdet);
        double adxbdy1 = adx * bdy;
        c = this.splitter * adx;
        abig = c - adx;
        ahi = c - abig;
        alo = adx - ahi;
        c = this.splitter * bdy;
        abig = c - bdy;
        bhi = c - abig;
        blo = bdy - bhi;
        err1 = adxbdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double adxbdy0 = alo * blo - err3;
        double bdxady1 = bdx * ady;
        c = this.splitter * bdx;
        abig = c - bdx;
        ahi = c - abig;
        alo = bdx - ahi;
        c = this.splitter * ady;
        abig = c - ady;
        bhi = c - abig;
        blo = ady - bhi;
        err1 = bdxady1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bdxady0 = alo * blo - err3;
        _i = adxbdy0 - bdxady0;
        bvirt = adxbdy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bdxady0;
        around = adxbdy0 - avirt;
        ab[0] = around + bround;
        _j = adxbdy1 + _i;
        bvirt = _j - adxbdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = adxbdy1 - avirt;
        _0 = around + bround;
        _i = _0 - bdxady1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bdxady1;
        around = _0 - avirt;
        ab[1] = around + bround;
        double ab3 = _j + _i;
        bvirt = ab3 - _j;
        avirt = ab3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ab[2] = around + bround;
        ab[3] = ab3;
        int clen = this.scale_expansion_zeroelim(4, ab, cdz, cdet);
        int ablen = this.fast_expansion_sum_zeroelim(alen, adet, blen, bdet, abdet);
        int finlength = this.fast_expansion_sum_zeroelim(ablen, abdet, clen, cdet, fin1);
        double det = this.estimate(finlength, fin1);
        if (det >= (errbound = this.o3derrboundB * permanent) || -det >= errbound) {
            return det;
        }
        bvirt = pa[0] - adx;
        avirt = adx + bvirt;
        bround = bvirt - pd[0];
        around = pa[0] - avirt;
        double adxtail = around + bround;
        bvirt = pb[0] - bdx;
        avirt = bdx + bvirt;
        bround = bvirt - pd[0];
        around = pb[0] - avirt;
        double bdxtail = around + bround;
        bvirt = pc[0] - cdx;
        avirt = cdx + bvirt;
        bround = bvirt - pd[0];
        around = pc[0] - avirt;
        double cdxtail = around + bround;
        bvirt = pa[1] - ady;
        avirt = ady + bvirt;
        bround = bvirt - pd[1];
        around = pa[1] - avirt;
        double adytail = around + bround;
        bvirt = pb[1] - bdy;
        avirt = bdy + bvirt;
        bround = bvirt - pd[1];
        around = pb[1] - avirt;
        double bdytail = around + bround;
        bvirt = pc[1] - cdy;
        avirt = cdy + bvirt;
        bround = bvirt - pd[1];
        around = pc[1] - avirt;
        double cdytail = around + bround;
        bvirt = pa[2] - adz;
        avirt = adz + bvirt;
        bround = bvirt - pd[2];
        around = pa[2] - avirt;
        double adztail = around + bround;
        bvirt = pb[2] - bdz;
        avirt = bdz + bvirt;
        bround = bvirt - pd[2];
        around = pb[2] - avirt;
        double bdztail = around + bround;
        bvirt = pc[2] - cdz;
        avirt = cdz + bvirt;
        bround = bvirt - pd[2];
        around = pc[2] - avirt;
        double cdztail = around + bround;
        if (adxtail == 0.0 && bdxtail == 0.0 && cdxtail == 0.0 && adytail == 0.0 && bdytail == 0.0 && cdytail == 0.0 && adztail == 0.0 && bdztail == 0.0 && cdztail == 0.0) {
            return det;
        }
        errbound = this.o3derrboundC * permanent + this.resulterrbound * (det >= 0.0 ? det : -det);
        if ((det += adz * (bdx * cdytail + cdy * bdxtail - (bdy * cdxtail + cdx * bdytail)) + adztail * (bdx * cdy - bdy * cdx) + (bdz * (cdx * adytail + ady * cdxtail - (cdy * adxtail + adx * cdytail)) + bdztail * (cdx * ady - cdy * adx)) + (cdz * (adx * bdytail + bdy * adxtail - (ady * bdxtail + bdx * adytail)) + cdztail * (adx * bdy - ady * bdx))) >= errbound || -det >= errbound) {
            return det;
        }
        double[] finnow = fin1;
        double[] finother = fin2;
        if (adxtail == 0.0) {
            if (adytail == 0.0) {
                at_b[0] = 0.0;
                at_blen = 1;
                at_c[0] = 0.0;
                at_clen = 1;
            } else {
                negate = -adytail;
                double at_blarge = negate * bdx;
                c = this.splitter * negate;
                abig = c - negate;
                ahi = c - abig;
                alo = negate - ahi;
                c = this.splitter * bdx;
                abig = c - bdx;
                bhi = c - abig;
                blo = bdx - bhi;
                err1 = at_blarge - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                at_b[0] = alo * blo - err3;
                at_b[1] = at_blarge;
                at_blen = 2;
                double at_clarge = adytail * cdx;
                c = this.splitter * adytail;
                abig = c - adytail;
                ahi = c - abig;
                alo = adytail - ahi;
                c = this.splitter * cdx;
                abig = c - cdx;
                bhi = c - abig;
                blo = cdx - bhi;
                err1 = at_clarge - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                at_c[0] = alo * blo - err3;
                at_c[1] = at_clarge;
                at_clen = 2;
            }
        } else if (adytail == 0.0) {
            double at_blarge = adxtail * bdy;
            c = this.splitter * adxtail;
            abig = c - adxtail;
            ahi = c - abig;
            alo = adxtail - ahi;
            c = this.splitter * bdy;
            abig = c - bdy;
            bhi = c - abig;
            blo = bdy - bhi;
            err1 = at_blarge - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            at_b[0] = alo * blo - err3;
            at_b[1] = at_blarge;
            at_blen = 2;
            negate = -adxtail;
            double at_clarge = negate * cdy;
            c = this.splitter * negate;
            abig = c - negate;
            ahi = c - abig;
            alo = negate - ahi;
            c = this.splitter * cdy;
            abig = c - cdy;
            bhi = c - abig;
            blo = cdy - bhi;
            err1 = at_clarge - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            at_c[0] = alo * blo - err3;
            at_c[1] = at_clarge;
            at_clen = 2;
        } else {
            double adxt_bdy1 = adxtail * bdy;
            c = this.splitter * adxtail;
            abig = c - adxtail;
            ahi = c - abig;
            alo = adxtail - ahi;
            c = this.splitter * bdy;
            abig = c - bdy;
            bhi = c - abig;
            blo = bdy - bhi;
            err1 = adxt_bdy1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double adxt_bdy0 = alo * blo - err3;
            double adyt_bdx1 = adytail * bdx;
            c = this.splitter * adytail;
            abig = c - adytail;
            ahi = c - abig;
            alo = adytail - ahi;
            c = this.splitter * bdx;
            abig = c - bdx;
            bhi = c - abig;
            blo = bdx - bhi;
            err1 = adyt_bdx1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double adyt_bdx0 = alo * blo - err3;
            _i = adxt_bdy0 - adyt_bdx0;
            bvirt = adxt_bdy0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - adyt_bdx0;
            around = adxt_bdy0 - avirt;
            at_b[0] = around + bround;
            _j = adxt_bdy1 + _i;
            bvirt = _j - adxt_bdy1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = adxt_bdy1 - avirt;
            _0 = around + bround;
            _i = _0 - adyt_bdx1;
            bvirt = _0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - adyt_bdx1;
            around = _0 - avirt;
            at_b[1] = around + bround;
            double at_blarge = _j + _i;
            bvirt = at_blarge - _j;
            avirt = at_blarge - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            at_b[2] = around + bround;
            at_b[3] = at_blarge;
            at_blen = 4;
            double adyt_cdx1 = adytail * cdx;
            c = this.splitter * adytail;
            abig = c - adytail;
            ahi = c - abig;
            alo = adytail - ahi;
            c = this.splitter * cdx;
            abig = c - cdx;
            bhi = c - abig;
            blo = cdx - bhi;
            err1 = adyt_cdx1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double adyt_cdx0 = alo * blo - err3;
            double adxt_cdy1 = adxtail * cdy;
            c = this.splitter * adxtail;
            abig = c - adxtail;
            ahi = c - abig;
            alo = adxtail - ahi;
            c = this.splitter * cdy;
            abig = c - cdy;
            bhi = c - abig;
            blo = cdy - bhi;
            err1 = adxt_cdy1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double adxt_cdy0 = alo * blo - err3;
            _i = adyt_cdx0 - adxt_cdy0;
            bvirt = adyt_cdx0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - adxt_cdy0;
            around = adyt_cdx0 - avirt;
            at_c[0] = around + bround;
            _j = adyt_cdx1 + _i;
            bvirt = _j - adyt_cdx1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = adyt_cdx1 - avirt;
            _0 = around + bround;
            _i = _0 - adxt_cdy1;
            bvirt = _0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - adxt_cdy1;
            around = _0 - avirt;
            at_c[1] = around + bround;
            double at_clarge = _j + _i;
            bvirt = at_clarge - _j;
            avirt = at_clarge - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            at_c[2] = around + bround;
            at_c[3] = at_clarge;
            at_clen = 4;
        }
        if (bdxtail == 0.0) {
            if (bdytail == 0.0) {
                bt_c[0] = 0.0;
                bt_clen = 1;
                bt_a[0] = 0.0;
                bt_alen = 1;
            } else {
                negate = -bdytail;
                double bt_clarge = negate * cdx;
                c = this.splitter * negate;
                abig = c - negate;
                ahi = c - abig;
                alo = negate - ahi;
                c = this.splitter * cdx;
                abig = c - cdx;
                bhi = c - abig;
                blo = cdx - bhi;
                err1 = bt_clarge - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                bt_c[0] = alo * blo - err3;
                bt_c[1] = bt_clarge;
                bt_clen = 2;
                double bt_alarge = bdytail * adx;
                c = this.splitter * bdytail;
                abig = c - bdytail;
                ahi = c - abig;
                alo = bdytail - ahi;
                c = this.splitter * adx;
                abig = c - adx;
                bhi = c - abig;
                blo = adx - bhi;
                err1 = bt_alarge - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                bt_a[0] = alo * blo - err3;
                bt_a[1] = bt_alarge;
                bt_alen = 2;
            }
        } else if (bdytail == 0.0) {
            double bt_clarge = bdxtail * cdy;
            c = this.splitter * bdxtail;
            abig = c - bdxtail;
            ahi = c - abig;
            alo = bdxtail - ahi;
            c = this.splitter * cdy;
            abig = c - cdy;
            bhi = c - abig;
            blo = cdy - bhi;
            err1 = bt_clarge - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            bt_c[0] = alo * blo - err3;
            bt_c[1] = bt_clarge;
            bt_clen = 2;
            negate = -bdxtail;
            double bt_alarge = negate * ady;
            c = this.splitter * negate;
            abig = c - negate;
            ahi = c - abig;
            alo = negate - ahi;
            c = this.splitter * ady;
            abig = c - ady;
            bhi = c - abig;
            blo = ady - bhi;
            err1 = bt_alarge - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            bt_a[0] = alo * blo - err3;
            bt_a[1] = bt_alarge;
            bt_alen = 2;
        } else {
            double bdxt_cdy1 = bdxtail * cdy;
            c = this.splitter * bdxtail;
            abig = c - bdxtail;
            ahi = c - abig;
            alo = bdxtail - ahi;
            c = this.splitter * cdy;
            abig = c - cdy;
            bhi = c - abig;
            blo = cdy - bhi;
            err1 = bdxt_cdy1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double bdxt_cdy0 = alo * blo - err3;
            double bdyt_cdx1 = bdytail * cdx;
            c = this.splitter * bdytail;
            abig = c - bdytail;
            ahi = c - abig;
            alo = bdytail - ahi;
            c = this.splitter * cdx;
            abig = c - cdx;
            bhi = c - abig;
            blo = cdx - bhi;
            err1 = bdyt_cdx1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double bdyt_cdx0 = alo * blo - err3;
            _i = bdxt_cdy0 - bdyt_cdx0;
            bvirt = bdxt_cdy0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - bdyt_cdx0;
            around = bdxt_cdy0 - avirt;
            bt_c[0] = around + bround;
            _j = bdxt_cdy1 + _i;
            bvirt = _j - bdxt_cdy1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = bdxt_cdy1 - avirt;
            _0 = around + bround;
            _i = _0 - bdyt_cdx1;
            bvirt = _0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - bdyt_cdx1;
            around = _0 - avirt;
            bt_c[1] = around + bround;
            double bt_clarge = _j + _i;
            bvirt = bt_clarge - _j;
            avirt = bt_clarge - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            bt_c[2] = around + bround;
            bt_c[3] = bt_clarge;
            bt_clen = 4;
            double bdyt_adx1 = bdytail * adx;
            c = this.splitter * bdytail;
            abig = c - bdytail;
            ahi = c - abig;
            alo = bdytail - ahi;
            c = this.splitter * adx;
            abig = c - adx;
            bhi = c - abig;
            blo = adx - bhi;
            err1 = bdyt_adx1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double bdyt_adx0 = alo * blo - err3;
            double bdxt_ady1 = bdxtail * ady;
            c = this.splitter * bdxtail;
            abig = c - bdxtail;
            ahi = c - abig;
            alo = bdxtail - ahi;
            c = this.splitter * ady;
            abig = c - ady;
            bhi = c - abig;
            blo = ady - bhi;
            err1 = bdxt_ady1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double bdxt_ady0 = alo * blo - err3;
            _i = bdyt_adx0 - bdxt_ady0;
            bvirt = bdyt_adx0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - bdxt_ady0;
            around = bdyt_adx0 - avirt;
            bt_a[0] = around + bround;
            _j = bdyt_adx1 + _i;
            bvirt = _j - bdyt_adx1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = bdyt_adx1 - avirt;
            _0 = around + bround;
            _i = _0 - bdxt_ady1;
            bvirt = _0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - bdxt_ady1;
            around = _0 - avirt;
            bt_a[1] = around + bround;
            double bt_alarge = _j + _i;
            bvirt = bt_alarge - _j;
            avirt = bt_alarge - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            bt_a[2] = around + bround;
            bt_a[3] = bt_alarge;
            bt_alen = 4;
        }
        if (cdxtail == 0.0) {
            if (cdytail == 0.0) {
                ct_a[0] = 0.0;
                ct_alen = 1;
                ct_b[0] = 0.0;
                ct_blen = 1;
            } else {
                negate = -cdytail;
                double ct_alarge = negate * adx;
                c = this.splitter * negate;
                abig = c - negate;
                ahi = c - abig;
                alo = negate - ahi;
                c = this.splitter * adx;
                abig = c - adx;
                bhi = c - abig;
                blo = adx - bhi;
                err1 = ct_alarge - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ct_a[0] = alo * blo - err3;
                ct_a[1] = ct_alarge;
                ct_alen = 2;
                double ct_blarge = cdytail * bdx;
                c = this.splitter * cdytail;
                abig = c - cdytail;
                ahi = c - abig;
                alo = cdytail - ahi;
                c = this.splitter * bdx;
                abig = c - bdx;
                bhi = c - abig;
                blo = bdx - bhi;
                err1 = ct_blarge - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ct_b[0] = alo * blo - err3;
                ct_b[1] = ct_blarge;
                ct_blen = 2;
            }
        } else if (cdytail == 0.0) {
            double ct_alarge = cdxtail * ady;
            c = this.splitter * cdxtail;
            abig = c - cdxtail;
            ahi = c - abig;
            alo = cdxtail - ahi;
            c = this.splitter * ady;
            abig = c - ady;
            bhi = c - abig;
            blo = ady - bhi;
            err1 = ct_alarge - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            ct_a[0] = alo * blo - err3;
            ct_a[1] = ct_alarge;
            ct_alen = 2;
            negate = -cdxtail;
            double ct_blarge = negate * bdy;
            c = this.splitter * negate;
            abig = c - negate;
            ahi = c - abig;
            alo = negate - ahi;
            c = this.splitter * bdy;
            abig = c - bdy;
            bhi = c - abig;
            blo = bdy - bhi;
            err1 = ct_blarge - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            ct_b[0] = alo * blo - err3;
            ct_b[1] = ct_blarge;
            ct_blen = 2;
        } else {
            double cdxt_ady1 = cdxtail * ady;
            c = this.splitter * cdxtail;
            abig = c - cdxtail;
            ahi = c - abig;
            alo = cdxtail - ahi;
            c = this.splitter * ady;
            abig = c - ady;
            bhi = c - abig;
            blo = ady - bhi;
            err1 = cdxt_ady1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double cdxt_ady0 = alo * blo - err3;
            double cdyt_adx1 = cdytail * adx;
            c = this.splitter * cdytail;
            abig = c - cdytail;
            ahi = c - abig;
            alo = cdytail - ahi;
            c = this.splitter * adx;
            abig = c - adx;
            bhi = c - abig;
            blo = adx - bhi;
            err1 = cdyt_adx1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double cdyt_adx0 = alo * blo - err3;
            _i = cdxt_ady0 - cdyt_adx0;
            bvirt = cdxt_ady0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - cdyt_adx0;
            around = cdxt_ady0 - avirt;
            ct_a[0] = around + bround;
            _j = cdxt_ady1 + _i;
            bvirt = _j - cdxt_ady1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = cdxt_ady1 - avirt;
            _0 = around + bround;
            _i = _0 - cdyt_adx1;
            bvirt = _0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - cdyt_adx1;
            around = _0 - avirt;
            ct_a[1] = around + bround;
            double ct_alarge = _j + _i;
            bvirt = ct_alarge - _j;
            avirt = ct_alarge - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            ct_a[2] = around + bround;
            ct_a[3] = ct_alarge;
            ct_alen = 4;
            double cdyt_bdx1 = cdytail * bdx;
            c = this.splitter * cdytail;
            abig = c - cdytail;
            ahi = c - abig;
            alo = cdytail - ahi;
            c = this.splitter * bdx;
            abig = c - bdx;
            bhi = c - abig;
            blo = bdx - bhi;
            err1 = cdyt_bdx1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double cdyt_bdx0 = alo * blo - err3;
            double cdxt_bdy1 = cdxtail * bdy;
            c = this.splitter * cdxtail;
            abig = c - cdxtail;
            ahi = c - abig;
            alo = cdxtail - ahi;
            c = this.splitter * bdy;
            abig = c - bdy;
            bhi = c - abig;
            blo = bdy - bhi;
            err1 = cdxt_bdy1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double cdxt_bdy0 = alo * blo - err3;
            _i = cdyt_bdx0 - cdxt_bdy0;
            bvirt = cdyt_bdx0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - cdxt_bdy0;
            around = cdyt_bdx0 - avirt;
            ct_b[0] = around + bround;
            _j = cdyt_bdx1 + _i;
            bvirt = _j - cdyt_bdx1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = cdyt_bdx1 - avirt;
            _0 = around + bround;
            _i = _0 - cdxt_bdy1;
            bvirt = _0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - cdxt_bdy1;
            around = _0 - avirt;
            ct_b[1] = around + bround;
            double ct_blarge = _j + _i;
            bvirt = ct_blarge - _j;
            avirt = ct_blarge - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            ct_b[2] = around + bround;
            ct_b[3] = ct_blarge;
            ct_blen = 4;
        }
        int bctlen = this.fast_expansion_sum_zeroelim(bt_clen, bt_c, ct_blen, ct_b, bct);
        int wlength = this.scale_expansion_zeroelim(bctlen, bct, adz, w);
        finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, wlength, w, finother);
        double[] finswap = finnow;
        finnow = finother;
        finother = finswap;
        int catlen = this.fast_expansion_sum_zeroelim(ct_alen, ct_a, at_clen, at_c, cat);
        wlength = this.scale_expansion_zeroelim(catlen, cat, bdz, w);
        finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, wlength, w, finother);
        finswap = finnow;
        finnow = finother;
        finother = finswap;
        int abtlen = this.fast_expansion_sum_zeroelim(at_blen, at_b, bt_alen, bt_a, abt);
        wlength = this.scale_expansion_zeroelim(abtlen, abt, cdz, w);
        finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, wlength, w, finother);
        finswap = finnow;
        finnow = finother;
        finother = finswap;
        if (adztail != 0.0) {
            vlength = this.scale_expansion_zeroelim(4, bc, adztail, v);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, vlength, v, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (bdztail != 0.0) {
            vlength = this.scale_expansion_zeroelim(4, ca, bdztail, v);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, vlength, v, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (cdztail != 0.0) {
            vlength = this.scale_expansion_zeroelim(4, ab, cdztail, v);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, vlength, v, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (adxtail != 0.0) {
            if (bdytail != 0.0) {
                double adxt_bdyt1 = adxtail * bdytail;
                c = this.splitter * adxtail;
                abig = c - adxtail;
                ahi = c - abig;
                alo = adxtail - ahi;
                c = this.splitter * bdytail;
                abig = c - bdytail;
                bhi = c - abig;
                blo = bdytail - bhi;
                err1 = adxt_bdyt1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                double adxt_bdyt0 = alo * blo - err3;
                c = this.splitter * cdz;
                abig = c - cdz;
                bhi = c - abig;
                blo = cdz - bhi;
                _i = adxt_bdyt0 * cdz;
                c = this.splitter * adxt_bdyt0;
                abig = c - adxt_bdyt0;
                ahi = c - abig;
                alo = adxt_bdyt0 - ahi;
                err1 = _i - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                u[0] = alo * blo - err3;
                _j = adxt_bdyt1 * cdz;
                c = this.splitter * adxt_bdyt1;
                abig = c - adxt_bdyt1;
                ahi = c - abig;
                alo = adxt_bdyt1 - ahi;
                err1 = _j - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                _0 = alo * blo - err3;
                _k = _i + _0;
                bvirt = _k - _i;
                avirt = _k - bvirt;
                bround = _0 - bvirt;
                around = _i - avirt;
                u[1] = around + bround;
                u3 = _j + _k;
                bvirt = u3 - _j;
                u[2] = _k - bvirt;
                u[3] = u3;
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (cdztail != 0.0) {
                    c = this.splitter * cdztail;
                    abig = c - cdztail;
                    bhi = c - abig;
                    blo = cdztail - bhi;
                    _i = adxt_bdyt0 * cdztail;
                    c = this.splitter * adxt_bdyt0;
                    abig = c - adxt_bdyt0;
                    ahi = c - abig;
                    alo = adxt_bdyt0 - ahi;
                    err1 = _i - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    u[0] = alo * blo - err3;
                    _j = adxt_bdyt1 * cdztail;
                    c = this.splitter * adxt_bdyt1;
                    abig = c - adxt_bdyt1;
                    ahi = c - abig;
                    alo = adxt_bdyt1 - ahi;
                    err1 = _j - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    _0 = alo * blo - err3;
                    _k = _i + _0;
                    bvirt = _k - _i;
                    avirt = _k - bvirt;
                    bround = _0 - bvirt;
                    around = _i - avirt;
                    u[1] = around + bround;
                    u3 = _j + _k;
                    bvirt = u3 - _j;
                    u[2] = _k - bvirt;
                    u[3] = u3;
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
            }
            if (cdytail != 0.0) {
                negate = -adxtail;
                double adxt_cdyt1 = negate * cdytail;
                c = this.splitter * negate;
                abig = c - negate;
                ahi = c - abig;
                alo = negate - ahi;
                c = this.splitter * cdytail;
                abig = c - cdytail;
                bhi = c - abig;
                blo = cdytail - bhi;
                err1 = adxt_cdyt1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                double adxt_cdyt0 = alo * blo - err3;
                c = this.splitter * bdz;
                abig = c - bdz;
                bhi = c - abig;
                blo = bdz - bhi;
                _i = adxt_cdyt0 * bdz;
                c = this.splitter * adxt_cdyt0;
                abig = c - adxt_cdyt0;
                ahi = c - abig;
                alo = adxt_cdyt0 - ahi;
                err1 = _i - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                u[0] = alo * blo - err3;
                _j = adxt_cdyt1 * bdz;
                c = this.splitter * adxt_cdyt1;
                abig = c - adxt_cdyt1;
                ahi = c - abig;
                alo = adxt_cdyt1 - ahi;
                err1 = _j - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                _0 = alo * blo - err3;
                _k = _i + _0;
                bvirt = _k - _i;
                avirt = _k - bvirt;
                bround = _0 - bvirt;
                around = _i - avirt;
                u[1] = around + bround;
                u3 = _j + _k;
                bvirt = u3 - _j;
                u[2] = _k - bvirt;
                u[3] = u3;
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (bdztail != 0.0) {
                    c = this.splitter * bdztail;
                    abig = c - bdztail;
                    bhi = c - abig;
                    blo = bdztail - bhi;
                    _i = adxt_cdyt0 * bdztail;
                    c = this.splitter * adxt_cdyt0;
                    abig = c - adxt_cdyt0;
                    ahi = c - abig;
                    alo = adxt_cdyt0 - ahi;
                    err1 = _i - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    u[0] = alo * blo - err3;
                    _j = adxt_cdyt1 * bdztail;
                    c = this.splitter * adxt_cdyt1;
                    abig = c - adxt_cdyt1;
                    ahi = c - abig;
                    alo = adxt_cdyt1 - ahi;
                    err1 = _j - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    _0 = alo * blo - err3;
                    _k = _i + _0;
                    bvirt = _k - _i;
                    avirt = _k - bvirt;
                    bround = _0 - bvirt;
                    around = _i - avirt;
                    u[1] = around + bround;
                    u3 = _j + _k;
                    bvirt = u3 - _j;
                    u[2] = _k - bvirt;
                    u[3] = u3;
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
            }
        }
        if (bdxtail != 0.0) {
            if (cdytail != 0.0) {
                double bdxt_cdyt1 = bdxtail * cdytail;
                c = this.splitter * bdxtail;
                abig = c - bdxtail;
                ahi = c - abig;
                alo = bdxtail - ahi;
                c = this.splitter * cdytail;
                abig = c - cdytail;
                bhi = c - abig;
                blo = cdytail - bhi;
                err1 = bdxt_cdyt1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                double bdxt_cdyt0 = alo * blo - err3;
                c = this.splitter * adz;
                abig = c - adz;
                bhi = c - abig;
                blo = adz - bhi;
                _i = bdxt_cdyt0 * adz;
                c = this.splitter * bdxt_cdyt0;
                abig = c - bdxt_cdyt0;
                ahi = c - abig;
                alo = bdxt_cdyt0 - ahi;
                err1 = _i - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                u[0] = alo * blo - err3;
                _j = bdxt_cdyt1 * adz;
                c = this.splitter * bdxt_cdyt1;
                abig = c - bdxt_cdyt1;
                ahi = c - abig;
                alo = bdxt_cdyt1 - ahi;
                err1 = _j - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                _0 = alo * blo - err3;
                _k = _i + _0;
                bvirt = _k - _i;
                avirt = _k - bvirt;
                bround = _0 - bvirt;
                around = _i - avirt;
                u[1] = around + bround;
                u3 = _j + _k;
                bvirt = u3 - _j;
                u[2] = _k - bvirt;
                u[3] = u3;
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (adztail != 0.0) {
                    c = this.splitter * adztail;
                    abig = c - adztail;
                    bhi = c - abig;
                    blo = adztail - bhi;
                    _i = bdxt_cdyt0 * adztail;
                    c = this.splitter * bdxt_cdyt0;
                    abig = c - bdxt_cdyt0;
                    ahi = c - abig;
                    alo = bdxt_cdyt0 - ahi;
                    err1 = _i - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    u[0] = alo * blo - err3;
                    _j = bdxt_cdyt1 * adztail;
                    c = this.splitter * bdxt_cdyt1;
                    abig = c - bdxt_cdyt1;
                    ahi = c - abig;
                    alo = bdxt_cdyt1 - ahi;
                    err1 = _j - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    _0 = alo * blo - err3;
                    _k = _i + _0;
                    bvirt = _k - _i;
                    avirt = _k - bvirt;
                    bround = _0 - bvirt;
                    around = _i - avirt;
                    u[1] = around + bround;
                    u3 = _j + _k;
                    bvirt = u3 - _j;
                    u[2] = _k - bvirt;
                    u[3] = u3;
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
            }
            if (adytail != 0.0) {
                negate = -bdxtail;
                double bdxt_adyt1 = negate * adytail;
                c = this.splitter * negate;
                abig = c - negate;
                ahi = c - abig;
                alo = negate - ahi;
                c = this.splitter * adytail;
                abig = c - adytail;
                bhi = c - abig;
                blo = adytail - bhi;
                err1 = bdxt_adyt1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                double bdxt_adyt0 = alo * blo - err3;
                c = this.splitter * cdz;
                abig = c - cdz;
                bhi = c - abig;
                blo = cdz - bhi;
                _i = bdxt_adyt0 * cdz;
                c = this.splitter * bdxt_adyt0;
                abig = c - bdxt_adyt0;
                ahi = c - abig;
                alo = bdxt_adyt0 - ahi;
                err1 = _i - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                u[0] = alo * blo - err3;
                _j = bdxt_adyt1 * cdz;
                c = this.splitter * bdxt_adyt1;
                abig = c - bdxt_adyt1;
                ahi = c - abig;
                alo = bdxt_adyt1 - ahi;
                err1 = _j - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                _0 = alo * blo - err3;
                _k = _i + _0;
                bvirt = _k - _i;
                avirt = _k - bvirt;
                bround = _0 - bvirt;
                around = _i - avirt;
                u[1] = around + bround;
                u3 = _j + _k;
                bvirt = u3 - _j;
                u[2] = _k - bvirt;
                u[3] = u3;
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (cdztail != 0.0) {
                    c = this.splitter * cdztail;
                    abig = c - cdztail;
                    bhi = c - abig;
                    blo = cdztail - bhi;
                    _i = bdxt_adyt0 * cdztail;
                    c = this.splitter * bdxt_adyt0;
                    abig = c - bdxt_adyt0;
                    ahi = c - abig;
                    alo = bdxt_adyt0 - ahi;
                    err1 = _i - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    u[0] = alo * blo - err3;
                    _j = bdxt_adyt1 * cdztail;
                    c = this.splitter * bdxt_adyt1;
                    abig = c - bdxt_adyt1;
                    ahi = c - abig;
                    alo = bdxt_adyt1 - ahi;
                    err1 = _j - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    _0 = alo * blo - err3;
                    _k = _i + _0;
                    bvirt = _k - _i;
                    avirt = _k - bvirt;
                    bround = _0 - bvirt;
                    around = _i - avirt;
                    u[1] = around + bround;
                    u3 = _j + _k;
                    bvirt = u3 - _j;
                    u[2] = _k - bvirt;
                    u[3] = u3;
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
            }
        }
        if (cdxtail != 0.0) {
            if (adytail != 0.0) {
                double cdxt_adyt1 = cdxtail * adytail;
                c = this.splitter * cdxtail;
                abig = c - cdxtail;
                ahi = c - abig;
                alo = cdxtail - ahi;
                c = this.splitter * adytail;
                abig = c - adytail;
                bhi = c - abig;
                blo = adytail - bhi;
                err1 = cdxt_adyt1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                double cdxt_adyt0 = alo * blo - err3;
                c = this.splitter * bdz;
                abig = c - bdz;
                bhi = c - abig;
                blo = bdz - bhi;
                _i = cdxt_adyt0 * bdz;
                c = this.splitter * cdxt_adyt0;
                abig = c - cdxt_adyt0;
                ahi = c - abig;
                alo = cdxt_adyt0 - ahi;
                err1 = _i - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                u[0] = alo * blo - err3;
                _j = cdxt_adyt1 * bdz;
                c = this.splitter * cdxt_adyt1;
                abig = c - cdxt_adyt1;
                ahi = c - abig;
                alo = cdxt_adyt1 - ahi;
                err1 = _j - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                _0 = alo * blo - err3;
                _k = _i + _0;
                bvirt = _k - _i;
                avirt = _k - bvirt;
                bround = _0 - bvirt;
                around = _i - avirt;
                u[1] = around + bround;
                u3 = _j + _k;
                bvirt = u3 - _j;
                u[2] = _k - bvirt;
                u[3] = u3;
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (bdztail != 0.0) {
                    c = this.splitter * bdztail;
                    abig = c - bdztail;
                    bhi = c - abig;
                    blo = bdztail - bhi;
                    _i = cdxt_adyt0 * bdztail;
                    c = this.splitter * cdxt_adyt0;
                    abig = c - cdxt_adyt0;
                    ahi = c - abig;
                    alo = cdxt_adyt0 - ahi;
                    err1 = _i - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    u[0] = alo * blo - err3;
                    _j = cdxt_adyt1 * bdztail;
                    c = this.splitter * cdxt_adyt1;
                    abig = c - cdxt_adyt1;
                    ahi = c - abig;
                    alo = cdxt_adyt1 - ahi;
                    err1 = _j - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    _0 = alo * blo - err3;
                    _k = _i + _0;
                    bvirt = _k - _i;
                    avirt = _k - bvirt;
                    bround = _0 - bvirt;
                    around = _i - avirt;
                    u[1] = around + bround;
                    u3 = _j + _k;
                    bvirt = u3 - _j;
                    u[2] = _k - bvirt;
                    u[3] = u3;
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
            }
            if (bdytail != 0.0) {
                negate = -cdxtail;
                double cdxt_bdyt1 = negate * bdytail;
                c = this.splitter * negate;
                abig = c - negate;
                ahi = c - abig;
                alo = negate - ahi;
                c = this.splitter * bdytail;
                abig = c - bdytail;
                bhi = c - abig;
                blo = bdytail - bhi;
                err1 = cdxt_bdyt1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                double cdxt_bdyt0 = alo * blo - err3;
                c = this.splitter * adz;
                abig = c - adz;
                bhi = c - abig;
                blo = adz - bhi;
                _i = cdxt_bdyt0 * adz;
                c = this.splitter * cdxt_bdyt0;
                abig = c - cdxt_bdyt0;
                ahi = c - abig;
                alo = cdxt_bdyt0 - ahi;
                err1 = _i - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                u[0] = alo * blo - err3;
                _j = cdxt_bdyt1 * adz;
                c = this.splitter * cdxt_bdyt1;
                abig = c - cdxt_bdyt1;
                ahi = c - abig;
                alo = cdxt_bdyt1 - ahi;
                err1 = _j - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                _0 = alo * blo - err3;
                _k = _i + _0;
                bvirt = _k - _i;
                avirt = _k - bvirt;
                bround = _0 - bvirt;
                around = _i - avirt;
                u[1] = around + bround;
                u3 = _j + _k;
                bvirt = u3 - _j;
                u[2] = _k - bvirt;
                u[3] = u3;
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (adztail != 0.0) {
                    c = this.splitter * adztail;
                    abig = c - adztail;
                    bhi = c - abig;
                    blo = adztail - bhi;
                    _i = cdxt_bdyt0 * adztail;
                    c = this.splitter * cdxt_bdyt0;
                    abig = c - cdxt_bdyt0;
                    ahi = c - abig;
                    alo = cdxt_bdyt0 - ahi;
                    err1 = _i - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    u[0] = alo * blo - err3;
                    _j = cdxt_bdyt1 * adztail;
                    c = this.splitter * cdxt_bdyt1;
                    abig = c - cdxt_bdyt1;
                    ahi = c - abig;
                    alo = cdxt_bdyt1 - ahi;
                    err1 = _j - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    _0 = alo * blo - err3;
                    _k = _i + _0;
                    bvirt = _k - _i;
                    avirt = _k - bvirt;
                    bround = _0 - bvirt;
                    around = _i - avirt;
                    u[1] = around + bround;
                    u3 = _j + _k;
                    bvirt = u3 - _j;
                    u[2] = _k - bvirt;
                    u[3] = u3;
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
            }
        }
        if (adztail != 0.0) {
            wlength = this.scale_expansion_zeroelim(bctlen, bct, adztail, w);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, wlength, w, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (bdztail != 0.0) {
            wlength = this.scale_expansion_zeroelim(catlen, cat, bdztail, w);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, wlength, w, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (cdztail != 0.0) {
            wlength = this.scale_expansion_zeroelim(abtlen, abt, cdztail, w);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, wlength, w, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        return finnow[finlength - 1];
    }

    private int fast_expansion_sum_zeroelim(int elen, double[] e, int flen, double[] f, double[] h) {
        double around;
        double bround;
        double avirt;
        double hh;
        double bvirt;
        double Qnew;
        double Q;
        double enow = e[0];
        double fnow = f[0];
        int findex = 0;
        int eindex = 0;
        if (fnow > enow == fnow > -enow) {
            Q = enow;
            enow = e[++eindex];
        } else {
            Q = fnow;
            fnow = f[++findex];
        }
        int hindex = 0;
        if (eindex < elen && findex < flen) {
            if (fnow > enow == fnow > -enow) {
                Qnew = enow + Q;
                bvirt = Qnew - enow;
                hh = Q - bvirt;
                enow = e[++eindex];
            } else {
                Qnew = fnow + Q;
                bvirt = Qnew - fnow;
                hh = Q - bvirt;
                fnow = f[++findex];
            }
            Q = Qnew;
            if (hh != 0.0) {
                h[hindex++] = hh;
            }
            while (eindex < elen && findex < flen) {
                if (fnow > enow == fnow > -enow) {
                    Qnew = Q + enow;
                    bvirt = Qnew - Q;
                    avirt = Qnew - bvirt;
                    bround = enow - bvirt;
                    around = Q - avirt;
                    hh = around + bround;
                    enow = e[++eindex];
                } else {
                    Qnew = Q + fnow;
                    bvirt = Qnew - Q;
                    avirt = Qnew - bvirt;
                    bround = fnow - bvirt;
                    around = Q - avirt;
                    hh = around + bround;
                    fnow = f[++findex];
                }
                Q = Qnew;
                if (hh == 0.0) continue;
                h[hindex++] = hh;
            }
        }
        while (eindex < elen) {
            Qnew = Q + enow;
            bvirt = Qnew - Q;
            avirt = Qnew - bvirt;
            bround = enow - bvirt;
            around = Q - avirt;
            hh = around + bround;
            enow = e[++eindex];
            Q = Qnew;
            if (hh == 0.0) continue;
            h[hindex++] = hh;
        }
        while (findex < flen) {
            Qnew = Q + fnow;
            bvirt = Qnew - Q;
            avirt = Qnew - bvirt;
            bround = fnow - bvirt;
            around = Q - avirt;
            hh = around + bround;
            fnow = f[++findex];
            Q = Qnew;
            if (hh == 0.0) continue;
            h[hindex++] = hh;
        }
        if (Q != 0.0 || hindex == 0) {
            h[hindex++] = Q;
        }
        return hindex;
    }

    private int scale_expansion_zeroelim(int elen, double[] e, double b, double[] h) {
        double c = this.splitter * b;
        double abig = c - b;
        double bhi = c - abig;
        double blo = b - bhi;
        double Q = e[0] * b;
        c = this.splitter * e[0];
        abig = c - e[0];
        double ahi = c - abig;
        double alo = e[0] - ahi;
        double err1 = Q - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double hh = alo * blo - err3;
        int hindex = 0;
        if (hh != 0.0) {
            h[hindex++] = hh;
        }
        for (int eindex = 1; eindex < elen; ++eindex) {
            double enow = e[eindex];
            c = this.splitter * enow;
            abig = c - enow;
            ahi = c - abig;
            alo = enow - ahi;
            double product1 = enow * b;
            err1 = product1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double product0 = alo * blo - err3;
            double sum = Q + product0;
            double bvirt = sum - Q;
            double avirt = sum - bvirt;
            double around = Q - avirt;
            double bround = product0 - bvirt;
            hh = around + bround;
            if (hh != 0.0) {
                h[hindex++] = hh;
            }
            if ((hh = sum - (bvirt = (Q = product1 + sum) - product1)) == 0.0) continue;
            h[hindex++] = hh;
        }
        if (Q != 0.0 || hindex == 0) {
            h[hindex++] = Q;
        }
        return hindex;
    }

    private double estimate(int elen, double[] e) {
        double Q = e[0];
        for (int eindex = 1; eindex < elen; ++eindex) {
            Q += e[eindex];
        }
        return Q;
    }
}

